/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.nav.editor;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.nav.editor.BNavTable;
import com.tridium.workbench.nav.editor.BSourceTable;
import com.tridium.workbench.nav.editor.Node;
import com.tridium.workbench.nav.editor.TransferSupport;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.WbCommands;
import java.io.InputStream;
import java.util.ArrayList;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.sys.BFacets;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToggleButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.DragRenderer;
import javax.baja.ui.transfer.SimpleDragRenderer;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.treetable.TreeTableController;
import javax.baja.ui.treetable.TreeTableModel;
import javax.baja.ui.treetable.TreeTableNode;
import javax.baja.ui.treetable.TreeTableSelection;
import javax.baja.ui.treetable.TreeTableSubject;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbView;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XWriter;

public class BNavFileEditor
extends BWbView {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$nav$editor$BNavFileEditor == null ? (class$com$tridium$workbench$nav$editor$BNavFileEditor = BNavFileEditor.class$("com.tridium.workbench.nav.editor.BNavFileEditor")) : class$com$tridium$workbench$nav$editor$BNavFileEditor));
    static BModule module = Sys.getModuleForClass((Class)(class$com$tridium$workbench$nav$editor$BNavFileEditor == null ? (class$com$tridium$workbench$nav$editor$BNavFileEditor = BNavFileEditor.class$("com.tridium.workbench.nav.editor.BNavFileEditor")) : class$com$tridium$workbench$nav$editor$BNavFileEditor));
    static Lexicon lex = Lexicon.make((String)"workbench");
    static String lexErrBig = BNavFileEditor.text("error.big");
    static String lexErrSmall = BNavFileEditor.text("error.small");
    static String lexOpenText = BNavFileEditor.text("openTextEditor");
    static String lexName = BNavFileEditor.text("displayName");
    static String lexOrd = BNavFileEditor.text("targetOrd");
    static String lexIcon = BNavFileEditor.text("icon");
    static BImage warning = BImage.make((String)"module://icons/x32/warning.png");
    static String defaultName = BNavFileEditor.text("defaultName");
    static BOrd defaultOrd = BOrd.make((String)"station:|slot:/");
    static BImage defaultIcon = BImage.make((String)"module://icons/x16/folder.png");
    BWidget sourceParent;
    BWidget resultParent;
    BSplitPane split;
    BSourceTable source;
    Model model;
    Node[] dragNodes;
    TransferSupport txSupport;
    WbCommands commands;
    NewCommand newCommand;
    EditCommand editCommand;
    MoveUpCommand moveUpCommand;
    MoveDownCommand moveDownCommand;
    ShowComponentsCommand showComponents;
    ShowFilesCommand showFiles;
    static /* synthetic */ Class class$com$tridium$workbench$nav$editor$BNavFileEditor;

    public Type getType() {
        return TYPE;
    }

    private void buildInterface() {
        this.commands = ((BNiagaraWbShell)this.getWbShell()).commands;
        this.txSupport = new TransferSupport(this);
        this.source = new BSourceTable(this);
        BNavTable bNavTable = new BNavTable(this);
        this.model = new Model();
        bNavTable.setModel((TableModel)this.model);
        bNavTable.setSelection((TableSelection)new Selection());
        bNavTable.setController((TableController)new Controller());
        BGridPane bGridPane = new BGridPane(8);
        this.newCommand = new NewCommand(this, null);
        bGridPane.add(null, (BValue)new BButton((Command)this.newCommand));
        this.editCommand = new EditCommand(this);
        bGridPane.add(null, (BValue)new BButton((Command)this.editCommand));
        bGridPane.add(null, (BValue)new BButton(this.commands.delete));
        this.moveUpCommand = new MoveUpCommand(this);
        bGridPane.add(null, (BValue)new BButton((Command)this.moveUpCommand));
        this.moveDownCommand = new MoveDownCommand(this);
        bGridPane.add(null, (BValue)new BButton((Command)this.moveDownCommand));
        bGridPane.add(null, (BValue)new BBorderPane((BWidget)new BNullWidget(), 0.0, 0.0, 0.0, 10.0));
        this.showComponents = new ShowComponentsCommand(this);
        bGridPane.add(null, (BValue)new BToggleButton((Command)this.showComponents));
        this.showFiles = new ShowFilesCommand(this);
        bGridPane.add(null, (BValue)new BToggleButton((Command)this.showFiles));
        this.sourceParent = BTitlePane.makePane((String)BNavFileEditor.text("source"), (BTable)this.source);
        this.resultParent = BTitlePane.makePane((String)BNavFileEditor.text("result"), (BTable)bNavTable);
        this.split = new BSplitPane(BOrientation.vertical, 50.0);
        this.split.setWidget1(this.sourceParent);
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setCenter(this.resultParent);
        bEdgePane.setBottom((BWidget)new BBorderPane((BWidget)bGridPane, 5.0, 0.0, 0.0, 0.0));
        this.setContent((BWidget)bEdgePane);
    }

    BEdgePane content() {
        return (BEdgePane)this.getContent();
    }

    void toggleSource() {
        if (this.resultParent.getParentWidget() == this.split) {
            this.split.setWidget2((BWidget)new BNullWidget());
            this.content().setCenter(this.resultParent);
            this.relayout();
        } else {
            this.content().setCenter((BWidget)new BNullWidget());
            this.split.setWidget2(this.resultParent);
            this.content().setCenter((BWidget)this.split);
            this.relayout();
        }
    }

    void computeSourceVisible() {
        if (this.showComponents.isSelected() || this.showFiles.isSelected()) {
            if (this.resultParent.getParentWidget() != this.split) {
                this.toggleSource();
            }
        } else if (this.resultParent.getParentWidget() == this.split) {
            this.toggleSource();
        }
    }

    protected void doLoadValue(BObject bObject, Context context) throws Exception {
        BIFile bIFile = (BIFile)bObject;
        if (bIFile.getFileSpace() == BFileSystem.INSTANCE) {
            BLabel bLabel = new BLabel(warning);
            BLabel bLabel2 = new BLabel(lexErrBig, Theme.widget().getLargeBoldFont());
            BLabel bLabel3 = new BLabel(lexErrSmall);
            BButton bButton = new BButton((Command)new OpenTextEditor(this));
            BGridPane bGridPane = new BGridPane(1);
            bGridPane.setRowGap(0.0);
            bGridPane.add(null, (BValue)bLabel2);
            bGridPane.add(null, (BValue)bLabel3);
            BGridPane bGridPane2 = new BGridPane(2);
            bGridPane2.setColumnGap(5.0);
            bGridPane2.add(null, (BValue)bLabel);
            bGridPane2.add(null, (BValue)bGridPane);
            BGridPane bGridPane3 = new BGridPane(1);
            bGridPane3.setRowGap(10.0);
            bGridPane3.setColumnAlign(BHalign.center);
            bGridPane3.add(null, (BValue)bGridPane2);
            bGridPane3.add(null, (BValue)bButton);
            this.setContent((BWidget)bGridPane3);
        } else {
            this.buildInterface();
            XParser xParser = XParser.make((InputStream)bIFile.getInputStream());
            XElem xElem = xParser.parse();
            XElem[] xElemArray = xElem.elems();
            if (xElemArray.length > 0) {
                this.model.root = this.parseNode(null, xElemArray[0]);
            }
            new ExpandAllCommand(this, this.model.root).invoke();
            this.model.getSelection().updateTable();
            this.setTransferWidget((BTransferWidget)this.model.getTreeTable());
        }
    }

    protected BObject doSaveValue(BObject bObject, Context context) throws Exception {
        BIFile bIFile = (BIFile)bObject;
        XWriter xWriter = new XWriter(bIFile.getOutputStream());
        xWriter.prolog();
        xWriter.w((Object)"<nav version='1.0'>\n");
        if (this.model.root != null) {
            this.writeNode(xWriter, this.model.root, 0);
        }
        xWriter.w((Object)"</nav>\n");
        xWriter.close();
        return bObject;
    }

    private Node parseNode(Node node, XElem xElem) {
        String string = xElem.get("name", "");
        String string2 = xElem.get("ord", "null");
        String string3 = xElem.get("icon", "module://icons/x16/folder.png");
        Node node2 = null;
        node2 = node == null ? new Node(this.model, string, BOrd.make((String)string2), BImage.make((String)string3)) : new Node(node, string, BOrd.make((String)string2), BImage.make((String)string3));
        XElem[] xElemArray = xElem.elems();
        for (int i = 0; i < xElemArray.length; ++i) {
            node2.kids.add(this.parseNode(node2, xElemArray[i]));
        }
        return node2;
    }

    private void writeNode(XWriter xWriter, Node node, int n) {
        xWriter.indent(n).w((Object)"<node");
        xWriter.w((Object)" name='").safe(node.name).w((Object)"'");
        xWriter.w((Object)" ord='").safe(node.ord.toString()).w((Object)"'");
        xWriter.w((Object)" icon='").safe(node.icon.getOrdList().get(0).toString()).w((Object)"'");
        if (node.kids.size() > 0) {
            xWriter.w((Object)">\n");
            for (int i = 0; i < node.kids.size(); ++i) {
                this.writeNode(xWriter, (Node)((Object)node.kids.get(i)), n + 2);
            }
            xWriter.indent(n).w((Object)"</node>\n");
        } else {
            xWriter.w((Object)"/>\n");
        }
    }

    Node findNode(String[] stringArray) {
        Node node = this.model.root;
        block0: for (int i = 1; i < stringArray.length; ++i) {
            for (int j = 0; j < node.kids.size(); ++j) {
                Node node2 = (Node)((Object)node.kids.get(j));
                if (!node2.name.equals(stringArray[i])) continue;
                node = node2;
                continue block0;
            }
        }
        return node;
    }

    String[] toPath(Node node) {
        ArrayList<String> arrayList = new ArrayList<String>();
        while (node != null) {
            arrayList.add(0, node.name);
            node = (Node)node.getParent();
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    boolean sameParent(int[] nArray) {
        if (nArray.length == 0) {
            return false;
        }
        Node node = (Node)this.model.rowToNode(nArray[0]);
        Node node2 = (Node)node.getParent();
        for (int i = 1; i < nArray.length; ++i) {
            node = (Node)this.model.rowToNode(nArray[i]);
            if (node2 == node.getParent()) continue;
            return false;
        }
        return true;
    }

    boolean isValidName(Node node, String string) {
        for (int i = 0; i < node.kids.size(); ++i) {
            Node node2 = (Node)((Object)node.kids.get(i));
            if (!node2.name.equals(string)) continue;
            return false;
        }
        return true;
    }

    String getValidName(Node node, String string) {
        int n = 1;
        String string2 = string;
        for (int i = 0; i < node.kids.size(); ++i) {
            Node node2 = (Node)((Object)node.kids.get(i));
            if (!node2.name.equals(string2)) continue;
            string2 = string + n++;
            i = -1;
        }
        return string2;
    }

    DragRenderer makeDragRenderer() {
        int[] nArray = this.model.getSelection().getRows();
        if (nArray.length == 0 || !this.sameParent(nArray)) {
            return null;
        }
        this.dragNodes = new Node[nArray.length];
        BImage[] bImageArray = new BImage[nArray.length];
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 0) {
                return null;
            }
            Node node = (Node)this.model.rowToNode(nArray[i]);
            bImageArray[i] = node.icon;
            stringArray[i] = node.name;
            this.dragNodes[i] = node;
        }
        SimpleDragRenderer simpleDragRenderer = new SimpleDragRenderer(bImageArray, stringArray);
        simpleDragRenderer.font = Theme.table().getCellFont();
        simpleDragRenderer.xCursorOffset = 0.0;
        simpleDragRenderer.yCursorOffset = 0.0;
        return simpleDragRenderer;
    }

    CommandArtifact insertTransferData(TransferContext transferContext, boolean bl) throws Exception {
        int n;
        int[] nArray;
        Object object = bl ? ((nArray = this.model.getSelection().getRows()).length == 0 ? this.model.root : (Node)this.model.rowToNode(nArray[0])) : ((n = this.model.getTable().getRowAt(transferContext.getY())) == -1 && this.model.root == null ? null : (Node)this.model.rowToNode(n == -1 ? 0 : n));
        return this.txSupport.insert((Node)((Object)object), transferContext);
    }

    String toNodeName(BINavNode bINavNode) {
        int n;
        String string = bINavNode.getNavDisplayName(this.getCurrentContext());
        if (bINavNode instanceof BIFile && (n = string.lastIndexOf(".")) != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    private void reorder(Node node, String[] stringArray, boolean[] blArray) {
        node.setExpanded(true);
        this.model.getSelection().deselectAll();
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < node.kids.size(); ++j) {
                Node node2 = (Node)((Object)node.kids.get(j));
                if (!node2.name.equals(stringArray[i])) continue;
                node.kids.remove((Object)node2);
                node.kids.add(i, node2);
                if (!blArray[i]) continue;
                this.model.updateTreeTable(false);
                this.model.getSelection().select(this.model.nodeToRow(node2));
            }
        }
        this.model.updateTreeTable(true);
        this.setModified();
    }

    static String text(String string) {
        return lex.getText("navFileEditor." + string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Snapshot {
        public String name;
        public BOrd ord;
        public BImage icon;

        public Snapshot(String string, BOrd bOrd, BImage bImage) {
            this.name = string;
            this.ord = bOrd;
            this.icon = bImage;
        }
    }

    class CollapseAllCommand
    extends Command {
        Node node;

        public CollapseAllCommand(BWidget bWidget, Node node) {
            super(bWidget, module, "navFileEditor.collapseAll");
            this.node = node;
        }

        public CommandArtifact doInvoke() {
            if (this.node != null) {
                this.collapse(this.node);
            }
            return null;
        }

        public void collapse(Node node) {
            node.setExpanded(false);
            for (int i = 0; i < node.kids.size(); ++i) {
                this.collapse((Node)((Object)node.kids.get(i)));
            }
        }
    }

    class ExpandAllCommand
    extends Command {
        Node node;

        public ExpandAllCommand(BWidget bWidget, Node node) {
            super(bWidget, module, "navFileEditor.expandAll");
            this.node = node;
        }

        public CommandArtifact doInvoke() {
            if (this.node != null) {
                this.expand(this.node);
            }
            return null;
        }

        public void expand(Node node) {
            node.setExpanded(true);
            for (int i = 0; i < node.kids.size(); ++i) {
                this.expand((Node)((Object)node.kids.get(i)));
            }
        }
    }

    class ReorderArtifact
    implements CommandArtifact {
        String[] path;
        String[] oldOrder;
        String[] newOrder;
        boolean[] oldSel;
        boolean[] newSel;

        public ReorderArtifact(String[] stringArray, String[] stringArray2, String[] stringArray3, boolean[] blArray, boolean[] blArray2) {
            this.path = stringArray;
            this.oldOrder = stringArray2;
            this.newOrder = stringArray3;
            this.oldSel = blArray;
            this.newSel = blArray2;
        }

        public void undo() throws Exception {
            Node node = BNavFileEditor.this.findNode(this.path);
            BNavFileEditor.this.reorder(node, this.oldOrder, this.oldSel);
        }

        public void redo() throws Exception {
            Node node = BNavFileEditor.this.findNode(this.path);
            BNavFileEditor.this.reorder(node, this.newOrder, this.newSel);
        }
    }

    class MoveDownCommand
    extends Command {
        public MoveDownCommand(BWidget bWidget) {
            super(bWidget, module, "navFileEditor.moveDown");
        }

        public CommandArtifact doInvoke() throws Exception {
            int[] nArray = BNavFileEditor.this.model.getSelection().getRows();
            if (BNavFileEditor.this.sameParent(nArray)) {
                Node node;
                int n;
                Node node2 = (Node)BNavFileEditor.this.model.rowToNode(nArray[0]).getParent();
                String[] stringArray = new String[node2.kids.size()];
                String[] stringArray2 = new String[node2.kids.size()];
                boolean[] blArray = new boolean[stringArray2.length];
                boolean[] blArray2 = new boolean[stringArray.length];
                for (n = 0; n < stringArray2.length; ++n) {
                    node = (Node)((Object)node2.kids.get(n));
                    stringArray2[n] = node.name;
                    stringArray[n] = node.name;
                    blArray2[n] = false;
                    blArray[n] = false;
                }
                for (n = nArray.length - 1; n >= 0; --n) {
                    node = (Node)BNavFileEditor.this.model.rowToNode(nArray[n]);
                    int n2 = node2.kids.indexOf((Object)node);
                    if (n2 == node2.kids.size() - 1) {
                        if (n != nArray.length - 1) break;
                        return null;
                    }
                    String string = stringArray[n2];
                    stringArray[n2] = stringArray[n2 + 1];
                    stringArray[n2 + 1] = string;
                    blArray[n2] = true;
                    blArray2[n2 + 1] = true;
                }
                ReorderArtifact reorderArtifact = new ReorderArtifact(BNavFileEditor.this.toPath(node2), stringArray2, stringArray, blArray, blArray2);
                reorderArtifact.redo();
                return reorderArtifact;
            }
            return null;
        }
    }

    class MoveUpCommand
    extends Command {
        public MoveUpCommand(BWidget bWidget) {
            super(bWidget, module, "navFileEditor.moveUp");
        }

        public CommandArtifact doInvoke() throws Exception {
            int[] nArray = BNavFileEditor.this.model.getSelection().getRows();
            if (BNavFileEditor.this.sameParent(nArray)) {
                Node node;
                int n;
                Node node2 = (Node)BNavFileEditor.this.model.rowToNode(nArray[0]).getParent();
                String[] stringArray = new String[node2.kids.size()];
                String[] stringArray2 = new String[node2.kids.size()];
                boolean[] blArray = new boolean[stringArray2.length];
                boolean[] blArray2 = new boolean[stringArray.length];
                for (n = 0; n < stringArray2.length; ++n) {
                    node = (Node)((Object)node2.kids.get(n));
                    stringArray2[n] = node.name;
                    stringArray[n] = node.name;
                    blArray2[n] = false;
                    blArray[n] = false;
                }
                for (n = 0; n < nArray.length; ++n) {
                    node = (Node)BNavFileEditor.this.model.rowToNode(nArray[n]);
                    int n2 = node2.kids.indexOf((Object)node);
                    if (n2 == 0) {
                        if (n != 0) break;
                        return null;
                    }
                    String string = stringArray[n2 - 1];
                    stringArray[n2 - 1] = stringArray[n2];
                    stringArray[n2] = string;
                    blArray[n2] = true;
                    blArray2[n2 - 1] = true;
                }
                ReorderArtifact reorderArtifact = new ReorderArtifact(BNavFileEditor.this.toPath(node2), stringArray2, stringArray, blArray, blArray2);
                reorderArtifact.redo();
                return reorderArtifact;
            }
            return null;
        }
    }

    class EditCommand
    extends Command {
        public EditCommand(BWidget bWidget) {
            super(bWidget, module, "navFileEditor.edit");
        }

        public CommandArtifact doInvoke() {
            int[] nArray = BNavFileEditor.this.model.getSelection().getRows();
            if (nArray.length > 0) {
                Node node = (Node)BNavFileEditor.this.model.rowToNode(nArray[0]);
                String string = nArray.length == 1 ? BNavFileEditor.text("edit.label") : BNavFileEditor.text("editMultiple");
                BTextField bTextField = new BTextField(node.name, 40);
                BWbFieldEditor bWbFieldEditor = BWbFieldEditor.makeFor((BObject)node.ord);
                BWbFieldEditor bWbFieldEditor2 = BWbFieldEditor.makeFor((BObject)node.icon);
                bWbFieldEditor.loadValue((BObject)node.ord, (Context)new BasicContext(BNavFileEditor.this.getCurrentContext(), BFacets.make((String)"chooseView", (boolean)true)));
                bWbFieldEditor2.loadValue((BObject)node.icon, BNavFileEditor.this.getCurrentContext());
                BGridPane bGridPane = new BGridPane(2);
                bGridPane.setHalign(BHalign.left);
                bGridPane.add(null, (BValue)new BLabel(lexName));
                bGridPane.add(null, (BValue)bTextField);
                bGridPane.add(null, (BValue)new BLabel(lexOrd));
                bGridPane.add(null, (BValue)bWbFieldEditor);
                bGridPane.add(null, (BValue)new BLabel(lexIcon));
                bGridPane.add(null, (BValue)bWbFieldEditor2);
                BBorderPane bBorderPane = new BBorderPane((BWidget)bGridPane);
                BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)bBorderPane);
                bConstrainedPane.setMinWidth(700.0);
                if (1 == BDialog.open((BWidget)this.getOwner(), (String)string, (Object)bConstrainedPane, (int)3)) {
                    Node node2 = (Node)node.getParent();
                    if (node2 != null && !BNavFileEditor.this.isValidName(node2, bTextField.getText()) && !node.name.equals(bTextField.getText())) {
                        BDialog.error((BWidget)this.getOwner(), (String)"", (Object)BNavFileEditor.text("namingError"));
                        return BNavFileEditor.this.editCommand.doInvoke();
                    }
                    try {
                        Snapshot snapshot = new Snapshot(node.name, node.ord, node.icon);
                        Snapshot snapshot2 = new Snapshot(bTextField.getText(), (BOrd)bWbFieldEditor.saveValue(), (BImage)bWbFieldEditor2.saveValue());
                        Artifact artifact = new Artifact(BNavFileEditor.this.toPath(node), snapshot, snapshot2);
                        artifact.redo();
                        return artifact;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            return null;
        }

        class Artifact
        implements CommandArtifact {
            String[] oldPath;
            String[] newPath;
            Snapshot oldNode;
            Snapshot newNode;

            public Artifact(String[] stringArray, Snapshot snapshot, Snapshot snapshot2) {
                this.newPath = stringArray;
                this.oldPath = new String[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    this.oldPath[i] = stringArray[i];
                }
                this.oldPath[this.oldPath.length - 1] = snapshot2.name;
                this.oldNode = snapshot;
                this.newNode = snapshot2;
            }

            public void undo() throws Exception {
                Node node = BNavFileEditor.this.findNode(this.oldPath);
                node.name = this.oldNode.name;
                node.ord = this.oldNode.ord;
                node.icon = this.oldNode.icon;
                ((EditCommand)EditCommand.this).BNavFileEditor.this.model.updateTreeTable(true);
                BNavFileEditor.this.setModified();
            }

            public void redo() throws Exception {
                Node node = BNavFileEditor.this.findNode(this.newPath);
                node.name = this.newNode.name;
                node.ord = this.newNode.ord;
                node.icon = this.newNode.icon;
                ((EditCommand)EditCommand.this).BNavFileEditor.this.model.updateTreeTable(true);
                BNavFileEditor.this.setModified();
            }
        }
    }

    class NewCommand
    extends Command {
        private Node parent;
        private Node child;

        public NewCommand(BWidget bWidget, Node node) {
            super(bWidget, module, "navFileEditor.new");
            this.parent = node;
        }

        public CommandArtifact doInvoke() throws Exception {
            Object object;
            BTextField bTextField = new BTextField(defaultName, 40);
            BWbFieldEditor bWbFieldEditor = BWbFieldEditor.makeFor((BObject)defaultOrd);
            BWbFieldEditor bWbFieldEditor2 = BWbFieldEditor.makeFor((BObject)defaultIcon);
            bWbFieldEditor.loadValue((BObject)defaultOrd, (Context)new BasicContext(BNavFileEditor.this.getCurrentContext(), BFacets.make((String)"chooseView", (boolean)true)));
            bWbFieldEditor2.loadValue((BObject)defaultIcon, BNavFileEditor.this.getCurrentContext());
            BGridPane bGridPane = new BGridPane(2);
            bGridPane.add(null, (BValue)new BLabel(lexName));
            bGridPane.add(null, (BValue)bTextField);
            bGridPane.add(null, (BValue)new BLabel(lexOrd));
            bGridPane.add(null, (BValue)bWbFieldEditor);
            bGridPane.add(null, (BValue)new BLabel(lexIcon));
            bGridPane.add(null, (BValue)bWbFieldEditor2);
            BBorderPane bBorderPane = new BBorderPane((BWidget)bGridPane);
            if (1 != BDialog.open((BWidget)this.getOwner(), (String)BNavFileEditor.text("new.label"), (Object)bBorderPane, (int)3)) {
                return null;
            }
            Node node = this.parent;
            if (node == null) {
                object = BNavFileEditor.this.model.getSelection().getRows();
                node = ((int[])object).length == 0 ? BNavFileEditor.this.model.root : (Node)BNavFileEditor.this.model.rowToNode(object[0]);
            }
            object = BNavFileEditor.this.getValidName(node, bTextField.getText());
            BOrd bOrd = (BOrd)bWbFieldEditor.saveValue();
            BImage bImage = (BImage)bWbFieldEditor2.saveValue();
            Artifact artifact = new Artifact(BNavFileEditor.this.toPath(node), new Snapshot((String)object, bOrd, bImage));
            artifact.redo();
            return artifact;
        }

        class Artifact
        implements CommandArtifact {
            String[] parent;
            Snapshot snap;

            public Artifact(String[] stringArray, Snapshot snapshot) {
                this.parent = stringArray;
                this.snap = snapshot;
            }

            public void undo() throws Exception {
                Node node = BNavFileEditor.this.findNode(this.parent);
                for (int i = 0; i < node.kids.size(); ++i) {
                    Node node2 = (Node)((Object)node.kids.get(i));
                    if (!node2.name.equals(this.snap.name)) continue;
                    node.kids.remove((Object)node2);
                    ((NewCommand)NewCommand.this).BNavFileEditor.this.model.updateTreeTable(true);
                    BNavFileEditor.this.setModified();
                    return;
                }
            }

            public void redo() throws Exception {
                Node node = BNavFileEditor.this.findNode(this.parent);
                node.kids.add(new Node(node, this.snap.name, this.snap.ord, this.snap.icon));
                node.setExpanded(true);
                ((NewCommand)NewCommand.this).BNavFileEditor.this.model.updateTreeTable(true);
                BNavFileEditor.this.setModified();
            }
        }
    }

    class ShowFilesCommand
    extends ToggleCommand {
        public ShowFilesCommand(BWidget bWidget) {
            super(bWidget, module, "navFileEditor.showFiles");
        }

        public CommandArtifact doInvoke() {
            BNavFileEditor.this.computeSourceVisible();
            BNavFileEditor.this.source.showFiles(this.isSelected());
            return null;
        }
    }

    class ShowComponentsCommand
    extends ToggleCommand {
        public ShowComponentsCommand(BWidget bWidget) {
            super(bWidget, module, "navFileEditor.showComponents");
        }

        public CommandArtifact doInvoke() {
            BNavFileEditor.this.computeSourceVisible();
            BNavFileEditor.this.source.showComponents(this.isSelected());
            return null;
        }
    }

    class OpenTextEditor
    extends Command {
        public OpenTextEditor(BWidget bWidget) {
            super(bWidget, lexOpenText);
        }

        public CommandArtifact doInvoke() {
            BOrd bOrd = BNavFileEditor.this.getWbShell().getActiveOrd();
            bOrd = BOrd.make((BOrd)bOrd, (String)"view:workbench:TextFileEditor");
            BNavFileEditor.this.getWbShell().hyperlink(bOrd);
            return null;
        }
    }

    class Controller
    extends TreeTableController {
        Controller() {
        }

        public void keyPressed(BKeyEvent bKeyEvent) {
            super.keyPressed(bKeyEvent);
            if (bKeyEvent.getKeyCode() == 10 && BNavFileEditor.this.editCommand.isEnabled()) {
                BNavFileEditor.this.editCommand.invoke();
            }
        }

        protected void cellDoubleClicked(BMouseEvent bMouseEvent, int n, int n2) {
            if (BNavFileEditor.this.editCommand.isEnabled()) {
                BNavFileEditor.this.editCommand.invoke();
            }
        }

        protected BMenu makePopup(TreeTableSubject treeTableSubject) {
            BMenu bMenu = new BMenu();
            Node node = (Node)treeTableSubject.getActiveNode();
            if (node == null) {
                bMenu.add(null, (Command)new NewCommand((BWidget)this.getTable(), BNavFileEditor.this.model.root));
                bMenu.add(null, BNavFileEditor.this.commands.paste);
            } else {
                bMenu.add(null, (Command)new NewCommand((BWidget)this.getTable(), node));
                bMenu.add(null, (Command)BNavFileEditor.this.editCommand);
                bMenu.add(null, (Command)BNavFileEditor.this.moveUpCommand);
                bMenu.add(null, (Command)BNavFileEditor.this.moveDownCommand);
                bMenu.add(null, (BValue)new BSeparator());
                bMenu.add(null, BNavFileEditor.this.commands.cut);
                bMenu.add(null, BNavFileEditor.this.commands.copy);
                bMenu.add(null, BNavFileEditor.this.commands.paste);
                bMenu.add(null, BNavFileEditor.this.commands.duplicate);
                bMenu.add(null, BNavFileEditor.this.commands.delete);
                bMenu.add(null, (BValue)new BSeparator());
                bMenu.add(null, (Command)new ExpandAllCommand((BWidget)this.getTable(), node));
                bMenu.add(null, (Command)new CollapseAllCommand((BWidget)this.getTable(), node));
            }
            return bMenu;
        }
    }

    class Selection
    extends TreeTableSelection {
        Selection() {
        }

        public void updateTable() {
            super.updateTable();
            int[] nArray = this.getRows();
            boolean bl = nArray.length > 0;
            boolean bl2 = BNavFileEditor.this.sameParent(nArray);
            BNavFileEditor.this.editCommand.setEnabled(bl);
            BNavFileEditor.this.model.getTreeTable().setCutEnabled(bl2);
            BNavFileEditor.this.model.getTreeTable().setCopyEnabled(bl2);
            BNavFileEditor.this.model.getTreeTable().setDuplicateEnabled(bl2);
            BNavFileEditor.this.model.getTreeTable().setDeleteEnabled(bl2);
            BNavFileEditor.this.moveUpCommand.setEnabled(bl2);
            BNavFileEditor.this.moveDownCommand.setEnabled(bl2);
            BNavFileEditor.this.repaint();
        }
    }

    class Model
    extends TreeTableModel {
        Node root;

        Model() {
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            return n == 0 ? lexName : lexOrd;
        }

        public int getRootCount() {
            return this.root == null ? 0 : 1;
        }

        public TreeTableNode getRoot(int n) {
            return this.root;
        }
    }
}

