/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.nav;

import com.tridium.sys.Nre;
import java.util.HashMap;
import java.util.Iterator;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavListener;
import javax.baja.nre.util.Array;
import javax.baja.space.BISpaceNode;
import javax.baja.space.BSpace;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.ui.table.TableModel;
import javax.baja.workbench.nav.tree.BNavTree;
import javax.baja.workbench.nav.tree.NavTreeNode;

public class NavMonitor
extends Thread {
    public static final long SCAN_RATE = Long.getLong("niagara.nav.touch.scanRate", 20000L);
    static NavMonitor monitor = null;
    static BAbsTime lastScanStart = BAbsTime.NULL;
    static long lastScanTicks = 0L;
    static long minScanTicks = Long.MAX_VALUE;
    static long maxScanTicks = Long.MIN_VALUE;
    static long sumScanTicks = 0L;
    static long numScans = 0L;
    static Log log = Log.getLog((String)"NavMonitor");
    static /* synthetic */ Class class$javax$baja$naming$BOrd;

    public static NavMonitor get() {
        if (monitor == null) {
            log.message("*** NavMonitor lazy init ***");
            NavMonitor.init();
        }
        return monitor;
    }

    public static void init() {
        if (monitor == null) {
            monitor = new NavMonitor();
            monitor.start();
            if (log.isTraceOn()) {
                log.trace("NavMonitor thread started.");
            }
        }
    }

    NavMonitor() {
        super(Nre.mainThreadGroup, "Ui:NavMonitor");
        this.setDaemon(true);
        Spy.ROOT.add("navMonitor", (Spy)new MySpy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (SCAN_RATE <= 0L) {
            if (log.isTraceOn()) {
                log.trace("NavMonitor disabled since SCAN_RATE = " + SCAN_RATE);
            }
            return;
        }
        long l = SCAN_RATE - 500L;
        if (l <= 0L) {
            l = SCAN_RATE;
        }
        if (log.isTraceOn()) {
            log.trace("NavMonitor enabled with SCAN_RATE = " + SCAN_RATE);
        }
        while (true) {
            try {
                while (true) {
                    NavMonitor navMonitor = this;
                    synchronized (navMonitor) {
                        this.wait(l);
                    }
                    Thread.sleep(500L);
                    lastScanStart = BAbsTime.now();
                    long l2 = Clock.ticks();
                    if (log.isTraceOn()) {
                        log.trace("Performing full TOUCH Scan");
                    }
                    this.scan();
                    NavMonitor navMonitor2 = monitor;
                    synchronized (navMonitor2) {
                        lastScanTicks = Clock.ticks() - l2;
                        minScanTicks = Math.min(lastScanTicks, minScanTicks);
                        maxScanTicks = Math.max(lastScanTicks, maxScanTicks);
                        sumScanTicks += lastScanTicks;
                        ++numScans;
                    }
                    if (!log.isTraceOn()) continue;
                    log.trace("Completed full TOUCH Scan in " + lastScanTicks + " ticks");
                }
            }
            catch (Throwable throwable) {
                log.error("Exception in NavMonitor", throwable);
                continue;
            }
            break;
        }
    }

    void scan() {
        Array array;
        BNavTree bNavTree;
        NavListener[] navListenerArray = BNavRoot.INSTANCE.getNavListeners();
        if (navListenerArray == null) {
            return;
        }
        HashMap<BSpace, Array> hashMap = new HashMap<BSpace, Array>();
        for (int i = 0; i < navListenerArray.length; ++i) {
            int n;
            Array array2;
            BSpace bSpace;
            BISpaceNode bISpaceNode;
            Object object;
            int n2;
            if (navListenerArray[i] instanceof BNavTree) {
                bNavTree = (BNavTree)navListenerArray[i];
                array = bNavTree.getVisibleNodes();
                if (array == null) continue;
                for (n2 = 0; n2 < ((Array)array).length; ++n2) {
                    object = ((NavTreeNode)array[n2]).getNavNode();
                    if (!(object instanceof BISpaceNode)) continue;
                    bISpaceNode = (BISpaceNode)object;
                    bSpace = bISpaceNode.getSpace();
                    array2 = (Array)hashMap.get(bSpace);
                    if (array2 == null) {
                        array2 = new Array(class$javax$baja$naming$BOrd == null ? NavMonitor.class$("javax.baja.naming.BOrd") : class$javax$baja$naming$BOrd);
                        hashMap.put(bSpace, array2);
                    }
                    array2.add((Object)bISpaceNode.getOrdInSpace());
                }
                continue;
            }
            if (!(navListenerArray[i] instanceof TableModel) || (n = (bNavTree = (TableModel)navListenerArray[i]).getRowCount()) < 1) continue;
            for (n2 = 0; n2 < n; ++n2) {
                object = bNavTree.getSubject(n2);
                if (!(object instanceof BINavNode) || !(object instanceof BISpaceNode)) continue;
                bISpaceNode = (BISpaceNode)object;
                bSpace = bISpaceNode.getSpace();
                array2 = (Array)hashMap.get(bSpace);
                if (array2 == null) {
                    array2 = new Array(class$javax$baja$naming$BOrd == null ? NavMonitor.class$("javax.baja.naming.BOrd") : class$javax$baja$naming$BOrd);
                    hashMap.put(bSpace, array2);
                }
                array2.add((Object)bISpaceNode.getOrdInSpace());
            }
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            bNavTree = (BSpace)iterator.next();
            if (bNavTree == null) continue;
            array = (Array)hashMap.get((Object)bNavTree);
            bNavTree.fw(110, (BOrd[])array.trim(), null, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spy(SpyWriter spyWriter) {
        spyWriter.startProps();
        spyWriter.trTitle((Object)"NavMonitor", 2);
        if (SCAN_RATE <= 0L) {
            spyWriter.prop((Object)"SCAN_RATE", (Object)(SCAN_RATE + " (disabled)"));
        } else {
            spyWriter.prop((Object)"SCAN_RATE", (Object)(SCAN_RATE + " (" + BRelTime.make((long)SCAN_RATE) + ")"));
        }
        spyWriter.prop((Object)"lastScanStart", (Object)lastScanStart);
        NavMonitor navMonitor = monitor;
        synchronized (navMonitor) {
            spyWriter.prop((Object)"numScans", (Object)("" + numScans));
            spyWriter.prop((Object)"lastScanTicks", (Object)(lastScanTicks + " (" + BRelTime.make((long)lastScanTicks) + ")"));
            spyWriter.prop((Object)"minScanTicks", (Object)(minScanTicks + " (" + BRelTime.make((long)minScanTicks) + ")"));
            spyWriter.prop((Object)"maxScanTicks", (Object)(maxScanTicks + " (" + BRelTime.make((long)maxScanTicks) + ")"));
            if (numScans > 0L) {
                double d = (double)sumScanTicks / (double)numScans;
                spyWriter.prop((Object)"avgScanTicks", (Object)(d + " (" + BRelTime.make((long)((long)d)) + ")"));
            }
        }
        spyWriter.endProps();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class MySpy
    extends Spy {
        MySpy() {
        }

        public void write(SpyWriter spyWriter) {
            NavMonitor.this.spy(spyWriter);
        }
    }
}

