/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.nav;

import com.tridium.sys.transfer.FileToFile;
import com.tridium.ui.BOptionDialog;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.util.BFileSearch;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FilePath;
import javax.baja.file.FileUtil;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BSubMenuItem;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.commands.CopyCommand;
import javax.baja.ui.commands.CutCommand;
import javax.baja.ui.commands.DeleteCommand;
import javax.baja.ui.commands.DuplicateCommand;
import javax.baja.ui.commands.PasteCommand;
import javax.baja.ui.commands.RenameCommand;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.commands.FileRenameCommand;
import javax.baja.workbench.nav.menu.BNavMenuAgent;
import javax.baja.workbench.nav.menu.NavMenuUtil;

public class BFileMenuAgent
extends BNavMenuAgent {
    public static final BFileMenuAgent INSTANCE = new BFileMenuAgent();
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$nav$BFileMenuAgent == null ? (class$com$tridium$workbench$nav$BFileMenuAgent = BFileMenuAgent.class$("com.tridium.workbench.nav.BFileMenuAgent")) : class$com$tridium$workbench$nav$BFileMenuAgent));
    static final int READONLY = 1;
    static final int ROOT = 2;
    public static boolean disable = System.getProperty("workbench.disableIfNoPermission", "true").equals("true");
    static /* synthetic */ Class class$com$tridium$workbench$nav$BFileMenuAgent;

    public Type getType() {
        return TYPE;
    }

    protected BMenu doMakeMenu(BWidget bWidget, BObject bObject, Context context) {
        BMenu bMenu;
        BIFile bIFile = bObject instanceof BFileSpace ? ((BFileSpace)bObject).resolveFile(new FilePath("^")) : (BIFile)bObject;
        BMenu bMenu2 = new BMenu();
        BMenu bMenu3 = NavMenuUtil.makeViewsMenu(bWidget, (BObject)bIFile);
        bMenu2.add("views", (BValue)new BSubMenuItem(bMenu3));
        if (!(!bIFile.isDirectory() || bIFile.isReadonly() && disable || (bMenu = BFileMenuAgent.makeNewMenu(bWidget, (BDirectory)bIFile)) == null)) {
            bMenu2.add(null, (BValue)new BSubMenuItem(bMenu));
        }
        bMenu2.add(null, (BValue)new BSeparator());
        BFileMenuAgent.addEditCommands(bMenu2, bWidget, bIFile);
        if (bIFile.isDirectory() && bIFile.getStore() instanceof BLocalFileStore) {
            bMenu2.add(null, (BValue)new BSeparator());
            bMenu2.add(null, (Command)new FindFilesCommand(bWidget, bIFile));
        }
        return bMenu2;
    }

    public static void addEditCommands(BMenu bMenu, BWidget bWidget, BIFile bIFile) {
        String string;
        FilePath filePath = bIFile.getFilePath();
        int n = 0;
        if (bIFile.isReadonly()) {
            n |= 1;
        }
        if (filePath.depth() == 0) {
            n |= 2;
        }
        if (filePath.depth() == 1 && (string = filePath.nameAt(0)).length() == 2 && string.charAt(1) == ':') {
            n |= 2;
        }
        if (bWidget instanceof BTransferWidget) {
            string = (BTransferWidget)bWidget;
            BFileMenuAgent.addCut(bMenu, (BTransferWidget)string, bIFile, n);
            BFileMenuAgent.addCopy(bMenu, (BTransferWidget)string, bIFile, n);
            BFileMenuAgent.addPaste(bMenu, (BTransferWidget)string, bIFile, n);
            BFileMenuAgent.addDuplicate(bMenu, (BTransferWidget)string, bIFile, n);
            BFileMenuAgent.addDelete(bMenu, (BTransferWidget)string, bIFile, n);
        }
        BFileMenuAgent.addRename(bMenu, bWidget, bIFile, n);
    }

    public static void addCut(BMenu bMenu, BTransferWidget bTransferWidget, BIFile bIFile, int n) {
        CutCommand cutCommand = new CutCommand(bTransferWidget);
        if ((BFileMenuAgent.isReadonlyOrRoot(n) || !bTransferWidget.isCutEnabled()) && disable) {
            cutCommand.setEnabled(false);
        }
        bMenu.add("cut", (Command)cutCommand);
    }

    public static void addCopy(BMenu bMenu, BTransferWidget bTransferWidget, BIFile bIFile, int n) {
        CopyCommand copyCommand = new CopyCommand(bTransferWidget);
        if (!bTransferWidget.isCopyEnabled() && disable) {
            copyCommand.setEnabled(false);
        }
        bMenu.add("copy", (Command)copyCommand);
    }

    public static void addPaste(BMenu bMenu, BTransferWidget bTransferWidget, BIFile bIFile, int n) {
        PasteCommand pasteCommand = new PasteCommand(bTransferWidget);
        if ((BFileMenuAgent.isReadonly(n) || !bTransferWidget.isPasteEnabled()) && disable) {
            pasteCommand.setEnabled(false);
        }
        bMenu.add("paste", (Command)pasteCommand);
    }

    public static void addDuplicate(BMenu bMenu, BTransferWidget bTransferWidget, BIFile bIFile, int n) {
        DuplicateCommand duplicateCommand = new DuplicateCommand(bTransferWidget);
        if ((BFileMenuAgent.isReadonlyOrRoot(n) || !bTransferWidget.isDuplicateEnabled()) && disable) {
            duplicateCommand.setEnabled(false);
        }
        bMenu.add("duplicate", (Command)duplicateCommand);
    }

    public static void addDelete(BMenu bMenu, BTransferWidget bTransferWidget, BIFile bIFile, int n) {
        DeleteCommand deleteCommand = new DeleteCommand(bTransferWidget);
        if ((BFileMenuAgent.isReadonlyOrRoot(n) || !bTransferWidget.isDeleteEnabled()) && disable) {
            deleteCommand.setEnabled(false);
        }
        bMenu.add("delete", (Command)deleteCommand);
    }

    public static void addRename(BMenu bMenu, BWidget bWidget, BIFile bIFile, int n) {
        Object object = bWidget instanceof BTransferWidget ? new RenameCommand((BTransferWidget)bWidget) : new FileRenameCommand(bWidget, bIFile);
        if (BFileMenuAgent.isReadonlyOrRoot(n) && disable) {
            object.setEnabled(false);
        }
        bMenu.add("rename", (Command)object);
    }

    public static BMenu makeNewMenu(BWidget bWidget, BDirectory bDirectory) {
        try {
            BMenu bMenu = new BMenu(UiLexicon.bajaui().getText("menu.new.label"));
            bMenu.add("xdir", (Command)new NewDirCommand(bWidget, bDirectory));
            BDirectory bDirectory2 = (BDirectory)BOrd.make((String)"file:!workbench/newfiles").get();
            BIFile[] bIFileArray = bDirectory2.listFiles();
            for (int i = 0; bIFileArray != null && i < bIFileArray.length; ++i) {
                if (i == 0) {
                    bMenu.add(null, (BValue)new BSeparator());
                }
                bMenu.add("x" + i, (Command)new NewFileCommand(bWidget, bDirectory, bIFileArray[i]));
            }
            return bMenu;
        }
        catch (Exception exception) {
            System.out.println("WARNING:  Cannot make new menu: " + exception);
            return null;
        }
    }

    public static String promptName(BWidget bWidget, String string, BDirectory bDirectory, String string2) {
        String string3 = FileToFile.getUniqueFilename((BDirectory)bDirectory, (String)string2);
        while ((string3 = BOptionDialog.promptFileName((BWidget)bWidget, (String)string, (String)string3)) != null) {
            if (FileToFile.isUniqueFilename((BDirectory)bDirectory, (String)string3)) {
                return string3;
            }
            BDialog.error((BWidget)bWidget, (Object)UiLexicon.bajaui().getText("newFile.duplicateName", new Object[]{string3}));
        }
        return null;
    }

    static boolean isReadonly(int n) {
        return (n & 1) != 0;
    }

    static boolean isRoot(int n) {
        return (n & 2) != 0;
    }

    static boolean isReadonlyOrRoot(int n) {
        return BFileMenuAgent.isReadonly(n) || BFileMenuAgent.isRoot(n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class FindFilesCommand
    extends Command {
        BIFile dir;

        public FindFilesCommand(BWidget bWidget, BIFile bIFile) {
            super(bWidget, UiLexicon.bajaui().module, "commands.findFiles");
            this.dir = bIFile;
        }

        public CommandArtifact doInvoke() throws Exception {
            BWidgetShell bWidgetShell = this.getOwner().getShell();
            if (bWidgetShell instanceof BNiagaraWbShell) {
                BFileSearch.findFiles((BNiagaraWbShell)bWidgetShell, this.dir.getFilePath().toString());
            }
            return null;
        }
    }

    public static class NewFileCommand
    extends Command {
        BDirectory target;
        BIFile source;

        public NewFileCommand(BWidget bWidget, BDirectory bDirectory, BIFile bIFile) {
            super(bWidget, bIFile.getFileName());
            this.target = bDirectory;
            this.source = bIFile;
            this.icon = BImage.make((BIcon)bIFile.getNavIcon());
        }

        public CommandArtifact doInvoke() throws Exception {
            String string = UiLexicon.bajaui().getText("newFile.prompt");
            String string2 = BFileMenuAgent.promptName(this.getOwner(), string, this.target, this.source.getFileName());
            if (string2 == null) {
                return null;
            }
            FilePath.verifyValidName((String)string2);
            BIFile bIFile = this.target.getFileSpace().makeFile(this.target.getFilePath().merge(string2));
            FileUtil.pipe((BIFile)this.source, (BIFile)bIFile);
            return null;
        }
    }

    public static class NewDirCommand
    extends Command {
        BDirectory target;

        public NewDirCommand(BWidget bWidget, BDirectory bDirectory) {
            super(bWidget, UiLexicon.bajaui().module, "commands.newDir");
            this.target = bDirectory;
        }

        public CommandArtifact doInvoke() throws Exception {
            String string = UiLexicon.bajaui().getText("newDir.prompt");
            String string2 = BFileMenuAgent.promptName(this.getOwner(), string, this.target, "Folder");
            if (string2 == null) {
                return null;
            }
            FilePath.verifyValidName((String)string2);
            this.target.getFileSpace().makeDir(this.target.getFilePath().merge(string2));
            return null;
        }
    }
}

