/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.nav;

import com.tridium.util.PxUtil;
import com.tridium.workbench.commands.LinkFromCommand;
import com.tridium.workbench.commands.LinkMarkCommand;
import com.tridium.workbench.commands.LinkToCommand;
import com.tridium.workbench.commands.PasteSpecialCommand;
import com.tridium.workbench.file.BExportDialog;
import com.tridium.workbench.nav.BFileMenuAgent;
import com.tridium.workbench.nav.BToolSpace;
import com.tridium.workbench.transfer.TransferUtil;
import com.tridium.workbench.util.BComponentFinder;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.file.BExporter;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.security.BPermissions;
import javax.baja.space.BComponentSpace;
import javax.baja.space.Mark;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BSubMenuItem;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.commands.CopyCommand;
import javax.baja.ui.commands.CutCommand;
import javax.baja.ui.commands.DeleteCommand;
import javax.baja.ui.commands.DuplicateCommand;
import javax.baja.ui.commands.PasteCommand;
import javax.baja.ui.commands.RenameCommand;
import javax.baja.ui.commands.SetDisplayNameCommand;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BFolder;
import javax.baja.util.BWsAnnotation;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.commands.ComponentCompositeCommand;
import javax.baja.workbench.commands.ComponentRenameCommand;
import javax.baja.workbench.commands.ComponentReorderCommand;
import javax.baja.workbench.nav.menu.BNavMenuAgent;
import javax.baja.workbench.nav.menu.NavMenuUtil;

public class BComponentMenuAgent
extends BNavMenuAgent {
    public static final BComponentMenuAgent INSTANCE = new BComponentMenuAgent();
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$nav$BComponentMenuAgent == null ? (class$com$tridium$workbench$nav$BComponentMenuAgent = BComponentMenuAgent.class$("com.tridium.workbench.nav.BComponentMenuAgent")) : class$com$tridium$workbench$nav$BComponentMenuAgent));
    public static final String VIEWS = "views";
    public static final String ACTIONS = "actions";
    public static final String NEW = "new";
    public static final String CUT = "cut";
    public static final String COPY = "copy";
    public static final String PASTE = "paste";
    public static final String PASTE_SPECIAL = "pasteSpecial";
    public static final String DELETE = "delete";
    public static final String DUPLICATE = "duplicate";
    public static final String LINK_MARK = "linkMark";
    public static final String LINK_TO = "linkTo";
    public static final String LINK_FROM = "linkFrom";
    public static final String SET_DISPLAY_NAME = "setDisplayName";
    public static final String RENAME = "rename";
    public static final String REORDER = "reorder";
    public static final String COMPOSITE = "composite";
    public static final String FIND = "find";
    public static final String EXPORT = "export";
    static boolean disable = BFileMenuAgent.disable;
    static /* synthetic */ Class class$com$tridium$workbench$nav$BComponentMenuAgent;

    public Type getType() {
        return TYPE;
    }

    protected BMenu doMakeMenu(BWidget bWidget, BObject bObject, Context context) {
        BComponent bComponent = bObject instanceof BComponentSpace ? ((BComponentSpace)bObject).getRootComponent() : (BComponent)bObject;
        BMenu bMenu = new BMenu();
        BComponentSpace bComponentSpace = bComponent.getComponentSpace();
        boolean bl = bComponentSpace instanceof BToolSpace;
        bComponent.lease();
        BMenu bMenu2 = NavMenuUtil.makeViewsMenu(bWidget, (BObject)bComponent);
        bMenu.add(VIEWS, (BValue)new BSubMenuItem(bMenu2));
        BMenu bMenu3 = NavMenuUtil.makeActionsMenu(bWidget, bComponent);
        bMenu.add(ACTIONS, (BValue)new BSubMenuItem(bMenu3));
        bMenu.add(null, (BValue)new BSeparator());
        boolean bl2 = false;
        if (!bComponent.getPermissions(null).has(BPermissions.adminWrite)) {
            bl2 = true;
        } else if (bComponentSpace != null && bComponentSpace.isSpaceReadonly()) {
            bl2 = true;
        }
        if (bl) {
            this.addFind(bMenu, bWidget, bComponent);
        } else if (bl2 && disable) {
            this.addCopy(bMenu, bWidget, bComponent);
        } else {
            this.addNewMenu(bMenu, bWidget, bComponent);
            this.addCut(bMenu, bWidget, bComponent);
            this.addCopy(bMenu, bWidget, bComponent);
            this.addPaste(bMenu, bWidget, bComponent);
            this.addPasteSpecial(bMenu, bWidget, bComponent);
            this.addDuplicate(bMenu, bWidget, bComponent);
            this.addDelete(bMenu, bWidget, bComponent);
            bMenu.add(null, (BValue)new BSeparator());
            this.addFind(bMenu, bWidget, bComponent);
            bMenu.add(null, (BValue)new BSeparator());
            this.addLinkMark(bMenu, bWidget, bComponent);
            this.addLinkFrom(bMenu, bWidget, bComponent);
            this.addLinkTo(bMenu, bWidget, bComponent);
            bMenu.add(null, (BValue)new BSeparator());
            this.addRename(bMenu, bWidget, bComponent);
            this.addSetDisplayName(bMenu, bWidget, bComponent);
            this.addReorder(bMenu, bWidget, bComponent);
            this.addComposite(bMenu, bWidget, bComponent);
            bMenu.add(null, (BValue)new BSeparator());
            this.addExport(bMenu, bWidget, bComponent);
        }
        return bMenu;
    }

    private void addNewMenu(BMenu bMenu, BWidget bWidget, BComponent bComponent) {
        if (this.isReadonly(bComponent)) {
            return;
        }
        BMenu bMenu2 = BComponentMenuAgent.makeNewMenu(bWidget, bComponent, null);
        if (bMenu2 == null) {
            return;
        }
        bMenu.add(NEW, (BValue)new BSubMenuItem(bMenu2));
        bMenu.add(null, (BValue)new BSeparator());
    }

    private void addCut(BMenu bMenu, BWidget bWidget, BComponent bComponent) {
        if (bWidget instanceof BTransferWidget) {
            CutCommand cutCommand = new CutCommand((BTransferWidget)bWidget);
            if (this.isFrozen(bComponent)) {
                cutCommand.setEnabled(false);
            }
            if (this.isReadonly(bComponent)) {
                cutCommand.setEnabled(false);
            }
            if (!((BTransferWidget)bWidget).isCutEnabled()) {
                cutCommand.setEnabled(false);
            }
            bMenu.add(CUT, (Command)cutCommand);
        }
    }

    private void addCopy(BMenu bMenu, BWidget bWidget, BComponent bComponent) {
        if (bWidget instanceof BTransferWidget) {
            CopyCommand copyCommand = new CopyCommand((BTransferWidget)bWidget);
            if (!((BTransferWidget)bWidget).isCopyEnabled()) {
                copyCommand.setEnabled(false);
            }
            bMenu.add(COPY, (Command)copyCommand);
        }
    }

    private void addPaste(BMenu bMenu, BWidget bWidget, BComponent bComponent) {
        if (bWidget instanceof BTransferWidget) {
            PasteCommand pasteCommand = new PasteCommand((BTransferWidget)bWidget);
            if (this.isReadonly(bComponent)) {
                pasteCommand.setEnabled(false);
            }
            if (!((BTransferWidget)bWidget).isPasteEnabled()) {
                pasteCommand.setEnabled(false);
            }
            bMenu.add(PASTE, (Command)pasteCommand);
        }
    }

    private void addPasteSpecial(BMenu bMenu, BWidget bWidget, BComponent bComponent) {
        if (bWidget instanceof BTransferWidget) {
            PasteSpecialCommand pasteSpecialCommand = new PasteSpecialCommand((BTransferWidget)bWidget, bComponent);
            if (this.isReadonly(bComponent)) {
                pasteSpecialCommand.setEnabled(false);
            }
            if (!((BTransferWidget)bWidget).isPasteEnabled()) {
                pasteSpecialCommand.setEnabled(false);
            }
            bMenu.add(PASTE_SPECIAL, (Command)pasteSpecialCommand);
        }
    }

    private void addDuplicate(BMenu bMenu, BWidget bWidget, BComponent bComponent) {
        if (bWidget instanceof BTransferWidget) {
            DuplicateCommand duplicateCommand = new DuplicateCommand((BTransferWidget)bWidget);
            if (this.isReadonly(bComponent)) {
                duplicateCommand.setEnabled(false);
            }
            if (this.isRoot(bComponent)) {
                duplicateCommand.setEnabled(false);
            }
            if (!((BTransferWidget)bWidget).isDuplicateEnabled()) {
                duplicateCommand.setEnabled(false);
            }
            bMenu.add(DUPLICATE, (Command)duplicateCommand);
        }
    }

    private void addDelete(BMenu bMenu, BWidget bWidget, BComponent bComponent) {
        if (bWidget instanceof BTransferWidget) {
            DeleteCommand deleteCommand = new DeleteCommand((BTransferWidget)bWidget);
            if (this.isFrozen(bComponent)) {
                deleteCommand.setEnabled(false);
            }
            if (this.isReadonly(bComponent)) {
                deleteCommand.setEnabled(false);
            }
            if (!((BTransferWidget)bWidget).isDeleteEnabled()) {
                deleteCommand.setEnabled(false);
            }
            bMenu.add(DELETE, (Command)deleteCommand);
        }
    }

    private void addLinkMark(BMenu bMenu, BWidget bWidget, BComponent bComponent) {
        LinkMarkCommand linkMarkCommand = new LinkMarkCommand(bWidget, bComponent);
        bMenu.add(LINK_MARK, (Command)linkMarkCommand);
    }

    private void addLinkFrom(BMenu bMenu, BWidget bWidget, BComponent bComponent) {
        LinkFromCommand linkFromCommand = new LinkFromCommand(bWidget, bComponent);
        bMenu.add(LINK_FROM, (Command)linkFromCommand);
    }

    private void addLinkTo(BMenu bMenu, BWidget bWidget, BComponent bComponent) {
        LinkToCommand linkToCommand = new LinkToCommand(bWidget, bComponent);
        if (this.isReadonly(bComponent)) {
            linkToCommand.setEnabled(false);
        }
        bMenu.add(LINK_TO, (Command)linkToCommand);
    }

    private void addRename(BMenu bMenu, BWidget bWidget, BComponent bComponent) {
        Object object = bWidget instanceof BTransferWidget ? new RenameCommand((BTransferWidget)bWidget) : new ComponentRenameCommand(bWidget, bComponent);
        if (this.isFrozen(bComponent)) {
            object.setEnabled(false);
        }
        if (this.isReadonly(bComponent)) {
            object.setEnabled(false);
        }
        bMenu.add(RENAME, (Command)object);
    }

    private void addSetDisplayName(BMenu bMenu, BWidget bWidget, BComponent bComponent) {
        SetDisplayNameCommand setDisplayNameCommand = new SetDisplayNameCommand(bWidget, bComponent);
        if (this.isReadonly(bComponent)) {
            setDisplayNameCommand.setEnabled(false);
        }
        bMenu.add(SET_DISPLAY_NAME, (Command)setDisplayNameCommand);
    }

    private void addReorder(BMenu bMenu, BWidget bWidget, BComponent bComponent) {
        ComponentReorderCommand componentReorderCommand = new ComponentReorderCommand(bWidget, bComponent);
        if (this.isReadonly(bComponent)) {
            componentReorderCommand.setEnabled(false);
        }
        bMenu.add(REORDER, (Command)componentReorderCommand);
    }

    private void addComposite(BMenu bMenu, BWidget bWidget, BComponent bComponent) {
        ComponentCompositeCommand componentCompositeCommand = new ComponentCompositeCommand(bWidget, bComponent);
        if (this.isReadonly(bComponent)) {
            componentCompositeCommand.setEnabled(false);
        }
        bMenu.add(COMPOSITE, (Command)componentCompositeCommand);
    }

    private void addFind(BMenu bMenu, BWidget bWidget, BComponent bComponent) {
        FindCommand findCommand = new FindCommand(bWidget, bComponent);
        bMenu.add(FIND, (Command)findCommand);
    }

    private void addExport(BMenu bMenu, BWidget bWidget, BComponent bComponent) {
        AgentFilter agentFilter = AgentFilter.is((Type)BExporter.TYPE);
        AgentList agentList = bComponent.getAgents().filter(agentFilter);
        int n = agentList.size();
        for (int i = 0; i < agentList.size(); ++i) {
            if (!(agentList.get(i) instanceof PxUtil.PxAgent)) continue;
            --n;
        }
        ExportCommand exportCommand = new ExportCommand(bWidget, bComponent);
        exportCommand.setEnabled(n > 0);
        bMenu.add(EXPORT, (Command)exportCommand);
    }

    private boolean isReadonly(BComponent bComponent) {
        return bComponent.isComponentReadonly() && disable;
    }

    private boolean isFrozen(BComponent bComponent) {
        Property property = bComponent.getPropertyInParent();
        if (property != null) {
            return property.isFrozen() && disable;
        }
        return true;
    }

    private boolean isRoot(BComponent bComponent) {
        return bComponent.getParent() == null;
    }

    public static BMenu makeNewMenu(BWidget bWidget, BComponent bComponent, BWsAnnotation bWsAnnotation) {
        try {
            if (bComponent.getType().getTypeSpec().toString().equals("nsedona:SedonaComponent")) {
                return null;
            }
            BMenu bMenu = new BMenu(UiLexicon.bajaui().getText("menu.new.label"));
            BComponent bComponent2 = (BComponent)BOrd.make((String)"file:!workbench/newComponents.bog|bog:|slot:/").get();
            BComponent[] bComponentArray = bComponent2.getChildComponents();
            for (int i = 0; i < bComponentArray.length; ++i) {
                BComponentMenuAgent.addToNewMenu(bWidget, bMenu, bComponent, bComponentArray[i], bWsAnnotation);
            }
            return bMenu;
        }
        catch (UnresolvedException unresolvedException) {
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static void addToNewMenu(BWidget bWidget, BMenu bMenu, BComponent bComponent, BComponent bComponent2, BWsAnnotation bWsAnnotation) {
        if (bComponent2 instanceof BFolder) {
            BComponent[] bComponentArray = bComponent2.getChildComponents();
            if (bComponentArray.length == 0) {
                bMenu.add(null, (Command)new NewComponentCommand(bWidget, bComponent, bComponent2, bWsAnnotation));
                return;
            }
            BMenu bMenu2 = new BMenu(bComponent2.getDisplayName(null));
            for (int i = 0; i < bComponentArray.length; ++i) {
                BComponentMenuAgent.addToNewMenu(bWidget, bMenu2, bComponent, bComponentArray[i], bWsAnnotation);
            }
            bMenu.add(null, (BValue)new BSubMenuItem(bMenu2));
        } else if (bComponent2 instanceof BSeparator) {
            bMenu.add(null, (BValue)new BSeparator());
        } else {
            bMenu.add(null, (Command)new NewComponentCommand(bWidget, bComponent, bComponent2, bWsAnnotation));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class ExportCommand
    extends Command {
        BComponent target;

        public ExportCommand(BWidget bWidget, BComponent bComponent) {
            super(bWidget, (Lexicon)UiLexicon.bajaui, "commands.export");
            this.target = bComponent;
        }

        public CommandArtifact doInvoke() {
            try {
                this.target.lease(1);
                BExportDialog.invoke(this.getOwner(), this.target.getAbsoluteOrd(), false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    public class FindCommand
    extends Command {
        BComponent base;

        public FindCommand(BWidget bWidget, BComponent bComponent) {
            super(bWidget, (Lexicon)UiLexicon.bajaui, "findComponent");
            this.base = bComponent;
        }

        public CommandArtifact doInvoke() {
            BWbShell bWbShell = (BWbShell)this.getShell();
            BComponentFinder.open(bWbShell, this.getLabel(), this.base);
            return null;
        }
    }

    public static class NewComponentCommand
    extends Command {
        BComponent parent;
        BComponent child;
        BWsAnnotation anno;

        public NewComponentCommand(BWidget bWidget, BComponent bComponent, BComponent bComponent2, BWsAnnotation bWsAnnotation) {
            super(bWidget, bComponent2.getDisplayName(null));
            this.icon = BImage.make((BIcon)bComponent2.getNavIcon());
            this.parent = bComponent;
            this.child = bComponent2;
            this.anno = bWsAnnotation;
        }

        public CommandArtifact doInvoke() throws Exception {
            String string = this.child.getName();
            BComponent bComponent = (BComponent)this.child.newCopy(true);
            Property property = bComponent.getProperty("wsAnnotation");
            if (this.anno == null) {
                if (property != null && property.isDynamic()) {
                    bComponent.remove(property);
                }
            } else if (property == null) {
                bComponent.add("wsAnnotation", (BValue)this.anno);
            } else {
                bComponent.set(property, (BValue)BWsAnnotation.merge((BWsAnnotation)((BWsAnnotation)bComponent.get(property)), (BWsAnnotation)this.anno));
            }
            return TransferUtil.insert(this.getOwner(), 16, new Mark((BObject)bComponent, string), (BObject)this.parent, null, null);
        }
    }
}

