/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.kiosk;

import com.tridium.fox.sys.BFoxService;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.sys.Nre;
import com.tridium.ui.NullUiEnv;
import com.tridium.ui.UiEnv;
import com.tridium.workbench.kiosk.BKioskProfileConfig;
import com.tridium.workbench.shell.BGeneralOptions;
import com.tridium.workbench.shell.BNiagaraWbFrame;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.BWbApplication;
import com.tridium.workbench.shell.WbMain;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BBrush;
import javax.baja.naming.BHost;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.security.AuthenticationException;
import javax.baja.security.BICredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.workbench.kiosk.BKioskSplash;

public class BKioskService
extends BAbstractService
implements BWbApplication.LogoffListener {
    public static final Property splash = BKioskService.newProperty((int)0, (BValue)BTypeSpec.make((String)"workbench", (String)"DefaultKioskSplash"), (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"workbench:KioskSplash")));
    public static final Property splashImage = BKioskService.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"file:ImageFile")));
    public static final Property splashFill = BKioskService.newProperty((int)0, (BValue)BBrush.NULL, null);
    public static final Property autoLoginUsername = BKioskService.newProperty((int)0, (String)"", null);
    public static final Property autoLoginPassword = BKioskService.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    public static final Property autoLogoffEnabled = BKioskService.newProperty((int)0, (boolean)true, null);
    public static final Property autoLogoffPeriod = BKioskService.newProperty((int)0, (BValue)BRelTime.make((long)900000L), null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$kiosk$BKioskService == null ? (class$com$tridium$workbench$kiosk$BKioskService = BKioskService.class$("com.tridium.workbench.kiosk.BKioskService")) : class$com$tridium$workbench$kiosk$BKioskService));
    private static final BIcon icon = BIcon.std((String)"workbench.png");
    static /* synthetic */ Class class$com$tridium$workbench$kiosk$BKioskService;

    public BTypeSpec getSplash() {
        return (BTypeSpec)this.get(splash);
    }

    public void setSplash(BTypeSpec bTypeSpec) {
        this.set(splash, (BValue)bTypeSpec, null);
    }

    public BOrd getSplashImage() {
        return (BOrd)this.get(splashImage);
    }

    public void setSplashImage(BOrd bOrd) {
        this.set(splashImage, (BValue)bOrd, null);
    }

    public BBrush getSplashFill() {
        return (BBrush)this.get(splashFill);
    }

    public void setSplashFill(BBrush bBrush) {
        this.set(splashFill, (BValue)bBrush, null);
    }

    public String getAutoLoginUsername() {
        return this.getString(autoLoginUsername);
    }

    public void setAutoLoginUsername(String string) {
        this.setString(autoLoginUsername, string, null);
    }

    public BPassword getAutoLoginPassword() {
        return (BPassword)this.get(autoLoginPassword);
    }

    public void setAutoLoginPassword(BPassword bPassword) {
        this.set(autoLoginPassword, (BValue)bPassword, null);
    }

    public boolean getAutoLogoffEnabled() {
        return this.getBoolean(autoLogoffEnabled);
    }

    public void setAutoLogoffEnabled(boolean bl) {
        this.setBoolean(autoLogoffEnabled, bl, null);
    }

    public BRelTime getAutoLogoffPeriod() {
        return (BRelTime)this.get(autoLogoffPeriod);
    }

    public void setAutoLogoffPeriod(BRelTime bRelTime) {
        this.set(autoLogoffPeriod, (BValue)bRelTime, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public void serviceStarted() throws Exception {
        super.serviceStarted();
        if (!this.getComponentSpace().isProxyComponentSpace()) {
            this.getComponentSpace().enableMixIn(BKioskProfileConfig.TYPE);
        }
    }

    public void serviceStopped() throws Exception {
        super.serviceStopped();
        if (!this.getComponentSpace().isProxyComponentSpace()) {
            this.getComponentSpace().disableMixIn(BKioskProfileConfig.TYPE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stationStarted() throws Exception {
        try {
            super.stationStarted();
            if (!this.isOperational()) {
                return;
            }
            if (UiEnv.get() instanceof NullUiEnv) {
                this.configFatal(Lexicon.make((BModule)TYPE.getModule(), (String)Sys.getLanguage()).getText("kioskInvalidUI"));
                return;
            }
            Object object = UiEnv.appLock;
            synchronized (object) {
                if (UiEnv.app == null) {
                    UiEnv.app = new BWbApplication();
                    UiEnv.app.start();
                }
            }
            WbMain.doCheckLicense();
            WbMain.boot();
            new Thread(){

                public void run() {
                    BFoxService.waitUntilPortOpen((long)10000L);
                    if (BKioskService.this.autoLogin()) {
                        return;
                    }
                    BKioskService.this.openSplash();
                }
            }.start();
        }
        catch (Throwable throwable) {
            this.configFatal(throwable.toString());
        }
    }

    void openSplash() {
        BKioskSplash bKioskSplash = (BKioskSplash)this.getSplash().getResolvedType().getInstance();
        UiEnv.get().setKiosk((BWidgetShell)bKioskSplash);
        bKioskSplash.open();
        bKioskSplash.relayout();
    }

    boolean autoLogin() {
        try {
            BUserService bUserService = (BUserService)Sys.getService((Type)BUserService.TYPE);
            BUser bUser = bUserService.getUser(this.getAutoLoginUsername());
            if (bUser == null) {
                return false;
            }
            BGeneralOptions.make().setAutoLogoffEnabled(false);
            BNiagaraWbShell bNiagaraWbShell = this.doLogin(bUser, this.getAutoLoginPassword());
            bNiagaraWbShell.commands.logoff.setEnabled(false);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean login(String string, String string2) throws Exception {
        Object object;
        BUser bUser = null;
        try {
            object = (BUserService)Sys.getService((Type)BUserService.TYPE);
            bUser = (BUser)object.get(string);
            if (bUser == null) {
                return false;
            }
            if (!object.canLogin(bUser)) {
                return false;
            }
            if (!bUser.getPassword().validate(string2)) {
                return false;
            }
        }
        catch (AuthenticationException authenticationException) {
            return false;
        }
        object = BGeneralOptions.make();
        ((BGeneralOptions)((Object)object)).setAutoLogoffEnabled(this.getAutoLogoffEnabled());
        ((BGeneralOptions)((Object)object)).setAutoLogoffPeriod(this.getAutoLogoffPeriod());
        this.doLogin(bUser, BPassword.make((String)string2));
        return true;
    }

    BNiagaraWbShell doLogin(BUser bUser, BPassword bPassword) throws Exception {
        String string = bUser.getLanguage();
        if (string.length() > 0) {
            Nre.setDefaultLocale((String)string);
        }
        BUsernameAndPassword bUsernameAndPassword = new BUsernameAndPassword(bUser.getUsername(), bPassword);
        BFoxService bFoxService = (BFoxService)Sys.getService((Type)BFoxService.TYPE);
        boolean bl = false;
        int n = -1;
        if (bFoxService.getFoxEnabled()) {
            n = bFoxService.getFoxPort();
        }
        if (bFoxService.getFoxsEnabled()) {
            n = bFoxService.getFoxsPort();
            bl = true;
        }
        if (n == -1) {
            throw new BajaException("Fox not enabled.");
        }
        BFoxSession bFoxSession = BFoxSession.make((BHost)BLocalHost.INSTANCE, (int)n, (boolean)bl);
        bFoxSession.disconnect();
        bFoxSession.setCredentials((BICredentials)bUsernameAndPassword);
        bFoxSession.connect();
        BKioskProfileConfig bKioskProfileConfig = BKioskProfileConfig.get(bUser);
        Type type = bKioskProfileConfig.getTypeSpec().getResolvedType();
        WbMain.kioskCredentials = bUsernameAndPassword;
        BWbApplication.logOffListener = this;
        BOrd bOrd = BOrd.make((BOrd)bFoxSession.getNavOrd(), (BOrd)bUser.getHomePage());
        BNiagaraWbFrame bNiagaraWbFrame = WbMain.openFrame(null, bOrd, type);
        return bNiagaraWbFrame;
    }

    public void logoff() {
        WbMain.kioskCredentials = null;
        BWbApplication.logOffListener = null;
        this.openSplash();
        BWbApplication bWbApplication = (BWbApplication)BWidget.getApplication();
        BWidgetShell[] bWidgetShellArray = bWbApplication.getShells();
        for (int i = 0; i < bWidgetShellArray.length; ++i) {
            BWidgetShell bWidgetShell = bWidgetShellArray[i];
            if (!(bWidgetShell instanceof BNiagaraWbFrame)) continue;
            ((BNiagaraWbFrame)bWidgetShell).close();
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

