/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.job;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.sys.Nre;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.job.JobEvent;
import com.tridium.workbench.job.JobListener;
import com.tridium.workbench.job.NotificationQueue;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.job.BJobService;
import javax.baja.job.BJobState;
import javax.baja.log.Log;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Subscriber;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.BNotification;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.kiosk.BKioskProfile;
import javax.baja.workbench.util.BNotifyPane;

public class JobMonitor
extends Thread {
    static final BImage messageIcon = BImage.make((String)"module://icons/x16/info.png");
    static final BImage unknownIcon = BImage.make((String)"module://icons/x16/job/unknown.png");
    static final BImage runningIcon = BImage.make((String)"module://icons/x16/job/running.png");
    static final BImage canceledIcon = BImage.make((String)"module://icons/x16/job/failed.png");
    static final BImage successIcon = BImage.make((String)"module://icons/x16/job/success.png");
    static final BImage failedIcon = BImage.make((String)"module://icons/x16/job/failed.png");
    static JobMonitor monitor;
    Log log = Log.getLog((String)"JobMonitor");
    Array sessions = new Array(class$com$tridium$workbench$job$JobMonitor$Session == null ? (class$com$tridium$workbench$job$JobMonitor$Session = JobMonitor.class$("com.tridium.workbench.job.JobMonitor$Session")) : class$com$tridium$workbench$job$JobMonitor$Session);
    Subscriber subscriber = new MySubscriber();
    Array listeners = new Array(class$com$tridium$workbench$job$JobListener == null ? (class$com$tridium$workbench$job$JobListener = JobMonitor.class$("com.tridium.workbench.job.JobListener")) : class$com$tridium$workbench$job$JobListener);
    static /* synthetic */ Class class$javax$baja$job$BJobService;
    static /* synthetic */ Class class$com$tridium$workbench$job$JobMonitor$Session;
    static /* synthetic */ Class class$com$tridium$workbench$job$JobListener;

    public static JobMonitor get() {
        if (monitor == null) {
            System.out.println("*** JobMonitor lazy init ***");
            JobMonitor.init();
        }
        return monitor;
    }

    public static void init() {
        monitor = new JobMonitor();
        monitor.start();
    }

    JobMonitor() {
        super(Nre.mainThreadGroup, "Ui:JobMonitor");
        this.setDaemon(true);
        Spy.ROOT.add("jobMonitor", (Spy)new MySpy());
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    Thread.sleep(1000L);
                    this.scan();
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                continue;
            }
            break;
        }
    }

    void scan() {
        int n;
        BFoxSession[] bFoxSessionArray = BFoxSession.list();
        Session[] sessionArray = (Session[])this.sessions.trim();
        for (n = 0; n < bFoxSessionArray.length; ++n) {
            BFoxSession bFoxSession = bFoxSessionArray[n];
            if (!bFoxSession.isConnected()) continue;
            boolean bl = false;
            for (int i = 0; i < sessionArray.length; ++i) {
                if (bFoxSession != sessionArray[i].foxSession) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            this.register(bFoxSession);
        }
        sessionArray = (Session[])this.sessions.copy().trim();
        for (n = 0; n < sessionArray.length; ++n) {
            if (sessionArray[n].foxSession.isConnected()) continue;
            this.unregister(sessionArray[n]);
        }
    }

    void register(BFoxSession bFoxSession) {
        this.log.trace("register " + bFoxSession);
        Session session = new Session();
        session.foxSession = bFoxSession;
        this.sessions.add((Object)session);
        try {
            session.service = (BJobService)BOrd.make((String)"service:baja:JobService").get((BObject)bFoxSession);
            session.service.loadSlots();
            SlotCursor slotCursor = session.service.getProperties();
            while (slotCursor.nextComponent()) {
                ((BComponent)slotCursor.get()).loadSlots();
            }
            this.subscriber.subscribe((BComponent)session.service, 1);
            this.jobEvent(new JobEvent(1, session.service));
        }
        catch (Throwable throwable) {
            this.log.error("Cannot register: " + throwable);
            session.error = true;
        }
    }

    void unregister(Session session) {
        try {
            this.log.trace("unregister " + session.foxSession);
            this.sessions.remove((Object)session);
            this.jobEvent(new JobEvent(2, session.service));
        }
        catch (Throwable throwable) {
            this.log.error("unregister", throwable);
        }
    }

    void handleComponentEvent(BComponentEvent bComponentEvent) {
        if (bComponentEvent.getId() == 0 && bComponentEvent.getSourceComponent() instanceof BJob) {
            BJobState bJobState;
            BJob bJob = (BJob)bComponentEvent.getSourceComponent();
            this.jobEvent(new JobEvent(5, bJob, bComponentEvent));
            if (bComponentEvent.getSlot() == BJob.jobState && ((bJobState = (BJobState)bComponentEvent.getValue()) == BJobState.success || bJobState == BJobState.failed)) {
                this.notify(bJob);
            }
            return;
        }
        if (bComponentEvent.getId() == 1 && bComponentEvent.getValue() instanceof BJob) {
            BJob bJob = (BJob)bComponentEvent.getValue();
            this.subscriber.subscribe((BComponent)bJob);
            this.jobEvent(new JobEvent(3, bJob, bComponentEvent));
            BJobState bJobState = bJob.getJobState();
            if (bJobState == BJobState.success || bJobState == BJobState.failed) {
                this.notify(bJob);
            }
            return;
        }
        if (bComponentEvent.getId() == 2 && bComponentEvent.getValue() instanceof BJob) {
            BJob bJob = (BJob)bComponentEvent.getValue();
            this.jobEvent(new JobEvent(4, bJob, bComponentEvent));
            return;
        }
        if (bComponentEvent.getId() == 5 && bComponentEvent.getValue() instanceof BNotification) {
            BNotification bNotification = (BNotification)bComponentEvent.getValue();
            NotificationQueue.enqueue(bNotification, (Context)BFacets.makePickle((BFacets)BFacets.DEFAULT, (Object)bComponentEvent.getSourceComponent()));
        }
    }

    void notify(BJob bJob) {
        BFoxSession bFoxSession;
        BHost bHost;
        Object object;
        BWidgetShell[] bWidgetShellArray = BWidget.getApplication().getShells();
        for (int i = 0; i < bWidgetShellArray.length; ++i) {
            if (!(bWidgetShellArray[i] instanceof BWbShell) || !((object = ((BWbShell)bWidgetShellArray[i]).getProfile()) instanceof BKioskProfile)) continue;
            return;
        }
        BLabel bLabel = null;
        try {
            object = (BJobService)bJob.getParent();
            bHost = object.getHost();
            bFoxSession = (BFoxSession)object.getSession();
            bLabel = new BLabel(bFoxSession.getStationName() + " on " + bHost.getNavDisplayName(null));
            bLabel.setForeground(Theme.widget().getControlShadow());
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = bJob.getType().getDisplayName(null);
        if (((String)object).endsWith(" Job")) {
            object = ((String)object).substring(0, ((String)object).length() - 4);
        }
        bHost = new BLabel(BImage.make((BIcon)bJob.getIcon()), (String)object);
        bHost.setFont(Theme.widget().getBoldText());
        bFoxSession = new BLabel(JobMonitor.stateToIcon(bJob.getJobState()), bJob.getJobState().toString());
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.add(null, (BValue)bHost);
        bGridPane.add(null, (BValue)bFoxSession);
        if (bLabel != null) {
            bGridPane.add(null, (BValue)bLabel);
        }
        BNotifyPane bNotifyPane = new BNotifyPane();
        bNotifyPane.setCenter((BWidget)bGridPane);
        bNotifyPane.open();
    }

    static BImage stateToIcon(BJobState bJobState) {
        switch (bJobState.getOrdinal()) {
            case 1: {
                return runningIcon;
            }
            case 2: {
                return canceledIcon;
            }
            case 3: {
                return canceledIcon;
            }
            case 4: {
                return successIcon;
            }
            case 5: {
                return failedIcon;
            }
        }
        return unknownIcon;
    }

    public BJobService[] list() {
        Array array = new Array(class$javax$baja$job$BJobService == null ? (class$javax$baja$job$BJobService = JobMonitor.class$("javax.baja.job.BJobService")) : class$javax$baja$job$BJobService);
        Session[] sessionArray = (Session[])this.sessions.trim();
        for (int i = 0; i < sessionArray.length; ++i) {
            BJobService bJobService = sessionArray[i].service;
            if (bJobService == null) continue;
            array.add((Object)bJobService);
        }
        return (BJobService[])array.trim();
    }

    public void addListener(JobListener jobListener) {
        this.listeners.add((Object)jobListener);
    }

    public void removeListener(JobListener jobListener) {
        this.listeners.remove((Object)jobListener);
    }

    public void jobEvent(JobEvent jobEvent) {
        if (this.log.isTraceOn()) {
            this.log.trace(jobEvent.toString());
        }
        JobListener[] jobListenerArray = (JobListener[])this.listeners.trim();
        for (int i = 0; i < jobListenerArray.length; ++i) {
            try {
                jobListenerArray[i].jobEvent(jobEvent);
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void spy(SpyWriter spyWriter) {
        int n;
        Session[] sessionArray = (Session[])this.sessions.trim();
        spyWriter.startTable(true);
        spyWriter.trTitle((Object)"Sessions", 4);
        spyWriter.w((Object)"<tr>").th((Object)"Ord").th((Object)"FoxSession").th((Object)"Err").th((Object)"Service").w((Object)"</tr>");
        for (n = 0; n < sessionArray.length; ++n) {
            Session session = sessionArray[n];
            spyWriter.tr((Object)session.foxSession.getNavOrd(), (Object)session.foxSession.getConnection().session(), (Object)("" + session.error), (Object)("" + session.service));
        }
        spyWriter.endTable();
        spyWriter.startTable(true);
        spyWriter.trTitle((Object)"Listeners", 1);
        for (n = 0; n < this.listeners.size(); ++n) {
            spyWriter.tr(this.listeners.get(0));
        }
        spyWriter.endTable();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class Session {
        BFoxSession foxSession;
        BJobService service;
        boolean error;

        Session() {
        }
    }

    class MySpy
    extends Spy {
        MySpy() {
        }

        public void write(SpyWriter spyWriter) {
            JobMonitor.this.spy(spyWriter);
        }
    }

    class MySubscriber
    extends Subscriber {
        MySubscriber() {
        }

        public void event(BComponentEvent bComponentEvent) {
            JobMonitor.this.handleComponentEvent(bComponentEvent);
        }
    }
}

