/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.job;

import com.tridium.ui.theme.Theme;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.NoSuchAgentException;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.job.JobLog;
import javax.baja.job.JobLogItem;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.view.BWbComponentView;

public class BJobBar
extends BEdgePane
implements BWbComponentView.Attachable {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$job$BJobBar == null ? (class$com$tridium$workbench$job$BJobBar = BJobBar.class$("com.tridium.workbench.job.BJobBar")) : class$com$tridium$workbench$job$BJobBar));
    static final BImage messageIcon = BImage.make((String)"module://icons/x16/info.png");
    static final BImage unknownIcon = BImage.make((String)"module://icons/x16/job/unknown.png");
    static final BImage runningIcon = BImage.make((String)"module://icons/x16/job/running.png");
    static final BImage canceledIcon = BImage.make((String)"module://icons/x16/job/failed.png");
    static final BImage successIcon = BImage.make((String)"module://icons/x16/job/success.png");
    static final BImage failedIcon = BImage.make((String)"module://icons/x16/job/failed.png");
    static final String lexStatus = UiLexicon.bajaui.getText("status");
    static final String lexTimestamp = UiLexicon.bajaui.getText("timestamp");
    static final String lexMessage = UiLexicon.bajaui.getText("message");
    static final String lexDetails = UiLexicon.bajaui.getText("details");
    static final String lexCancel = UiLexicon.bajaui.getText("cancel");
    static final String lexDispose = UiLexicon.bajaui.getText("dispose");
    static final String lexLog = UiLexicon.bajaui.getText("log");
    static final String lexJobLog = UiLexicon.bajaui.getText("job.log");
    static final String lexLogDetails = UiLexicon.bajaui.getText("log.details");
    static AgentFilter agentFilter = AgentFilter.is((Type)TYPE);
    static BImage cancelIcon = BImage.make((String)"module://icons/x16/stop.png");
    static BImage disposeIcon = BImage.make((String)"module://icons/x16/close.png");
    static BImage logIcon = BImage.make((String)"module://icons/x16/doubleArrowRight.png");
    private BJob job;
    private BLabel state = new BLabel();
    private BLabel name = new BLabel();
    private BLabel message = new BLabel("", BHalign.right);
    private BBorderPane progress = new BBorderPane((BWidget)new BNullWidget(), BInsets.make((double)10.0, (double)0.0, (double)0.0, (double)10.0));
    private BWidget content;
    private BButton cancelButton;
    private BButton disposeButton;
    private BButton logButton;
    private int complete = 0;
    private Cancel cancel = new Cancel((BWidget)this);
    private Dispose dispose = new Dispose((BWidget)this);
    private Log log = new Log((BWidget)this);
    static /* synthetic */ Class class$com$tridium$workbench$job$BJobBar;

    public Type getType() {
        return TYPE;
    }

    public static BJobBar makeFor(BJob bJob) {
        try {
            return (BJobBar)bJob.getAgents().filter(agentFilter).getDefault().getInstance();
        }
        catch (NoSuchAgentException noSuchAgentException) {
            return new BJobBar();
        }
    }

    public BJobBar() {
        BButton bButton = new BButton((Command)this.cancel);
        BButton bButton2 = new BButton((Command)this.dispose);
        BButton bButton3 = new BButton((Command)this.log);
        bButton.setBackground(Theme.widget().getWindowBackground());
        bButton2.setBackground(Theme.widget().getWindowBackground());
        bButton3.setBackground(Theme.widget().getWindowBackground());
        bButton.setButtonStyle(BButtonStyle.toolBar);
        bButton2.setButtonStyle(BButtonStyle.toolBar);
        bButton3.setButtonStyle(BButtonStyle.toolBar);
        this.cancelButton = bButton;
        this.disposeButton = bButton2;
        this.logButton = bButton3;
        BGridPane bGridPane = new BGridPane(5);
        bGridPane.setStretchColumn(2);
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.add(null, (BValue)this.state);
        bGridPane.add(null, (BValue)this.name);
        bGridPane.add("center", (BValue)this.message);
        bGridPane.add(null, (BValue)bButton3);
        bGridPane.add("action", (BValue)this.disposeButton);
        this.setCenter((BWidget)bGridPane);
        this.content = bGridPane;
        this.sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        if (this.job != null && !this.job.isMounted()) {
            this.load(null);
        }
        graphics.setBrush(Theme.progressBar().getWindowBackground((IStylable)this));
        graphics.fillRect(0.0, 0.0, this.getWidth(), this.getHeight());
        super.paint(graphics);
        if (this.progress.getParentWidget() == null) {
            return;
        }
        double d = this.progress.getX();
        double d2 = this.progress.getY();
        double d3 = this.progress.getWidth() - 1.0;
        double d4 = this.progress.getHeight() - 1.0;
        double d5 = (double)this.complete / 100.0 * d3;
        graphics.setBrush(Theme.progressBar().getWindowForeground((IStylable)this));
        graphics.push();
        try {
            graphics.translate(d, d2);
            graphics.fillRect(0.0, 0.0, d5, d4);
        }
        finally {
            graphics.pop();
        }
        graphics.setBrush(BColor.black);
        graphics.strokeRect(d, d2, d3, d4);
    }

    public String getStyleSelector() {
        return "progress-bar";
    }

    public void load(BJob bJob) {
        this.job = bJob;
        this.sync();
    }

    void sync() {
        this.cancelButton.setEnabled(this.job != null);
        this.disposeButton.setEnabled(this.job != null);
        this.logButton.setEnabled(this.job != null);
        this.state.setVisible(this.job != null);
        this.name.setVisible(this.job != null);
        this.message.setVisible(this.job != null);
        if (this.job == null) {
            return;
        }
        this.state.setImage(BJobBar.stateToIcon(this.job.getJobState()));
        this.name.setText(this.job.toString(null));
        this.name.setImage(BImage.make((BIcon)this.job.getIcon()));
        this.message.setText(this.job.getJobState().toString(null));
        this.complete = this.job.getProgress();
        if (this.job.getJobState().isRunning()) {
            this.content.set("center", (BValue)this.progress);
            this.content.set("action", (BValue)this.cancelButton);
        } else {
            this.content.set("center", (BValue)this.message);
            this.content.set("action", (BValue)this.disposeButton);
        }
        this.repaint();
    }

    public void attached(BWbComponentView bWbComponentView) {
    }

    public void detached(BWbComponentView bWbComponentView) {
    }

    public void handleComponentEvent(BComponentEvent bComponentEvent) {
        if (bComponentEvent.getSourceComponent() == this.job) {
            this.sync();
        }
    }

    static BImage stateToIcon(BJobState bJobState) {
        switch (bJobState.getOrdinal()) {
            case 1: {
                return runningIcon;
            }
            case 2: {
                return canceledIcon;
            }
            case 3: {
                return canceledIcon;
            }
            case 4: {
                return successIcon;
            }
            case 5: {
                return failedIcon;
            }
        }
        return unknownIcon;
    }

    static BImage itemToIcon(JobLogItem jobLogItem) {
        switch (jobLogItem.getId()) {
            case 1: {
                return runningIcon;
            }
            case 2: {
                return canceledIcon;
            }
            case 3: {
                return successIcon;
            }
            case 4: {
                return failedIcon;
            }
        }
        return messageIcon;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class JobLogController
    extends TableController {
        JobLog log;

        JobLogController(JobLog jobLog) {
            this.log = jobLog;
        }

        public void cellDoubleClicked(BMouseEvent bMouseEvent, int n, int n2) {
            JobLogItem jobLogItem = this.log.getItem(n);
            BTextEditor bTextEditor = new BTextEditor(jobLogItem.toString(null), false);
            BTextEditorPane bTextEditorPane = new BTextEditorPane(bTextEditor, 40, 80);
            BDialog.open((BWidget)this.getTable(), (String)lexLogDetails, (Object)bTextEditorPane, (int)1);
        }
    }

    class JobLogTable
    extends TableModel {
        int count;
        JobLogItem[] items;
        String[] messages;
        String[] details;

        JobLogTable(JobLog jobLog) {
            this.items = jobLog.getItems();
            this.messages = new String[this.items.length];
            this.details = new String[this.items.length];
            for (int i = 0; i < this.items.length; ++i) {
                this.messages[i] = this.str(this.items[i].getMessage(null));
                this.details[i] = this.str(this.items[i].getDetails(null));
            }
        }

        String str(String string) {
            if (string == null) {
                return "";
            }
            int n = string.indexOf(10);
            if (n < 0) {
                return string;
            }
            return string.substring(0, n);
        }

        public int getRowCount() {
            return this.items.length;
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return lexStatus;
                }
                case 1: {
                    return lexTimestamp;
                }
                case 2: {
                    return lexMessage;
                }
                case 3: {
                    return lexDetails;
                }
            }
            return "???";
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.items[n].getIdString(null);
                }
                case 1: {
                    return this.items[n].getTimestamp();
                }
                case 2: {
                    return this.messages[n];
                }
                case 3: {
                    return this.details[n];
                }
            }
            return "???";
        }

        public Object getSubject(int n) {
            return this.items[n];
        }

        public BObject export(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.export(this.items[n].getIdString(null));
                }
                case 1: {
                    return this.items[n].getTimestamp();
                }
                case 2: {
                    return this.export(this.items[n].getMessage(null));
                }
                case 3: {
                    return this.export(this.items[n].getDetails(null));
                }
            }
            return BString.DEFAULT;
        }

        BString export(String string) {
            if (string == null) {
                return BString.DEFAULT;
            }
            return BString.make((String)string);
        }

        public BImage getRowIcon(int n) {
            return BJobBar.itemToIcon(this.items[n]);
        }
    }

    class Log
    extends Command {
        public Log(BWidget bWidget) {
            super(bWidget, lexLog);
        }

        public String getLabel() {
            return null;
        }

        public BImage getIcon() {
            return logIcon;
        }

        public CommandArtifact doInvoke() throws Exception {
            JobLog jobLog = JobLog.decode((String)BJobBar.this.job.readLog().toString());
            BTable bTable = new BTable((TableModel)new JobLogTable(jobLog), (TableController)new JobLogController(jobLog));
            BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)bTable);
            bConstrainedPane.setFixedSize(800.0, 400.0);
            BDialog.open((BWidget)this.getOwner(), (String)lexJobLog, (Object)bConstrainedPane, (int)1);
            return null;
        }
    }

    class Dispose
    extends Command {
        public Dispose(BWidget bWidget) {
            super(bWidget, lexDispose);
        }

        public String getLabel() {
            return null;
        }

        public BImage getIcon() {
            return disposeIcon;
        }

        public CommandArtifact doInvoke() {
            this.setEnabled(false);
            BJobBar.this.job.dispose();
            return null;
        }
    }

    class Cancel
    extends Command {
        public Cancel(BWidget bWidget) {
            super(bWidget, lexCancel);
        }

        public String getLabel() {
            return null;
        }

        public BImage getIcon() {
            return cancelIcon;
        }

        public CommandArtifact doInvoke() {
            BJobBar.this.job.cancel();
            return null;
        }
    }
}

