/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.file;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.shell.BNiagaraWbShell;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import javax.baja.file.BIFile;
import javax.baja.file.BLocalFileStore;
import javax.baja.gx.BInsets;
import javax.baja.gx.RectGeom;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.ViewQuery;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.Line;
import javax.baja.ui.text.Position;
import javax.baja.ui.text.Segment;
import javax.baja.ui.text.TextModel;
import javax.baja.ui.text.TextParser;
import javax.baja.ui.text.TextRenderer;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BWbView;
import javax.baja.xml.XInputStreamReader;

public class BTextFileViewer
extends BWbView {
    public static final Property wordWrap = BTextFileViewer.newProperty((int)0, (boolean)false);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$file$BTextFileViewer == null ? (class$com$tridium$workbench$file$BTextFileViewer = BTextFileViewer.class$("com.tridium.workbench.file.BTextFileViewer")) : class$com$tridium$workbench$file$BTextFileViewer));
    static final Log log = Log.getLog((String)"textEditor");
    static final Lexicon lex = Lexicon.make((String)"workbench");
    private static HashMap fileStates = new HashMap();
    public BTextEditorPane pane = new BTextEditorPane("", 80, 40, true);
    public BTextEditor text = this.pane.getEditor();
    public FileState state;
    public BTextField encodingStatus = new BTextField("", 0, false);
    public ToggleCommand wordWrapCommand;
    BGridPane status = new BGridPane(4);
    BIFile file;
    File localFile;
    boolean zipped;
    String encoding;
    static /* synthetic */ Class class$com$tridium$workbench$file$BTextFileViewer;

    public boolean getWordWrap() {
        return this.getBoolean(wordWrap);
    }

    public void setWordWrap(boolean bl) {
        this.setBoolean(wordWrap, bl, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BTextFileViewer() {
        this.setContent((BWidget)this.pane);
        this.status.add("encoding", (BValue)this.encodingStatus);
        this.wordWrapCommand = new WordWrapCommand(this);
    }

    protected void doLoadValue(BObject bObject, Context context) throws Exception {
        String string;
        Object object;
        ViewQuery viewQuery;
        if (this.getWbShell() != null && (viewQuery = (object = this.getWbShell().getActiveOrdTarget()).getViewQuery()) != null && (string = viewQuery.getParameter("wordWrap", "false")).equals("true")) {
            this.setWordWrap(true);
        }
        this.file = (BIFile)bObject;
        this.localFile = null;
        if (this.file.getStore() instanceof BLocalFileStore) {
            this.localFile = ((BLocalFileStore)this.file.getStore()).getLocalFile();
        }
        this.pane.setHpolicy(BScrollBarPolicy.asNeeded);
        this.text.setParser((TextParser)new WordWrapTextParser());
        this.text.setModel((TextModel)new WordWrapTextModel());
        this.text.setEditable(false);
        this.text.updateEnableStates();
        this.setTransferWidget((BTransferWidget)this.text);
        this.setCommandEnabled(6, true);
        this.setCommandEnabled(7, true);
        this.setCommandEnabled(8, true);
        this.setCommandEnabled(10, true);
        object = this.toReader(new BufferedInputStream(this.file.getInputStream()));
        this.text.getModel().read((Reader)object);
        ((Reader)object).close();
        if (this.getWbShell() != null) {
            viewQuery = this.getWbShell().getActiveOrd();
            this.state = (FileState)fileStates.get(viewQuery);
            if (this.state == null) {
                this.state = new FileState((BOrd)viewQuery);
                fileStates.put(viewQuery, this.state);
            }
        }
        this.wordWrapCommand.setSelected(this.getWordWrap());
    }

    protected BObject doSaveValue(BObject bObject, Context context) throws Exception {
        return bObject;
    }

    public String getDefaultOptionsId() {
        return "textEditor";
    }

    public BToolBar getViewToolBar() {
        BToolBar bToolBar = new BToolBar();
        BNiagaraWbShell bNiagaraWbShell = (BNiagaraWbShell)this.getWbShell();
        bToolBar.add("find", bNiagaraWbShell.commands.find);
        bToolBar.add("sep0", (BValue)new BSeparator());
        bToolBar.add("wordWrap", (Command)this.wordWrapCommand);
        return bToolBar;
    }

    public BWidget getViewStatusBarSupplement() {
        return this.status;
    }

    public CommandArtifact invokeCommand(int n) throws Exception {
        switch (n) {
            case 6: {
                return this.text.doFind();
            }
            case 8: {
                return this.text.doFindNext();
            }
            case 7: {
                return this.text.doFindPrev();
            }
            case 10: {
                return this.text.doGoto();
            }
        }
        return super.invokeCommand(n);
    }

    Reader toReader(InputStream inputStream) throws Exception {
        XInputStreamReader xInputStreamReader = new XInputStreamReader(inputStream);
        this.encoding = xInputStreamReader.getEncoding();
        this.zipped = xInputStreamReader.isZipped();
        String string = this.encoding;
        if (this.zipped) {
            string = "Zip/" + string;
        }
        this.encodingStatus.setText(string);
        this.encodingStatus.setVisibleColumns(string.length());
        return xInputStreamReader;
    }

    public String getSelectedText() {
        return this.text.getModel().getSelectedText();
    }

    public void highlight(int n, int n2, int n3, int n4) {
        Position position = this.text.getModel().getEndPosition();
        Position position2 = new Position(n - 1, n2 - 1);
        Position position3 = new Position(n3 - 1, n4 - 1);
        if (position2.compareTo((Object)position) > 0) {
            position2 = position;
        }
        if (position3.compareTo((Object)position) > 0) {
            position3 = position;
        }
        this.state.viewport = null;
        this.text.getSelection().select(position2, position3);
        this.text.moveCaretPosition(position3);
        this.text.requestFocus();
    }

    public void caretMoved(Position position) {
        this.state.lastPosition = position;
    }

    public void doLayout(BWidget[] bWidgetArray) {
        super.doLayout(bWidgetArray);
        this.layoutText();
    }

    public void deactivated() {
        super.deactivated();
        if (this.state != null) {
            this.state.viewport = this.pane.getViewport();
        }
    }

    void layoutText() {
        if (this.text.getModel() instanceof WordWrapTextModel) {
            ((WordWrapTextModel)this.text.getModel()).update(this.text.getParser().parse(this.text.getText().toCharArray()));
            this.text.getSelection().deselect();
            this.repaint();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class WordWrapTextModel
    extends TextModel {
        double prefWidth;

        protected void update(Line[] lineArray) {
            super.update(lineArray);
            BTextEditor bTextEditor = this.getEditor();
            boolean bl = bTextEditor.isSingleLine();
            double d = this.prefWidth;
            if (!bl) {
                this.walkLines();
            }
            if (d != this.prefWidth && !bl) {
                bTextEditor.relayout();
            } else {
                bTextEditor.repaint();
            }
        }

        private void walkLines() {
            TextRenderer textRenderer = this.getRenderer();
            double d = 10.0;
            for (int i = 0; i < this.getLineCount(); ++i) {
                if (BTextFileViewer.this.getWordWrap()) {
                    Segment[] segmentArray = this.getLine((int)i).segments;
                    for (int j = 0; j < segmentArray.length; ++j) {
                        d = Math.max(d, textRenderer.getLineWidth(this.getLine(i), segmentArray[j].offset, segmentArray[j].length));
                    }
                    continue;
                }
                d = Math.max(d, textRenderer.getLineWidth(this.getLine(i)));
            }
            this.prefWidth = d;
        }

        public double getPreferredWidth() {
            return this.prefWidth;
        }

        public double getPreferredHeight() {
            return super.getPreferredHeight() + 5.0;
        }
    }

    class WordWrapTextParser
    extends TextParser {
        WordWrapTextParser() {
        }

        public synchronized Line[] parse(char[] cArray) {
            this.buffer = cArray;
            this.length = cArray.length;
            this.pos = 0;
            this.last = -1;
            this.current = this.length > 0 ? cArray[0] : -1;
            this.next = this.length > 1 ? cArray[1] : -1;
            this.segmentStart = 0;
            this.lineStart = 0;
            double d = 0.0;
            if (BTextFileViewer.this.getWordWrap() && BTextFileViewer.this.pane != null) {
                d = BTextFileViewer.this.getWidth();
                boolean bl = false;
                switch (BTextFileViewer.this.pane.getVpolicy().getOrdinal()) {
                    case 0: {
                        bl = true;
                        break;
                    }
                    case 1: {
                        bl = true;
                        break;
                    }
                    case 2: {
                        bl = false;
                    }
                }
                if (bl) {
                    double d2 = 20.0;
                    BInsets bInsets = Theme.scrollPane().getInsets();
                    double d3 = d2 + bInsets.right() + bInsets.left();
                    d = d - Theme.scrollBar().getFixedWidth() - d3;
                }
            }
            ArrayList<Line> arrayList = new ArrayList<Line>();
            ArrayList<Segment> arrayList2 = new ArrayList<Segment>();
            while (this.pos < this.length) {
                Segment segment = this.nextSegment();
                arrayList2.add(segment);
                if (segment.type == 3) {
                    int n = this.pos - this.lineStart;
                    if (segment.modifiers == 4) {
                        --n;
                    }
                    arrayList.add(new Line(cArray, this.lineStart, n, arrayList2));
                    arrayList2.clear();
                    this.lineStart = this.pos;
                } else if (BTextFileViewer.this.getWordWrap()) {
                    int n = this.pos - this.lineStart;
                    Line line = new Line(cArray, this.lineStart, n, arrayList2);
                    if (d > 0.0 && !segment.isWhitespace() && this.getRenderer().getLineWidth(line) > d) {
                        arrayList2.remove(segment);
                        this.pos -= segment.length;
                        n = this.pos - this.lineStart;
                        arrayList.add(new Line(cArray, this.lineStart, n, arrayList2));
                        arrayList2.clear();
                        Segment segment2 = new Segment(segment.type, segment.modifiers, 0, segment.length);
                        arrayList2.add(segment2);
                        this.lineStart = this.pos;
                        this.pos += segment2.length;
                    }
                }
                this.segmentStart = this.pos;
            }
            if (arrayList2.size() > 0) {
                arrayList.add(new Line(cArray, this.lineStart, cArray.length - this.lineStart, arrayList2));
            }
            if (arrayList.size() == 0) {
                arrayList.add(new Line(new char[0], new Segment[0]));
            }
            return arrayList.toArray(new Line[arrayList.size()]);
        }
    }

    public static class FileState {
        public BOrd ord;
        public Position lastPosition = new Position(0, 0);
        public RectGeom viewport;

        public FileState(BOrd bOrd) {
            this.ord = bOrd;
        }

        public String toString() {
            return this.ord.toString() + " " + this.lastPosition;
        }
    }

    class WordWrapCommand
    extends ToggleCommand {
        public WordWrapCommand(BWidget bWidget) {
            super(bWidget, lex, "TextFileViewer.wordWrap");
        }

        public CommandArtifact doInvoke() throws Exception {
            BTextFileViewer.this.setWordWrap(this.isSelected());
            BTextFileViewer.this.layoutText();
            return null;
        }
    }
}

