/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.file;

import com.tridium.ui.CaretTracker;
import com.tridium.workbench.console.BConsole;
import com.tridium.workbench.shell.BNiagaraWbShell;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.baja.file.BIFile;
import javax.baja.file.BLocalFileStore;
import javax.baja.gx.RectGeom;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.Position;
import javax.baja.ui.text.TextController;
import javax.baja.ui.text.TextParser;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BWbView;
import javax.baja.xml.XInputStreamReader;

public class BTextFileEditor
extends BWbView
implements CaretTracker {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$file$BTextFileEditor == null ? (class$com$tridium$workbench$file$BTextFileEditor = BTextFileEditor.class$("com.tridium.workbench.file.BTextFileEditor")) : class$com$tridium$workbench$file$BTextFileEditor));
    static final Log log = Log.getLog((String)"textEditor");
    static final Lexicon lex = Lexicon.make((String)"workbench");
    static final String lexLine = lex.getText("fileEditor.line");
    static final String lexCol = lex.getText("fileEditor.col");
    static final int linePad = 6;
    static final int colPad = 4;
    private static Properties parserProps = new Properties();
    private static File parserPropsFile;
    private static long parserPropsLastModified;
    private static HashMap fileStates;
    public BTextEditorPane pane = new BTextEditorPane("", 80, 40, true);
    public BTextEditor text = this.pane.getEditor();
    public FileState state;
    public BTextField encodingStatus = new BTextField("", 0, false);
    public BTextField rwStatus = new BTextField("", 2, false);
    public BTextField lineStatus = new BTextField(lexLine, lexLine.length() + 6, false);
    public BTextField columnStatus = new BTextField(lexCol, lexCol.length() + 4, false);
    public Command saveAndCompile;
    public Command saveAndSlot;
    BGridPane status = new BGridPane(4);
    BIFile file;
    File localFile;
    BAbsTime lastModified;
    boolean zipped;
    String encoding;
    static /* synthetic */ Class class$com$tridium$workbench$file$BTextFileEditor;

    public Type getType() {
        return TYPE;
    }

    public BTextFileEditor() {
        this.text.setController((TextController)new Controller());
        this.setContent((BWidget)this.pane);
        this.linkTo("lk0", (BComponent)this.pane.getEditor(), (Slot)BTextEditor.textModified, (Slot)setModified);
        this.status.add("encoding", (BValue)this.encodingStatus);
        this.status.add("rw", (BValue)this.rwStatus);
        this.status.add("line", (BValue)this.lineStatus);
        this.status.add("col", (BValue)this.columnStatus);
        this.saveAndCompile = new SaveAndCompileCommand(this);
        this.saveAndSlot = new SaveAndSlotCommand(this);
    }

    protected void doLoadValue(BObject bObject, Context context) throws Exception {
        this.getUndoManager().setMaxArtifacts(10000);
        this.file = (BIFile)bObject;
        this.lastModified = this.file.getLastModified();
        this.localFile = null;
        if (this.file.getStore() instanceof BLocalFileStore) {
            this.localFile = ((BLocalFileStore)this.file.getStore()).getLocalFile();
        }
        this.saveAndCompile.setEnabled(this.localFile != null);
        this.saveAndSlot.setEnabled(this.localFile != null);
        String string = this.file.getExtension();
        TextParser textParser = BTextFileEditor.getParser(string);
        if (textParser != null) {
            this.text.setParser(textParser);
        }
        boolean bl = !this.file.isReadonly();
        this.text.setEditable(bl);
        this.rwStatus.setText(bl ? "RW" : "RO");
        this.text.updateEnableStates();
        this.setTransferWidget((BTransferWidget)this.text);
        this.setCommandEnabled(6, true);
        this.setCommandEnabled(7, true);
        this.setCommandEnabled(8, true);
        this.setCommandEnabled(9, bl);
        this.setCommandEnabled(10, true);
        Reader reader = this.toReader(new BufferedInputStream(this.file.getInputStream()));
        this.text.getModel().read(reader);
        reader.close();
        BOrd bOrd = this.getWbShell().getActiveOrd();
        this.state = (FileState)fileStates.get(bOrd);
        if (this.state == null) {
            this.state = new FileState(bOrd);
            fileStates.put(bOrd, this.state);
        }
        this.text.moveCaretPosition(this.state.lastPosition);
    }

    protected BObject doSaveValue(BObject bObject, Context context) throws Exception {
        BIFile bIFile = (BIFile)bObject;
        Writer writer = this.toWriter(bIFile.getOutputStream());
        this.text.getModel().write(writer);
        writer.flush();
        writer.close();
        this.lastModified = bIFile.getLastModified();
        return bObject;
    }

    public String getDefaultOptionsId() {
        return "textEditor";
    }

    public BMenu[] getViewMenus() {
        BMenu bMenu = new BMenu(TYPE.getDisplayName(null));
        bMenu.add(null, this.saveAndCompile);
        bMenu.add(null, this.saveAndSlot);
        return new BMenu[]{bMenu};
    }

    public BToolBar getViewToolBar() {
        BToolBar bToolBar = new BToolBar();
        BNiagaraWbShell bNiagaraWbShell = (BNiagaraWbShell)this.getWbShell();
        bToolBar.add("find", bNiagaraWbShell.commands.find);
        bToolBar.add("replace", bNiagaraWbShell.commands.replace);
        bToolBar.add("sep0", (BValue)new BSeparator());
        bToolBar.add("findFiles", bNiagaraWbShell.commands.findFiles);
        bToolBar.add("replaceInFiles", bNiagaraWbShell.commands.replaceInFiles);
        bToolBar.add("sep1", (BValue)new BSeparator());
        bToolBar.add("saveAndCompile", this.saveAndCompile);
        bToolBar.add("sep2", (BValue)new BSeparator());
        bToolBar.add("consolePrev", bNiagaraWbShell.commands.consolePrev);
        bToolBar.add("consoleNext", bNiagaraWbShell.commands.consoleNext);
        return bToolBar;
    }

    public BWidget getViewStatusBarSupplement() {
        return this.status;
    }

    public void prime() {
        this.text.requestFocus();
    }

    public CommandArtifact invokeCommand(int n) throws Exception {
        switch (n) {
            case 6: {
                return this.text.doFind();
            }
            case 8: {
                return this.text.doFindNext();
            }
            case 7: {
                return this.text.doFindPrev();
            }
            case 9: {
                return this.text.doReplace();
            }
            case 10: {
                return this.text.doGoto();
            }
        }
        return super.invokeCommand(n);
    }

    public static File findBuildFile(File file, String string) {
        Object object;
        if (file == null) {
            return null;
        }
        if (file.isDirectory()) {
            object = new File(file, string);
            if (((File)object).exists()) {
                return object;
            }
        } else if (file.getName().equals(string)) {
            return file;
        }
        if ((object = file.getParent()) == null) {
            return null;
        }
        return BTextFileEditor.findBuildFile(new File(file.getParent()), string);
    }

    public static File findParentDirectory(File file, String string) {
        if (file == null) {
            return null;
        }
        if (file.isDirectory() && file.getName().equals(string)) {
            return file;
        }
        String string2 = file.getParent();
        if (string2 == null) {
            return null;
        }
        return BTextFileEditor.findParentDirectory(new File(file.getParent()), string);
    }

    Reader toReader(InputStream inputStream) throws Exception {
        XInputStreamReader xInputStreamReader = new XInputStreamReader(inputStream);
        this.encoding = xInputStreamReader.getEncoding();
        this.zipped = xInputStreamReader.isZipped();
        String string = this.encoding;
        if (this.zipped) {
            string = "Zip/" + string;
        }
        this.encodingStatus.setText(string);
        this.encodingStatus.setVisibleColumns(string.length());
        return xInputStreamReader;
    }

    Writer toWriter(OutputStream outputStream) throws Exception {
        if (this.zipped) {
            ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
            zipOutputStream.putNextEntry(new ZipEntry("file.xml"));
            outputStream = zipOutputStream;
        }
        if (this.encoding.equals("UTF-16LE")) {
            outputStream.write(255);
            outputStream.write(254);
        }
        if (this.encoding.equals("UTF-16BE")) {
            outputStream.write(254);
            outputStream.write(255);
        }
        return new OutputStreamWriter(outputStream, this.encoding);
    }

    public String getSelectedText() {
        return this.text.getModel().getSelectedText();
    }

    public void highlight(int n, int n2, int n3, int n4) {
        Position position = this.text.getModel().getEndPosition();
        Position position2 = new Position(n - 1, n2 - 1);
        Position position3 = new Position(n3 - 1, n4 - 1);
        if (position2.compareTo((Object)position) > 0) {
            position2 = position;
        }
        if (position3.compareTo((Object)position) > 0) {
            position3 = position;
        }
        this.state.viewport = null;
        this.text.getSelection().select(position2, position3);
        this.text.moveCaretPosition(position3);
        this.text.requestFocus();
    }

    public void caretMoved(Position position) {
        this.state.lastPosition = position;
        String string = String.valueOf(position.line + 1);
        String string2 = String.valueOf(position.column + 1);
        this.lineStatus.setText(lexLine + TextUtil.padLeft((String)string, (int)6));
        this.columnStatus.setText(lexCol + TextUtil.padLeft((String)string2, (int)4));
    }

    public void doLayout(BWidget[] bWidgetArray) {
        super.doLayout(bWidgetArray);
        if (this.state != null && this.state.viewport != null) {
            this.pane.scrollToVisible(this.state.viewport);
            this.state.viewport = null;
        }
    }

    public void deactivated() {
        super.deactivated();
        if (this.state != null) {
            this.state.viewport = this.pane.getViewport();
        }
    }

    public void checkFileTimestamp() {
        if (this.lastModified == null) {
            return;
        }
        if (this.lastModified.equals((Object)this.file.getLastModified())) {
            return;
        }
        this.lastModified = this.file.getLastModified();
        new Thread(){

            public void run() {
                BTextFileEditor.this.confirmReload();
            }
        }.start();
    }

    public void confirmReload() {
        int n = BDialog.confirm((BWidget)this, (Object)lex.getText("fileEditor.fileHasChangedReload"));
        if (n == 4) {
            this.getWbShell().getRefreshCommand().invoke();
        }
    }

    public static TextParser getParser(String string) {
        Object object;
        if (string == null) {
            return null;
        }
        if (parserPropsFile == null) {
            parserPropsFile = new File(Sys.getBajaHome() + File.separator + "lib" + File.separator + "colorCoding.properties");
        }
        if (parserPropsFile.lastModified() > parserPropsLastModified) {
            log.message("Load \"" + parserPropsFile + "\"");
            parserPropsLastModified = parserPropsFile.lastModified();
            try {
                parserProps.clear();
                object = new FileInputStream(parserPropsFile);
                parserProps.load((InputStream)object);
                ((InputStream)object).close();
            }
            catch (Exception exception) {
                log.message("Load failed \"" + parserPropsFile + "\"", (Throwable)exception);
            }
        }
        if ((object = parserProps.getProperty(string)) == null) {
            return null;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, ":");
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            return (TextParser)Sys.loadModule((String)string2).loadClass(string3).newInstance();
        }
        catch (Exception exception) {
            log.message("Parser not found \"" + (String)object + "\"", (Throwable)exception);
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        fileStates = new HashMap();
    }

    public static class FileState {
        public BOrd ord;
        public Position lastPosition = new Position(0, 0);
        public RectGeom viewport;

        public FileState(BOrd bOrd) {
            this.ord = bOrd;
        }

        public String toString() {
            return this.ord.toString() + " " + this.lastPosition;
        }
    }

    class Controller
    extends TextController {
        Controller() {
        }

        public void focusGained(BFocusEvent bFocusEvent) {
            super.focusGained(bFocusEvent);
            BTextFileEditor.this.checkFileTimestamp();
        }
    }

    class SaveAndSlotCommand
    extends Command
    implements BConsole.ExecCallback {
        public SaveAndSlotCommand(BWidget bWidget) {
            super(bWidget, UiLexicon.bajaui().module, "programEditor.saveAndSlot");
        }

        public void consoleExecDone(BConsole bConsole, int n) {
            BTextFileEditor.this.checkFileTimestamp();
        }

        public CommandArtifact doInvoke() throws Exception {
            BNiagaraWbShell bNiagaraWbShell = (BNiagaraWbShell)this.getOwner().getShell();
            bNiagaraWbShell.getSaveCommand().invoke();
            File file = BTextFileEditor.findBuildFile(BTextFileEditor.this.localFile, "build.xml");
            if (file == null) {
                BDialog.error((BWidget)this.getOwner(), (Object)"No build.xml file found");
                return null;
            }
            String string = "src";
            if (BTextFileEditor.findParentDirectory(BTextFileEditor.this.localFile, "srcTest") != null) {
                string = "srcTest";
            }
            bNiagaraWbShell.openConsole().exec("slot \"" + file.getParent() + File.separator + string + "\"", this);
            return null;
        }
    }

    class SaveAndCompileCommand
    extends Command {
        public SaveAndCompileCommand(BWidget bWidget) {
            super(bWidget, UiLexicon.bajaui().module, "programEditor.saveAndCompile");
        }

        public CommandArtifact doInvoke() throws Exception {
            BNiagaraWbShell bNiagaraWbShell = (BNiagaraWbShell)this.getOwner().getShell();
            bNiagaraWbShell.getSaveCommand().invoke();
            File file = BTextFileEditor.findBuildFile(BTextFileEditor.this.localFile, "kit.xml");
            if (file != null) {
                bNiagaraWbShell.openConsole().exec("sedonac \"" + file + "\"");
                return null;
            }
            File file2 = BTextFileEditor.findBuildFile(BTextFileEditor.this.localFile, "build.xml");
            if (file2 != null) {
                String string = "";
                if (BTextFileEditor.findParentDirectory(BTextFileEditor.this.localFile, "srcTest") != null) {
                    string = string + " -t";
                }
                bNiagaraWbShell.openConsole().exec("build \"" + file2.getParent() + "\"" + string);
                return null;
            }
            BDialog.error((BWidget)this.getOwner(), (Object)"No build file found");
            return null;
        }
    }
}

