/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.file;

import com.tridium.sys.registry.NAgentList;
import com.tridium.util.PxUtil;
import com.tridium.workbench.shell.BNiagaraWbWebShell;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.agent.BAbstractPxView;
import javax.baja.collection.BITable;
import javax.baja.file.BExporter;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.ExportOp;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.list.ListSelection;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.BWbProfile;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.px.BWbPxView;
import javax.baja.workbench.view.BIExportableTableView;
import javax.baja.workbench.view.BIWbViewExporter;
import javax.baja.workbench.view.BWbView;

public class BExportDialog
extends BEdgePane {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$file$BExportDialog == null ? (class$com$tridium$workbench$file$BExportDialog = BExportDialog.class$("com.tridium.workbench.file.BExportDialog")) : class$com$tridium$workbench$file$BExportDialog));
    static AgentFilter viewFilter = AgentFilter.is((TypeInfo)BWbView.TYPE.getTypeInfo());
    static BImage icon = BImage.make((String)"module://icons/x32/export.png");
    UiLexicon lex = UiLexicon.bajaui();
    static final int VIEW_INTERNAL = 0;
    static final int VIEW_EXTERNAL = 1;
    static final int EMAIL = 2;
    static final int SAVE = 3;
    BWidget owner;
    BWbView view;
    OrdTarget target;
    ExporterItem[] exporters;
    ExporterItem cur;
    BListDropDown exporterField;
    BTextField email;
    BTextField saveOrd;
    ToggleCommandGroup action;
    ToggleCommand actionViewInternal = new ActionViewInternal((BWidget)this);
    ToggleCommand actionViewExternal = new ActionViewExternal((BWidget)this);
    ToggleCommand actionEmail = new ActionEmail((BWidget)this);
    ToggleCommand actionSave = new ActionSave((BWidget)this);
    Command saveBrowse = new SaveBrowse((BWidget)this);
    BBorderPane setupPane = new BBorderPane();
    BWbEditor setup;
    static /* synthetic */ Class class$com$tridium$workbench$file$BExportDialog;
    static /* synthetic */ Class class$com$tridium$workbench$file$BExportDialog$ExporterItem;
    static /* synthetic */ Class class$javax$baja$ui$BBinding;

    public Type getType() {
        return TYPE;
    }

    public static boolean hasExporters(BWbShell bWbShell, boolean bl) throws Exception {
        BWbView bWbView = bWbShell.getActiveView();
        OrdTarget ordTarget = bWbShell.getActiveOrdTarget();
        BExportDialog bExportDialog = null;
        try {
            bExportDialog = new BExportDialog((BWidget)bWbShell, ordTarget, bWbView, bl);
        }
        catch (Exception exception) {
            return false;
        }
        return bExportDialog.findExporters(bWbShell.getProfile()).length > 0;
    }

    public static CommandArtifact invoke(BWbShell bWbShell, boolean bl) throws Exception {
        BWbView bWbView = bWbShell.getActiveView();
        OrdTarget ordTarget = bWbShell.getActiveOrdTarget();
        return BExportDialog.invoke(new BExportDialog((BWidget)bWbShell, ordTarget, bWbView, bl));
    }

    public static CommandArtifact invoke(BWidget bWidget, BITable bITable, boolean bl) throws Exception {
        OrdTarget ordTarget = BOrd.make((String)"view:?dummy=dummy").resolve((BObject)bITable, (Context)bITable.getTableFacets());
        return BExportDialog.invoke(new BExportDialog(bWidget, ordTarget, null, bl));
    }

    public static CommandArtifact invoke(BWidget bWidget, BOrd bOrd, boolean bl) throws Exception {
        OrdTarget ordTarget = bOrd.resolve();
        return BExportDialog.invoke(new BExportDialog(bWidget, ordTarget, null, bl));
    }

    public static CommandArtifact invoke(BExportDialog bExportDialog) throws Exception {
        while (true) {
            int n;
            if ((n = BDialog.open((BWidget)bExportDialog.owner, (String)"Export", (Object)((Object)bExportDialog), (int)3)) != 1) {
                return null;
            }
            try {
                bExportDialog.setup.saveValue();
            }
            catch (Exception exception) {
                BDialog.error((BWidget)bExportDialog.owner, (String)"Cannot save setup", (Object)exception);
                continue;
            }
            break;
        }
        switch (bExportDialog.getSelectedAction()) {
            case 0: {
                BExportDialog.viewInternal(bExportDialog);
                break;
            }
            case 1: {
                BExportDialog.viewExternal(bExportDialog);
                break;
            }
            case 2: {
                BExportDialog.email(bExportDialog);
                break;
            }
            case 3: {
                BExportDialog.save(bExportDialog);
            }
        }
        return null;
    }

    static void viewInternal(BExportDialog bExportDialog) throws Exception {
        File file = BExportDialog.makeTempFile(bExportDialog);
        BOrd bOrd = BFileSystem.INSTANCE.localFileToOrd(file);
        bExportDialog.shell().hyperlink(bOrd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static File makeTempFile(BExportDialog bExportDialog) throws Exception {
        BExporter bExporter = bExportDialog.cur.getInstance();
        OrdTarget ordTarget = bExportDialog.cur.target;
        File file = new File(Sys.getBajaHome(), "temp");
        file.mkdirs();
        File file2 = File.createTempFile("temp", "." + bExporter.getFileExtension(), file);
        file2.deleteOnExit();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
        try {
            bExporter.export(ExportOp.make((OrdTarget)ordTarget, (OutputStream)bufferedOutputStream));
        }
        finally {
            bufferedOutputStream.close();
        }
        return file2;
    }

    static void viewExternal(BExportDialog bExportDialog) throws Exception {
        File file = BExportDialog.makeTempFile(bExportDialog);
        BExportDialog.launchExternal(file);
    }

    public static void launchExternal(File file) throws Exception {
        String string = BExportDialog.formatPath(file);
        if (System.getProperty("os.name").equalsIgnoreCase("linux")) {
            Runtime.getRuntime().exec("gnome-open " + string);
        } else {
            Runtime.getRuntime().exec("cmd.exe /c start " + string);
        }
    }

    static String formatPath(File file) throws Exception {
        String string = "";
        String[] stringArray = TextUtil.split((String)file.getCanonicalPath(), (char)'\\');
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                string = string + "\\";
            }
            string = stringArray[i].indexOf(" ") != -1 ? string + "\"" + stringArray[i] + "\"" : string + stringArray[i];
        }
        return string;
    }

    static void email(BExportDialog bExportDialog) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void save(BExportDialog bExportDialog) throws Exception {
        BExporter bExporter = bExportDialog.cur.getInstance();
        OrdTarget ordTarget = bExportDialog.cur.target;
        String string = bExporter.getFileExtension();
        String string2 = bExportDialog.saveOrd.getText();
        if (string2.length() == 0) {
            BDialog.error((BWidget)bExportDialog.owner, (Object)("Illegal filename: " + string2));
            return;
        }
        if (!string2.endsWith(string)) {
            string2 = string2 + "." + string;
        }
        BOrd bOrd = BOrd.make((String)string2);
        BIFile bIFile = null;
        try {
            bIFile = (BIFile)bOrd.resolve().get();
            if (8 == BDialog.confirm((BWidget)bExportDialog.owner, (Object)"File already exists.  Do you want to overwrite?")) {
                return;
            }
        }
        catch (UnresolvedException unresolvedException) {
            OrdQuery[] ordQueryArray = bOrd.parse();
            FilePath filePath = (FilePath)ordQueryArray[ordQueryArray.length - 1];
            ordQueryArray[ordQueryArray.length - 1] = new FilePath("");
            BFileSpace bFileSpace = (BFileSpace)BOrd.make((OrdQuery[])ordQueryArray).resolve().get();
            bIFile = bFileSpace.makeFile(filePath);
        }
        catch (SyntaxException syntaxException) {
            BDialog.error((BWidget)bExportDialog.owner, (Object)("Illegal filename: " + string2));
            return;
        }
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(bIFile.getOutputStream());
        try {
            bExporter.export(ExportOp.make((OrdTarget)ordTarget, (OutputStream)bufferedOutputStream));
        }
        finally {
            bufferedOutputStream.close();
        }
    }

    public static BWbProfile getProfile(BWidget bWidget) {
        if (BWbShell.getWbShell(bWidget) != null) {
            return BWbShell.getWbShell(bWidget).getProfile();
        }
        return new BWbProfile();
    }

    private BExportDialog(BWidget bWidget, OrdTarget ordTarget, BWbView bWbView, boolean bl) throws Exception {
        this.owner = bWidget;
        this.target = ordTarget;
        this.view = bWbView;
        BWbProfile bWbProfile = BExportDialog.getProfile(bWidget);
        this.exporters = this.findExporters(bWbProfile);
        if (this.exporters.length == 0) {
            throw new LocalizableException((Lexicon)this.lex, "exporter.noExporters");
        }
        this.setTop((BWidget)new BWizardHeader(icon, this.lex.getText("commands.export.label")));
        BTabbedPane bTabbedPane = new BTabbedPane();
        bTabbedPane.addPane(this.lex.getText("exporter.action"), this.buildAction());
        bTabbedPane.addPane(this.lex.getText("exporter.setup"), (BWidget)this.setupPane);
        this.setCenter((BWidget)new BBorderPane((BWidget)bTabbedPane));
        int n = 0;
        if (bl) {
            TypeInfo typeInfo = Sys.getRegistry().getType("pdf:PdfExporter");
            for (int i = 0; i < this.exporters.length; ++i) {
                if (!this.exporters[i].agent.getAgentType().is(typeInfo)) continue;
                n = i;
                break;
            }
        }
        this.exporterField.getList().setSelectedIndex(n);
    }

    BWidget buildAction() {
        ExporterItem exporterItem;
        this.exporterField = new BListDropDown();
        this.exporterField.getList().setSelection((ListSelection)new ExporterListSelection());
        for (int i = 0; i < this.exporters.length; ++i) {
            exporterItem = this.exporters[i];
            this.exporterField.getList().addItem(exporterItem.icon, (Object)exporterItem.label);
        }
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.add(null, (BValue)new BLabel(this.lex.getText("exporter.select.exporter")));
        bGridPane.add(null, (BValue)this.exporterField);
        exporterItem = new ToggleCommandGroup();
        exporterItem.add(this.actionViewInternal);
        exporterItem.add(this.actionViewExternal);
        exporterItem.add(this.actionEmail);
        exporterItem.add(this.actionSave);
        this.actionViewExternal.setSelected(true);
        this.email = new BTextField("", 55, false);
        this.saveOrd = new BTextField("", 55, false);
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setRight((BWidget)new BButton(this.saveBrowse));
        BGridPane bGridPane2 = new BGridPane(1);
        bGridPane2.setColumnAlign(BHalign.fill);
        BWbShell bWbShell = this.shell();
        if (!(bWbShell instanceof BNiagaraWbWebShell)) {
            bGridPane2.add(null, (BValue)new BRadioButton(this.actionViewInternal));
        }
        bGridPane2.add(null, (BValue)new BRadioButton(this.actionViewExternal));
        bGridPane2.add(null, (BValue)new BRadioButton(this.actionSave));
        bGridPane2.add(null, (BValue)new BBorderPane((BWidget)this.saveOrd, 0.0, 0.0, 0.0, 20.0));
        bGridPane2.add(null, (BValue)new BBorderPane((BWidget)bEdgePane, 0.0, 0.0, 0.0, 20.0));
        BGridPane bGridPane3 = new BGridPane(1);
        bGridPane3.setValign(BValign.top);
        bGridPane3.setHalign(BHalign.left);
        bGridPane3.add(null, (BValue)bGridPane);
        bGridPane3.add(null, (BValue)new BBorderPane((BWidget)bGridPane2, 10.0, 0.0, 0.0, 0.0));
        return new BBorderPane((BWidget)bGridPane3);
    }

    ExporterItem[] findExporters(BWbProfile bWbProfile) {
        Array array = new Array(class$com$tridium$workbench$file$BExportDialog$ExporterItem == null ? (class$com$tridium$workbench$file$BExportDialog$ExporterItem = BExportDialog.class$("com.tridium.workbench.file.BExportDialog$ExporterItem")) : class$com$tridium$workbench$file$BExportDialog$ExporterItem);
        if (this.view != null) {
            this.findViewExporters(array, this.view, bWbProfile);
        }
        if (this.view instanceof BWbPxView) {
            this.findPxViewExporters(array, this.target, bWbProfile);
        }
        if (this.view instanceof BIExportableTableView) {
            this.findTableViewExporters(array, (BIExportableTableView)((Object)this.view), bWbProfile);
        }
        if (this.target != null) {
            this.findOrdTargetExporters(array, this.target, bWbProfile);
        }
        return (ExporterItem[])array.trim();
    }

    void findViewExporters(Array array, BWbView bWbView, BWbProfile bWbProfile) {
        BOrd bOrd = BOrd.make((String)("view:" + bWbView.getType()));
        OrdTarget ordTarget = bOrd.resolve((BObject)bWbView);
        AgentFilter agentFilter = AgentFilter.is((Type)BIWbViewExporter.TYPE);
        AgentList agentList = bWbProfile.getAgents((BObject)bWbView).filter(agentFilter);
        this.addExporters(array, agentList, ordTarget);
    }

    void findPxViewExporters(Array array, OrdTarget ordTarget, BWbProfile bWbProfile) {
        BAbstractPxView bAbstractPxView = ((BWbPxView)this.view).getPxAgent();
        AgentFilter agentFilter = AgentFilter.is((Type)BExporter.TYPE);
        AgentList agentList = bWbProfile.getAgents(ordTarget.get()).filter(agentFilter);
        NAgentList nAgentList = new NAgentList();
        for (int i = 0; i < agentList.size(); ++i) {
            String string;
            String string2;
            AgentInfo agentInfo = agentList.get(i);
            if (agentInfo instanceof PxUtil.PxAgent && (string2 = bAbstractPxView.getAgentId()).equals(string = ((PxUtil.PxAgent)agentInfo).getPxView().getAgentId())) continue;
            nAgentList.add(agentInfo);
        }
        agentList.remove((AgentList)nAgentList);
        this.addExporters(array, agentList, ordTarget);
        this.findEmbeddedViews(array, this.view, bWbProfile);
    }

    void findEmbeddedViews(Array array, BWidget bWidget, BWbProfile bWbProfile) {
        BWidget[] bWidgetArray = bWidget.getChildWidgets();
        for (int i = 0; i < bWidgetArray.length; ++i) {
            if (bWidgetArray[i] instanceof BWbView) {
                this.findViewExporters(array, (BWbView)bWidgetArray[i], bWbProfile);
                continue;
            }
            this.findEmbeddedViews(array, bWidgetArray[i], bWbProfile);
        }
    }

    void findTableViewExporters(Array array, BIExportableTableView bIExportableTableView, BWbProfile bWbProfile) {
        BITable bITable = bIExportableTableView.getExportTable().getModel().export();
        OrdTarget ordTarget = BOrd.make((String)"view:?dummy=dummy").resolve((BObject)bITable, (Context)bITable.getTableFacets());
        this.findOrdTargetExporters(array, ordTarget, bWbProfile);
    }

    void findOrdTargetExporters(Array array, OrdTarget ordTarget, BWbProfile bWbProfile) {
        AgentFilter agentFilter = AgentFilter.is((Type)BExporter.TYPE);
        AgentList agentList = bWbProfile.getAgents(ordTarget.get()).filter(agentFilter);
        agentList = this.pruneViewExporters(agentList);
        this.addExporters(array, agentList, ordTarget);
    }

    AgentList pruneViewExporters(AgentList agentList) {
        TypeInfo[] typeInfoArray = null;
        NAgentList nAgentList = new NAgentList();
        block0: for (int i = 0; i < agentList.size(); ++i) {
            AgentInfo agentInfo = agentList.get(i);
            if (agentInfo instanceof PxUtil.PxAgent) {
                nAgentList.add(agentInfo);
                continue;
            }
            typeInfoArray = agentInfo.getAgentType().getInterfaces();
            for (int j = 0; j < typeInfoArray.length; ++j) {
                if (!typeInfoArray[j].is(BIWbViewExporter.TYPE)) continue;
                nAgentList.add(agentInfo);
                continue block0;
            }
        }
        agentList.remove((AgentList)nAgentList);
        return agentList;
    }

    void addExporters(Array array, AgentList agentList, OrdTarget ordTarget) {
        for (int i = 0; i < agentList.size(); ++i) {
            array.add((Object)new ExporterItem(agentList.get(i), ordTarget));
        }
    }

    public BWbShell shell() {
        return BWbShell.getWbShell(this.owner);
    }

    void updateExporter(ExporterItem exporterItem) {
        try {
            this.cur = exporterItem;
            BExporter bExporter = exporterItem.getInstance();
            this.setup = (BWbEditor)bExporter.getAgents().filter(viewFilter).getDefault().getInstance();
            this.setup.loadValue((BObject)bExporter);
            this.setupPane.setContent((BWidget)this.setup);
            AgentList agentList = bExporter.getAgents().filter(viewFilter);
            this.actionViewInternal.setEnabled(agentList.size() > 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.setup = null;
            this.setupPane.setContent((BWidget)new BLabel("ERROR"));
        }
    }

    int getSelectedAction() {
        if (this.actionViewInternal.isSelected()) {
            return 0;
        }
        if (this.actionViewExternal.isSelected()) {
            return 1;
        }
        if (this.actionEmail.isSelected()) {
            return 2;
        }
        if (this.actionSave.isSelected()) {
            return 3;
        }
        throw new IllegalStateException();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class ExporterItem {
        final AgentInfo agent;
        final OrdTarget target;
        final BImage icon;
        final String label;
        private BExporter instance;

        ExporterItem(AgentInfo agentInfo, OrdTarget ordTarget) {
            BBinding[] bBindingArray;
            this.agent = agentInfo;
            this.target = ordTarget;
            this.icon = BImage.make((BIcon)agentInfo.getIcon(null));
            StringBuffer stringBuffer = new StringBuffer(agentInfo.getDisplayName(null));
            BComponent bComponent = ordTarget.getComponent();
            if (bComponent != null && (bBindingArray = (BBinding[])bComponent.getChildren(class$javax$baja$ui$BBinding == null ? (class$javax$baja$ui$BBinding = BExportDialog.class$("javax.baja.ui.BBinding")) : class$javax$baja$ui$BBinding)).length > 0) {
                stringBuffer.append(" (").append(bBindingArray[0].getOrd().toString()).append(")");
            }
            this.label = stringBuffer.toString();
        }

        public BExporter getInstance() {
            if (this.instance == null) {
                this.instance = (BExporter)this.agent.getInstance();
            }
            return this.instance;
        }
    }

    class SaveBrowse
    extends Command {
        SaveBrowse(BWidget bWidget) {
            super(bWidget, (Lexicon)BExportDialog.this.lex, "exporter.save.browse");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            BFileChooser bFileChooser = BFileChooser.makeSave((BWidget)this.getOwner());
            bFileChooser.setCreateFileOnSave(false);
            bFileChooser.setConfirmOverwrite(false);
            BOrd bOrd = bFileChooser.show();
            if (bOrd != null) {
                bOrd = bOrd.relativizeToSession();
                BExportDialog.this.saveOrd.setText(bOrd.toString());
            }
            return null;
        }
    }

    class ActionSave
    extends ToggleCommand {
        ActionSave(BWidget bWidget) {
            super(bWidget, (Lexicon)BExportDialog.this.lex, "exporter.action.save");
        }

        public void setSelected(boolean bl) {
            super.setSelected(bl);
            BExportDialog.this.saveOrd.setEditable(this.isSelected());
            BExportDialog.this.saveBrowse.setEnabled(this.isSelected());
        }
    }

    class ActionEmail
    extends ToggleCommand {
        ActionEmail(BWidget bWidget) {
            super(bWidget, (Lexicon)BExportDialog.this.lex, "exporter.action.email");
        }

        public void setSelected(boolean bl) {
            super.setSelected(bl);
            BExportDialog.this.email.setEditable(this.isSelected());
        }
    }

    class ActionViewExternal
    extends ToggleCommand {
        ActionViewExternal(BWidget bWidget) {
            super(bWidget, (Lexicon)BExportDialog.this.lex, "exporter.action.viewExternal");
        }
    }

    class ActionViewInternal
    extends ToggleCommand {
        ActionViewInternal(BWidget bWidget) {
            super(bWidget, (Lexicon)BExportDialog.this.lex, "exporter.action.viewInternal");
        }
    }

    class ExporterListSelection
    extends ListSelection {
        ExporterListSelection() {
        }

        public void updateList() {
            super.updateList();
            int n = this.getList().getSelectedIndex();
            if (n >= 0) {
                BExportDialog.this.updateExporter(BExportDialog.this.exporters[n]);
            }
        }
    }
}

