/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors;

import com.tridium.util.ObjectUtil;
import com.tridium.workbench.celltable.BCellTable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.baja.naming.ViewQuery;
import javax.baja.nre.util.Array;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.IllegalNameException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.options.BMruButton;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.TableSelection;
import javax.baja.util.Lexicon;
import javax.baja.workbench.celleditor.BWbCellEditor;
import org.apache.oro.text.perl.Perl5Util;

public class BViewQueryEditor
extends BEdgePane {
    public static final Action tableSelectionModified = BViewQueryEditor.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$fieldeditors$BViewQueryEditor == null ? (class$com$tridium$workbench$fieldeditors$BViewQueryEditor = BViewQueryEditor.class$("com.tridium.workbench.fieldeditors.BViewQueryEditor")) : class$com$tridium$workbench$fieldeditors$BViewQueryEditor));
    private static Lexicon wbLex = Lexicon.make((String)"workbench");
    private static String lexKey = wbLex.get("viewQueryFE.key", "Key");
    private static String lexValue = wbLex.get("viewQueryFE.value", "Value");
    private BCellTable table;
    private TableSelection tableSel;
    private BButton btnRemove;
    private BButton btnAdd;
    private BMruButton history;
    private String viewQueryId = "ViewQueryEditor";
    private Array rows = new Array(class$com$tridium$workbench$fieldeditors$BViewQueryEditor$Row == null ? (class$com$tridium$workbench$fieldeditors$BViewQueryEditor$Row = BViewQueryEditor.class$("com.tridium.workbench.fieldeditors.BViewQueryEditor$Row")) : class$com$tridium$workbench$fieldeditors$BViewQueryEditor$Row);
    private boolean readonly = false;
    private Perl5Util util = new Perl5Util();
    static /* synthetic */ Class class$com$tridium$workbench$fieldeditors$BViewQueryEditor;
    static /* synthetic */ Class class$com$tridium$workbench$fieldeditors$BViewQueryEditor$Row;

    public void tableSelectionModified() {
        this.invoke(tableSelectionModified, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static String open(BWidget bWidget, ViewQuery viewQuery) throws Exception {
        return BViewQueryEditor.open(bWidget, viewQuery, false);
    }

    public static String open(BWidget bWidget, ViewQuery viewQuery, boolean bl) throws Exception {
        String string = wbLex.getText("viewQueryFE.dialogTitle");
        return BViewQueryEditor.open(bWidget, string, viewQuery, bl);
    }

    public static String open(BWidget bWidget, String string, ViewQuery viewQuery, boolean bl) throws Exception {
        BViewQueryEditor bViewQueryEditor = new BViewQueryEditor(viewQuery, bl);
        int n = BDialog.open((BWidget)bWidget, (String)string, (Object)((Object)bViewQueryEditor), (int)3);
        if (n != 1) {
            return null;
        }
        return bViewQueryEditor.save();
    }

    public BViewQueryEditor() {
        throw new IllegalStateException();
    }

    public BViewQueryEditor(ViewQuery viewQuery, boolean bl) {
        this.table = new BCellTable(new String[]{lexKey, lexValue}, new double[]{120.0, 75.0});
        this.tableSel = this.table.getSelection();
        this.table.setCellsEnabled(!bl);
        this.readonly = bl;
        this.loadViewQuery(viewQuery);
        BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)this.table);
        bConstrainedPane.setMinHeight(150.0);
        bConstrainedPane.setMinWidth(300.0);
        this.history = new BMruButton("viewQueryFE");
        this.history.setMruController((BMruButton.MruController)new MruController());
        BGridPane bGridPane = new BGridPane(4);
        bGridPane.setHalign(BHalign.right);
        this.btnAdd = BViewQueryEditor.newButton(new Add((BWidget)this));
        bGridPane.add(null, (BValue)this.btnAdd);
        this.btnRemove = BViewQueryEditor.newButton(new Remove((BWidget)this));
        bGridPane.add(null, (BValue)this.btnRemove);
        bGridPane.add(null, (BValue)this.history);
        this.btnRemove.setEnabled(false);
        this.btnAdd.setEnabled(!bl);
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setCenter((BWidget)bGridPane);
        BEdgePane bEdgePane2 = new BEdgePane();
        bEdgePane2.setCenter((BWidget)bConstrainedPane);
        bEdgePane2.setBottom((BWidget)new BBorderPane((BWidget)bEdgePane, 3.0, 0.0, 6.0, 0.0));
        this.setCenter((BWidget)bEdgePane2);
        this.linkTo("linkTable", (BComponent)this.table, (Slot)BCellTable.selectionModified, (Slot)tableSelectionModified);
    }

    private static BButton newButton(Command command) {
        BButton bButton = new BButton(command, true, true);
        bButton.setHalign(BHalign.left);
        return bButton;
    }

    public String save() throws Exception {
        Row row;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.rows.size(); ++i) {
            row = (Row)this.rows.get(i);
            BString bString = (BString)row.keyCe.saveValue();
            BString bString2 = (BString)row.valCe.saveValue();
            if (bString.getString().length() == 0) {
                throw new IllegalNameException("baja", "IllegalNameException.name", new Object[]{bString});
            }
            if (i > 0) {
                stringBuffer.append(";");
            }
            stringBuffer.append(bString).append("=").append(bString2);
        }
        String string = stringBuffer.toString();
        row = new ViewQuery(this.viewQueryId + "?" + string);
        this.history.getMruOptions().save(string);
        return row.getBody();
    }

    public void doTableSelectionModified() {
        if (!this.readonly) {
            int n = this.tableSel.getRow();
            this.btnRemove.setEnabled(n != -1);
        }
    }

    private void clearTable() {
        while (this.rows.size() > 0) {
            this.rows.remove(0);
            this.table.removeRow(0);
        }
        this.tableSel.deselectAll();
        this.table.relayout();
    }

    private SortedMap parseParamString(String string) {
        ArrayList arrayList = new ArrayList();
        this.util.split(arrayList, "/;/", string);
        TreeMap treeMap = new TreeMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = (String)arrayList.get(i);
            ArrayList arrayList2 = new ArrayList(2);
            this.util.split(arrayList2, "/=/", string2, 2);
            treeMap.put(arrayList2.get(0), (String)(arrayList2.size() == 2 ? arrayList2.get(1) : ""));
        }
        return treeMap;
    }

    private void loadViewQuery(ViewQuery viewQuery) {
        if (viewQuery != null) {
            this.viewQueryId = viewQuery.getViewId();
            String string = viewQuery.getBody();
            int n = string.indexOf("?");
            if (n >= 0) {
                String string2 = string.substring(n + 1);
                SortedMap sortedMap = this.parseParamString(string2);
                Iterator iterator = sortedMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    String string3 = (String)entry.getKey();
                    String string4 = (String)entry.getValue();
                    this.table.addRow(new Row(string3, (BObject)BString.make((String)string4), false).toArray());
                }
            }
        }
    }

    private boolean containsKey(String string) {
        try {
            for (int i = 0; i < this.rows.size(); ++i) {
                Row row = (Row)this.rows.get(i);
                String string2 = row.keyCe.saveValue().toString();
                if (!string2.equals(string)) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class MruController
    extends BMruButton.MruController {
        MruController() {
        }

        public void select(String string) {
            try {
                BViewQueryEditor.this.clearTable();
                BViewQueryEditor.this.loadViewQuery(new ViewQuery(BViewQueryEditor.this.viewQueryId + "?" + string));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private class Row {
        BWbCellEditor keyCe;
        BWbCellEditor valCe;

        Row(String string, BObject bObject, boolean bl) {
            BString bString = BString.make((String)string);
            this.keyCe = BWbCellEditor.makeFor((BObject)bString);
            this.valCe = BWbCellEditor.makeFor(bObject);
            this.keyCe.setReadonly(bl);
            this.valCe.setReadonly(bl);
            this.keyCe.loadValue((BObject)bString);
            this.valCe.loadValue(bObject);
            BViewQueryEditor.this.rows.add((Object)this);
        }

        BWbCellEditor[] toArray() {
            return new BWbCellEditor[]{this.keyCe, this.valCe};
        }
    }

    private class Remove
    extends Command {
        Remove(BWidget bWidget) {
            super(bWidget, wbLex, "viewQueryFE.remove");
        }

        public CommandArtifact doInvoke() {
            if (BViewQueryEditor.this.readonly) {
                return null;
            }
            int n = BViewQueryEditor.this.tableSel.getRow();
            if (n == -1) {
                throw new IllegalStateException();
            }
            BViewQueryEditor.this.rows.remove(n);
            BViewQueryEditor.this.table.removeRow(n);
            BViewQueryEditor.this.tableSel.deselectAll();
            int n2 = BViewQueryEditor.this.table.getRowCount();
            if (n2 > 0) {
                BViewQueryEditor.this.tableSel.select(n == n2 ? n - 1 : n);
            }
            BViewQueryEditor.this.table.relayout();
            return null;
        }
    }

    private class Add
    extends Command
    implements ObjectUtil.NameContainer {
        Add(BWidget bWidget) {
            super(bWidget, wbLex, "viewQueryFE.add");
        }

        public boolean contains(String string) {
            return BViewQueryEditor.this.containsKey(string);
        }

        public CommandArtifact doInvoke() {
            int n = BViewQueryEditor.this.table.getRowCount();
            BViewQueryEditor.this.table.addRow(new Row(ObjectUtil.generateUniqueSlotName((String)"key", (ObjectUtil.NameContainer)this), (BObject)BString.DEFAULT, false).toArray());
            BViewQueryEditor.this.tableSel.deselectAll();
            BViewQueryEditor.this.tableSel.select(n - 1);
            BViewQueryEditor.this.table.relayout();
            return null;
        }
    }
}

