/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors;

import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.options.BMruButton;
import javax.baja.ui.pane.BGridPane;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BUnitFE
extends BWbFieldEditor {
    public static final Action qboxChanged = BUnitFE.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$fieldeditors$BUnitFE == null ? (class$com$tridium$workbench$fieldeditors$BUnitFE = BUnitFE.class$("com.tridium.workbench.fieldeditors.BUnitFE")) : class$com$tridium$workbench$fieldeditors$BUnitFE));
    private BListDropDown qbox = new BListDropDown();
    private BListDropDown ubox = new BListDropDown();
    private BMruButton history = new BMruButton("unitFE");
    private BUnit loading;
    static /* synthetic */ Class class$com$tridium$workbench$fieldeditors$BUnitFE;

    public void qboxChanged() {
        this.invoke(qboxChanged, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BUnitFE() {
        this.history.setMruController((BMruButton.MruController)new MruController());
        this.history.setButtonStyle(BButtonStyle.toolBar);
        BGridPane bGridPane = new BGridPane(3);
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.add("qbox", (BValue)this.qbox);
        bGridPane.add("ubox", (BValue)this.ubox);
        bGridPane.add("history", (BValue)this.history);
        this.setContent((BWidget)bGridPane);
        this.linkTo("lk0", (BComponent)this.qbox, (Slot)BListDropDown.actionPerformed, (Slot)actionPerformed);
        this.linkTo("lk1", (BComponent)this.qbox, (Slot)BListDropDown.valueModified, (Slot)qboxChanged);
        this.linkTo("lk3", (BComponent)this.qbox, (Slot)BListDropDown.valueModified, (Slot)setModified);
        this.linkTo("lk4", (BComponent)this.ubox, (Slot)BListDropDown.valueModified, (Slot)setModified);
        this.linkTo("lk5", (BComponent)this.ubox, (Slot)BListDropDown.actionPerformed, (Slot)actionPerformed);
        UnitDatabase.Quantity[] quantityArray = UnitDatabase.getDefault().getQuantities();
        for (int i = 0; i < quantityArray.length; ++i) {
            this.qbox.getList().addItem((Object)quantityArray[i]);
        }
        this.qbox.setSelectedIndex(0);
    }

    protected void doSetReadonly(boolean bl) {
        this.qbox.setDropDownEnabled(!bl);
        this.ubox.setDropDownEnabled(!bl);
        this.history.setEnabled(!bl);
    }

    protected void doLoadValue(BObject bObject, Context context) {
        BUnit bUnit = (BUnit)bObject;
        UnitDatabase.Quantity quantity = UnitDatabase.getDefault().getQuantity(bUnit);
        if (quantity == null) {
            quantity = UnitDatabase.getDefault().getQuantities()[0];
        }
        this.loading = bUnit;
        this.qbox.setSelectedItem(null);
        this.qbox.setSelectedItem((Object)quantity);
        this.loading = null;
    }

    protected BObject doSaveValue(BObject bObject, Context context) throws Exception {
        UnitEntry unitEntry = (UnitEntry)this.ubox.getSelectedItem();
        this.history.getMruOptions().save(unitEntry.unit.encodeToString());
        return unitEntry.unit;
    }

    public void doQboxChanged() {
        int n = -1;
        this.ubox.getList().removeAllItems();
        UnitDatabase.Quantity quantity = (UnitDatabase.Quantity)this.qbox.getSelectedItem();
        if (quantity != null) {
            BUnit[] bUnitArray = quantity.getUnits();
            for (int i = 0; i < bUnitArray.length; ++i) {
                this.ubox.getList().addItem((Object)new UnitEntry(bUnitArray[i]));
                if (bUnitArray[i] != this.loading) continue;
                n = i;
            }
            if (n == -1 && this.loading != null) {
                this.ubox.getList().insertItem(0, (Object)new UnitEntry(this.loading));
                n = 0;
            }
            this.ubox.setSelectedIndex(n);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class MruController
    extends BMruButton.MruController {
        MruController() {
        }

        public String toDisplayString(String string) {
            try {
                BUnit bUnit = (BUnit)BUnit.DEFAULT.decodeFromString(string);
                return bUnit.getUnitName() + " (" + bUnit.getSymbol() + ")";
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return string;
            }
        }

        public void select(String string) {
            try {
                BUnitFE.this.loadValue(BUnit.DEFAULT.decodeFromString(string), BUnitFE.this.getCurrentContext());
                BUnitFE.this.setModified();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    static class UnitEntry {
        BUnit unit;
        String string;

        UnitEntry(BUnit bUnit) {
            this.unit = bUnit;
            this.string = bUnit.getUnitName() + " (" + bUnit.getSymbol() + ")";
        }

        public String toString() {
            return this.string;
        }
    }
}

