/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors;

import com.tridium.ui.theme.Theme;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.security.BPermissions;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BPermissionsEditor
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$fieldeditors$BPermissionsEditor == null ? (class$com$tridium$workbench$fieldeditors$BPermissionsEditor = BPermissionsEditor.class$("com.tridium.workbench.fieldeditors.BPermissionsEditor")) : class$com$tridium$workbench$fieldeditors$BPermissionsEditor));
    static final String lexOperator = UiLexicon.bajaui.getText("security.operator");
    static final String lexAdmin = UiLexicon.bajaui.getText("security.admin");
    static final String[] lexPermissions = new String[]{UiLexicon.bajaui.getText("security.r").trim(), UiLexicon.bajaui.getText("security.w").trim(), UiLexicon.bajaui.getText("security.i").trim(), UiLexicon.bajaui.getText("security.r").trim(), UiLexicon.bajaui.getText("security.w").trim(), UiLexicon.bajaui.getText("security.i").trim()};
    static final int r = 0;
    static final int w = 1;
    static final int i = 2;
    static final int R = 3;
    static final int W = 4;
    static final int I = 5;
    static BFont font = Theme.widget().getBoldText();
    static BColor selected = BColor.make((int)32768);
    static BColor implied = BColor.make((int)0x999999);
    int blockWidth = 0;
    int blockHeight = 16;
    BLabel operator;
    BLabel admin;
    BLabel oRead;
    BLabel oWrite;
    BLabel oInvoke;
    BLabel aRead;
    BLabel aWrite;
    BLabel aInvoke;
    boolean[] mode = new boolean[6];
    static /* synthetic */ Class class$com$tridium$workbench$fieldeditors$BPermissionsEditor;

    public Type getType() {
        return TYPE;
    }

    public BPermissionsEditor() {
        this.operator = this.make(lexOperator);
        this.add(null, (BValue)this.operator);
        this.admin = this.make(lexAdmin);
        this.add(null, (BValue)this.admin);
        this.oRead = this.make(lexPermissions[0]);
        this.add(null, (BValue)this.oRead);
        this.oWrite = this.make(lexPermissions[1]);
        this.add(null, (BValue)this.oWrite);
        this.oInvoke = this.make(lexPermissions[2]);
        this.add(null, (BValue)this.oInvoke);
        this.aRead = this.make(lexPermissions[3]);
        this.add(null, (BValue)this.aRead);
        this.aWrite = this.make(lexPermissions[4]);
        this.add(null, (BValue)this.aWrite);
        this.aInvoke = this.make(lexPermissions[5]);
        this.add(null, (BValue)this.aInvoke);
    }

    private BLabel make(String string) {
        return new BLabel(string, font);
    }

    protected void doLoadValue(BObject bObject, Context context) {
        BPermissions bPermissions = (BPermissions)bObject;
        this.mode[0] = bPermissions.hasOperatorRead();
        this.mode[1] = bPermissions.hasOperatorWrite();
        this.mode[2] = bPermissions.hasOperatorInvoke();
        this.mode[3] = bPermissions.hasAdminRead();
        this.mode[4] = bPermissions.hasAdminWrite();
        this.mode[5] = bPermissions.hasAdminInvoke();
    }

    protected BObject doSaveValue(BObject bObject, Context context) throws Exception {
        String string = "";
        if (this.mode[0]) {
            string = string + "r";
        }
        if (this.mode[1]) {
            string = string + "w";
        }
        if (this.mode[2]) {
            string = string + "i";
        }
        if (this.mode[3]) {
            string = string + "R";
        }
        if (this.mode[4]) {
            string = string + "W";
        }
        if (this.mode[5]) {
            string = string + "I";
        }
        return BPermissions.make((String)string);
    }

    public void computePreferredSize() {
        this.blockWidth = 16;
        this.blockHeight = 16;
        double d = Math.max(font.width(lexOperator), font.width(lexAdmin)) + 20.0;
        this.blockWidth = Math.max(this.blockWidth, (int)(d / 3.0));
        for (int i = 0; i < lexPermissions.length; ++i) {
            this.blockWidth = Math.max(this.blockWidth, (int)(font.width(lexPermissions[i]) + 10.0));
        }
        this.setPreferredSize(this.blockWidth * 6 + 4, this.blockHeight * 3);
    }

    public void doLayout(BWidget[] bWidgetArray) {
        double d = 2.0;
        double d2 = 2.0;
        double d3 = this.blockWidth + 1;
        double d4 = 14.0;
        this.operator.setBounds(d, d2, (double)(this.blockWidth * 3), d4);
        this.admin.setBounds(d + (double)(this.blockWidth * 3), d2, (double)(this.blockWidth * 3), d4);
        this.oRead.setBounds(d, d2 + d4, d3, d4);
        this.oWrite.setBounds(d + (double)this.blockWidth, d2 + d4, d3, d4);
        this.oInvoke.setBounds(d + (double)(this.blockWidth * 2), d2 + d4, d3, d4);
        this.aRead.setBounds(d + (double)(this.blockWidth * 3), d2 + d4, d3, d4);
        this.aWrite.setBounds(d + (double)(this.blockWidth * 4), d2 + d4, d3, d4);
        this.aInvoke.setBounds(d + (double)(this.blockWidth * 5), d2 + d4, d3, d4);
    }

    public void paint(Graphics graphics) {
        double d = this.getWidth() - 1.0;
        double d2 = this.getHeight() - 1.0;
        double d3 = 30.0;
        graphics.setBrush(Theme.widget().getControlBackground());
        graphics.fillRect(0.0, 0.0, d, d3);
        if (this.isReadonly()) {
            graphics.setBrush(Theme.widget().getControlBackground());
        } else {
            graphics.setBrush(Theme.widget().getWindowBackground());
        }
        graphics.fillRect(0.0, d3, d, 16.0);
        graphics.setBrush(BColor.black);
        graphics.strokeLine(0.0, d3, d, d3);
        graphics.strokeLine((double)(this.blockWidth * 3 + 2), 4.0, (double)(this.blockWidth * 3 + 2), d3 - 3.0);
        for (int i = 1; i < 6; ++i) {
            graphics.strokeLine((double)(2 + i * this.blockWidth), d3, (double)(2 + i * this.blockWidth), d3 + (double)this.blockHeight);
        }
        if (this.mode[4]) {
            this.paintMark(graphics, 4, selected);
            this.paintMark(graphics, 3, implied);
            this.paintMark(graphics, 1, implied);
            this.paintMark(graphics, 0, implied);
        } else if (this.mode[3]) {
            this.paintMark(graphics, 3, selected);
            this.paintMark(graphics, 0, implied);
            if (this.mode[1]) {
                this.paintMark(graphics, 1, selected);
            }
        } else if (this.mode[1]) {
            this.paintMark(graphics, 1, selected);
            this.paintMark(graphics, 0, implied);
        } else if (this.mode[0]) {
            this.paintMark(graphics, 0, selected);
        }
        if (this.mode[5]) {
            this.paintMark(graphics, 5, selected);
            this.paintMark(graphics, 2, implied);
        } else if (this.mode[2]) {
            this.paintMark(graphics, 2, selected);
        }
        this.paintChildren(graphics);
        graphics.setBrush(BColor.black);
        graphics.strokeRect(1.0, 1.0, d - 2.0, d2 - 2.0);
        graphics.setBrush(Theme.widget().getControlHighlight());
        graphics.strokeLine(0.0, d2, d, d2);
        graphics.strokeLine(d, 0.0, d, d2);
        graphics.setBrush(Theme.widget().getControlShadow());
        graphics.strokeLine(0.0, 0.0, d, 0.0);
        graphics.strokeLine(0.0, 0.0, 0.0, d2);
    }

    private void paintMark(Graphics graphics, int n, BColor bColor) {
        double d = n * this.blockWidth + (this.blockWidth - 6) / 2;
        double d2 = 35.0;
        graphics.setBrush(bColor);
        graphics.strokeLine(d, d2 + 4.0, d + 2.0, d2 + 6.0);
        graphics.strokeLine(d + 1.0, d2 + 4.0, d + 2.0, d2 + 5.0);
        graphics.strokeLine(d + 1.0, d2 + 3.0, d + 3.0, d2 + 5.0);
        graphics.strokeLine(d + 2.0, d2 + 4.0, d + 6.0, d2);
        graphics.strokeLine(d + 2.0, d2 + 5.0, d + 6.0, d2 + 1.0);
        graphics.strokeLine(d + 3.0, d2 + 5.0, d + 7.0, d2 + 1.0);
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        if (this.isReadonly()) {
            return;
        }
        double d = bMouseEvent.getX();
        double d2 = bMouseEvent.getY();
        if (d2 >= 30.0 && d2 <= 46.0 && d >= 2.0 && d2 <= 98.0) {
            int n = (int)((d - 4.0) / (double)this.blockWidth);
            if (n == 4) {
                this.mode[4] = !this.mode[4];
                this.mode[3] = false;
                this.mode[1] = false;
                this.mode[0] = false;
                this.setModified();
            } else if (n == 3 && !this.mode[4]) {
                this.mode[3] = !this.mode[3];
                this.mode[0] = false;
                this.setModified();
            } else if (n == 1 && !this.mode[4]) {
                this.mode[1] = !this.mode[1];
                this.mode[0] = false;
                this.setModified();
            } else if (!(n != 0 || this.mode[4] || this.mode[3] || this.mode[1])) {
                this.mode[0] = !this.mode[0];
                this.setModified();
            } else if (n == 5) {
                this.mode[5] = !this.mode[5];
                this.mode[2] = false;
                this.setModified();
            } else if (n == 2 && !this.mode[5]) {
                this.mode[2] = !this.mode[2];
                this.setModified();
            }
            this.repaint();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

