/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors;

import com.tridium.ui.theme.TextFieldTheme;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.util.BDatePickerCalendar;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BMonth;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BSpinnerButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.style.IStylable;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public abstract class BMultiFieldFE
extends BWbFieldEditor {
    public static final Action increment = BMultiFieldFE.newAction((int)0, null);
    public static final Action decrement = BMultiFieldFE.newAction((int)0, null);
    public static final Action showDatePicker = BMultiFieldFE.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$fieldeditors$BMultiFieldFE == null ? (class$com$tridium$workbench$fieldeditors$BMultiFieldFE = BMultiFieldFE.class$("com.tridium.workbench.fieldeditors.BMultiFieldFE")) : class$com$tridium$workbench$fieldeditors$BMultiFieldFE));
    public static final BImage calendarIcon = BImage.make((String)"module://icons/x16/calendar.png");
    protected Field[] fields = new Field[0];
    BSpinnerButton spinner = new BSpinnerButton();
    BWidget datePickerButton;
    int selection = 0;
    boolean paintNull;
    double prefHeight;
    static final double textViewFix = 4.0;
    static /* synthetic */ Class class$com$tridium$workbench$fieldeditors$BMultiFieldFE;

    public void increment() {
        this.invoke(increment, null, null);
    }

    public void decrement() {
        this.invoke(decrement, null, null);
    }

    public void showDatePicker() {
        this.invoke(showDatePicker, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BMultiFieldFE() {
        this.add("spinner", (BValue)this.spinner, 6);
        this.linkTo("incrementLink", (BComponent)this.spinner, (Slot)BSpinnerButton.increment, (Slot)increment);
        this.linkTo("decrementLink", (BComponent)this.spinner, (Slot)BSpinnerButton.decrement, (Slot)decrement);
    }

    protected void addDatePicker() {
        if (this.get("picker") != null) {
            return;
        }
        this.datePickerButton = new BButton(calendarIcon);
        ((BButton)this.datePickerButton).setFocusTraversable(false);
        ((BButton)this.datePickerButton).setButtonStyle(BButtonStyle.toolBar);
        this.add("picker", (BValue)this.datePickerButton);
        this.linkTo("editButtonLink", (BComponent)this.datePickerButton, (Slot)BButton.actionPerformed, (Slot)showDatePicker);
    }

    protected void doSetReadonly(boolean bl) {
        this.relayout();
    }

    public void computePreferredSize() {
        BFont bFont = Theme.textField().getFont();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.fields.length; ++i) {
            stringBuffer.append(this.fields[i].string());
        }
        double d = bFont.width(stringBuffer.toString());
        BInsets bInsets = Theme.textField().getInsets();
        double d2 = d + bInsets.left + bInsets.right + Theme.spinner().getSpinnerWidth();
        double d3 = bFont.getHeight() - 4.0 + bInsets.top + bInsets.bottom;
        if (this.datePickerButton != null && !this.isReadonly()) {
            this.datePickerButton.computePreferredSize();
            d2 += this.datePickerButton.getPreferredWidth() + 5.0;
            d3 = Math.max(d3, this.datePickerButton.getPreferredHeight());
        }
        this.setPreferredSize(d2, d3);
    }

    public void doLayout(BWidget[] bWidgetArray) {
        this.computePreferredSize();
        BFont bFont = Theme.textField().getFont();
        BInsets bInsets = Theme.textField().getInsets();
        this.prefHeight = this.getPreferredHeight();
        if (this.isReadonly()) {
            this.spinner.setVisible(false);
            this.spinner.setBounds(-1.0, -1.0, 0.0, 0.0);
            if (this.datePickerButton != null) {
                this.datePickerButton.setVisible(false);
                this.datePickerButton.setBounds(-1.0, -1.0, 0.0, 0.0);
            }
        } else {
            double d = this.getWidth();
            double d2 = this.getHeight();
            double d3 = Theme.spinner().getSpinnerWidth();
            double d4 = 0.0;
            double d5 = bFont.getHeight() - 4.0 + bInsets.top + bInsets.bottom;
            if (this.datePickerButton != null) {
                this.datePickerButton.computePreferredSize();
                d4 = this.datePickerButton.getPreferredWidth();
                this.datePickerButton.setVisible(true);
                this.datePickerButton.setBounds(d - d4, 0.0, d4, Math.min(d2, this.prefHeight));
            }
            this.spinner.setVisible(true);
            this.spinner.setBounds(d - d3 - (d4 == 0.0 ? 0.0 : d4 + 5.0), 0.0, d3, Math.min(d5, this.prefHeight));
        }
    }

    int fieldAt(double d, double d2) {
        TextFieldTheme textFieldTheme = Theme.textField();
        double d3 = textFieldTheme.getInsets().left;
        BFont bFont = textFieldTheme.getFont();
        for (int i = 0; i < this.fields.length; ++i) {
            String string = this.fields[i].string();
            if (!((d3 += bFont.width(string)) > d)) continue;
            return i;
        }
        return -1;
    }

    public void paint(Graphics graphics) {
        TextFieldTheme textFieldTheme = Theme.textField();
        BFont bFont = textFieldTheme.getFont();
        BInsets bInsets = textFieldTheme.getInsets();
        double d = this.getWidth();
        double d2 = this.prefHeight;
        double d3 = d - this.spinner.getWidth();
        double d4 = bFont.getHeight() - 4.0 + bInsets.top + bInsets.bottom;
        boolean bl = this.isReadonly();
        boolean bl2 = this.hasFocus();
        if (this.datePickerButton != null) {
            d3 -= this.datePickerButton.getWidth() + 5.0;
        }
        BBrush bBrush = textFieldTheme.getTextBrush((IStylable)this);
        BBrush bBrush2 = textFieldTheme.getControlBackground((IStylable)this);
        BBrush bBrush3 = textFieldTheme.getSelectionForeground((IStylable)this);
        BBrush bBrush4 = textFieldTheme.getSelectionBackground((IStylable)this);
        graphics.setFont(bFont);
        graphics.setBrush(bBrush2);
        graphics.fillRect(0.0, 0.0, d3, d4);
        graphics.setBrush(bBrush);
        double d5 = bInsets.left;
        double d6 = d4 - bInsets.bottom - 2.0;
        if (this.paintNull && this.isReadonly()) {
            graphics.drawString("null", d5, d6);
        } else {
            for (int i = 0; i < this.fields.length; ++i) {
                Field field = this.fields[i];
                String string = field.string();
                if (string == null) {
                    string = "?";
                }
                double d7 = bFont.width(string);
                if (i == this.selection && bl2) {
                    graphics.setBrush(bBrush4);
                    graphics.fillRect(d5, bInsets.top, d7, d4 - bInsets.top - bInsets.bottom);
                    graphics.setBrush(bBrush3);
                }
                graphics.drawString(string, d5, d6);
                d5 += d7;
                graphics.setBrush(bBrush);
            }
        }
        Theme.textField().paintBorder(graphics, (BWidget)this, d3, d4);
        this.paintChildren(graphics);
    }

    public String getStyleSelector() {
        return "text-editor";
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        super.mousePressed(bMouseEvent);
        if (this.isReadonly()) {
            return;
        }
        this.requestFocus();
        int n = this.fieldAt(bMouseEvent.getX(), bMouseEvent.getY());
        if (n != -1 && this.fields[n].isEditable()) {
            this.setSelection(n);
        }
    }

    public void keyTyped(BKeyEvent bKeyEvent) {
        char c = bKeyEvent.getKeyChar();
        if (c == '\n' || c == '\r') {
            this.fireActionPerformed(new BWidgetEvent(2, (BWidget)this));
            bKeyEvent.consume();
        } else if (this.fields[this.selection].keyTyped(c)) {
            bKeyEvent.consume();
        }
    }

    public void keyPressed(BKeyEvent bKeyEvent) {
        if (bKeyEvent.getModifiers() != 0) {
            return;
        }
        int n = this.selection;
        switch (bKeyEvent.getKeyCode()) {
            case 39: {
                do {
                    if (++n < this.fields.length) continue;
                    n = 0;
                } while (!this.fields[n].isEditable());
                this.setSelection(n);
                bKeyEvent.consume();
                break;
            }
            case 37: {
                do {
                    if (--n >= 0) continue;
                    n = this.fields.length - 1;
                } while (!this.fields[n].isEditable());
                this.setSelection(n);
                bKeyEvent.consume();
                break;
            }
            case 38: {
                this.doIncrement();
                bKeyEvent.consume();
                break;
            }
            case 40: {
                this.doDecrement();
                bKeyEvent.consume();
            }
        }
    }

    public boolean isFocusTraversable() {
        return !this.isReadonly();
    }

    public void focusGained(BFocusEvent bFocusEvent) {
        this.repaint();
    }

    public void focusLost(BFocusEvent bFocusEvent) {
        this.repaint();
    }

    public void doIncrement() {
        this.fields[this.selection].increment();
    }

    public void doDecrement() {
        this.fields[this.selection].decrement();
    }

    public void doShowDatePicker() {
        Field field = null;
        Field field2 = null;
        Field field3 = null;
        for (int i = 0; i < this.fields.length; ++i) {
            if (this.fields[i] instanceof YearField) {
                field = this.fields[i];
            }
            if (this.fields[i] instanceof MonthField) {
                field2 = this.fields[i];
            }
            if (!(this.fields[i] instanceof DayField)) continue;
            field3 = this.fields[i];
        }
        if (field == null || field2 == null || field3 == null) {
            return;
        }
        BDatePickerCalendar bDatePickerCalendar = BDatePickerCalendar.dialog(this, field.value, BMonth.make((int)field2.value));
        if (bDatePickerCalendar == null) {
            return;
        }
        field.set(bDatePickerCalendar.year);
        field2.set(bDatePickerCalendar.month.getOrdinal());
        field3.set(bDatePickerCalendar.day);
        this.setModified();
        this.repaint();
    }

    void setSelection(int n) {
        if (!this.fields[n].isEditable()) {
            throw new IllegalStateException();
        }
        this.fields[this.selection].typeCount = 0;
        this.selection = n;
        this.repaint();
    }

    protected void fieldModified(Field field) {
        this.setModified();
        this.repaint();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class AmPmField
    extends Field {
        String string() {
            return this.value == 0 ? "AM" : "PM";
        }

        int length() {
            return 2;
        }

        int max() {
            return 1;
        }
    }

    public class LabelField
    extends Field {
        LabelField(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            this.string = string;
        }

        int length() {
            return this.string.length();
        }

        boolean isEditable() {
            return false;
        }

        int max() {
            return 1;
        }
    }

    public class YearField
    extends Field {
        int length() {
            return 4;
        }

        int max() {
            return 2100;
        }
    }

    public class MonthTagField
    extends MonthField {
        int length() {
            return 3;
        }

        int max() {
            return 11;
        }

        public void set(int n) {
            BMonth bMonth = BMonth.make((int)n);
            this.value = n;
            this.string = bMonth.getShortDisplayTag(null);
            while (this.string.length() < 3) {
                this.string = this.string + " ";
            }
            if (this.string.length() > 3) {
                this.string = this.string.substring(0, 3);
            }
            if (BMultiFieldFE.this != null) {
                this.fieldModified();
            }
        }

        boolean keyTyped(int n) {
            return false;
        }
    }

    public class MonthField
    extends Field {
        int length() {
            return 2;
        }

        int max() {
            return 11;
        }

        public void set(int n) {
            this.value = n;
            this.string = String.valueOf(n + 1);
            for (int i = this.string.length(); i < this.length(); ++i) {
                this.string = "0" + this.string;
            }
            if (BMultiFieldFE.this != null) {
                this.fieldModified();
            }
        }

        boolean keyTyped(int n) {
            if (Character.isDigit((char)n)) {
                int n2;
                int n3 = n - 48;
                if (this.typeCount == 0) {
                    n2 = n3;
                } else {
                    int n4 = 1;
                    for (int i = 0; i < this.length() - 1; ++i) {
                        n4 *= 10;
                    }
                    n2 = (this.value + 1) % n4 * 10 + n3;
                }
                if (n2 > 0 && n2 <= this.max() + 1) {
                    this.set(n2 - 1);
                }
                ++this.typeCount;
                return true;
            }
            return false;
        }
    }

    public class DayField
    extends Field {
        int maxDay = 31;

        int length() {
            return 2;
        }

        int min() {
            return 1;
        }

        int max() {
            return this.maxDay;
        }

        void setMax(int n) {
            this.maxDay = n;
            if (this.value > this.maxDay) {
                this.set(this.maxDay);
            }
        }
    }

    public class MillisecondField
    extends Field {
        int length() {
            return 3;
        }

        int max() {
            return 999;
        }
    }

    public class SecondField
    extends Field {
        int length() {
            return 2;
        }

        int max() {
            return 59;
        }
    }

    public class MinuteField
    extends Field {
        int length() {
            return 2;
        }

        int max() {
            return 59;
        }
    }

    public class BigHourField
    extends Field {
        int length() {
            return 5;
        }

        int max() {
            return 99999;
        }
    }

    public class TwelveHourField
    extends HourField {
        int length() {
            return 2;
        }

        int min() {
            return 1;
        }

        int max() {
            return 12;
        }

        public void set(int n) {
            this.value = n;
            this.string = n == 0 ? "12" : String.valueOf(n);
            for (int i = this.string.length(); i < this.length(); ++i) {
                this.string = "0" + this.string;
            }
            if (BMultiFieldFE.this != null) {
                this.fieldModified();
            }
        }
    }

    public class HourField
    extends Field {
        int length() {
            return 2;
        }

        int max() {
            return 23;
        }
    }

    public abstract class Field {
        public int value;
        String string;
        int typeCount;

        Field() {
            this.set(this.min());
        }

        int min() {
            return 0;
        }

        abstract int max();

        abstract int length();

        boolean isEditable() {
            return true;
        }

        String string() {
            return this.string;
        }

        public void set(int n) {
            this.value = n;
            this.string = String.valueOf(n);
            for (int i = this.string.length(); i < this.length(); ++i) {
                this.string = "0" + this.string;
            }
            this.fieldModified();
        }

        void fieldModified() {
            if (!BMultiFieldFE.this.isModifiedStateLocked()) {
                BMultiFieldFE.this.fieldModified(this);
            }
        }

        void increment() {
            int n = this.value + 1;
            if (n > this.max()) {
                n = this.min();
            }
            this.set(n);
        }

        void decrement() {
            int n = this.value - 1;
            if (n < this.min()) {
                n = this.max();
            }
            this.set(n);
        }

        boolean keyTyped(int n) {
            if (Character.isDigit((char)n)) {
                int n2;
                int n3 = n - 48;
                if (this.typeCount == 0) {
                    n2 = n3;
                } else {
                    int n4 = 1;
                    for (int i = 0; i < this.length() - 1; ++i) {
                        n4 *= 10;
                    }
                    n2 = this.value % n4 * 10 + n3;
                }
                if (n2 <= this.max()) {
                    this.set(n2);
                }
                ++this.typeCount;
                return true;
            }
            return false;
        }
    }
}

