/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors;

import com.tridium.workbench.fieldeditors.BFloatFE;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.TextController;
import javax.baja.units.BUnit;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BIntegerFE
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$fieldeditors$BIntegerFE == null ? (class$com$tridium$workbench$fieldeditors$BIntegerFE = BIntegerFE.class$("com.tridium.workbench.fieldeditors.BIntegerFE")) : class$com$tridium$workbench$fieldeditors$BIntegerFE));
    private int width = 14;
    private BTextField field = new BTextField("", this.width);
    private BLabel postlabel = new BLabel("");
    private BLabel prelabel = new BLabel("");
    private String range = "";
    private Values values;
    static /* synthetic */ Class class$com$tridium$workbench$fieldeditors$BIntegerFE;

    public Type getType() {
        return TYPE;
    }

    public BIntegerFE() {
        this.field.setController((TextController)new BFloatFE.Controller());
        BGridPane bGridPane = new BGridPane(3);
        bGridPane.add("prelabel", (BValue)this.prelabel);
        bGridPane.add("field", (BValue)this.field);
        bGridPane.add("postlabel", (BValue)this.postlabel);
        this.setContent((BWidget)bGridPane);
        this.linkTo("lk0", (BComponent)this.field, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo("lk1", (BComponent)this.field, (Slot)BTextField.actionPerformed, (Slot)actionPerformed);
    }

    protected void doSetReadonly(boolean bl) {
        this.field.setEditable(!bl);
    }

    protected void doLoadValue(BObject bObject, Context context) {
        Object object;
        Object object2;
        this.values = bObject instanceof BInteger ? new IntValues(context) : new LongValues(context);
        this.range = "";
        this.width = 14;
        String string = "";
        String string2 = "";
        BNumber bNumber = null;
        BNumber bNumber2 = null;
        if (context != null) {
            object2 = (BUnit)context.getFacet("units");
            if (object2 != null && !object2.isNull()) {
                if (object2.getIsPrefix()) {
                    string2 = object2.getSymbol();
                } else {
                    string = object2.getSymbol();
                }
            }
            if ((object = (BInteger)context.getFacet("fieldWidth")) != null) {
                this.width = object.getInt();
            }
            bNumber = (BNumber)context.getFacet("min");
            bNumber2 = (BNumber)context.getFacet("max");
        }
        if (this.width != 14) {
            this.field.setVisibleColumns(this.width);
        }
        if (this.values.radix != 10) {
            if (string.length() > 0) {
                string = string + ' ';
            }
            string = string + "Radix=" + this.values.radix;
        }
        if (this.values.loadFacets(bNumber, bNumber2)) {
            object2 = bNumber == null ? "min" : this.values.toString((BObject)bNumber);
            object = bNumber2 == null ? "max" : this.values.toString((BObject)bNumber2);
            this.range = "[" + (String)object2 + " - " + (String)object + "]";
            if (string.length() > 0) {
                string = string + ' ';
            }
            string = string + this.range;
        }
        object2 = this.values.toString(bObject);
        this.field.setText((String)object2);
        this.prelabel.setText(string2);
        this.postlabel.setText(string);
    }

    protected BObject doSaveValue(BObject bObject, Context context) throws Exception {
        String string = this.field.getText();
        BValue bValue = this.values.fromString(string, this.range);
        this.field.setText(this.values.toString((BObject)bValue));
        return bValue;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class LongValues
    extends Values {
        long min = Long.MIN_VALUE;
        long max = Long.MAX_VALUE;

        public LongValues(Context context) {
            super(context);
        }

        boolean loadFacets(BNumber bNumber, BNumber bNumber2) {
            if (bNumber != null) {
                this.min = bNumber.getLong();
            }
            if (bNumber2 != null) {
                this.max = bNumber2.getLong();
            }
            return this.min != Long.MIN_VALUE || this.max != Long.MAX_VALUE;
        }

        String toString(BObject bObject) {
            return this.toString(((BNumber)bObject).getLong());
        }

        String toString(long l) {
            if (l == Long.MIN_VALUE) {
                return "min";
            }
            if (l == Long.MAX_VALUE) {
                return "max";
            }
            if (l == 0L || this.radix != 10) {
                return Long.toString(l, this.radix);
            }
            return this.toStringFormat.format(l);
        }

        BValue fromString(String string, String string2) throws CannotSaveException {
            long l;
            try {
                if (string.equals("min")) {
                    l = Long.MIN_VALUE;
                } else if (string.equals("max")) {
                    l = Long.MAX_VALUE;
                } else if (this.radix != 10) {
                    l = Long.parseLong(string, this.radix);
                } else {
                    String string3 = string.startsWith("+") ? string.substring(1) : string;
                    ParsePosition parsePosition = new ParsePosition(0);
                    l = this.fromStringFormat.parse(string3, parsePosition).longValue();
                    if (parsePosition.getIndex() != string3.length()) {
                        throw new CannotSaveException("Invalid format: " + string);
                    }
                }
            }
            catch (CannotSaveException cannotSaveException) {
                throw cannotSaveException;
            }
            catch (Exception exception) {
                throw new CannotSaveException("Invalid format: " + string);
            }
            if (l < this.min) {
                throw new CannotSaveException(this.toString(l) + " < " + this.toString(this.min) + " " + string2);
            }
            if (l > this.max) {
                throw new CannotSaveException(this.toString(l) + " > " + this.toString(this.max) + " " + string2);
            }
            return BLong.make((long)l);
        }
    }

    static class IntValues
    extends Values {
        int min = Integer.MIN_VALUE;
        int max = Integer.MAX_VALUE;

        public IntValues(Context context) {
            super(context);
        }

        boolean loadFacets(BNumber bNumber, BNumber bNumber2) {
            if (bNumber != null) {
                this.min = bNumber.getInt();
            }
            if (bNumber2 != null) {
                this.max = bNumber2.getInt();
            }
            return this.min != Integer.MIN_VALUE || this.max != Integer.MAX_VALUE;
        }

        String toString(BObject bObject) {
            return this.toString(((BNumber)bObject).getInt());
        }

        String toString(int n) {
            if (n == Integer.MIN_VALUE) {
                return "min";
            }
            if (n == Integer.MAX_VALUE) {
                return "max";
            }
            if (n == 0 || this.radix != 10) {
                return Long.toString((long)n & 0xFFFFFFFFL, this.radix);
            }
            return this.toStringFormat.format(n);
        }

        BValue fromString(String string, String string2) throws CannotSaveException {
            int n;
            try {
                if (string.equals("min")) {
                    n = Integer.MIN_VALUE;
                } else if (string.equals("max")) {
                    n = Integer.MAX_VALUE;
                } else if (this.radix != 10) {
                    n = (int)Long.parseLong(string, this.radix);
                } else {
                    String string3 = string.startsWith("+") ? string.substring(1) : string;
                    ParsePosition parsePosition = new ParsePosition(0);
                    n = this.fromStringFormat.parse(string3, parsePosition).intValue();
                    if (parsePosition.getIndex() != string3.length()) {
                        throw new CannotSaveException("Invalid format: " + string);
                    }
                }
            }
            catch (CannotSaveException cannotSaveException) {
                throw cannotSaveException;
            }
            catch (Exception exception) {
                throw new CannotSaveException("Invalid format: " + string);
            }
            if (n < this.min) {
                throw new CannotSaveException(this.toString(n) + " < " + this.toString(this.min) + " " + string2);
            }
            if (n > this.max) {
                throw new CannotSaveException(this.toString(n) + " > " + this.toString(this.max) + " " + string2);
            }
            return BInteger.make((int)n);
        }
    }

    static abstract class Values {
        final int radix;
        final boolean showSeparators;
        final boolean forceSign;
        final DecimalFormat toStringFormat;
        final DecimalFormat fromStringFormat;

        public Values(Context context) {
            BFacets bFacets = context == null ? BFacets.DEFAULT : context.getFacets();
            this.radix = bFacets.geti("radix", 10);
            this.showSeparators = bFacets.getb("showSeparators", false);
            this.forceSign = bFacets.getb("forceSign", false);
            String string = null;
            string = this.showSeparators ? "#,##0" : "#0";
            this.fromStringFormat = new DecimalFormat(string);
            string = this.forceSign ? "+" + string + ";-" + string : string;
            this.toStringFormat = new DecimalFormat(string);
        }

        abstract boolean loadFacets(BNumber var1, BNumber var2);

        abstract String toString(BObject var1);

        abstract BValue fromString(String var1, String var2) throws CannotSaveException;
    }
}

