/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors;

import com.tridium.ui.theme.Theme;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.Locale;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BFontFE
extends BWbFieldEditor {
    public static final Action updateFont = BFontFE.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$fieldeditors$BFontFE == null ? (class$com$tridium$workbench$fieldeditors$BFontFE = BFontFE.class$("com.tridium.workbench.fieldeditors.BFontFE")) : class$com$tridium$workbench$fieldeditors$BFontFE));
    private static Lexicon lex = Lexicon.make((String)"workbench");
    private static String[] fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames(Locale.ENGLISH);
    private static int[] fontSizes = new int[]{8, 9, 10, 11, 12, 14, 16, 18, 20, 22, 24, 26, 28, 36, 48, 72};
    private BCheckBox isNull = new BCheckBox((ToggleCommand)new Null());
    private BListDropDown name = new BListDropDown();
    private BTextDropDown size = new BTextDropDown(4, true);
    private BCheckBox bold = new BCheckBox(BFontFE.text("bold"));
    private BCheckBox italic = new BCheckBox(BFontFE.text("italic"));
    private BCheckBox underline = new BCheckBox(BFontFE.text("underline"));
    private BLabel sample = new BLabel("AaBbYyZz", BFont.make((String)"SansSerif", (double)20.0));
    private boolean frozen = false;
    static /* synthetic */ Class class$com$tridium$workbench$fieldeditors$BFontFE;

    public void updateFont() {
        this.invoke(updateFont, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BFontFE() {
        String string;
        Font font;
        String string2;
        int n;
        this.sample.computePreferredSize();
        BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)this.sample);
        bConstrainedPane.setMinWidth((double)((int)this.sample.getPreferredWidth()));
        bConstrainedPane.setMinHeight((double)((int)this.sample.getPreferredHeight()));
        bConstrainedPane.setMaxWidth((double)((int)this.sample.getPreferredWidth()));
        bConstrainedPane.setMaxHeight((double)((int)this.sample.getPreferredHeight()));
        BBorderPane bBorderPane = new BBorderPane((BWidget)bConstrainedPane, BBorder.make((int)6), BInsets.make((double)5.0));
        for (n = 0; n < fontNames.length; ++n) {
            string2 = fontNames[n];
            font = Font.decode(fontNames[n] + " plain");
            if (font != null && (string = font.getFamily(Locale.forLanguageTag(Sys.getLanguage()))) != null && !string2.equals(string)) {
                string2 = string;
            }
            this.name.getList().addItem((Object)string2);
        }
        for (n = 0; n < fontSizes.length; ++n) {
            this.size.getList().addItem((Object)Integer.toString(fontSizes[n]));
        }
        this.name.computePreferredSize();
        this.size.computePreferredSize();
        BConstrainedPane bConstrainedPane2 = new BConstrainedPane((BWidget)this.name);
        string2 = new BConstrainedPane((BWidget)this.size);
        bConstrainedPane2.setMinWidth((double)((int)this.name.getPreferredWidth()));
        string2.setMinWidth((double)((int)this.size.getPreferredWidth()));
        font = new BGridPane(2);
        font.add(null, (BValue)bConstrainedPane2);
        font.add(null, (BValue)string2);
        string = new BGridPane(4);
        string.add(null, (BValue)new BBorderPane((BWidget)this.bold, 0.0, 5.0, 0.0, 5.0));
        string.add(null, (BValue)this.italic);
        string.add(null, (BValue)this.underline);
        string.add(null, (BValue)this.isNull);
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.add(null, (BValue)font);
        bGridPane.add(null, (BValue)string);
        BGridPane bGridPane2 = new BGridPane(2);
        bGridPane2.add(null, (BValue)bGridPane);
        bGridPane2.add(null, (BValue)bBorderPane);
        this.setContent((BWidget)bGridPane2);
        this.addUpdateFontLinks();
        this.linkTo((BComponent)this.name, (Slot)BListDropDown.actionPerformed, (Slot)actionPerformed);
        this.linkTo((BComponent)this.size, (Slot)BTextDropDown.actionPerformed, (Slot)actionPerformed);
        this.linkTo((BComponent)this.name, (Slot)BListDropDown.valueModified, (Slot)setModified);
        this.linkTo((BComponent)this.size, (Slot)BTextDropDown.valueModified, (Slot)setModified);
        this.linkTo((BComponent)this.bold, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
        this.linkTo((BComponent)this.italic, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
        this.linkTo((BComponent)this.underline, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
        this.linkTo((BComponent)this.isNull, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
    }

    private void addUpdateFontLinks() {
        this.linkTo("lnkNameA", (BComponent)this.name, (Slot)BListDropDown.actionPerformed, (Slot)updateFont);
        this.linkTo("lnkSizeA", (BComponent)this.size, (Slot)BListDropDown.actionPerformed, (Slot)updateFont);
        this.linkTo("lnkNameV", (BComponent)this.name, (Slot)BListDropDown.valueModified, (Slot)updateFont);
        this.linkTo("lnkSizeV", (BComponent)this.size, (Slot)BListDropDown.valueModified, (Slot)updateFont);
        this.linkTo("lnkBold", (BComponent)this.bold, (Slot)BCheckBox.actionPerformed, (Slot)updateFont);
        this.linkTo("lnkItalic", (BComponent)this.italic, (Slot)BCheckBox.actionPerformed, (Slot)updateFont);
        this.linkTo("lnkUnderline", (BComponent)this.underline, (Slot)BCheckBox.actionPerformed, (Slot)updateFont);
        this.linkTo("lnkIsNull", (BComponent)this.isNull, (Slot)BCheckBox.actionPerformed, (Slot)updateFont);
    }

    private void removeUpdateFontLinks() {
        this.remove("lnkNameA");
        this.remove("lnkSizeA");
        this.remove("lnkNameV");
        this.remove("lnkSizeV");
        this.remove("lnkBold");
        this.remove("lnkItalic");
        this.remove("lnkUnderline");
        this.remove("lnkIsNull");
    }

    public void doUpdateFont() {
        this.sample.setFont(this.saveFont());
        this.sample.relayout();
    }

    protected void doSetReadonly(boolean bl) {
        this.name.setDropDownEnabled(!bl);
        this.size.setDropDownEnabled(!bl);
        this.size.getEditor().setEditable(!bl);
        this.bold.setEnabled(!bl);
        this.italic.setEnabled(!bl);
        this.underline.setEnabled(!bl);
    }

    protected void doLoadValue(BObject bObject, Context context) throws Exception {
        this.removeUpdateFontLinks();
        this.frozen = true;
        BFont bFont = bObject instanceof BString ? (BFont)BFont.DEFAULT.decodeFromString(((BString)bObject).getString()) : (BFont)bObject;
        this.sample.setFont(bFont);
        this.sample.relayout();
        if (bFont.equals((Object)BFont.NULL)) {
            this.isNull.setSelected(true);
            this.enable(false);
            this.nullFont();
        } else {
            this.isNull.setSelected(false);
            this.enable(true);
            this.font(bFont);
        }
        this.frozen = false;
        this.addUpdateFontLinks();
    }

    protected BObject doSaveValue(BObject bObject, Context context) throws Exception {
        BFont bFont = this.saveFont();
        if (bObject instanceof BString) {
            return BString.make((String)bFont.encodeToString());
        }
        return bFont;
    }

    private BFont saveFont() {
        String string;
        Font font;
        if (this.isNull.isSelected()) {
            return BFont.NULL;
        }
        String string2 = (String)this.name.getSelectedItem();
        if (string2 == null) {
            string2 = "null";
        }
        if ((font = Font.decode(string2 + " plain")) != null && (string = font.getFamily(Locale.ENGLISH)) != null && !string2.equals(string)) {
            string2 = string;
        }
        double d = Double.parseDouble(this.size.getText());
        int n = 0;
        if (this.bold.getSelected()) {
            n |= 1;
        }
        if (this.italic.getSelected()) {
            n |= 2;
        }
        if (this.underline.getSelected()) {
            n |= 4;
        }
        return BFont.make((String)string2, (double)d, (int)n);
    }

    private void enable(boolean bl) {
        this.name.setEnabled(bl);
        this.size.setEnabled(bl);
        this.bold.setEnabled(bl);
        this.italic.setEnabled(bl);
        this.underline.setEnabled(bl);
    }

    private void font(BFont bFont) {
        String string;
        String string2 = bFont.getName();
        Font font = Font.decode(string2 + " plain");
        if (font != null && (string = font.getFamily(Locale.forLanguageTag(Sys.getLanguage()))) != null && !string2.equals(string)) {
            string2 = string;
        }
        this.name.setSelectedItem((Object)string2);
        this.size.setText(Double.toString(bFont.getSize()));
        this.bold.setSelected(bFont.isBold());
        this.italic.setSelected(bFont.isItalic());
        this.underline.setSelected(bFont.isUnderline());
    }

    private void nullFont() {
        this.name.getList().getSelection().deselectAll();
        this.size.setText("");
        this.bold.setSelected(false);
        this.italic.setSelected(false);
        this.underline.setSelected(false);
    }

    private static String text(String string) {
        return lex.getText("fontFE." + string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Null
    extends ToggleCommand {
        private Null() {
            super((BWidget)BFontFE.this, BFontFE.text("null"));
        }

        public CommandArtifact doInvoke() {
            if (BFontFE.this.frozen) {
                return null;
            }
            BFontFE.this.removeUpdateFontLinks();
            if (this.isSelected()) {
                BFontFE.this.enable(false);
                BFontFE.this.nullFont();
            } else {
                BFontFE.this.enable(true);
                BFontFE.this.font(Theme.label().getTextFont());
            }
            BFontFE.this.doUpdateFont();
            BFontFE.this.addUpdateFontLinks();
            return null;
        }
    }
}

