/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors;

import com.tridium.sys.Nre;
import com.tridium.ui.KeyboardLayout;
import com.tridium.ui.UiEnv;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import java.util.HashMap;
import javax.baja.gx.BBrush;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.Segment;
import javax.baja.ui.text.TextController;
import javax.baja.ui.text.TextRenderer;
import javax.baja.units.BUnit;
import javax.baja.units.BUnitConversion;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BFloatFE
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$fieldeditors$BFloatFE == null ? (class$com$tridium$workbench$fieldeditors$BFloatFE = BFloatFE.class$("com.tridium.workbench.fieldeditors.BFloatFE")) : class$com$tridium$workbench$fieldeditors$BFloatFE));
    private static HashMap formatters = new HashMap();
    private static DecimalFormat fSN = new DecimalFormat("0.###############E0");
    private static final long MAX_LONG_PREC = 0x20000000000000L;
    private int width = 10;
    private boolean forceSign = false;
    private BTextField field = new BTextField("", this.width);
    private BLabel postlabel = new BLabel("");
    private BLabel prelabel = new BLabel("");
    private String range = "";
    private DecimalFormat format = BFloatFE.getFormat(2, false);
    private boolean isFloat = true;
    private BUnit realUnits;
    private BUnit displayUnits;
    private double min = Double.NEGATIVE_INFINITY;
    private double max = Double.POSITIVE_INFINITY;
    private double MIN = Double.NEGATIVE_INFINITY;
    private double MAX = Double.POSITIVE_INFINITY;
    BBrush fg = BBrush.NULL;
    BBrush bg = BBrush.NULL;
    static /* synthetic */ Class class$com$tridium$workbench$fieldeditors$BFloatFE;

    public Type getType() {
        return TYPE;
    }

    public BFloatFE() {
        this.field.setRenderer((TextRenderer)new Renderer());
        this.field.setController((TextController)new Controller());
        BGridPane bGridPane = new BGridPane(3);
        bGridPane.add("pre", (BValue)this.prelabel);
        bGridPane.add("field", (BValue)this.field);
        bGridPane.add("post", (BValue)this.postlabel);
        this.setContent((BWidget)bGridPane);
        this.linkTo("lk0", (BComponent)this.field, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo("lk1", (BComponent)this.field, (Slot)BTextField.actionPerformed, (Slot)actionPerformed);
    }

    protected void doSetReadonly(boolean bl) {
        this.field.setEditable(!bl);
    }

    protected void doLoadValue(BObject bObject, Context context) {
        Object object;
        Object object2;
        this.isFloat = bObject instanceof BFloat;
        if (this.isFloat) {
            this.MIN = Double.NEGATIVE_INFINITY;
            this.MAX = Double.POSITIVE_INFINITY;
        } else {
            this.MIN = Double.NEGATIVE_INFINITY;
            this.MAX = Double.POSITIVE_INFINITY;
        }
        this.min = this.MIN;
        this.max = this.MAX;
        this.width = 10;
        double d = ((BNumber)bObject).getDouble();
        this.realUnits = null;
        int n = 2;
        boolean bl = false;
        this.forceSign = false;
        int n2 = Nre.unitConversion;
        if (context != null) {
            BNumber bNumber;
            BNumber bNumber2;
            object2 = context.getFacets();
            this.realUnits = (BUnit)context.getFacet("units");
            if (this.realUnits != null && this.realUnits.isNull()) {
                this.realUnits = null;
            }
            if ((object = (BInteger)context.getFacet("fieldWidth")) != null) {
                this.width = object.getInt();
            }
            if ((bNumber2 = (BNumber)context.getFacet("min")) != null) {
                double d2 = this.min = this.isFloat ? (double)bNumber2.getFloat() : bNumber2.getDouble();
            }
            if ((bNumber = (BNumber)context.getFacet("max")) != null) {
                this.max = this.isFloat ? (double)bNumber.getFloat() : bNumber.getDouble();
            }
            n2 = context.getFacets().geti("unitConversion", n2);
            n = object2.geti("precision", n);
            bl = object2.getb("showSeparators", bl);
            this.forceSign = object2.getb("forceSign", this.forceSign);
        }
        if (this.width != 10) {
            this.field.setVisibleColumns(this.width);
        }
        this.format = BFloatFE.getFormat(n, bl);
        this.displayUnits = this.realUnits;
        if (n2 != 0 && this.realUnits != null) {
            object2 = BUnitConversion.make((int)n2);
            this.displayUnits = object2.getDesiredUnit(this.realUnits);
            if (this.displayUnits != this.realUnits) {
                d = this.realUnits.convertTo(this.displayUnits, d);
                this.min = this.realUnits.convertTo(this.displayUnits, this.min);
                this.max = this.realUnits.convertTo(this.displayUnits, this.max);
            }
        }
        object2 = "";
        object = "";
        if (this.displayUnits != null) {
            if (this.displayUnits.getIsPrefix()) {
                object = this.displayUnits.getSymbol();
            } else {
                object2 = this.displayUnits.getSymbol();
            }
        }
        if (this.min != this.MIN || this.max != this.MAX) {
            this.range = '[' + this.toString(this.min) + " - " + this.toString(this.max) + ']';
            if (((String)object2).length() > 0) {
                object2 = (String)object2 + ' ';
            }
            object2 = (String)object2 + this.range;
        }
        this.field.setText(this.toString(d));
        this.prelabel.setText((String)object);
        this.postlabel.setText((String)object2);
    }

    protected BObject doSaveValue(BObject bObject, Context context) throws Exception {
        String string;
        String string2 = this.field.getText();
        double d = 0.0;
        try {
            string2 = TextUtil.toLowerCase((String)string2);
            if (string2.equals("-inf")) {
                d = Double.NEGATIVE_INFINITY;
            } else if (string2.equals("+inf")) {
                d = Double.POSITIVE_INFINITY;
            } else if (string2.equals("nan")) {
                d = Double.NaN;
            } else {
                string = string2.startsWith("+") ? string2.substring(1) : string2;
                ParsePosition parsePosition = new ParsePosition(0);
                d = string.indexOf(101) != -1 ? fSN.parse(TextUtil.toUpperCase((String)string), parsePosition).doubleValue() : this.format.parse(string, parsePosition).doubleValue();
                if (parsePosition.getIndex() != string.length()) {
                    throw new CannotSaveException("Invalid format: " + string2);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new CannotSaveException("Invalid format: " + numberFormatException.getMessage());
        }
        catch (Exception exception) {
            throw new CannotSaveException("Invalid format: " + string2);
        }
        if (d < this.min) {
            throw new CannotSaveException(this.toString(d) + " < " + this.toString(this.min) + " " + this.range);
        }
        if (d > this.max) {
            throw new CannotSaveException(this.toString(d) + " > " + this.toString(this.max) + " " + this.range);
        }
        if (this.realUnits != this.displayUnits) {
            d = this.displayUnits.convertTo(this.realUnits, d);
        }
        string = this.isFloat ? BFloat.make((float)((float)d)) : BDouble.make((double)d);
        this.field.setText(this.toString(d));
        return string;
    }

    private String toString(double d) {
        String string;
        if (d == this.MIN) {
            return "-inf";
        }
        if (d == this.MAX) {
            return "+inf";
        }
        if (this.isFloat && Float.isNaN((float)d)) {
            return "nan";
        }
        if (!this.isFloat && Double.isNaN(d)) {
            return "nan";
        }
        String string2 = string = this.forceSign && d > 0.0 ? "+" : "";
        if (Math.IEEEremainder(d, 1.0) == 0.0) {
            if ((long)Math.abs(d) >= 0x20000000000000L) {
                return string + fSN.format(d);
            }
            return string + this.format.format(d);
        }
        return d == 0.0 ? this.format.format(d) : string + this.format.format(d);
    }

    public void requestFocus() {
        this.field.requestFocus();
    }

    private static DecimalFormat getFormat(int n, boolean bl) {
        String string = "" + n + bl;
        DecimalFormat decimalFormat = (DecimalFormat)formatters.get(string);
        if (decimalFormat == null) {
            StringBuffer stringBuffer = new StringBuffer(16);
            if (bl) {
                stringBuffer.append("#,##0");
            } else {
                stringBuffer.append("#0");
            }
            if (n > 0) {
                stringBuffer.append('.');
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append('0');
                }
            }
            decimalFormat = new DecimalFormat(stringBuffer.toString());
            formatters.put(string, decimalFormat);
        }
        return decimalFormat;
    }

    public Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        switch (n) {
            case 306: {
                this.fg = (BBrush)object;
                this.bg = (BBrush)object2;
                this.repaint();
                return null;
            }
        }
        return super.fw(n, object, object2, object3, object4);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static final class Controller
    extends TextController {
        private static final BOrd defNumberpad = BOrd.make((String)"module://bajaui/com/tridium/ui/numberpad.xml");
        private static KeyboardLayout numberpad;

        public void mouseReleased(BMouseEvent bMouseEvent) {
            BTextEditor bTextEditor = this.getEditor();
            if (!UiEnv.get().hasKeyboard() && bTextEditor.isEditable()) {
                UiEnv.get().input(bTextEditor, numberpad);
                return;
            }
        }

        static {
            String string = Sys.getLanguage();
            try {
                numberpad = string.equals("en") ? KeyboardLayout.make((BOrd)defNumberpad) : KeyboardLayout.make((BOrd)BOrd.make((String)("file:!lexicon/" + string + "/numberpad.xml")));
            }
            catch (Exception exception) {
                try {
                    numberpad = KeyboardLayout.make();
                }
                catch (Exception exception2) {
                    throw new BajaRuntimeException((Throwable)exception2);
                }
            }
        }
    }

    class Renderer
    extends TextRenderer {
        Renderer() {
        }

        public BBrush getBackground() {
            if (BFloatFE.this.bg.isNull()) {
                return super.getBackground();
            }
            return BFloatFE.this.bg;
        }

        public BBrush getForeground(Segment segment) {
            if (BFloatFE.this.fg.isNull()) {
                return super.getForeground(segment);
            }
            return BFloatFE.this.fg;
        }
    }
}

