/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors;

import java.util.ArrayList;
import java.util.HashMap;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BFrame;
import javax.baja.ui.BLabel;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BTypeSpec;

public class BEnumRangeDialog
extends BDialog {
    public static final Action fixedChanged = BEnumRangeDialog.newAction((int)0, null);
    public static final Action selectionChanged = BEnumRangeDialog.newAction((int)0, null);
    public static final Action ordinalChanged = BEnumRangeDialog.newAction((int)0, null);
    public static final Action ordinalAction = BEnumRangeDialog.newAction((int)0, null);
    public static final Action tagChanged = BEnumRangeDialog.newAction((int)0, null);
    public static final Action tagAction = BEnumRangeDialog.newAction((int)0, null);
    public static final Action addPressed = BEnumRangeDialog.newAction((int)0, null);
    public static final Action modifyPressed = BEnumRangeDialog.newAction((int)0, null);
    public static final Action removePressed = BEnumRangeDialog.newAction((int)0, null);
    public static final Action okPressed = BEnumRangeDialog.newAction((int)0, null);
    public static final Action cancelPressed = BEnumRangeDialog.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$fieldeditors$BEnumRangeDialog == null ? (class$com$tridium$workbench$fieldeditors$BEnumRangeDialog = BEnumRangeDialog.class$("com.tridium.workbench.fieldeditors.BEnumRangeDialog")) : class$com$tridium$workbench$fieldeditors$BEnumRangeDialog));
    static String dialogTitle = UiLexicon.bajaui().getText("enumRangeDialog.title");
    static final int space = 4;
    static final int ERR = -1;
    static final int NEW = -2;
    static HashMap fixedHistory = new HashMap();
    ArrayList pairs = new ArrayList();
    BEnumRange orig;
    BEnumRange result;
    BFrozenEnum fixed;
    BCheckBox useFixed = new BCheckBox(UiLexicon.bajaui().getText("enumRangeDialog.useFrozen"));
    BTextDropDown fixedField = new BTextDropDown("", 20, true);
    boolean enumValid;
    BLabel enumValidLabel = new BLabel("");
    boolean enabled;
    TableModel model = new Model();
    BTable table = new BTable(this.model);
    BTextField ordinalField = new BTextField("", 5);
    BTextField tagField = new BTextField("", 20);
    BButton add = new BButton(UiLexicon.bajaui().getText("action.add"));
    BButton modify = new BButton(UiLexicon.bajaui().getText("action.modify"));
    BButton remove = new BButton(UiLexicon.bajaui().getText("action.remove"));
    BSeparator sep1 = new BSeparator(BOrientation.horizontal);
    BGridPane options = new BGridPane(2);
    BTextField lexicon = new BTextField("", 20);
    BSeparator sep2 = new BSeparator(BOrientation.horizontal);
    BButton ok = new BButton(UiLexicon.bajaui().getText("action.ok"));
    BButton cancel = new BButton(UiLexicon.bajaui().getText("action.cancel"));
    static /* synthetic */ Class class$com$tridium$workbench$fieldeditors$BEnumRangeDialog;

    public void fixedChanged() {
        this.invoke(fixedChanged, null, null);
    }

    public void selectionChanged() {
        this.invoke(selectionChanged, null, null);
    }

    public void ordinalChanged() {
        this.invoke(ordinalChanged, null, null);
    }

    public void ordinalAction() {
        this.invoke(ordinalAction, null, null);
    }

    public void tagChanged() {
        this.invoke(tagChanged, null, null);
    }

    public void tagAction() {
        this.invoke(tagAction, null, null);
    }

    public void addPressed() {
        this.invoke(addPressed, null, null);
    }

    public void modifyPressed() {
        this.invoke(modifyPressed, null, null);
    }

    public void removePressed() {
        this.invoke(removePressed, null, null);
    }

    public void okPressed() {
        this.invoke(okPressed, null, null);
    }

    public void cancelPressed() {
        this.invoke(cancelPressed, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BEnumRange open(BWidget bWidget, BEnumRange bEnumRange, boolean bl) {
        BEnumRangeDialog bEnumRangeDialog = new BEnumRangeDialog(bWidget, bEnumRange, bl);
        bEnumRangeDialog.setBoundsCenteredOnOwner();
        bEnumRangeDialog.open();
        return bEnumRangeDialog.result;
    }

    private BEnumRangeDialog(BWidget bWidget, BEnumRange bEnumRange, boolean bl) {
        super(bWidget, dialogTitle, true);
        this.orig = bEnumRange;
        int[] nArray = bEnumRange.getOrdinals();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            String string = bEnumRange.getTag(n);
            String string2 = bEnumRange.getDisplayTag(n, null);
            boolean bl2 = bEnumRange.isFrozenOrdinal(n);
            this.pairs.add(new Pair(n, string, string2, bl2));
        }
        Type type = bEnumRange.getFrozenType();
        if (type != null) {
            this.fixed = (BFrozenEnum)type.getInstance();
            this.useFixed.setSelected(this.fixed != null);
            this.fixedField.setText(this.fixed.getType().toString());
        }
        this.options.add(null, (BValue)new BLabel(UiLexicon.bajaui().getText("enumRangeDialog.lexicon")));
        this.options.add(null, (BValue)this.lexicon);
        this.lexicon.setText(this.orig.getOptions().gets("lexicon", "").trim());
        this.updateFixedList();
        this.sort();
        this.table.setMultipleSelection(false);
        this.table.setCellRenderer((TableCellRenderer)new CellRenderer());
        this.enumValidLabel.setForeground(BColor.red.toBrush());
        this.enabled = bl;
        if (!bl) {
            this.ordinalField.setEditable(false);
            this.tagField.setEditable(false);
            this.useFixed.setEnabled(false);
            this.fixedField.setEnabled(false);
        }
        this.add.setEnabled(false);
        this.modify.setEnabled(false);
        this.remove.setEnabled(false);
        this.add("useFixed", (BValue)this.useFixed);
        this.add("fixedField", (BValue)this.fixedField);
        this.add("enumInvalid", (BValue)this.enumValidLabel);
        this.add("table", (BValue)this.table);
        this.add("ordinalField", (BValue)this.ordinalField);
        this.add("tagField", (BValue)this.tagField);
        this.add("add", (BValue)this.add);
        this.add("modify", (BValue)this.modify);
        this.add("remove", (BValue)this.remove);
        this.add("sep1", (BValue)this.sep1);
        this.add("options", (BValue)this.options);
        this.add("sep2", (BValue)this.sep2);
        this.add("ok", (BValue)this.ok);
        this.add("cancel", (BValue)this.cancel);
        this.linkTo("lk0", (BComponent)this.table, (Slot)BTable.selectionModified, (Slot)selectionChanged);
        this.linkTo("lk1", (BComponent)this.ordinalField, (Slot)BTextField.textModified, (Slot)ordinalChanged);
        this.linkTo("lk2", (BComponent)this.ordinalField, (Slot)BTextField.actionPerformed, (Slot)ordinalAction);
        this.linkTo("lk3", (BComponent)this.tagField, (Slot)BTextField.textModified, (Slot)tagChanged);
        this.linkTo("lk4", (BComponent)this.tagField, (Slot)BTextField.actionPerformed, (Slot)tagAction);
        this.linkTo("lk5", (BComponent)this.add, (Slot)BButton.actionPerformed, (Slot)addPressed);
        this.linkTo("lk6", (BComponent)this.modify, (Slot)BButton.actionPerformed, (Slot)modifyPressed);
        this.linkTo("lk7", (BComponent)this.remove, (Slot)BButton.actionPerformed, (Slot)removePressed);
        this.linkTo("lk9", (BComponent)this.useFixed, (Slot)BButton.actionPerformed, (Slot)fixedChanged);
        this.linkTo("lkA", (BComponent)this.fixedField, (Slot)BTextDropDown.valueModified, (Slot)fixedChanged);
        this.linkTo("lkC", (BComponent)this.ok, (Slot)BButton.actionPerformed, (Slot)okPressed);
        this.linkTo("lkD", (BComponent)this.cancel, (Slot)BButton.actionPerformed, (Slot)cancelPressed);
        this.check();
    }

    public void computePreferredSize() {
        this.setPreferredSize(350.0, 400.0);
    }

    public void doLayout(BWidget[] bWidgetArray) {
        double d = this.getWidth();
        double d2 = this.getHeight();
        this.useFixed.computePreferredSize();
        double d3 = this.useFixed.getPreferredWidth();
        double d4 = this.useFixed.getPreferredHeight();
        this.useFixed.setBounds(4.0, 4.0, d3, d4);
        this.fixedField.computePreferredSize();
        double d5 = 4.0 + d4 + 4.0;
        double d6 = this.fixedField.getPreferredHeight();
        double d7 = 2.0 * d / 3.0;
        this.fixedField.setBounds(4.0, d5, d7, d6);
        this.enumValidLabel.setBounds(4.0 + d7 + 4.0, d5, 25.0, d6);
        double d8 = 4.0 + d4 + 4.0 + d6 + 4.0;
        this.ok.computePreferredSize();
        this.cancel.computePreferredSize();
        double d9 = Math.max(this.ok.getPreferredWidth(), this.cancel.getPreferredWidth());
        double d10 = this.ok.getPreferredHeight();
        double d11 = d2 - 4.0 - d10;
        double d12 = (d - (d9 + 4.0 + d9)) / 2.0;
        this.ok.setBounds(d12, d11, d9, d10);
        this.cancel.setBounds(d12 + d9 + 4.0, d11, d9, d10);
        this.sep1.setBounds(4.0, d11 - 12.0, d - 4.0 - 4.0, 4.0);
        this.options.computePreferredSize();
        double d13 = this.options.getPreferredWidth();
        double d14 = this.options.getPreferredHeight();
        this.options.setBounds(4.0, this.sep1.getY() - 8.0 - d14, d13, d14);
        this.sep2.setBounds(4.0, this.options.getY() - 8.0, d - 4.0 - 4.0, 4.0);
        this.add.computePreferredSize();
        double d15 = this.add.getPreferredHeight();
        double d16 = (d - 16.0) / 3.0;
        double d17 = this.sep2.getY() - 8.0 - d15;
        this.add.setBounds(4.0, d17, d16, d15);
        this.modify.setBounds(4.0 + (d16 + 4.0), d17, d16, d15);
        this.remove.setBounds(4.0 + 2.0 * (d16 + 4.0), d17, d16, d15);
        this.ordinalField.computePreferredSize();
        double d18 = this.ordinalField.getPreferredHeight();
        double d19 = d17 - 4.0 - d18;
        double d20 = d / 4.0;
        double d21 = d - d20 - 12.0;
        this.ordinalField.setBounds(4.0, d19, d20, d18);
        this.tagField.setBounds(4.0 + d20 + 4.0, d19, d21, d18);
        this.table.setBounds(4.0, d8, d - 4.0 - 4.0, d19 - 4.0 - d8 - 4.0);
    }

    void updateFixed(BFrozenEnum bFrozenEnum) {
        this.fixed = bFrozenEnum;
        if (bFrozenEnum == null) {
            Pair[] pairArray = this.pairs.toArray(new Pair[this.pairs.size()]);
            ArrayList<Pair> arrayList = new ArrayList<Pair>();
            for (int i = 0; i < pairArray.length; ++i) {
                if (pairArray[i].fixed) continue;
                arrayList.add(pairArray[i]);
            }
            this.pairs = arrayList;
        } else {
            ArrayList<Pair> arrayList = new ArrayList<Pair>();
            BEnumRange bEnumRange = bFrozenEnum.getRange();
            int[] nArray = bEnumRange.getOrdinals();
            for (int i = 0; i < nArray.length; ++i) {
                arrayList.add(new Pair(nArray[i], bEnumRange.getTag(nArray[i]), bEnumRange.getDisplayTag(nArray[i], null), true));
            }
            Pair[] pairArray = this.pairs.toArray(new Pair[this.pairs.size()]);
            for (int i = 0; i < pairArray.length; ++i) {
                Pair pair = pairArray[i];
                if (pair.fixed || bEnumRange.isOrdinal(pair.ordinal) || bEnumRange.isTag(pair.tag)) continue;
                arrayList.add(pairArray[i]);
            }
            this.pairs = arrayList;
        }
        this.sort();
        this.model.updateTable();
        this.check();
    }

    void setEnumValid(boolean bl) {
        this.enumValid = bl;
        boolean bl2 = bl || this.fixedField.getText().length() == 0;
        this.enumValidLabel.setText(bl2 ? "" : "***");
        this.enumValidLabel.relayout();
        this.repaint();
    }

    void updateFixedList() {
        Object[] objectArray = Sys.getRegistry().getConcreteTypes(BFrozenEnum.TYPE.getTypeInfo());
        SortUtil.sort((Object[])objectArray);
        this.fixedField.getList().removeAllItems();
        for (int i = 0; i < objectArray.length; ++i) {
            this.fixedField.getList().addItem(objectArray[i]);
        }
    }

    public BEnumRange save() {
        Object object;
        Object object2;
        int n;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (n = 0; n < this.pairs.size(); ++n) {
            object2 = (Pair)this.pairs.get(n);
            if (((Pair)object2).fixed) continue;
            arrayList.add(object2);
        }
        n = arrayList.size();
        object2 = new int[n];
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            object = (Pair)arrayList.get(i);
            object2[i] = ((Pair)object).ordinal;
            stringArray[i] = ((Pair)object).tag;
        }
        object = this.lexicon.getText().trim();
        BFacets bFacets = ((String)object).length() == 0 ? BFacets.makeRemove((BFacets)this.orig.getOptions(), (String)"lexicon") : BFacets.make((BFacets)this.orig.getOptions(), (String)"lexicon", (BIDataValue)BString.make((String)object));
        return BEnumRange.make((Type)BEnumRangeDialog.toFrozenType(this.fixed), (int[])object2, (String[])stringArray, (int)n, (BFacets)bFacets);
    }

    public void windowClosing(BWindowEvent bWindowEvent) {
        this.doCancelPressed();
    }

    public void doCancelPressed() {
        this.result = null;
        this.close();
    }

    public void doOkPressed() {
        this.result = this.save();
        this.close();
    }

    public void doSelectionChanged() {
        if (!this.enabled) {
            return;
        }
        int n = this.table.getSelection().getRow();
        if (n >= 0 && n < this.pairs.size()) {
            Pair pair = (Pair)this.pairs.get(n);
            this.ordinalField.setText(String.valueOf(pair.ordinal));
            this.tagField.setText(pair.display);
        }
        this.check();
    }

    public void doFixedChanged() {
        BFrozenEnum bFrozenEnum = null;
        try {
            String string = this.fixedField.getText();
            BTypeSpec bTypeSpec = BTypeSpec.make((String)string);
            Type type = bTypeSpec.getResolvedType();
            BFrozenEnum bFrozenEnum2 = (BFrozenEnum)type.getInstance();
            if (this.useFixed.isSelected()) {
                bFrozenEnum = bFrozenEnum2;
            }
            this.setEnumValid(true);
        }
        catch (Throwable throwable) {
            this.setEnumValid(false);
        }
        this.updateFixed(bFrozenEnum);
        this.check();
    }

    public void doOrdinalChanged() {
        this.check();
    }

    public void doTagChanged() {
        this.check();
    }

    public void doOrdinalAction() {
        this.commitCurrent();
    }

    public void doTagAction() {
        this.commitCurrent();
        this.ordinalField.requestFocus();
    }

    public void doAddPressed() {
        if (!this.enabled) {
            return;
        }
        int n = Integer.parseInt(this.ordinalField.getText());
        String string = this.tagField.getText();
        String string2 = SlotPath.escape((String)string);
        if (!this.checkTag(string2)) {
            return;
        }
        this.pairs.add(new Pair(n, string2, string, false));
        this.sort();
        this.model.updateTable();
        this.check();
        this.table.getSelection().deselectAll();
    }

    public void doModifyPressed() {
        if (!this.enabled) {
            return;
        }
        String string = this.tagField.getText();
        String string2 = SlotPath.escape((String)string);
        if (!this.checkTag(string2)) {
            return;
        }
        Pair pair = (Pair)this.pairs.get(this.ordinalToIndex());
        pair.tag = string2;
        pair.display = string;
        this.sort();
        this.model.updateTable();
        this.check();
    }

    public void doRemovePressed() {
        if (!this.enabled) {
            return;
        }
        this.pairs.remove(this.table.getSelection().getRow());
        this.sort();
        this.model.updateTable();
        this.check();
    }

    private void commitCurrent() {
        if (this.add.isEnabled()) {
            this.doAddPressed();
        } else if (this.modify.isEnabled()) {
            this.doModifyPressed();
        }
    }

    private boolean checkTag(String string) {
        if (this.containsTag(string)) {
            Object[] objectArray = new Object[]{string};
            String string2 = UiLexicon.bajaui().getText("dialog.error");
            String string3 = UiLexicon.bajaui().getText("enumRangeDialog.duplicateTag", objectArray);
            BDialog.error((BWidget)this, (String)string2, (Object)string3);
            return false;
        }
        return true;
    }

    private void check() {
        if (!this.enabled) {
            return;
        }
        int n = this.ordinalToIndex();
        Pair pair = null;
        if (n >= 0) {
            pair = (Pair)this.pairs.get(n);
        }
        int n2 = this.table.getSelection().getRow();
        this.add.setEnabled(n == -2);
        this.modify.setEnabled(pair != null && !pair.fixed && !pair.tag.equals(this.tagField.getText()));
        this.remove.setEnabled(pair != null && !pair.fixed);
        this.fixedField.setEnabled(this.useFixed.isSelected());
    }

    static Type toFrozenType(BFrozenEnum bFrozenEnum) {
        if (bFrozenEnum == null) {
            return null;
        }
        return bFrozenEnum.getType();
    }

    void sort() {
        Object[] objectArray = this.pairs.toArray(new Pair[this.pairs.size()]);
        SortUtil.sort((Object[])objectArray);
        this.pairs.clear();
        for (int i = 0; i < objectArray.length; ++i) {
            this.pairs.add(objectArray[i]);
        }
    }

    boolean containsTag(String string) {
        for (int i = 0; i < this.pairs.size(); ++i) {
            Pair pair = (Pair)this.pairs.get(i);
            if (!pair.tag.equals(string)) continue;
            return true;
        }
        return false;
    }

    int ordinalToIndex() {
        try {
            int n = Integer.parseInt(this.ordinalField.getText());
            for (int i = 0; i < this.pairs.size(); ++i) {
                Pair pair = (Pair)this.pairs.get(i);
                if (n != pair.ordinal) continue;
                return i;
            }
            return -2;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        int[] nArray = new int[]{2, 3, 4};
        String[] stringArray2 = new String[]{"two", "three", "four"};
        BOrientation bOrientation = BOrientation.horizontal;
        BEnumRange bEnumRange = BEnumRange.make((Type)BEnumRangeDialog.toFrozenType((BFrozenEnum)bOrientation), (int[])nArray, (String[])stringArray2);
        BEnumRangeDialog bEnumRangeDialog = new BEnumRangeDialog((BWidget)new BFrame(), bEnumRange, true);
        bEnumRangeDialog.setScreenBounds(100.0, 100.0, 350.0, 400.0);
        bEnumRangeDialog.open();
        if (bEnumRangeDialog.result == null) {
            System.out.println("canceled");
        } else {
            System.out.println(bEnumRangeDialog.result.encodeToString());
        }
        System.exit(0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class Pair
    implements Comparable {
        int ordinal;
        String tag;
        String display;
        boolean fixed;

        Pair(int n, String string, String string2, boolean bl) {
            this.ordinal = n;
            this.tag = string;
            this.display = string2;
            this.fixed = bl;
        }

        public int compareTo(Object object) {
            int n = ((Pair)object).ordinal;
            if (this.ordinal == n) {
                return 0;
            }
            return this.ordinal < n ? -1 : 1;
        }

        public boolean equals(Object object) {
            return this.ordinal == ((Pair)object).ordinal;
        }
    }

    class CellRenderer
    extends TableCellRenderer {
        CellRenderer() {
        }

        public BBrush getForeground(TableCellRenderer.Cell cell) {
            Pair pair = (Pair)BEnumRangeDialog.this.pairs.get(cell.row);
            return pair.fixed ? BColor.blue.toBrush() : BColor.black.toBrush();
        }
    }

    class Model
    extends TableModel {
        Model() {
        }

        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            return BEnumRangeDialog.this.pairs.size();
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Ordinal";
                }
                case 1: {
                    return "Tag";
                }
                case 2: {
                    return "Display";
                }
            }
            throw new IllegalStateException();
        }

        public Object getValueAt(int n, int n2) {
            Pair pair = (Pair)BEnumRangeDialog.this.pairs.get(n);
            switch (n2) {
                case 0: {
                    return String.valueOf(pair.ordinal);
                }
                case 1: {
                    return pair.tag;
                }
                case 2: {
                    return pair.display;
                }
            }
            throw new IllegalStateException();
        }
    }
}

