/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors;

import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.bql.util.BDynamicTimeRangeType;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.fieldeditors.BTimeEditors;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BFrame;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BDynamicTimeRangeFE
extends BWbFieldEditor {
    public static final Action editTimeRange = BDynamicTimeRangeFE.newAction((int)0, null);
    public static final Action updateLayout = BDynamicTimeRangeFE.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$fieldeditors$BDynamicTimeRangeFE == null ? (class$com$tridium$workbench$fieldeditors$BDynamicTimeRangeFE = BDynamicTimeRangeFE.class$("com.tridium.workbench.fieldeditors.BDynamicTimeRangeFE")) : class$com$tridium$workbench$fieldeditors$BDynamicTimeRangeFE));
    private static final String prefTemplate = "WW-WWW-WWWW WW:WWWW to WW-WWW-WWWW WW:WWWW WWWWWWWWWWW";
    private static final Lexicon lex = Lexicon.make((String)"bql");
    private static final double HGAP = 8.0;
    private BListDropDown typeChoice = BDynamicTimeRangeFE.makeTypeChoice();
    private BLabel timeRangeLabel;
    private BButton editButton;
    private BAbsTime startTime;
    private BAbsTime endTime;
    static /* synthetic */ Class class$com$tridium$workbench$fieldeditors$BDynamicTimeRangeFE;

    public void editTimeRange() {
        this.invoke(editTimeRange, null, null);
    }

    public void updateLayout() {
        this.invoke(updateLayout, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BDynamicTimeRangeFE() {
        this.add("typeChoice", (BValue)this.typeChoice);
        this.timeRangeLabel = new BLabel();
        this.add("rangeLabel", (BValue)this.timeRangeLabel);
        this.add("typeLayout", (BValue)new BLink((BComponent)this.typeChoice, (Slot)BListDropDown.listActionPerformed, (Slot)updateLayout));
        this.add("typeMod", (BValue)new BLink((BComponent)this.typeChoice, (Slot)BListDropDown.listActionPerformed, (Slot)setModified));
        this.editButton = new BButton(BImage.make((BIcon)BIcon.std((String)"clock.png")));
        this.editButton.setButtonStyle(BButtonStyle.toolBar);
        this.add("editButton", (BValue)this.editButton);
        this.add("editLink", (BValue)new BLink((BComponent)this.editButton, (Slot)BButton.actionPerformed, (Slot)editTimeRange));
    }

    public void doLoadValue(BObject bObject, Context context) {
        BDynamicTimeRange bDynamicTimeRange = (BDynamicTimeRange)bObject;
        this.typeChoice.setSelectedItem((Object)bDynamicTimeRange.getRangeType());
        if (bDynamicTimeRange.getRangeType() == BDynamicTimeRangeType.timeRange) {
            this.startTime = bDynamicTimeRange.getFixedStartTime();
            this.endTime = bDynamicTimeRange.getFixedEndTime();
        }
        if (this.startTime == null) {
            this.startTime = BAbsTime.NULL;
        }
        if (this.endTime == null) {
            this.endTime = BAbsTime.NULL;
        }
        this.timeRangeLabel.setText(this.formatTimeRange(bDynamicTimeRange.getFixedStartTime(), bDynamicTimeRange.getFixedEndTime()));
        this.relayout();
    }

    public BObject doSaveValue(BObject bObject, Context context) throws Exception, CannotSaveException {
        BDynamicTimeRangeType bDynamicTimeRangeType = (BDynamicTimeRangeType)this.typeChoice.getSelectedItem();
        if (bDynamicTimeRangeType != BDynamicTimeRangeType.timeRange) {
            return BDynamicTimeRange.make((BDynamicTimeRangeType)bDynamicTimeRangeType);
        }
        return BDynamicTimeRange.make((BAbsTime)this.startTime, (BAbsTime)this.endTime);
    }

    public void computePreferredSize() {
        double d = 0.0;
        double d2 = 0.0;
        this.typeChoice.computePreferredSize();
        this.editButton.computePreferredSize();
        BFont bFont = Theme.label().getTextFont();
        d = this.typeChoice.getPreferredWidth();
        d += 8.0 + bFont.width(prefTemplate);
        d2 = this.typeChoice.getPreferredHeight();
        d2 = Math.max(d2, bFont.getHeight());
        d2 = Math.max(d2, this.editButton.getPreferredHeight());
        this.setPreferredSize(d += 8.0 + this.editButton.getPreferredWidth(), d2);
    }

    public void doLayout(BWidget[] bWidgetArray) {
        double d = this.getWidth();
        double d2 = this.getHeight();
        this.typeChoice.computePreferredSize();
        this.timeRangeLabel.computePreferredSize();
        this.editButton.computePreferredSize();
        double d3 = 0.0;
        this.typeChoice.setBounds(d3, (d2 - this.typeChoice.getPreferredHeight()) / 2.0, this.typeChoice.getPreferredWidth(), this.typeChoice.getPreferredHeight());
        d3 += this.typeChoice.getPreferredWidth() + 8.0;
        BDynamicTimeRangeType bDynamicTimeRangeType = (BDynamicTimeRangeType)this.typeChoice.getSelectedItem();
        if (bDynamicTimeRangeType == BDynamicTimeRangeType.timeRange) {
            this.timeRangeLabel.setBounds(d3, (d2 - this.timeRangeLabel.getPreferredHeight()) / 2.0, this.timeRangeLabel.getPreferredWidth(), this.timeRangeLabel.getPreferredHeight());
            this.editButton.setBounds(d3 += 8.0 + this.timeRangeLabel.getPreferredWidth(), (d2 - this.editButton.getPreferredHeight()) / 2.0, this.editButton.getPreferredWidth(), this.editButton.getPreferredHeight());
            d3 += 8.0 + this.editButton.getPreferredWidth();
        } else {
            this.timeRangeLabel.setBounds(0.0, 0.0, 0.0, 0.0);
            this.editButton.setBounds(0.0, 0.0, 0.0, 0.0);
        }
    }

    public void doUpdateLayout() {
        this.relayout();
    }

    protected void doSetReadonly(boolean bl) {
        super.setReadonly(bl);
        this.typeChoice.setEnabled(!bl);
        this.editButton.setEnabled(!bl);
    }

    public void doEditTimeRange() {
        BAbsTime bAbsTime = this.startTime;
        BAbsTime bAbsTime2 = this.endTime;
        while (true) {
            BTimeEditors bTimeEditors = new BTimeEditors(bAbsTime, bAbsTime2, this.getCurrentContext());
            int n = BDialog.open((BWidget)this, (String)lex.getText("dynamicTimeRangeFE.editTimeRange"), (Object)((Object)bTimeEditors), (int)3);
            if (n == 2) {
                return;
            }
            bAbsTime = bTimeEditors.getStartTime();
            bAbsTime2 = bTimeEditors.getEndTime();
            if (bAbsTime.equals((Object)BAbsTime.NULL) || bAbsTime2.equals((Object)BAbsTime.NULL) || bAbsTime2.isAfter(bAbsTime)) break;
            BDialog.error((BWidget)this, (Object)lex.getText("dynamicTimeRangeFE.timeSequenceError"));
        }
        this.startTime = bAbsTime;
        this.endTime = bAbsTime2;
        this.timeRangeLabel.setText(this.formatTimeRange(this.startTime, this.endTime));
        this.setModified();
    }

    private String formatTimeRange(BAbsTime bAbsTime, BAbsTime bAbsTime2) {
        StringBuffer stringBuffer = new StringBuffer(prefTemplate.length());
        if (bAbsTime == null || bAbsTime.isNull()) {
            stringBuffer.append(lex.getText("dynamicTimeRangeFE.epoch"));
        } else {
            stringBuffer.append(bAbsTime.toString(this.getCurrentContext()));
        }
        stringBuffer.append("  ").append(lex.getText("dynamicTimeRangeFE.to")).append("  ");
        if (bAbsTime2 == null || bAbsTime2.isNull()) {
            stringBuffer.append(lex.getText("dynamicTimeRangeFE.now"));
        } else {
            stringBuffer.append(bAbsTime2.toString(this.getCurrentContext()));
        }
        return stringBuffer.toString();
    }

    public static BListDropDown makeTypeChoice() {
        BListDropDown bListDropDown = new BListDropDown();
        BList bList = bListDropDown.getList();
        BEnumRange bEnumRange = BDynamicTimeRangeType.today.getRange();
        int[] nArray = bEnumRange.getOrdinals();
        for (int i = 0; i < nArray.length; ++i) {
            bList.addItem((Object)bEnumRange.get(nArray[i]));
        }
        bListDropDown.setSelectedItem((Object)BDynamicTimeRangeType.today);
        return bListDropDown;
    }

    public static void main(String[] stringArray) {
        BEdgePane bEdgePane = new BEdgePane();
        BDynamicTimeRangeFE bDynamicTimeRangeFE = new BDynamicTimeRangeFE();
        bDynamicTimeRangeFE.loadValue((BObject)BDynamicTimeRange.make((BDynamicTimeRangeType)BDynamicTimeRangeType.today));
        bEdgePane.setTop((BWidget)bDynamicTimeRangeFE);
        BFrame bFrame = new BFrame();
        bFrame.setContent((BWidget)bEdgePane);
        bFrame.setScreenBounds(200.0, 10.0, 700.0, 150.0);
        bFrame.open();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

