/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.console;

import com.tridium.ui.UiEnv;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.console.BConsole;
import java.io.File;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.gx.IPoint;
import javax.baja.gx.Point;
import javax.baja.naming.BOrd;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BScrollBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.style.IStylable;

public class BConsoleBuffer
extends BWidget {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$console$BConsoleBuffer == null ? (class$com$tridium$workbench$console$BConsoleBuffer = BConsoleBuffer.class$("com.tridium.workbench.console.BConsoleBuffer")) : class$com$tridium$workbench$console$BConsoleBuffer));
    Point hoverPoint;
    BConsole console;
    Line[] lines;
    BFont font;
    double cellHeight;
    int highlight = -1;
    static /* synthetic */ Class class$com$tridium$workbench$console$BConsoleBuffer;

    public Type getType() {
        return TYPE;
    }

    public BConsoleBuffer() {
        throw new IllegalStateException();
    }

    public BConsoleBuffer(BConsole bConsole) {
        this.console = bConsole;
        this.font = Theme.textEditor().getFont();
        this.lines = new Line[500];
        this.cellHeight = this.font.getHeight();
    }

    public void append(String string, boolean bl) {
        Line line;
        if (bl) {
            line = new BreakLine(string);
            this.highlight = -1;
        } else {
            line = this.captureLine(string);
        }
        System.arraycopy(this.lines, 1, this.lines, 0, this.lines.length - 1);
        this.lines[this.lines.length - 1] = line;
        if (this.highlight != -1) {
            --this.highlight;
        }
        this.repaint();
    }

    private Line captureLine(String string) {
        try {
            int n;
            OrdLine ordLine = null;
            ordLine = OrdLine.make(string);
            if (ordLine != null) {
                return ordLine;
            }
            int n2 = string.indexOf(58, 4);
            int n3 = n2 < 0 ? -1 : string.indexOf(58, n2 + 1);
            int n4 = n3 < 0 ? -1 : string.indexOf(58, n3 + 1);
            int n5 = n4 < 0 ? -1 : string.indexOf(58, n4 + 1);
            int n6 = n = n5 < 0 ? -1 : string.indexOf(58, n5 + 1);
            if (n > 0) {
                try {
                    File file = new File(string.substring(0, n2));
                    int n7 = Integer.parseInt(string.substring(n2 + 1, n3));
                    int n8 = Integer.parseInt(string.substring(n3 + 1, n4));
                    int n9 = Integer.parseInt(string.substring(n4 + 1, n5));
                    int n10 = Integer.parseInt(string.substring(n5 + 1, n));
                    String string2 = string.substring(n + 2);
                    String string3 = file.getName() + ":" + n7 + ":" + n8 + ": " + string2;
                    return new FileLine(string3, file, n7, n8, n9, n10 + 1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (n3 > 0) {
                File file = new File(string.substring(0, n2));
                int n11 = Integer.parseInt(string.substring(n2 + 1, n3));
                String string4 = string.substring(n3 + 2);
                String string5 = file.getName() + ":" + n11 + ": " + string4;
                return new FileLine(string5, file, n11, 1, n11, 75);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return new Line(string);
    }

    public FileLine getFileLine(int n) {
        return (FileLine)this.lines[n];
    }

    public int topOfLastCommand() {
        for (int i = this.lines.length - 1; i >= 0; --i) {
            if (!(this.lines[i] instanceof BreakLine)) continue;
            return i;
        }
        return -1;
    }

    public int next() {
        int n = this.highlight;
        if (n == -1) {
            n = this.topOfLastCommand();
        }
        if (n == -1) {
            return -1;
        }
        for (int i = n + 1; i < this.lines.length; ++i) {
            if (!(this.lines[i] instanceof FileLine)) continue;
            return i;
        }
        return -1;
    }

    public int prev() {
        int n = this.highlight;
        int n2 = this.topOfLastCommand();
        if (n == -1 || n2 == -1) {
            return -1;
        }
        for (int i = n - 1; i > n2; --i) {
            if (!(this.lines[i] instanceof FileLine)) continue;
            return i;
        }
        return -1;
    }

    public void doLayout(BWidget[] bWidgetArray) {
        double d = this.getHeight();
        int n = (int)(d / this.cellHeight);
        BScrollBar bScrollBar = this.console.scrollBar;
        bScrollBar.setExtent(n);
        bScrollBar.setBlockIncrement(n);
        if (bScrollBar.getPosition() + bScrollBar.getExtent() >= this.lines.length) {
            bScrollBar.setPosition(bScrollBar.getPosition() - bScrollBar.getExtent() - 1);
        }
    }

    public int yToLine(double d) {
        int n;
        double d2 = this.getHeight();
        if (d < 0.0) {
            return -1;
        }
        if (d > d2) {
            return -1;
        }
        int n2 = this.console.scrollBar.getPosition();
        int n3 = n2 + (n = (int)(d2 / this.cellHeight)) - (int)((d2 - d) / this.cellHeight);
        if (n3 < 0) {
            return -1;
        }
        if (n3 >= this.lines.length) {
            return -1;
        }
        return n3;
    }

    public boolean isOffscreen(Line line) {
        double d = this.font.width(line.text);
        return d >= this.getWidth();
    }

    public void paint(Graphics graphics) {
        graphics.setBrush(Theme.widget().getWindowBackground((IStylable)this));
        graphics.fillRect(0.0, 0.0, this.getWidth(), this.getHeight());
        graphics.setFont(this.font);
        graphics.setBrush(Theme.widget().getWindowForeground((IStylable)this));
        double d = this.getWidth();
        double d2 = this.getHeight();
        int n = this.console.scrollBar.getPosition();
        int n2 = (int)(d2 / this.cellHeight);
        double d3 = d2 - (double)n2 * this.cellHeight;
        for (int i = 0; i <= n2; ++i) {
            int n3 = i + n;
            if (n3 < 0 || n3 >= this.lines.length) continue;
            Line line = this.lines[n3];
            double d4 = d3 + (double)(i - 1) * this.cellHeight;
            if (line == null) continue;
            if (n3 == this.highlight) {
                graphics.setBrush(BColor.yellow);
                graphics.fillRect(0.0, d4, d, this.cellHeight);
                graphics.setBrush(Theme.widget().getWindowForeground((IStylable)this));
            }
            if (line.isBreak()) {
                graphics.setBrush(BColor.make((int)192, (int)192, (int)192));
                graphics.strokeLine(0.0, d4, d, d4);
                graphics.setBrush(Theme.widget().getWindowForeground((IStylable)this));
            }
            graphics.drawString(line.text, 3.0, d3 + (double)i * this.cellHeight - 3.0);
        }
    }

    public String getStyleSelector() {
        return "console";
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        this.console.entry.requestFocus();
    }

    public void mouseReleased(BMouseEvent bMouseEvent) {
        int n = this.yToLine(bMouseEvent.getY());
        if (n != -1 && (this.lines[n] instanceof FileLine || this.lines[n] != null && this.lines[n].isOrd())) {
            this.console.show(n);
        }
    }

    public void mouseMoved(BMouseEvent bMouseEvent) {
        if (this.hoverPoint != null) {
            double d = (int)Math.abs(this.hoverPoint.x - bMouseEvent.getX());
            double d2 = (int)Math.abs(this.hoverPoint.y - bMouseEvent.getY());
            if (d > 4.0 || d2 > 4.0) {
                UiEnv.get().closeBubbleHelp();
                this.resetHover();
                this.hoverPoint = null;
            }
        }
    }

    public void mouseExited(BMouseEvent bMouseEvent) {
        UiEnv.get().closeBubbleHelp();
        this.resetHover();
        this.hoverPoint = null;
    }

    public void mouseHover(BMouseEvent bMouseEvent) {
        Point point = new Point(bMouseEvent.getX(), bMouseEvent.getY());
        this.hoverPoint = new Point((IPoint)point);
        int n = this.yToLine(bMouseEvent.getY());
        if (n != -1 && this.lines[n] != null && this.isOffscreen(this.lines[n])) {
            String string = this.lines[n].text;
            point.y += 18.0;
            UiEnv.get().openBubbleHelp((BWidget)this, point.x, point.y, string);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class OrdLine
    extends Line {
        BOrd ord;

        protected OrdLine(String string, BOrd bOrd) {
            super(string);
            this.ord = bOrd;
        }

        public static OrdLine make(String string) {
            int n = string.indexOf("||");
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = "";
            BOrd bOrd = null;
            if (n < 0) {
                return null;
            }
            bOrd = BOrd.make((String)string.substring(0, n));
            string2 = string.substring(n + 2);
            int n2 = string.indexOf("|view:");
            if (n2 > 0) {
                stringBuffer.append(string.substring(0, n2));
            } else {
                stringBuffer.append(bOrd.toString());
            }
            stringBuffer.append(" -- ").append(string2);
            return new OrdLine(stringBuffer.toString(), bOrd);
        }

        public BOrd getOrd() {
            return this.ord;
        }

        public HyperlinkInfo getHyperlinkInfo() {
            return new HyperlinkInfo(this.ord);
        }
    }

    static class FileLine
    extends Line {
        public final File file;
        public final int line1;
        public final int col1;
        public final int line2;
        public final int col2;

        public FileLine(String string, File file, int n, int n2, int n3, int n4) {
            super(string);
            this.file = file;
            this.line1 = n;
            this.col1 = n2;
            this.line2 = n3;
            this.col2 = n4;
        }
    }

    static class BreakLine
    extends Line {
        public BreakLine(String string) {
            super(string);
        }

        public boolean isBreak() {
            return true;
        }
    }

    static class Line {
        public final String text;

        public Line(String string) {
            this.text = string;
        }

        public boolean isBreak() {
            return false;
        }

        public boolean isOrd() {
            return this instanceof OrdLine;
        }
    }
}

