/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.console;

import com.tridium.nsh.NShell;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.console.BConsoleBuffer;
import com.tridium.workbench.console.BConsoleEntry;
import com.tridium.workbench.console.BConsolePane;
import com.tridium.workbench.console.ConsoleWriter;
import com.tridium.workbench.shell.BNiagaraWbShell;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BScrollBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseWheelEvent;
import javax.baja.ui.event.BScrollEvent;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.view.BWbView;

public class BConsole
extends BEdgePane {
    public static final Action scrolled = BConsole.newAction((int)0, (BValue)new BScrollEvent());
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$console$BConsole == null ? (class$com$tridium$workbench$console$BConsole = BConsole.class$("com.tridium.workbench.console.BConsole")) : class$com$tridium$workbench$console$BConsole));
    public static final int BUFFER_SIZE = 500;
    BNiagaraWbShell shell;
    BLabel prompt;
    BConsoleEntry entry;
    BScrollBar scrollBar;
    BConsoleBuffer buffer;
    ExecCallback execCallback;
    NShell nsh;
    ArrayList history = new ArrayList();
    int historyPosition = -1;
    static /* synthetic */ Class class$com$tridium$workbench$console$BConsole;

    public void scrolled(BScrollEvent bScrollEvent) {
        this.invoke(scrolled, (BValue)bScrollEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BConsole() {
        throw new IllegalStateException();
    }

    public BConsole(BNiagaraWbShell bNiagaraWbShell) {
        this.shell = bNiagaraWbShell;
        this.entry = new BConsoleEntry(this);
        this.buffer = new BConsoleBuffer(this);
        this.nsh = new ConsoleShell(new PrintStream(new ConsoleWriter(this)));
        this.scrollBar = new BScrollBar();
        this.prompt = new BLabel(">", Theme.textEditor().getFont());
        this.scrollBar.setMin(0);
        this.scrollBar.setMax(499);
        this.scrollBar.setExtent(10);
        this.scrollBar.setPosition(489);
        this.scrollBar.setUnitIncrement(1);
        this.linkTo("scrollLink", (BComponent)this.scrollBar, (Slot)BScrollBar.positionChanged, (Slot)scrolled);
        this.updatePrompt();
        this.setCenter((BWidget)new BConsolePane(this.buffer, this.prompt, this.entry));
        this.setRight((BWidget)this.scrollBar);
    }

    public String getStyleSelector() {
        return "console";
    }

    public void appendBreak() {
        this.buffer.append("", true);
    }

    public void appendLine(String string) {
        this.buffer.append(string, false);
    }

    public void show(int n) {
        String string = null;
        if (n == -1) {
            string = UiLexicon.bajaui().getText("noMore");
            if (this.buffer.highlight == -1) {
                this.showStatus(string);
                return;
            }
            n = this.buffer.highlight;
        }
        this.buffer.highlight = n;
        this.buffer.repaint();
        this.scrollToVisible(n);
        if (this.buffer.lines[n].isOrd()) {
            if (this.shell != null) {
                this.shell.hyperlink(((BConsoleBuffer.OrdLine)this.buffer.lines[n]).getHyperlinkInfo());
            }
            return;
        }
        BConsoleBuffer.FileLine fileLine = this.buffer.getFileLine(n);
        if (this.shell != null) {
            HyperlinkInterceptor hyperlinkInterceptor;
            BWbView bWbView = this.shell.getActiveView();
            if (bWbView instanceof HyperlinkInterceptor && (hyperlinkInterceptor = (HyperlinkInterceptor)((Object)bWbView)).consoleHyperlink(fileLine.file, fileLine.line1, fileLine.col1, fileLine.line2, fileLine.col2)) {
                return;
            }
            this.shell.hyperlink(fileLine.file, fileLine.line1, fileLine.col1, fileLine.line2, fileLine.col2);
        }
        if (string == null) {
            string = fileLine.text;
        }
        this.showStatus(string);
    }

    public void next() {
        this.show(this.buffer.next());
    }

    public void prev() {
        this.show(this.buffer.prev());
    }

    public void prime() {
        this.scrollToEnd();
        this.entry.requestFocus();
    }

    public void doScrolled(BScrollEvent bScrollEvent) {
        this.buffer.repaint();
    }

    public void scrollToEnd() {
        this.scrollBar.setPosition(500 - this.scrollBar.getExtent() - 1);
    }

    public void mouseWheel(BMouseWheelEvent bMouseWheelEvent) {
        BScrollBar bScrollBar = this.scrollBar;
        if (!bScrollBar.isVisible() || bScrollBar.getWidth() == 0.0) {
            return;
        }
        if (bMouseWheelEvent.getWheelRotation() > 0) {
            bScrollBar.incrementByUnit();
        } else {
            bScrollBar.decrementByUnit();
        }
        bMouseWheelEvent.consume();
    }

    public void scrollToVisible(int n) {
        int n2 = this.scrollBar.getExtent();
        int n3 = this.scrollBar.getPosition();
        int n4 = n3 + n2;
        int n5 = this.scrollBar.getMax();
        if (n <= n3) {
            int n6 = n - 1;
            if (n6 < 0) {
                n6 = 0;
            }
            this.scrollBar.setPosition(n6);
        } else if (n >= n4) {
            int n7 = n - n2;
            if (n7 >= n5) {
                n7 = n5 - 1;
            }
            if (n7 < 0) {
                n7 = 0;
            }
            this.scrollBar.setPosition(n7);
        }
    }

    public void nextCommand() {
        if (this.historyPosition < this.history.size() - 1) {
            ++this.historyPosition;
            this.entry.setCommand((String)this.history.get(this.historyPosition));
        }
    }

    public void prevCommand() {
        if (this.historyPosition > 0) {
            --this.historyPosition;
            this.entry.setCommand((String)this.history.get(this.historyPosition));
        }
    }

    private void updateHistory(String string) {
        for (int i = 0; i < this.history.size(); ++i) {
            if (!string.equals(this.history.get(i))) continue;
            this.history.remove(i);
            break;
        }
        this.history.add(string);
        this.historyPosition = this.history.size();
    }

    public void exec(String string) {
        this.exec(string, null);
    }

    public void exec(String string, ExecCallback execCallback) {
        this.showStatus(null);
        this.updateHistory(string);
        this.entry.setCommand("");
        this.scrollToEnd();
        this.entry.getUndoManager().discardAllArtifacts();
        this.buffer.append(this.prompt.getText() + string, true);
        if (string.equalsIgnoreCase("cls")) {
            this.cls();
            return;
        }
        try {
            this.execCallback = execCallback;
            this.nsh.exec(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.nsh.out().println("Command failed: " + exception);
        }
        this.shell.updateCommandStates(this.shell.getActiveView());
        this.updatePrompt();
    }

    public void kill() {
        if (!this.nsh.inExec()) {
            return;
        }
        if (4 == BDialog.confirm((BWidget)this, (Object)this.getLexicon().get("killConsoleCommand.warning.message"))) {
            this.nsh.execKill();
        }
    }

    public boolean inExec() {
        boolean bl = false;
        if (this.nsh != null) {
            bl = this.nsh.inExec();
        }
        return bl;
    }

    public void updatePrompt() {
        this.prompt.setText(this.nsh.cd() + ">");
    }

    public void cls() {
        for (int i = 0; i < this.buffer.lines.length; ++i) {
            this.buffer.lines[i] = null;
        }
        this.buffer.repaint();
    }

    public void dump() {
        System.out.println("Console");
        System.out.println("  historyPosition = " + this.historyPosition);
        for (int i = 0; i < this.history.size(); ++i) {
            System.out.println("    history[" + i + "] = " + this.history.get(i));
        }
    }

    public void showStatus(String string) {
        if (this.shell != null) {
            this.shell.showStatus(string);
        } else {
            System.out.println("showStatus: " + string);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ConsoleShell
    extends NShell {
        ConsoleShell(PrintStream printStream) {
            super(printStream);
        }

        public void execWaitForDone() {
        }

        public void execDone(int n) {
            super.execDone(n);
            if (BConsole.this.execCallback != null) {
                try {
                    BConsole.this.execCallback.consoleExecDone(BConsole.this, n);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                BConsole.this.execCallback = null;
            }
            BConsole.this.shell.updateCommandStates(BConsole.this.shell.getActiveView());
            BConsole.this.repaint();
        }
    }

    public static interface HyperlinkInterceptor {
        public boolean consoleHyperlink(File var1, int var2, int var3, int var4, int var5);
    }

    public static interface ExecCallback {
        public void consoleExecDone(BConsole var1, int var2);
    }
}

