/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.commands;

import com.tridium.sys.transfer.CompToComp;
import com.tridium.workbench.transfer.NTransferContext;
import com.tridium.workbench.transfer.TransferUtil;
import javax.baja.gx.BImage;
import javax.baja.space.Mark;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.SlotCursor;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.commands.CompoundCommand;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.Clipboard;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.BWsAnnotation;

public class PasteSpecialCommand
extends Command {
    BComponent target;

    public PasteSpecialCommand(BTransferWidget bTransferWidget, BComponent bComponent) {
        super((BWidget)bTransferWidget, UiLexicon.bajaui().module, "commands.pasteSpecial");
        this.target = bComponent;
        this.setEnabled(bTransferWidget.isPasteSpecialEnabled());
    }

    public CommandArtifact doInvoke() throws Exception {
        BComponent bComponent;
        BTransferWidget bTransferWidget = (BTransferWidget)this.getOwner();
        UiLexicon uiLexicon = UiLexicon.bajaui();
        BImage bImage = BImage.make((String)"module://icons/x32/pasteSpecial.png");
        TransferEnvelope transferEnvelope = Clipboard.getDefault().getContents();
        if (transferEnvelope == null) {
            BDialog.error((BWidget)bTransferWidget, (Object)uiLexicon.getText("command.paste.emptyClipboard"));
            return null;
        }
        if (!transferEnvelope.supports(TransferFormat.mark)) {
            BDialog.error((BWidget)bTransferWidget, (Object)uiLexicon.getText("command.paste.unsupportedFormat"));
            return null;
        }
        Mark mark = (Mark)transferEnvelope.getData(TransferFormat.mark);
        if (!mark.areAllValuesComponents()) {
            BDialog.error((BWidget)bTransferWidget, (Object)uiLexicon.getText("command.paste.unsupportedFormat"));
            return null;
        }
        if (mark.isPendingMove()) {
            BDialog.error((BWidget)bTransferWidget, (Object)uiLexicon.getText("pasteSpecial.copyOnly"));
            return null;
        }
        for (int i = 0; i < mark.size(); ++i) {
            bComponent = (BComponent)mark.getValue(i);
            if (!this.containsTarget(bComponent, this.target)) continue;
            BDialog.error((BWidget)bTransferWidget, (Object)uiLexicon.getText("pasteSpecial.selfPaste"));
            return null;
        }
        BTextField bTextField = new BTextField("1", 3);
        bComponent = new BGridPane(2);
        bComponent.setColumnGap(14.0);
        bComponent.add(null, (BValue)new BLabel(uiLexicon.getText("pasteSpecial.numCopies")));
        bComponent.add(null, (BValue)bTextField);
        BCheckBox bCheckBox = new BCheckBox(uiLexicon.getText("pasteSpecial.keepAllLinks"));
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.setRowGap(14.0);
        bGridPane.add(null, (BValue)bComponent);
        bGridPane.add(null, (BValue)bCheckBox);
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setTop((BWidget)new BWizardHeader(bImage, this.getLabel()));
        bEdgePane.setCenter((BWidget)new BBorderPane((BWidget)bGridPane));
        int n = BDialog.open((BWidget)bTransferWidget, (String)this.getLabel(), (Object)bEdgePane, (int)3);
        if (n != 1) {
            return null;
        }
        int n2 = Integer.parseInt(bTextField.getText());
        if (n2 < 1 || n2 > 100) {
            throw new Exception("Invalid number of copies, 1-100 only");
        }
        TransferContext transferContext = bTransferWidget.makeTransferContext(transferEnvelope);
        BComponent bComponent2 = null;
        if (transferContext instanceof NTransferContext) {
            bComponent2 = ((NTransferContext)transferContext).params;
        }
        if (bComponent2 == null) {
            bComponent2 = new BComponent();
        }
        bComponent2.add("promptForName", (BValue)BBoolean.FALSE);
        bComponent2.add("keepAllLinks", (BValue)BBoolean.make((boolean)bCheckBox.isSelected()));
        BWsAnnotation bWsAnnotation = (BWsAnnotation)bComponent2.get("origin");
        if (bWsAnnotation == null) {
            bWsAnnotation = CompToComp.computeOrigin((BObject[])mark.getValues(), (int)mark.size());
            bWsAnnotation = BWsAnnotation.make((int)(bWsAnnotation.p + 1), (int)(bWsAnnotation.q + 1));
            bComponent2.add("origin", (BValue)bWsAnnotation);
        }
        CommandArtifact[] commandArtifactArray = new CommandArtifact[n2];
        for (int i = 0; i < n2; ++i) {
            commandArtifactArray[i] = TransferUtil.insert((BWidget)bTransferWidget, transferContext, (BObject)this.target, bComponent2);
            bWsAnnotation = BWsAnnotation.make((int)(bWsAnnotation.p + 1), (int)(bWsAnnotation.q + 1));
            bComponent2.set("origin", (BValue)bWsAnnotation);
        }
        return new CompoundCommand.Artifact(commandArtifactArray){

            public void redo() {
                throw new LocalizableRuntimeException("bajaui", "pasteSpecial.redoUnsupported");
            }
        };
    }

    private boolean containsTarget(BComponent bComponent, BComponent bComponent2) {
        if (bComponent == bComponent2) {
            return true;
        }
        SlotCursor slotCursor = bComponent.getProperties();
        while (slotCursor.nextComponent()) {
            if (!this.containsTarget((BComponent)slotCursor.get(), bComponent2)) continue;
            return true;
        }
        return false;
    }
}

