/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.celltable;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.celltable.BAbstractCellTable;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.table.TableModel;
import javax.baja.workbench.celleditor.BWbCellEditor;

public class BLabeledCellTable
extends BAbstractCellTable {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$celltable$BLabeledCellTable == null ? (class$com$tridium$workbench$celltable$BLabeledCellTable = BLabeledCellTable.class$("com.tridium.workbench.celltable.BLabeledCellTable")) : class$com$tridium$workbench$celltable$BLabeledCellTable));
    private Array rows = new Array(class$com$tridium$workbench$celltable$BLabeledCellTable$Row == null ? (class$com$tridium$workbench$celltable$BLabeledCellTable$Row = BLabeledCellTable.class$("com.tridium.workbench.celltable.BLabeledCellTable$Row")) : class$com$tridium$workbench$celltable$BLabeledCellTable$Row);
    private double[] prefCellWidths = null;
    static /* synthetic */ Class class$com$tridium$workbench$celltable$BLabeledCellTable;
    static /* synthetic */ Class class$com$tridium$workbench$celltable$BLabeledCellTable$Row;

    public Type getType() {
        return TYPE;
    }

    public BLabeledCellTable() {
        super(null, false);
        throw new IllegalStateException();
    }

    public BLabeledCellTable(final String[] stringArray) {
        super(stringArray, true);
        this.setModel(new TableModel(){

            public int getRowCount() {
                return BLabeledCellTable.this.rows.size();
            }

            public int getColumnCount() {
                return stringArray.length + 1;
            }

            public String getColumnName(int n) {
                return n == 0 ? "" : stringArray[n - 1];
            }

            public Object getSubject(int n) {
                return BLabeledCellTable.this.getRowCells(n);
            }

            public Object getValueAt(int n, int n2) {
                if (n2 == 0) {
                    return BLabeledCellTable.this.getRowName(n);
                }
                return BLabeledCellTable.this.getRowCells(n)[n2 - 1];
            }
        });
    }

    public void doLayout(BWidget[] bWidgetArray) {
        super.doLayout(bWidgetArray);
        double d = this.getCellRenderer().getCellHeight();
        double d2 = this.getHeaderRenderer().getHeaderHeight() - 1.0;
        for (int i = 0; i < this.rows.size(); ++i) {
            BWbCellEditor[] bWbCellEditorArray = this.getRowCells(i);
            double d3 = 0.0;
            int n = 0;
            d3 = this.getCellWidth(0);
            n = 1;
            for (int j = 0; j < bWbCellEditorArray.length; ++j) {
                double d4 = this.getCellWidth(j + n);
                bWbCellEditorArray[j].setBounds(d3, d2, d4, d);
                d3 += d4;
            }
            d2 += d;
        }
    }

    public void computePreferredSize() {
        this.preferredCellWidths();
        super.computePreferredSize();
    }

    public void addRow(String string, BWbCellEditor[] bWbCellEditorArray) {
        this.checkEnabled(bWbCellEditorArray);
        this.insertRow(this.rows.size(), string, bWbCellEditorArray);
    }

    public void insertRow(int n, String string, BWbCellEditor[] bWbCellEditorArray) {
        this.checkEnabled(bWbCellEditorArray);
        this.rows.add(n, (Object)new Row(string, bWbCellEditorArray));
        this.prefCellWidths = null;
        for (int i = 0; i < this.colNames.length; ++i) {
            String string2 = this.colNames[i] + this.stemCtr++;
            this.add("ce" + string2, (BValue)bWbCellEditorArray[i]);
            this.linkTo("mod" + string2, (BComponent)bWbCellEditorArray[i], (Slot)BWbCellEditor.pluginModified, (Slot)modified);
            this.rowLinks.put(bWbCellEditorArray[i], "mod" + string2);
        }
        this.resetRowIndexes();
        this.getModel().updateTable(true);
    }

    public String getRowName(int n) {
        return this.row(n).name;
    }

    public void setRowName(int n, String string) {
        this.row(n).name = string;
    }

    public void removeRow(int n) {
        BWbCellEditor[] bWbCellEditorArray = this.getRowCells(n);
        this.rows.remove(n);
        this.prefCellWidths = null;
        for (int i = 0; i < bWbCellEditorArray.length; ++i) {
            this.remove(bWbCellEditorArray[i].getPropertyInParent());
            this.remove((String)this.rowLinks.get((Object)bWbCellEditorArray[i]));
            this.rowLinks.remove((Object)bWbCellEditorArray[i]);
        }
        this.resetRowIndexes();
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public void clearRows() {
        for (int i = 0; i < this.rows.size(); ++i) {
            BWbCellEditor[] bWbCellEditorArray = this.getRowCells(i);
            for (int j = 0; j < bWbCellEditorArray.length; ++j) {
                this.remove(bWbCellEditorArray[j].getPropertyInParent());
                this.remove((String)this.rowLinks.get((Object)bWbCellEditorArray[j]));
            }
        }
        this.rows.clear();
        this.prefCellWidths = null;
        this.rowLinks.clear();
    }

    public BWbCellEditor[] getRowCells(int n) {
        return this.row(n).cells;
    }

    private void resetRowIndexes() {
        for (int i = 0; i < this.rows.size(); ++i) {
            BWbCellEditor[] bWbCellEditorArray = this.getRowCells(i);
            for (int j = 0; j < bWbCellEditorArray.length; ++j) {
                bWbCellEditorArray[j].setRowIndex(i);
            }
        }
    }

    private Row row(int n) {
        return (Row)this.rows.get(n);
    }

    protected double[] preferredCellWidths() {
        if (this.prefCellWidths == null) {
            int n = this.getModel().getColumnCount();
            this.prefCellWidths = new double[n];
            for (int i = 0; i < n; ++i) {
                this.prefCellWidths[i] = this.columnWidth(i);
            }
        }
        return this.prefCellWidths;
    }

    private double columnWidth(int n) {
        if (this.rows.size() == 0) {
            return 10.0;
        }
        if (n == 0) {
            double d = BLabeledCellTable.stringWidth(this.getRowName(0));
            for (int i = 1; i < this.rows.size(); ++i) {
                d = Math.max(d, BLabeledCellTable.stringWidth(this.getRowName(i)));
            }
            return d + 10.0;
        }
        return BLabeledCellTable.cellEditorWidth(this.getRowCells(0)[n - 1]);
    }

    private static double cellEditorWidth(BWbCellEditor bWbCellEditor) {
        bWbCellEditor.computePreferredSize();
        return bWbCellEditor.getPreferredWidth();
    }

    private static double stringWidth(String string) {
        return Theme.label().getTextFont().width(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Row {
        private String name;
        private BWbCellEditor[] cells;

        private Row(String string, BWbCellEditor[] bWbCellEditorArray) {
            this.name = string;
            this.cells = bWbCellEditorArray;
        }
    }
}

