/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.celltable;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.celltable.CellController;
import com.tridium.workbench.celltable.CellEditorContainer;
import java.util.HashMap;
import java.util.Map;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.Graphics;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BMenu;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableHeaderRenderer;
import javax.baja.workbench.celleditor.BWbCellEditor;

public abstract class BAbstractCellTable
extends BTable
implements CellEditorContainer {
    public static final Topic modified = BAbstractCellTable.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$celltable$BAbstractCellTable == null ? (class$com$tridium$workbench$celltable$BAbstractCellTable = BAbstractCellTable.class$("com.tridium.workbench.celltable.BAbstractCellTable")) : class$com$tridium$workbench$celltable$BAbstractCellTable));
    private CellController cellController;
    protected final String[] colNames;
    protected Map rowLinks = new HashMap();
    protected int stemCtr;
    private boolean isLabeled;
    private boolean dragging = false;
    private boolean cellsEnabled = true;
    static /* synthetic */ Class class$com$tridium$workbench$celltable$BAbstractCellTable;

    public void fireModified(BWidgetEvent bWidgetEvent) {
        this.fire(modified, (BValue)bWidgetEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BAbstractCellTable(String[] stringArray, boolean bl) {
        this.colNames = stringArray;
        this.isLabeled = bl;
        this.setStyleClasses("cell-table");
        this.setCellRenderer(new CellRenderer());
        this.setHeaderRenderer(new HeaderRenderer());
        this.setController(new Controller());
        this.setMultipleSelection(false);
        this.setGridBrush(Theme.widget().getControlShadow());
        this.setHscrollBarVisible(false);
        this.setVscrollBarVisible(false);
        this.setCellController(new CellController());
    }

    public CellController getCellController() {
        return this.cellController;
    }

    public void setCellController(CellController cellController) {
        this.installSupport(this.cellController, cellController);
        this.cellController = cellController;
    }

    private void installSupport(BTable.TableSupport tableSupport, BTable.TableSupport tableSupport2) {
        if (tableSupport2 == null) {
            throw new NullPointerException();
        }
        if (tableSupport == tableSupport2) {
            return;
        }
        if (tableSupport2.getTable() != null) {
            throw new IllegalArgumentException("Already installed on another table");
        }
        if (tableSupport != null) {
            tableSupport.setTable(null);
        }
        tableSupport2.setTable((BTable)this);
    }

    protected abstract double[] preferredCellWidths();

    protected final void checkEnabled(BWbCellEditor[] bWbCellEditorArray) {
        for (int i = 0; i < bWbCellEditorArray.length; ++i) {
            if (bWbCellEditorArray[i].isReadonly()) continue;
            bWbCellEditorArray[i].setReadonly(!this.cellsEnabled);
        }
    }

    public abstract void removeRow(int var1);

    public abstract void clearRows();

    public abstract int getRowCount();

    public abstract BWbCellEditor[] getRowCells(int var1);

    public void setCellsEnabled(boolean bl) {
        this.cellsEnabled = bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Controller
    extends TableController {
        protected void resizeHotspotPressed(BMouseEvent bMouseEvent, int n) {
            this.table().dragging = true;
        }

        protected void resizeHotspotDragged(BMouseEvent bMouseEvent, int n) {
            BAbstractCellTable bAbstractCellTable = this.table();
            bAbstractCellTable.setColumnPosition(n, bMouseEvent.getX());
            bAbstractCellTable.preferredCellWidths()[n] = bAbstractCellTable.getCellWidth(n);
            bAbstractCellTable.relayout();
        }

        protected void resizeHotspotReleased(BMouseEvent bMouseEvent, int n) {
            BAbstractCellTable bAbstractCellTable = this.table();
            bAbstractCellTable.dragging = false;
            bAbstractCellTable.preferredCellWidths()[n] = bAbstractCellTable.getCellWidth(n);
            bAbstractCellTable.relayout();
        }

        protected BMenu makeOptionsMenu() {
            BMenu bMenu = super.makeOptionsMenu();
            bMenu.keep(new String[]{"resizeColumns"});
            return bMenu;
        }

        private BAbstractCellTable table() {
            return (BAbstractCellTable)this.getTable();
        }
    }

    public static class CellRenderer
    extends TableCellRenderer {
        public final double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            return this.table().preferredCellWidths()[cell.column];
        }

        public final void paintCell(Graphics graphics, TableCellRenderer.Cell cell) {
            if (this.table().isLabeled && cell.column == 0) {
                super.paintCell(graphics, cell);
            } else {
                this.paintCellBackground(graphics, cell);
            }
        }

        public BBrush getBackground(TableCellRenderer.Cell cell) {
            if (!this.getTable().isEnabled()) {
                return BBrush.makeSolid((BColor)BColor.gainsboro);
            }
            return null;
        }

        private BAbstractCellTable table() {
            return (BAbstractCellTable)this.getTable();
        }
    }

    public static class HeaderRenderer
    extends TableHeaderRenderer {
        public double getPreferredHeaderWidth(TableHeaderRenderer.Header header) {
            double d = super.getPreferredHeaderWidth(header);
            return Math.max(this.table().preferredCellWidths()[header.column], d);
        }

        private BAbstractCellTable table() {
            return (BAbstractCellTable)this.getTable();
        }
    }
}

