/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.bql.filter;

import com.tridium.workbench.filter.BWbFilter;
import javax.baja.data.BIDataValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BTimeQueryBuilder
extends BFlowPane {
    public static final Property bqlEnabled = BTimeQueryBuilder.newProperty((int)0, (boolean)true, null);
    public static final Action updateState = BTimeQueryBuilder.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$bql$filter$BTimeQueryBuilder == null ? (class$com$tridium$workbench$bql$filter$BTimeQueryBuilder = BTimeQueryBuilder.class$("com.tridium.workbench.bql.filter.BTimeQueryBuilder")) : class$com$tridium$workbench$bql$filter$BTimeQueryBuilder));
    private static final int ABSOLUTE_RANGE = 0;
    private static final int TODAY = 1;
    private static final int YESTERDAY = 2;
    private static final int LAST_WEEK = 3;
    private static final int LAST_7_DAYS = 4;
    private static final int LAST_MONTH = 5;
    private static final int LAST_YEAR = 6;
    private static final int MONTH_TO_DATE = 7;
    private static final int YEAR_TO_DATE = 8;
    private BListDropDown typeChoice = new BListDropDown();
    private BWbFilter startEditor;
    private BWbFilter endEditor;
    private BPane timeEditors;
    private BFacets timeFacets;
    static /* synthetic */ Class class$com$tridium$workbench$bql$filter$BTimeQueryBuilder;

    public boolean getBqlEnabled() {
        return this.getBoolean(bqlEnabled);
    }

    public void setBqlEnabled(boolean bl) {
        this.setBoolean(bqlEnabled, bl, null);
    }

    public void updateState() {
        this.invoke(updateState, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BTimeQueryBuilder() {
        super(BHalign.left, 6, 4);
        this.add("typeChoice", (BValue)this.typeChoice);
        Lexicon lexicon = Lexicon.make((String)"bql");
        this.timeEditors = new BFlowPane(BHalign.left, 4, 4);
        this.timeFacets = BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.FALSE);
        this.timeFacets = BFacets.make((BFacets)this.timeFacets, (String)"showSeconds", (BIDataValue)BBoolean.FALSE);
        this.timeFacets = BFacets.make((BFacets)this.timeFacets, (String)"showTimeZone", (BIDataValue)BBoolean.FALSE);
        BAbsTime bAbsTime = BAbsTime.now();
        bAbsTime = BAbsTime.make((int)bAbsTime.getYear(), (BMonth)bAbsTime.getMonth(), (int)bAbsTime.getDay(), (int)bAbsTime.getHour(), (int)bAbsTime.getMinute());
        this.timeEditors.add("startLabel", (BValue)new BLabel(lexicon.getText("dynamicTimeRangeFE.startTime")));
        this.startEditor = new BWbFilter(BWbFieldEditor.makeFor((BObject)bAbsTime));
        this.startEditor.setDefault(null);
        try {
            this.startEditor.loadValue((BObject)bAbsTime, (Context)this.timeFacets);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.timeEditors.add("startEd", (BValue)this.startEditor);
        this.timeEditors.add("endLabel", (BValue)new BLabel(lexicon.getText("dynamicTimeRangeFE.endTime")));
        this.endEditor = new BWbFilter(BWbFieldEditor.makeFor((BObject)bAbsTime));
        this.endEditor.setDefault(null);
        try {
            this.endEditor.loadValue((BObject)bAbsTime, (Context)this.timeFacets);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.timeEditors.add("endEd", (BValue)this.endEditor);
        this.add("timeEditors", (BValue)this.timeEditors);
        this.timeEditors.setVisible(true);
        this.add("typeChange", (BValue)new BLink((BComponent)this.typeChoice, (Slot)BListDropDown.listActionPerformed, (Slot)updateState));
        this.updateOptions();
    }

    public void setStartTime(BAbsTime bAbsTime) {
        if (bAbsTime.getSecond() != 0 || bAbsTime.getMillisecond() != 0) {
            bAbsTime = BAbsTime.make((int)bAbsTime.getYear(), (BMonth)bAbsTime.getMonth(), (int)bAbsTime.getDay(), (int)bAbsTime.getHour(), (int)bAbsTime.getMinute());
        }
        try {
            this.startEditor.loadValue((BObject)bAbsTime, (Context)this.timeFacets);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setEndTime(BAbsTime bAbsTime) {
        if (bAbsTime.getSecond() != 0 || bAbsTime.getMillisecond() != 0) {
            bAbsTime = BAbsTime.make((int)bAbsTime.getYear(), (BMonth)bAbsTime.getMonth(), (int)bAbsTime.getDay(), (int)bAbsTime.getHour(), (int)bAbsTime.getMinute());
        }
        try {
            this.endEditor.loadValue((BObject)bAbsTime, (Context)this.timeFacets);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void computePreferredSize() {
        boolean bl = this.getBqlEnabled();
        if (bl && this.typeChoice.getList().getItemCount() < 2) {
            this.updateOptions();
        }
        this.timeEditors.computePreferredSize();
        double d = this.timeEditors.getPreferredWidth();
        if (bl) {
            this.typeChoice.computePreferredSize();
            d += this.typeChoice.getPreferredWidth() + 6.0;
        }
        double d2 = this.timeEditors.getPreferredHeight();
        if (bl) {
            d2 = Math.max(d2, this.typeChoice.getPreferredHeight());
        }
        this.setPreferredSize(d, d2);
    }

    public void doLayout(BWidget[] bWidgetArray) {
        boolean bl = this.getBqlEnabled();
        if (bl && this.typeChoice.getList().getItemCount() < 2) {
            this.updateOptions();
        }
        super.doLayout(bWidgetArray);
    }

    private void updateOptions() {
        boolean bl = this.getBqlEnabled();
        Lexicon lexicon = Lexicon.make((String)"bql");
        BList bList = this.typeChoice.getList();
        bList.removeAllItems();
        bList.addItem((Object)new RangeType(0, lexicon.getText("timeRange.absoluteRange"), null));
        if (bl) {
            bList.addItem((Object)new RangeType(1, lexicon.getText("timeRange.today"), "BqlTime.today"));
            bList.addItem((Object)new RangeType(2, lexicon.getText("timeRange.yesterday"), "BqlTime.yesterday"));
            bList.addItem((Object)new RangeType(3, lexicon.getText("timeRange.lastWeek"), "BqlTime.lastWeek"));
            bList.addItem((Object)new RangeType(4, lexicon.getText("timeRange.last7Days"), "BqlTime.last7Days"));
            bList.addItem((Object)new RangeType(5, lexicon.getText("timeRange.lastMonth"), "BqlTime.lastMonth"));
            bList.addItem((Object)new RangeType(6, lexicon.getText("timeRange.lastYear"), "BqlTime.lastYear"));
            bList.addItem((Object)new RangeType(7, lexicon.getText("timeRange.monthToDate"), "BqlTime.monthToDate"));
            bList.addItem((Object)new RangeType(8, lexicon.getText("timeRange.yearToDate"), "BqlTime.yearToDate"));
        }
        if (bl) {
            bList.setSelectedIndex(1);
        } else {
            bList.setSelectedIndex(0);
        }
        this.updateState();
    }

    public boolean requiresBql() {
        RangeType rangeType = (RangeType)this.typeChoice.getSelectedItem();
        return rangeType.getId() != 0;
    }

    public String getBqlQualifier(String string) {
        RangeType rangeType = (RangeType)this.typeChoice.getSelectedItem();
        if (!this.getBqlEnabled() || rangeType != null && rangeType.getId() == 0) {
            try {
                BAbsTime bAbsTime = (BAbsTime)this.startEditor.saveValue(null);
                BAbsTime bAbsTime2 = (BAbsTime)this.endEditor.saveValue(null);
                StringBuffer stringBuffer = new StringBuffer(64);
                if (bAbsTime != null) {
                    stringBuffer.append(string).append(" >= AbsTime '").append(bAbsTime.encodeToString()).append("'");
                }
                if (bAbsTime2 != null) {
                    if (bAbsTime != null) {
                        stringBuffer.append(" and ");
                    }
                    stringBuffer.append(string).append(" <= AbsTime '").append(bAbsTime2.encodeToString()).append("'");
                }
                return stringBuffer.toString();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        if (rangeType != null) {
            return string + " in " + rangeType.toBql();
        }
        return null;
    }

    public BAbsTime getStartTime() {
        RangeType rangeType = (RangeType)this.typeChoice.getSelectedItem();
        if (rangeType.getId() != 0) {
            return null;
        }
        try {
            return (BAbsTime)this.startEditor.saveValue(null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public BAbsTime getEndTime() {
        RangeType rangeType = (RangeType)this.typeChoice.getSelectedItem();
        if (rangeType.getId() != 0) {
            return null;
        }
        try {
            return (BAbsTime)this.endEditor.saveValue(null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void doUpdateState() {
        boolean bl = this.getBqlEnabled();
        RangeType rangeType = (RangeType)this.typeChoice.getSelectedItem();
        this.typeChoice.setVisible(bl);
        boolean bl2 = rangeType.getId() == 0;
        this.timeEditors.setVisible(bl2 || !bl);
        this.relayout();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (property == bqlEnabled) {
            this.updateOptions();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class RangeType {
        int id;
        String displayText;
        String bqlText;

        public RangeType(int n, String string, String string2) {
            this.id = n;
            this.displayText = string;
            this.bqlText = string2;
        }

        public String toString() {
            return this.displayText;
        }

        public String toBql() {
            return this.bqlText;
        }

        public int getId() {
            return this.id;
        }
    }
}

