/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.bookmark;

import com.tridium.ui.BOptionDialog;
import com.tridium.workbench.bookmark.BBookmarkMenu;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.BViewTab;
import com.tridium.workbench.shell.BViewTabbedPane;
import com.tridium.workbench.shell.WbHistory;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BHyperlinkMode;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.bookmark.BBookmark;
import javax.baja.ui.bookmark.BBookmarkFolder;
import javax.baja.ui.bookmark.BBookmarkItem;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BTreePane;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.tree.TreeSubject;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;

public class BookmarkUtil {
    private TreeNode last = null;
    private static BModule module = Sys.getModuleForClass((Class)(class$com$tridium$workbench$bookmark$BBookmarkMenu == null ? (class$com$tridium$workbench$bookmark$BBookmarkMenu = BookmarkUtil.class$("com.tridium.workbench.bookmark.BBookmarkMenu")) : class$com$tridium$workbench$bookmark$BBookmarkMenu));
    private static BImage folderIcon = BImage.make((String)"module://icons/x16/bookmarkFolder.png");
    private BWidget owner;
    private BBookmarkFolder rootFolder;
    private BBookmark bookmark;
    private BTextField name;
    private BTree tree;
    static /* synthetic */ Class class$javax$baja$ui$bookmark$BBookmarkFolder;
    static /* synthetic */ Class class$com$tridium$workbench$bookmark$BBookmarkMenu;

    public static void add(BWidget bWidget, BBookmarkFolder bBookmarkFolder, BBookmark bBookmark) {
        BookmarkUtil.add(bWidget, bBookmarkFolder, null, bBookmark);
    }

    public static void add(BWidget bWidget, BBookmarkFolder bBookmarkFolder, BBookmarkFolder bBookmarkFolder2, BBookmark bBookmark) {
        BookmarkUtil bookmarkUtil = new BookmarkUtil(bWidget);
        BWidget bWidget2 = bookmarkUtil.makeAdd(bBookmarkFolder, bBookmarkFolder2, bBookmark);
        if (1 == BDialog.open((BWidget)bWidget, (String)BookmarkUtil.lex().getText("bookmark.add.label"), (Object)new BBorderPane(bWidget2), (int)3)) {
            bookmarkUtil.bookmark.setText(bookmarkUtil.name.getText());
            TreeNode treeNode = bookmarkUtil.tree.getSelection().getNode();
            BBookmarkFolder bBookmarkFolder3 = ((Node)treeNode).folder;
            bBookmarkFolder3.add(null, (BValue)bookmarkUtil.bookmark);
        }
    }

    public static void add(BWidget bWidget, BBookmarkFolder bBookmarkFolder, BBookmark[] bBookmarkArray) {
        BookmarkUtil bookmarkUtil = new BookmarkUtil(bWidget);
        BBookmark bBookmark = new BBookmark("New Folder");
        BWidget bWidget2 = bookmarkUtil.makeAdd(bBookmarkFolder, null, bBookmark);
        if (1 == BDialog.open((BWidget)bWidget, (String)BookmarkUtil.lex().getText("bookmark.addAll.label"), (Object)new BBorderPane(bWidget2), (int)3)) {
            TreeNode treeNode = bookmarkUtil.tree.getSelection().getNode();
            BBookmarkFolder bBookmarkFolder2 = ((Node)treeNode).folder;
            BBookmarkFolder bBookmarkFolder3 = new BBookmarkFolder(bookmarkUtil.name.getText());
            for (int i = 0; i < bBookmarkArray.length; ++i) {
                bBookmarkFolder3.add(null, (BValue)bBookmarkArray[i]);
            }
            bBookmarkFolder2.add(null, (BValue)bBookmarkFolder3);
        }
    }

    public static BBookmarkFolder copy(BWidget bWidget, BBookmarkFolder bBookmarkFolder, BComponent[] bComponentArray) {
        BookmarkUtil bookmarkUtil = new BookmarkUtil(bWidget);
        BWidget bWidget2 = bookmarkUtil.makeMove(bBookmarkFolder, BookmarkUtil.lex().getText("bookmark.copyTo"));
        if (1 == BDialog.open((BWidget)bWidget, (String)BookmarkUtil.lex().getText("bookmark.copyTo"), (Object)new BBorderPane(bWidget2), (int)3)) {
            TreeNode treeNode = bookmarkUtil.tree.getSelection().getNode();
            BBookmarkFolder bBookmarkFolder2 = ((Node)treeNode).folder;
            for (int i = 0; i < bComponentArray.length; ++i) {
                bBookmarkFolder2.add(null, bComponentArray[i].newCopy());
            }
            return bBookmarkFolder2;
        }
        return null;
    }

    public static BBookmarkFolder move(BWidget bWidget, BBookmarkFolder bBookmarkFolder, BComponent[] bComponentArray) {
        BookmarkUtil bookmarkUtil = new BookmarkUtil(bWidget);
        BWidget bWidget2 = bookmarkUtil.makeMove(bBookmarkFolder, BookmarkUtil.lex().getText("bookmark.moveTo"));
        if (1 == BDialog.open((BWidget)bWidget, (String)BookmarkUtil.lex().getText("bookmark.moveTo"), (Object)new BBorderPane(bWidget2), (int)3)) {
            int n;
            TreeNode treeNode = bookmarkUtil.tree.getSelection().getNode();
            BBookmarkFolder bBookmarkFolder2 = ((Node)treeNode).folder;
            for (n = 0; n < bComponentArray.length; ++n) {
                BBookmarkFolder bBookmarkFolder3 = bBookmarkFolder2;
                while (bBookmarkFolder3 instanceof BBookmarkItem) {
                    if (bBookmarkFolder3 == bComponentArray[n]) {
                        BDialog.error((BWidget)bWidget, (Object)BookmarkUtil.lex().getText("bookmark.manage.cannotMove"));
                        return null;
                    }
                    bBookmarkFolder3 = bBookmarkFolder3.getParent().asComponent();
                }
            }
            for (n = 0; n < bComponentArray.length; ++n) {
                bComponentArray[n].getParent().asComponent().remove((BComplex)bComponentArray[n]);
                bBookmarkFolder2.add(null, (BValue)bComponentArray[n]);
            }
            return bBookmarkFolder2;
        }
        return null;
    }

    public static void open(BWbShell bWbShell, BBookmark bBookmark) {
        BookmarkUtil.open(bWbShell, bBookmark, false);
    }

    public static void open(BWbShell bWbShell, BBookmark bBookmark, boolean bl) {
        BNiagaraWbShell bNiagaraWbShell;
        if (bl) {
            bWbShell.hyperlink(new HyperlinkInfo(bBookmark.getBookmarkOrd(), BHyperlinkMode.newTab));
        } else {
            bWbShell.hyperlink(bBookmark.getBookmarkOrd());
        }
        if (bWbShell instanceof BNiagaraWbShell && (bNiagaraWbShell = (BNiagaraWbShell)bWbShell).getActiveOrdTarget() != null) {
            bNiagaraWbShell.syncTree(true);
        }
    }

    public static BBookmark makeForCurrentContext(BWbShell bWbShell) {
        BOrd bOrd = bWbShell.getActiveOrd();
        String string = WbHistory.toName(bOrd);
        BObject bObject = bWbShell.getActiveOrdTarget().get();
        return new BBookmark(string, bOrd, bObject.getIcon());
    }

    public static BBookmark makeForTab(BViewTab bViewTab) {
        BOrd bOrd = bViewTab.getOrd();
        String string = WbHistory.toName(bOrd);
        BObject bObject = bViewTab.getTarget().get();
        return new BBookmark(string, bOrd, bObject.getIcon());
    }

    public static BViewTab[] tabs(BWbShell bWbShell) {
        if (!(bWbShell instanceof BNiagaraWbShell)) {
            return new BViewTab[0];
        }
        BNiagaraWbShell bNiagaraWbShell = (BNiagaraWbShell)bWbShell;
        return ((BViewTabbedPane)bNiagaraWbShell.tab().getParentWidget()).getTabs();
    }

    private BookmarkUtil(BWidget bWidget) {
        this.owner = bWidget;
    }

    private BWidget makeAdd(BBookmarkFolder bBookmarkFolder, BBookmarkFolder bBookmarkFolder2, BBookmark bBookmark) {
        this.rootFolder = bBookmarkFolder;
        this.bookmark = bBookmark;
        this.name = new BTextField(bBookmark.getText());
        this.tree = new BTree((TreeModel)new Model());
        this.tree.setController((TreeController)new Controller());
        this.last = this.tree.getModel().getRoot(0);
        this.tree.getSelection().select(this.last);
        BToolBar bToolBar = new BToolBar();
        bToolBar.add(null, (Command)new NewFolder(this.owner));
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setLeft((BWidget)new BBorderPane((BWidget)new BLabel(BookmarkUtil.lex().getText("bookmark.name")), 0.0, 0.0, 0.0, 5.0));
        bEdgePane.setCenter((BWidget)this.name);
        BEdgePane bEdgePane2 = new BEdgePane();
        bEdgePane2.setLeft((BWidget)new BLabel(BookmarkUtil.lex().getText("bookmark.createIn")));
        bEdgePane2.setRight((BWidget)bToolBar);
        BEdgePane bEdgePane3 = new BEdgePane();
        bEdgePane3.setTop((BWidget)bEdgePane);
        bEdgePane3.setBottom((BWidget)new BBorderPane((BWidget)bEdgePane2, 5.0, 0.0, 0.0, 0.0));
        BEdgePane bEdgePane4 = new BEdgePane();
        bEdgePane4.setTop((BWidget)bEdgePane3);
        bEdgePane4.setCenter((BWidget)new BBorderPane((BWidget)new BTreePane(this.tree), BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        if (bBookmarkFolder2 != null) {
            TreeNode treeNode = this.findNode((BComponent)bBookmarkFolder2);
            this.tree.scrollNodeToVisible(treeNode);
            this.tree.getSelection().select(treeNode);
        }
        return this.makeConstrainedPane((BWidget)bEdgePane4, 400, 300);
    }

    private BWidget makeMove(BBookmarkFolder bBookmarkFolder, String string) {
        this.rootFolder = bBookmarkFolder;
        this.tree = new BTree((TreeModel)new Model());
        this.tree.setController((TreeController)new Controller());
        this.last = this.tree.getModel().getRoot(0);
        this.tree.getSelection().select(this.last);
        BToolBar bToolBar = new BToolBar();
        bToolBar.add(null, (Command)new NewFolder(this.owner));
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setLeft((BWidget)new BLabel(string));
        bEdgePane.setRight((BWidget)bToolBar);
        BEdgePane bEdgePane2 = new BEdgePane();
        bEdgePane2.setTop((BWidget)bEdgePane);
        bEdgePane2.setCenter((BWidget)new BBorderPane((BWidget)new BTreePane(this.tree), BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        return this.makeConstrainedPane((BWidget)bEdgePane2, 400, 300);
    }

    private BWidget makeConstrainedPane(BWidget bWidget, int n, int n2) {
        BConstrainedPane bConstrainedPane = new BConstrainedPane(bWidget);
        bConstrainedPane.setMinWidth((double)n);
        bConstrainedPane.setMaxWidth((double)n);
        bConstrainedPane.setMinHeight((double)n2);
        bConstrainedPane.setMaxHeight((double)n2);
        return bConstrainedPane;
    }

    private BOptionDialog getOptionDialog() {
        BWidget bWidget = this.tree.getParentWidget();
        while (!(bWidget instanceof BOptionDialog)) {
            bWidget = bWidget.getParentWidget();
        }
        return (BOptionDialog)bWidget;
    }

    TreeNode findNode(BComponent bComponent) {
        TreeModel treeModel = this.tree.getModel();
        for (int i = 0; i < treeModel.getRootCount(); ++i) {
            TreeNode treeNode = this.findNode(treeModel.getRoot(i), bComponent);
            if (treeNode == null) continue;
            return treeNode;
        }
        return null;
    }

    TreeNode findNode(TreeNode treeNode, BComponent bComponent) {
        if (bComponent == ((Node)treeNode).folder) {
            return treeNode;
        }
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            TreeNode treeNode2 = this.findNode(treeNode.getChild(i), bComponent);
            if (treeNode2 == null) continue;
            return treeNode2;
        }
        return null;
    }

    static Lexicon lex() {
        return BBookmarkMenu.TYPE.getModule().getLexicon();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class NewFolder
    extends Command {
        NewFolder(BWidget bWidget) {
            super(bWidget, module, "bookmark.manage.newFolder");
        }

        public CommandArtifact doInvoke() {
            String string = BDialog.prompt((BWidget)this.getOwner(), (String)"New Folder", (String)"New Folder", (int)20);
            if (string == null) {
                return null;
            }
            TreeNode treeNode = BookmarkUtil.this.tree.getSelection().getNode();
            Node node = (Node)treeNode;
            BBookmarkFolder bBookmarkFolder = new BBookmarkFolder(string);
            node.folder.add(null, (BValue)bBookmarkFolder);
            Node[] nodeArray = new Node[node.kids.length + 1];
            System.arraycopy(node.kids, 0, nodeArray, 0, node.kids.length);
            nodeArray[nodeArray.length - 1] = new Node(node, bBookmarkFolder);
            node.kids = nodeArray;
            node.setExpanded(true);
            BookmarkUtil.this.tree.getSelection().select((TreeNode)node.kids[node.kids.length - 1]);
            BookmarkUtil.this.tree.relayout();
            return null;
        }
    }

    class Controller
    extends TreeController {
        Controller() {
        }

        protected void mouseSelection(TreeNode treeNode, BMouseEvent bMouseEvent) {
            TreeNode treeNode2 = this.getSelection().getNode();
            super.mouseSelection(treeNode, bMouseEvent);
            if (this.getSelection().getNode() == null) {
                if (treeNode2 == null) {
                    TreeNode treeNode3 = treeNode2 = BookmarkUtil.this.last;
                    while (treeNode2 != null) {
                        if (!treeNode2.isExpanded()) {
                            treeNode3 = treeNode2;
                        }
                        treeNode2 = treeNode2.getParent();
                    }
                    treeNode2 = treeNode3;
                }
                this.getSelection().select(treeNode2);
            }
            BookmarkUtil.this.last = treeNode2;
        }

        protected void doSelectAction(TreeNode treeNode, double d, double d2) {
            BookmarkUtil.this.getOptionDialog().getOkButton().invokeAction();
        }

        protected BMenu makePopup(TreeSubject treeSubject) {
            BMenu bMenu = super.makePopup(treeSubject);
            if (bMenu == null) {
                bMenu = new BMenu();
            }
            bMenu.add(null, (Command)new NewFolder((BWidget)BookmarkUtil.this.tree));
            return bMenu;
        }
    }

    class Node
    extends TreeNode {
        BBookmarkFolder folder;
        Node[] kids;

        public Node(TreeModel treeModel, BBookmarkFolder bBookmarkFolder) {
            super(treeModel);
            this.folder = bBookmarkFolder;
            this.load();
        }

        public Node(TreeNode treeNode, BBookmarkFolder bBookmarkFolder) {
            super(treeNode);
            this.folder = bBookmarkFolder;
            this.load();
        }

        public void load() {
            BBookmarkFolder[] bBookmarkFolderArray = (BBookmarkFolder[])this.folder.getChildren(class$javax$baja$ui$bookmark$BBookmarkFolder == null ? (class$javax$baja$ui$bookmark$BBookmarkFolder = BookmarkUtil.class$("javax.baja.ui.bookmark.BBookmarkFolder")) : class$javax$baja$ui$bookmark$BBookmarkFolder);
            this.kids = new Node[bBookmarkFolderArray.length];
            for (int i = 0; i < bBookmarkFolderArray.length; ++i) {
                this.kids[i] = new Node(this, bBookmarkFolderArray[i]);
            }
        }

        public Object getSubject() {
            return this.folder;
        }

        public String getText() {
            return this.folder.getText();
        }

        public BImage getIcon() {
            return folderIcon;
        }

        public int getChildCount() {
            return this.kids.length;
        }

        public TreeNode getChild(int n) {
            return this.kids[n];
        }
    }

    class Model
    extends TreeModel {
        Node root;

        public Model() {
            this.root = new Node(this, BookmarkUtil.this.rootFolder);
            BBookmarkFolder[] bBookmarkFolderArray = (BBookmarkFolder[])BookmarkUtil.this.rootFolder.getChildren(class$javax$baja$ui$bookmark$BBookmarkFolder == null ? (class$javax$baja$ui$bookmark$BBookmarkFolder = BookmarkUtil.class$("javax.baja.ui.bookmark.BBookmarkFolder")) : class$javax$baja$ui$bookmark$BBookmarkFolder);
            this.root.kids = new Node[bBookmarkFolderArray.length];
            for (int i = 0; i < bBookmarkFolderArray.length; ++i) {
                this.root.kids[i] = new Node(this.root, bBookmarkFolderArray[i]);
            }
            this.root.setExpanded(true);
        }

        public int getRootCount() {
            return 1;
        }

        public TreeNode getRoot(int n) {
            return this.root;
        }
    }
}

