/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.bookmark;

import com.tridium.workbench.bookmark.BBookmarkMenu;
import com.tridium.workbench.bookmark.BookmarkEvents;
import com.tridium.workbench.bookmark.BookmarkUtil;
import com.tridium.workbench.fieldeditors.BOrdFE;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.bookmark.BBookmark;
import javax.baja.ui.bookmark.BBookmarkFolder;
import javax.baja.ui.bookmark.BBookmarkItem;
import javax.baja.ui.bookmark.BBookmarkOptions;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.tree.TreeSubject;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;

public class BBookmarkTree
extends BTree {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$bookmark$BBookmarkTree == null ? (class$com$tridium$workbench$bookmark$BBookmarkTree = BBookmarkTree.class$("com.tridium.workbench.bookmark.BBookmarkTree")) : class$com$tridium$workbench$bookmark$BBookmarkTree));
    private static BModule module = Sys.getModuleForClass((Class)(class$com$tridium$workbench$bookmark$BBookmarkTree == null ? (class$com$tridium$workbench$bookmark$BBookmarkTree = BBookmarkTree.class$("com.tridium.workbench.bookmark.BBookmarkTree")) : class$com$tridium$workbench$bookmark$BBookmarkTree));
    private static Lexicon lex = Lexicon.make((String)"workbench");
    static /* synthetic */ Class class$com$tridium$workbench$bookmark$BBookmarkTree;
    static /* synthetic */ Class class$javax$baja$ui$bookmark$BBookmarkItem;

    public Type getType() {
        return TYPE;
    }

    public BBookmarkTree() {
        BBookmarkOptions bBookmarkOptions = BBookmarkOptions.make();
        this.setModel(new Model(bBookmarkOptions.getRootFolder()));
        this.setController(new Controller());
    }

    public void reload() {
        BBookmarkOptions bBookmarkOptions = BBookmarkOptions.make();
        this.setModel(new Model(bBookmarkOptions.getRootFolder()));
        this.relayout();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Remove
    extends Command {
        private BBookmarkItem item;

        public Remove(BWidget bWidget, BBookmarkItem bBookmarkItem) {
            super(bWidget, module, "bookmark.remove");
            this.item = bBookmarkItem;
        }

        public CommandArtifact doInvoke() {
            if (BDialog.confirm((BWidget)this.getOwner(), (String)lex.getText("bookmark.remove.label"), (Object)lex.getText("bookmark.removePrompt")) == 4) {
                BBookmarkTree.this.getSelection().deselectAll();
                this.item.getParent().asComponent().remove((BComplex)this.item);
                BBookmarkOptions.make().save();
                BookmarkEvents.fireBookmarkChanged();
                BBookmarkTree.this.reload();
            }
            return null;
        }
    }

    private class Edit
    extends Command {
        private BBookmarkItem item;

        public Edit(BWidget bWidget, BBookmarkItem bBookmarkItem) {
            super(bWidget, module, "bookmark.edit");
            this.item = bBookmarkItem;
        }

        public CommandArtifact doInvoke() {
            BBookmarkFolder bBookmarkFolder;
            String string;
            if (this.item instanceof BBookmark) {
                BBookmark bBookmark = (BBookmark)this.item;
                Object[] objectArray = this.doEditBookmark(bBookmark);
                if (objectArray != null) {
                    bBookmark.setText((String)objectArray[0]);
                    bBookmark.setBookmarkOrd((BOrd)objectArray[1]);
                    BBookmarkOptions.make().save();
                    BookmarkEvents.fireBookmarkChanged();
                    BBookmarkTree.this.reload();
                }
            } else if (this.item instanceof BBookmarkFolder && (string = this.doEditFolder(bBookmarkFolder = (BBookmarkFolder)this.item)) != null) {
                bBookmarkFolder.setText(string);
                BBookmarkOptions.make().save();
                BookmarkEvents.fireBookmarkChanged();
                BBookmarkTree.this.reload();
            }
            return null;
        }

        public Object[] doEditBookmark(BBookmark bBookmark) {
            try {
                BTextField bTextField = new BTextField(bBookmark.getText(), 60);
                BOrdFE bOrdFE = new BOrdFE();
                bOrdFE.loadValue((BObject)bBookmark.getBookmarkOrd(), (Context)BFacets.make((String)"ordRelativize", (BIDataValue)BBoolean.FALSE));
                BGridPane bGridPane = new BGridPane(2);
                bGridPane.add(null, (BValue)new BLabel(lex.getText("bookmark.name")));
                bGridPane.add(null, (BValue)bTextField);
                bGridPane.add(null, (BValue)new BLabel(lex.getText("bookmark.ord")));
                bGridPane.add(null, (BValue)bOrdFE);
                if (1 == BDialog.open((BWidget)this.getOwner(), (String)lex.getText("bookmark.edit.label"), (Object)bGridPane, (int)3)) {
                    return new Object[]{bTextField.getText(), bOrdFE.saveValue()};
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return null;
        }

        public String doEditFolder(BBookmarkFolder bBookmarkFolder) {
            BTextField bTextField = new BTextField(bBookmarkFolder.getText(), 30);
            BGridPane bGridPane = new BGridPane(2);
            bGridPane.add(null, (BValue)new BLabel(lex.getText("bookmark.name")));
            bGridPane.add(null, (BValue)bTextField);
            if (1 == BDialog.open((BWidget)this.getOwner(), (String)lex.getText("bookmark.edit.label"), (Object)bGridPane, (int)3)) {
                return bTextField.getText();
            }
            return null;
        }
    }

    class Controller
    extends TreeController {
        Controller() {
        }

        protected void nodeDoubleClicked(BMouseEvent bMouseEvent, TreeNode treeNode) {
            Node node = (Node)treeNode;
            if (node.item instanceof BBookmark) {
                BBookmark bBookmark = (BBookmark)node.item;
                try {
                    BObject bObject = bBookmark.getBookmarkOrd().resolve().get();
                    bBookmark.setIcon(bObject.getIcon());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                BookmarkUtil.open((BWbShell)this.getShell(), bBookmark, bMouseEvent.isControlDown());
            }
        }

        protected BMenu makePopup(TreeSubject treeSubject) {
            Node node = (Node)treeSubject.getActiveNode();
            Node node2 = null;
            if (node != null && !(node.item instanceof BBookmarkFolder)) {
                node2 = (Node)node.getParent();
            }
            BMenu bMenu = new BMenu();
            if (node2 == null) {
                bMenu.add(null, (Command)new BBookmarkMenu.Add((BWidget)this.getTree()));
            } else {
                bMenu.add(null, (Command)new BBookmarkMenu.Add((BWidget)this.getTree(), (BBookmarkFolder)node2.item));
            }
            bMenu.add(null, (Command)new BBookmarkMenu.Manage((BWidget)this.getTree()));
            if (node != null) {
                bMenu.add(null, (BValue)new BSeparator());
                bMenu.add(null, (Command)new Edit((BWidget)this.getTree(), node.item));
                bMenu.add(null, (Command)new Remove((BWidget)this.getTree(), node.item));
            }
            return bMenu;
        }
    }

    class Node
    extends TreeNode {
        BBookmarkItem item;
        Node[] kids;

        public Node(TreeModel treeModel, BBookmarkItem bBookmarkItem) {
            super(treeModel);
            this.item = bBookmarkItem;
            this.load();
        }

        public Node(TreeNode treeNode, BBookmarkItem bBookmarkItem) {
            super(treeNode);
            this.item = bBookmarkItem;
            this.load();
        }

        public void load() {
            BBookmarkItem[] bBookmarkItemArray = (BBookmarkItem[])this.item.getChildren(class$javax$baja$ui$bookmark$BBookmarkItem == null ? (class$javax$baja$ui$bookmark$BBookmarkItem = BBookmarkTree.class$("javax.baja.ui.bookmark.BBookmarkItem")) : class$javax$baja$ui$bookmark$BBookmarkItem);
            this.kids = new Node[bBookmarkItemArray.length];
            for (int i = 0; i < bBookmarkItemArray.length; ++i) {
                this.kids[i] = new Node(this, bBookmarkItemArray[i]);
            }
        }

        public Object getSubject() {
            return this.item;
        }

        public String getText() {
            return this.item.getText();
        }

        public BImage getIcon() {
            return BImage.make((BIcon)this.item.getIcon());
        }

        public int getChildCount() {
            return this.kids.length;
        }

        public TreeNode getChild(int n) {
            return this.kids[n];
        }
    }

    class Model
    extends TreeModel {
        Node[] roots;

        public Model(BBookmarkFolder bBookmarkFolder) {
            BBookmarkItem[] bBookmarkItemArray = (BBookmarkItem[])bBookmarkFolder.getChildren(class$javax$baja$ui$bookmark$BBookmarkItem == null ? (class$javax$baja$ui$bookmark$BBookmarkItem = BBookmarkTree.class$("javax.baja.ui.bookmark.BBookmarkItem")) : class$javax$baja$ui$bookmark$BBookmarkItem);
            this.roots = new Node[bBookmarkItemArray.length];
            for (int i = 0; i < bBookmarkItemArray.length; ++i) {
                this.roots[i] = new Node(this, bBookmarkItemArray[i]);
            }
        }

        public int getRootCount() {
            return this.roots.length;
        }

        public TreeNode getRoot(int n) {
            return this.roots[n];
        }
    }
}

