/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.bookmark;

import com.tridium.workbench.bookmark.BBookmarkManager;
import com.tridium.workbench.bookmark.BFolderSubMenuItem;
import com.tridium.workbench.bookmark.BookmarkEvents;
import com.tridium.workbench.bookmark.BookmarkSpy;
import com.tridium.workbench.bookmark.BookmarkUtil;
import com.tridium.workbench.shell.BViewTab;
import javax.baja.gx.BImage;
import javax.baja.nre.util.Array;
import javax.baja.spy.Spy;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BMenuItem;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.CommandEvent;
import javax.baja.ui.bookmark.BBookmark;
import javax.baja.ui.bookmark.BBookmarkFolder;
import javax.baja.ui.bookmark.BBookmarkOptions;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;

public class BBookmarkMenu
extends BMenu {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$bookmark$BBookmarkMenu == null ? (class$com$tridium$workbench$bookmark$BBookmarkMenu = BBookmarkMenu.class$("com.tridium.workbench.bookmark.BBookmarkMenu")) : class$com$tridium$workbench$bookmark$BBookmarkMenu));
    static /* synthetic */ Class class$com$tridium$workbench$bookmark$BBookmarkMenu;
    static /* synthetic */ Class class$javax$baja$ui$bookmark$BBookmark;

    public Type getType() {
        return TYPE;
    }

    public BBookmarkMenu(String string) {
        super(string);
    }

    public BBookmarkMenu() {
        super(Lexicon.make((String)"workbench").getText("menu.bookmark.label"));
    }

    public void open(BWidget bWidget, double d, double d2) {
        this.removeAll();
        BWidget bWidget2 = this.getParentWidget();
        BViewTab[] bViewTabArray = BookmarkUtil.tabs((BWbShell)bWidget2.getShell());
        AddAll addAll = new AddAll(bWidget2, bViewTabArray);
        addAll.setEnabled(bViewTabArray.length > 1);
        Add add = new Add(bWidget2);
        add.setEnabled(((BWbShell)bWidget2.getShell()).getActiveOrdTarget() != null);
        this.add(null, add);
        this.add(null, addAll);
        this.add(null, new Manage(bWidget2));
        this.add(null, (BValue)new BSeparator());
        BBookmarkOptions bBookmarkOptions = BBookmarkOptions.make();
        BBookmarkFolder bBookmarkFolder = bBookmarkOptions.getRootFolder();
        BComponent[] bComponentArray = bBookmarkFolder.getChildComponents();
        for (int i = 0; i < bComponentArray.length; ++i) {
            if (bComponentArray[i] instanceof BBookmarkFolder) {
                this.addSubMenu(this, (BBookmarkFolder)bComponentArray[i]);
                continue;
            }
            if (!(bComponentArray[i] instanceof BBookmark)) continue;
            this.add(null, new Open(bWidget2, (BBookmark)bComponentArray[i]));
        }
        super.open(bWidget, d, d2);
    }

    private void addSubMenu(BMenu bMenu, BBookmarkFolder bBookmarkFolder) {
        BMenu bMenu2 = new BMenu();
        BComponent[] bComponentArray = bBookmarkFolder.getChildComponents();
        int n = 0;
        for (int i = 0; i < bComponentArray.length; ++i) {
            if (bComponentArray[i] instanceof BBookmarkFolder) {
                this.addSubMenu(bMenu2, (BBookmarkFolder)bComponentArray[i]);
                continue;
            }
            if (!(bComponentArray[i] instanceof BBookmark)) continue;
            ++n;
            bMenu2.add(null, (Command)new Open(this.getParentWidget(), (BBookmark)bComponentArray[i]));
        }
        if (n > 1) {
            bMenu2.reorderToTop(bMenu2.add(null, (BValue)new BSeparator()));
            bMenu2.reorderToTop(bMenu2.add(null, (Command)new OpenInTabs(this.getParentWidget(), bMenu2.getMenuItems())).getPropertyInParent());
        }
        BFolderSubMenuItem bFolderSubMenuItem = new BFolderSubMenuItem(bBookmarkFolder.getText(), bMenu2);
        bFolderSubMenuItem.setImage(BImage.make((BIcon)bBookmarkFolder.getIcon()));
        bMenu.add(null, (BValue)bFolderSubMenuItem);
    }

    private boolean isNewTabOpen(CommandEvent commandEvent) {
        BInputEvent bInputEvent = commandEvent.getInputEvent();
        return commandEvent.isControlDown() || bInputEvent instanceof BMouseEvent && ((BMouseEvent)bInputEvent).isButton2Down();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Spy.ROOT.add("bookmarks", (Spy)new BookmarkSpy());
    }

    class OpenInTabs
    extends Command {
        BMenuItem[] items;

        public OpenInTabs(BWidget bWidget, BMenuItem[] bMenuItemArray) {
            super(bWidget, TYPE.getModule(), "bookmark.openAll");
            this.items = bMenuItemArray;
        }

        public CommandArtifact doInvoke(CommandEvent commandEvent) throws Exception {
            boolean bl = false;
            for (int i = 0; i < this.items.length; ++i) {
                if (!(this.items[i].getCommand() instanceof Open)) continue;
                Open open = (Open)this.items[i].getCommand();
                if (!bl) {
                    bl = true;
                    open.invoke(commandEvent);
                    continue;
                }
                try {
                    BObject bObject = open.mark.getBookmarkOrd().resolve().get();
                    open.mark.setIcon(bObject.getIcon());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                BookmarkUtil.open((BWbShell)this.getShell(), open.mark, true);
            }
            return null;
        }
    }

    class Open
    extends Command {
        BBookmark mark;

        public Open(BWidget bWidget, BBookmark bBookmark) {
            super(bWidget, bBookmark.getText());
            this.mark = bBookmark;
        }

        public BImage getIcon() {
            return BImage.make((BIcon)this.mark.getIcon());
        }

        public CommandArtifact doInvoke(CommandEvent commandEvent) {
            try {
                BObject bObject = this.mark.getBookmarkOrd().resolve().get();
                this.mark.setIcon(bObject.getIcon());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (BBookmarkMenu.this.isNewTabOpen(commandEvent)) {
                BookmarkUtil.open((BWbShell)this.getShell(), this.mark, true);
            } else {
                BookmarkUtil.open((BWbShell)this.getShell(), this.mark);
            }
            return null;
        }
    }

    public static class Manage
    extends Command {
        public Manage(BWidget bWidget) {
            super(bWidget, TYPE.getModule(), "bookmark.manage");
        }

        public CommandArtifact doInvoke() {
            BBookmarkManager.open(this.getOwner());
            return null;
        }
    }

    public static class Add
    extends Command {
        private BBookmarkFolder folder;

        public Add(BWidget bWidget) {
            super(bWidget, TYPE.getModule(), "bookmark.add");
        }

        public Add(BWidget bWidget, BBookmarkFolder bBookmarkFolder) {
            super(bWidget, TYPE.getModule(), "bookmark.add");
            this.folder = bBookmarkFolder;
        }

        public CommandArtifact doInvoke() {
            try {
                BBookmark bBookmark = BookmarkUtil.makeForCurrentContext((BWbShell)this.getShell());
                BBookmarkOptions bBookmarkOptions = BBookmarkOptions.make();
                if (this.folder == null) {
                    BookmarkUtil.add(this.getOwner(), bBookmarkOptions.getRootFolder(), bBookmark);
                } else {
                    BookmarkUtil.add(this.getOwner(), bBookmarkOptions.getRootFolder(), this.folder, bBookmark);
                }
                bBookmarkOptions.save();
                BookmarkEvents.fireBookmarkChanged();
            }
            catch (Exception exception) {
                BDialog.error((BWidget)this.getOwner(), (String)"Error", (Object)"Add failed", (Throwable)exception);
            }
            return null;
        }
    }

    public static class AddAll
    extends Command {
        private BViewTab[] tabs;

        public AddAll(BWidget bWidget, BViewTab[] bViewTabArray) {
            super(bWidget, TYPE.getModule(), "bookmark.addAll");
            this.tabs = bViewTabArray;
        }

        public CommandArtifact doInvoke() throws Exception {
            try {
                Array array = new Array(class$javax$baja$ui$bookmark$BBookmark == null ? (class$javax$baja$ui$bookmark$BBookmark = BBookmarkMenu.class$("javax.baja.ui.bookmark.BBookmark")) : class$javax$baja$ui$bookmark$BBookmark);
                for (int i = 0; i < this.tabs.length; ++i) {
                    if (this.tabs[i].getTarget() == null) continue;
                    array.add((Object)BookmarkUtil.makeForTab(this.tabs[i]));
                }
                BBookmark[] bBookmarkArray = (BBookmark[])array.trim();
                BBookmarkOptions bBookmarkOptions = BBookmarkOptions.make();
                BookmarkUtil.add(this.getOwner(), bBookmarkOptions.getRootFolder(), bBookmarkArray);
                bBookmarkOptions.save();
                BookmarkEvents.fireBookmarkChanged();
            }
            catch (Exception exception) {
                BDialog.error((BWidget)this.getOwner(), (String)"Error", (Object)"Add failed", (Throwable)exception);
            }
            return null;
        }
    }
}

