/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.bookmark;

import com.tridium.workbench.bookmark.BBookmarkTable;
import com.tridium.workbench.bookmark.BookmarkEvents;
import com.tridium.workbench.bookmark.BookmarkUtil;
import com.tridium.workbench.fieldeditors.BOrdFE;
import java.util.ArrayList;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.bookmark.BBookmark;
import javax.baja.ui.bookmark.BBookmarkFolder;
import javax.baja.ui.bookmark.BBookmarkItem;
import javax.baja.ui.bookmark.BBookmarkOptions;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.treetable.TreeTableController;
import javax.baja.ui.treetable.TreeTableModel;
import javax.baja.ui.treetable.TreeTableNode;
import javax.baja.ui.treetable.TreeTableSelection;
import javax.baja.ui.treetable.TreeTableSubject;
import javax.baja.util.Lexicon;

public class BBookmarkManager
extends BEdgePane {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$bookmark$BBookmarkManager == null ? (class$com$tridium$workbench$bookmark$BBookmarkManager = BBookmarkManager.class$("com.tridium.workbench.bookmark.BBookmarkManager")) : class$com$tridium$workbench$bookmark$BBookmarkManager));
    private static BModule module = Sys.getModuleForClass((Class)(class$com$tridium$workbench$bookmark$BBookmarkManager == null ? (class$com$tridium$workbench$bookmark$BBookmarkManager = BBookmarkManager.class$("com.tridium.workbench.bookmark.BBookmarkManager")) : class$com$tridium$workbench$bookmark$BBookmarkManager));
    final Lexicon lex = Lexicon.make((String)"workbench");
    private BBookmarkOptions options;
    private BBookmarkTable table;
    private NewFolder newFolder;
    private Add add;
    private CopyTo copyTo;
    private MoveTo moveTo;
    private Edit edit;
    private Remove remove;
    private MoveUp moveUp;
    private MoveDown moveDown;
    private boolean modifyOptions;
    static /* synthetic */ Class class$com$tridium$workbench$bookmark$BBookmarkManager;

    public Type getType() {
        return TYPE;
    }

    public static void open(BWidget bWidget) {
        BBookmarkOptions bBookmarkOptions = BBookmarkOptions.make();
        BBookmarkOptions bBookmarkOptions2 = (BBookmarkOptions)bBookmarkOptions.newCopy();
        BBookmarkManager bBookmarkManager = new BBookmarkManager(bBookmarkOptions2, false);
        BBorderPane bBorderPane = new BBorderPane((BWidget)bBookmarkManager);
        if (1 == BDialog.open((BWidget)bWidget, (String)Lexicon.make((String)"workbench").getText("bookmark.manage.label"), (Object)bBorderPane, (int)3)) {
            bBookmarkOptions.getRootFolder().removeAll();
            BBookmarkManager.copy((BBookmarkItem)bBookmarkOptions.getRootFolder(), bBookmarkOptions2.getRootFolder().getChildComponents());
            bBookmarkOptions.save();
            BookmarkEvents.fireBookmarkChanged();
        }
    }

    private static void copy(BBookmarkItem bBookmarkItem, BComponent[] bComponentArray) {
        for (int i = 0; i < bComponentArray.length; ++i) {
            BBookmarkItem bBookmarkItem2 = (BBookmarkItem)bComponentArray[i];
            BBookmark bBookmark = null;
            if (bComponentArray[i] instanceof BBookmark) {
                bBookmark = new BBookmark();
                bBookmark.setBookmarkOrd(((BBookmark)bBookmarkItem2).getBookmarkOrd());
            } else if (bComponentArray[i] instanceof BBookmarkFolder) {
                bBookmark = new BBookmarkFolder();
                BBookmarkManager.copy((BBookmarkItem)bBookmark, bBookmarkItem2.getChildComponents());
            }
            if (bBookmark == null) continue;
            bBookmark.setText(bBookmarkItem2.getText());
            bBookmark.setIconOrd(bBookmarkItem2.getIconOrd());
            bBookmarkItem.add(bBookmarkItem2.getName(), (BValue)bBookmark);
        }
    }

    public BBookmarkManager() {
        throw new IllegalStateException();
    }

    public BBookmarkManager(BBookmarkOptions bBookmarkOptions) {
        this(bBookmarkOptions, true);
    }

    private BBookmarkManager(BBookmarkOptions bBookmarkOptions, boolean bl) {
        this.options = bBookmarkOptions;
        this.modifyOptions = bl;
        this.table = new BBookmarkTable(bBookmarkOptions.getRootFolder());
        this.table.setMultipleSelection(true);
        this.table.setSelection((TableSelection)new Selection());
        this.table.setController((TableController)new Controller());
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.setValign(BValign.top);
        bGridPane.setColumnAlign(BHalign.fill);
        this.newFolder = new NewFolder((BWidget)this);
        bGridPane.add(null, (BValue)BBookmarkManager.newButton(this.newFolder));
        this.add = new Add((BWidget)this);
        bGridPane.add(null, (BValue)BBookmarkManager.newButton(this.add));
        bGridPane.add(null, (BValue)new BBorderPane((BWidget)new BNullWidget(), 10.0, 0.0, 0.0, 0.0));
        this.copyTo = new CopyTo((BWidget)this);
        bGridPane.add(null, (BValue)BBookmarkManager.newButton(this.copyTo));
        this.moveTo = new MoveTo((BWidget)this);
        bGridPane.add(null, (BValue)BBookmarkManager.newButton(this.moveTo));
        this.remove = new Remove((BWidget)this);
        bGridPane.add(null, (BValue)BBookmarkManager.newButton(this.remove));
        bGridPane.add(null, (BValue)new BBorderPane((BWidget)new BNullWidget(), 10.0, 0.0, 0.0, 0.0));
        this.edit = new Edit((BWidget)this);
        bGridPane.add(null, (BValue)BBookmarkManager.newButton(this.edit));
        this.moveUp = new MoveUp((BWidget)this);
        bGridPane.add(null, (BValue)BBookmarkManager.newButton(this.moveUp));
        this.moveDown = new MoveDown((BWidget)this);
        bGridPane.add(null, (BValue)BBookmarkManager.newButton(this.moveDown));
        BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)new BBorderPane((BWidget)this.table, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        bConstrainedPane.setMinWidth(500.0);
        bConstrainedPane.setMaxWidth(500.0);
        bConstrainedPane.setMinHeight(350.0);
        bConstrainedPane.setMaxHeight(350.0);
        this.setCenter((BWidget)bConstrainedPane);
        this.setRight((BWidget)new BBorderPane((BWidget)bGridPane, 0.0, 0.0, 0.0, 10.0));
        this.table.getTreeTableModel().getRoot(0).setExpanded(true);
    }

    static BButton newButton(Command command) {
        BButton bButton = new BButton(command, true, true);
        bButton.setHalign(BHalign.left);
        return bButton;
    }

    Property[] getDynamicProperties(BComponent bComponent) {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        SlotCursor slotCursor = bComponent.loadSlots().getProperties();
        while (slotCursor.next()) {
            Property property = slotCursor.property();
            if (Flags.isHidden((BComplex)bComponent, (Slot)property) || property.isFrozen()) continue;
            arrayList.add(property);
        }
        return arrayList.toArray(new Property[arrayList.size()]);
    }

    TreeTableNode findNode(BComponent bComponent) {
        TreeTableModel treeTableModel = this.table.getTreeTableModel();
        for (int i = 0; i < treeTableModel.getRootCount(); ++i) {
            TreeTableNode treeTableNode = this.findNode(treeTableModel.getRoot(i), bComponent);
            if (treeTableNode == null) continue;
            return treeTableNode;
        }
        return null;
    }

    TreeTableNode findNode(TreeTableNode treeTableNode, BComponent bComponent) {
        if (bComponent == ((BBookmarkTable.Node)treeTableNode).item) {
            return treeTableNode;
        }
        for (int i = 0; i < treeTableNode.getChildCount(); ++i) {
            TreeTableNode treeTableNode2 = this.findNode(treeTableNode.getChild(i), bComponent);
            if (treeTableNode2 == null) continue;
            return treeTableNode2;
        }
        return null;
    }

    BBookmarkFolder getRootFolder(BComponent bComponent) {
        BComponent bComponent2 = bComponent;
        while (!(bComponent2.getParent() instanceof BBookmarkOptions)) {
            bComponent2 = bComponent2.getParent().asComponent();
        }
        return (BBookmarkFolder)bComponent2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class MoveDown
    extends Command {
        public MoveDown(BWidget bWidget) {
            super(bWidget, module, "bookmark.moveDown");
        }

        public CommandArtifact doInvoke() {
            int n;
            TreeTableModel treeTableModel = BBookmarkManager.this.table.getTreeTableModel();
            TableSelection tableSelection = BBookmarkManager.this.table.getSelection();
            int[] nArray = tableSelection.getRows();
            BBookmarkTable.Node node = (BBookmarkTable.Node)treeTableModel.rowToNode(nArray[0]);
            BComponent bComponent = node.item.getParent().asComponent();
            ArrayList<TreeTableNode> arrayList = new ArrayList<TreeTableNode>();
            tableSelection.deselectAll();
            Property[] propertyArray = BBookmarkManager.this.getDynamicProperties(bComponent);
            int n2 = propertyArray.length - 1;
            for (n = nArray.length - 1; n >= 0; --n) {
                TreeTableNode treeTableNode = treeTableModel.rowToNode(nArray[n]);
                int n3 = node.getParent().getChildIndex(treeTableNode);
                arrayList.add(treeTableNode);
                if (n3 == n2) {
                    --n2;
                    continue;
                }
                Property property = propertyArray[n3 + 1];
                propertyArray[n3 + 1] = propertyArray[n3];
                propertyArray[n3] = property;
            }
            bComponent.reorder(propertyArray);
            if (BBookmarkManager.this.modifyOptions) {
                BBookmarkManager.this.options.save();
            }
            treeTableModel.updateTreeTable(false);
            for (n = 0; n < arrayList.size(); ++n) {
                int n4 = treeTableModel.nodeToRow((TreeTableNode)arrayList.get(n));
                tableSelection.select(n4);
            }
            return null;
        }
    }

    private class MoveUp
    extends Command {
        public MoveUp(BWidget bWidget) {
            super(bWidget, module, "bookmark.moveUp");
        }

        public CommandArtifact doInvoke() {
            int n;
            TreeTableModel treeTableModel = BBookmarkManager.this.table.getTreeTableModel();
            TableSelection tableSelection = BBookmarkManager.this.table.getSelection();
            int[] nArray = tableSelection.getRows();
            BBookmarkTable.Node node = (BBookmarkTable.Node)treeTableModel.rowToNode(nArray[0]);
            BComponent bComponent = node.item.getParent().asComponent();
            ArrayList<TreeTableNode> arrayList = new ArrayList<TreeTableNode>();
            int n2 = 0;
            tableSelection.deselectAll();
            Property[] propertyArray = BBookmarkManager.this.getDynamicProperties(bComponent);
            for (n = 0; n < nArray.length; ++n) {
                TreeTableNode treeTableNode = treeTableModel.rowToNode(nArray[n]);
                int n3 = node.getParent().getChildIndex(treeTableNode);
                arrayList.add(treeTableNode);
                if (n3 == n2) {
                    ++n2;
                    continue;
                }
                Property property = propertyArray[n3 - 1];
                propertyArray[n3 - 1] = propertyArray[n3];
                propertyArray[n3] = property;
            }
            bComponent.reorder(propertyArray);
            if (BBookmarkManager.this.modifyOptions) {
                BBookmarkManager.this.options.save();
            }
            treeTableModel.updateTreeTable(false);
            for (n = 0; n < arrayList.size(); ++n) {
                int n4 = treeTableModel.nodeToRow((TreeTableNode)arrayList.get(n));
                tableSelection.select(n4);
            }
            return null;
        }
    }

    private class Remove
    extends Command {
        public Remove(BWidget bWidget) {
            super(bWidget, module, "bookmark.remove");
        }

        public CommandArtifact doInvoke() {
            int[] nArray = BBookmarkManager.this.table.getSelection().getRows();
            for (int i = 0; i < nArray.length; ++i) {
                BBookmarkTable.Node node = (BBookmarkTable.Node)BBookmarkManager.this.table.getTreeTableModel().rowToNode(nArray[i]);
                node.item.getParent().asComponent().remove((BComplex)node.item);
            }
            BBookmarkManager.this.table.getSelection().deselectAll();
            if (BBookmarkManager.this.modifyOptions) {
                BBookmarkManager.this.options.save();
            }
            BBookmarkManager.this.table.getTreeTableModel().updateTreeTable(true);
            return null;
        }
    }

    private class Edit
    extends Command {
        public Edit(BWidget bWidget) {
            super(bWidget, module, "bookmark.edit");
        }

        public CommandArtifact doInvoke() {
            BBookmarkFolder bBookmarkFolder;
            String string;
            int n = BBookmarkManager.this.table.getSelection().getRow();
            BBookmarkTable.Node node = (BBookmarkTable.Node)BBookmarkManager.this.table.getTreeTableModel().rowToNode(n);
            if (node.item instanceof BBookmark) {
                BBookmark bBookmark = (BBookmark)node.item;
                Object[] objectArray = this.doEditBookmark(bBookmark);
                if (objectArray != null) {
                    bBookmark.setText((String)objectArray[0]);
                    bBookmark.setBookmarkOrd((BOrd)objectArray[1]);
                    node.load();
                    if (BBookmarkManager.this.modifyOptions) {
                        BBookmarkManager.this.options.save();
                    }
                    BBookmarkManager.this.table.getTreeTableModel().updateTreeTable(true);
                }
            } else if (node.item instanceof BBookmarkFolder && (string = this.doEditFolder(bBookmarkFolder = (BBookmarkFolder)node.item)) != null) {
                bBookmarkFolder.setText(string);
                node.load();
                if (BBookmarkManager.this.modifyOptions) {
                    BBookmarkManager.this.options.save();
                }
                BBookmarkManager.this.table.getTreeTableModel().updateTreeTable(true);
            }
            return null;
        }

        public Object[] doEditBookmark(BBookmark bBookmark) {
            try {
                BTextField bTextField = new BTextField(bBookmark.getText(), 60);
                BOrdFE bOrdFE = new BOrdFE();
                bOrdFE.loadValue((BObject)bBookmark.getBookmarkOrd(), (Context)BFacets.make((String)"ordRelativize", (BIDataValue)BBoolean.FALSE));
                BGridPane bGridPane = new BGridPane(2);
                bGridPane.add(null, (BValue)new BLabel(BBookmarkManager.this.lex.getText("bookmark.name")));
                bGridPane.add(null, (BValue)bTextField);
                bGridPane.add(null, (BValue)new BLabel(BBookmarkManager.this.lex.getText("bookmark.ord")));
                bGridPane.add(null, (BValue)bOrdFE);
                if (1 == BDialog.open((BWidget)this.getOwner(), (String)BBookmarkManager.this.lex.getText("bookmark.edit.label"), (Object)bGridPane, (int)3)) {
                    return new Object[]{bTextField.getText(), bOrdFE.saveValue()};
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return null;
        }

        public String doEditFolder(BBookmarkFolder bBookmarkFolder) {
            BTextField bTextField = new BTextField(bBookmarkFolder.getText(), 30);
            BGridPane bGridPane = new BGridPane(2);
            bGridPane.add(null, (BValue)new BLabel(BBookmarkManager.this.lex.getText("bookmark.name")));
            bGridPane.add(null, (BValue)bTextField);
            if (1 == BDialog.open((BWidget)this.getOwner(), (String)BBookmarkManager.this.lex.getText("bookmark.edit.label"), (Object)bGridPane, (int)3)) {
                return bTextField.getText();
            }
            return null;
        }
    }

    private class MoveTo
    extends Command {
        public MoveTo(BWidget bWidget) {
            super(bWidget, module, "bookmark.moveTo");
        }

        public CommandArtifact doInvoke() {
            BBookmarkTable.Node node;
            TreeTableModel treeTableModel = BBookmarkManager.this.table.getTreeTableModel();
            TableSelection tableSelection = BBookmarkManager.this.table.getSelection();
            int[] nArray = tableSelection.getRows();
            BComponent[] bComponentArray = new BComponent[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                node = (BBookmarkTable.Node)treeTableModel.rowToNode(nArray[i]);
                bComponentArray[i] = node.item;
            }
            BBookmarkFolder bBookmarkFolder = BookmarkUtil.move(this.getOwner(), BBookmarkManager.this.getRootFolder(bComponentArray[0]), bComponentArray);
            if (bBookmarkFolder != null) {
                if (BBookmarkManager.this.modifyOptions) {
                    BBookmarkManager.this.options.save();
                }
                treeTableModel.updateTreeTable(true);
                for (BBookmarkTable.Node node2 = node = BBookmarkManager.this.findNode((BComponent)bBookmarkFolder); node2 != null; node2 = node2.getParent()) {
                    node2.setExpanded(true);
                }
                tableSelection.deselectAll();
                bBookmarkFolder.loadSlots();
                int n = bBookmarkFolder.getChildComponents().length - bComponentArray.length;
                for (int i = 0; i < bComponentArray.length; ++i) {
                    TreeTableNode treeTableNode = node.getChild(n + i);
                    tableSelection.select(treeTableModel.nodeToRow(treeTableNode));
                }
            }
            return null;
        }
    }

    private class CopyTo
    extends Command {
        public CopyTo(BWidget bWidget) {
            super(bWidget, module, "bookmark.copyTo");
        }

        public CommandArtifact doInvoke() {
            BBookmarkTable.Node node;
            TreeTableModel treeTableModel = BBookmarkManager.this.table.getTreeTableModel();
            TableSelection tableSelection = BBookmarkManager.this.table.getSelection();
            int[] nArray = tableSelection.getRows();
            BComponent[] bComponentArray = new BComponent[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                node = (BBookmarkTable.Node)treeTableModel.rowToNode(nArray[i]);
                bComponentArray[i] = node.item;
            }
            BBookmarkFolder bBookmarkFolder = BookmarkUtil.copy(this.getOwner(), BBookmarkManager.this.getRootFolder(bComponentArray[0]), bComponentArray);
            if (bBookmarkFolder != null) {
                if (BBookmarkManager.this.modifyOptions) {
                    BBookmarkManager.this.options.save();
                }
                treeTableModel.updateTreeTable(true);
                for (BBookmarkTable.Node node2 = node = BBookmarkManager.this.findNode((BComponent)bBookmarkFolder); node2 != null; node2 = node2.getParent()) {
                    node2.setExpanded(true);
                }
                tableSelection.deselectAll();
                bBookmarkFolder.loadSlots();
                int n = bBookmarkFolder.getChildComponents().length - bComponentArray.length;
                for (int i = 0; i < bComponentArray.length; ++i) {
                    TreeTableNode treeTableNode = node.getChild(n + i);
                    tableSelection.select(treeTableModel.nodeToRow(treeTableNode));
                }
            }
            return null;
        }
    }

    private class Add
    extends Command {
        public Add(BWidget bWidget) {
            super(bWidget, module, "bookmark.manage.add");
        }

        public CommandArtifact doInvoke() {
            TreeTableModel treeTableModel = BBookmarkManager.this.table.getTreeTableModel();
            TableSelection tableSelection = BBookmarkManager.this.table.getSelection();
            int n = tableSelection.getRow();
            BBookmarkTable.Node node = (BBookmarkTable.Node)treeTableModel.rowToNode(n);
            BBookmark bBookmark = new BBookmark();
            Object[] objectArray = new Edit(this.getOwner()).doEditBookmark(bBookmark);
            if (objectArray != null) {
                bBookmark.setText((String)objectArray[0]);
                bBookmark.setBookmarkOrd((BOrd)objectArray[1]);
                node.item.add(null, (BValue)bBookmark);
                if (BBookmarkManager.this.modifyOptions) {
                    BBookmarkManager.this.options.save();
                }
                node.setExpanded(true);
                treeTableModel.updateTreeTable(true);
            }
            return null;
        }
    }

    private class NewFolder
    extends Command {
        public NewFolder(BWidget bWidget) {
            super(bWidget, module, "bookmark.manage.newFolder");
        }

        public CommandArtifact doInvoke() {
            TreeTableModel treeTableModel = BBookmarkManager.this.table.getTreeTableModel();
            TableSelection tableSelection = BBookmarkManager.this.table.getSelection();
            int n = tableSelection.getRow();
            BBookmarkTable.Node node = (BBookmarkTable.Node)treeTableModel.rowToNode(n);
            BBookmarkFolder bBookmarkFolder = new BBookmarkFolder();
            String string = new Edit(this.getOwner()).doEditFolder(bBookmarkFolder);
            if (string != null) {
                bBookmarkFolder.setText(string);
                node.item.add(null, (BValue)bBookmarkFolder);
                if (BBookmarkManager.this.modifyOptions) {
                    BBookmarkManager.this.options.save();
                }
                node.setExpanded(true);
                treeTableModel.updateTreeTable(true);
                tableSelection.deselectAll();
                tableSelection.select(treeTableModel.nodeToRow(BBookmarkManager.this.findNode(node, (BComponent)bBookmarkFolder)));
            }
            return null;
        }
    }

    private class Controller
    extends TreeTableController {
        private Controller() {
        }

        protected void cellDoubleClicked(BMouseEvent bMouseEvent, int n, int n2) {
            BBookmarkManager.this.edit.invoke();
        }

        public void keyPressed(BKeyEvent bKeyEvent) {
            super.keyPressed(bKeyEvent);
            if (bKeyEvent.getKeyCode() == 127) {
                bKeyEvent.consume();
                if (BBookmarkManager.this.remove.isEnabled()) {
                    BBookmarkManager.this.remove.invoke();
                }
            }
        }

        protected BMenu makePopup(TreeTableSubject treeTableSubject) {
            BMenu bMenu = new BMenu();
            bMenu.add(null, (Command)BBookmarkManager.this.newFolder);
            bMenu.add(null, (Command)BBookmarkManager.this.add);
            bMenu.add(null, (BValue)new BSeparator());
            bMenu.add(null, (Command)BBookmarkManager.this.copyTo);
            bMenu.add(null, (Command)BBookmarkManager.this.moveTo);
            bMenu.add(null, (Command)BBookmarkManager.this.remove);
            bMenu.add(null, (BValue)new BSeparator());
            bMenu.add(null, (Command)BBookmarkManager.this.edit);
            bMenu.add(null, (Command)BBookmarkManager.this.moveUp);
            bMenu.add(null, (Command)BBookmarkManager.this.moveDown);
            return bMenu;
        }
    }

    private class Selection
    extends TreeTableSelection {
        private Selection() {
        }

        public void updateTable() {
            boolean bl;
            super.updateTable();
            int[] nArray = this.getRows();
            boolean bl2 = nArray.length == 1;
            boolean bl3 = bl = nArray.length > 0;
            boolean bl4 = false;
            boolean bl5 = false;
            if (nArray.length > 0) {
                TreeTableNode treeTableNode = BBookmarkManager.this.table.getTreeTableModel().rowToNode(nArray[0]);
                TreeTableNode treeTableNode2 = treeTableNode.getParent();
                boolean bl6 = bl5 = !(((BBookmarkTable.Node)treeTableNode).item instanceof BBookmark);
                if (treeTableNode2 == null) {
                    bl4 = true;
                } else {
                    for (int i = 1; i < nArray.length; ++i) {
                        treeTableNode = BBookmarkManager.this.table.getTreeTableModel().rowToNode(nArray[i]);
                        if (treeTableNode2 == treeTableNode.getParent()) continue;
                        bl3 = false;
                        break;
                    }
                }
            }
            BBookmarkManager.this.newFolder.setEnabled(bl2 && bl5);
            BBookmarkManager.this.add.setEnabled(bl2 && bl5);
            BBookmarkManager.this.copyTo.setEnabled(!bl4 && bl3);
            BBookmarkManager.this.moveTo.setEnabled(!bl4 && bl3);
            BBookmarkManager.this.edit.setEnabled(!bl4 && bl2);
            BBookmarkManager.this.remove.setEnabled(!bl4 && bl);
            BBookmarkManager.this.moveUp.setEnabled(!bl4 && bl3);
            BBookmarkManager.this.moveDown.setEnabled(!bl4 && bl3);
        }
    }
}

