/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.auth;

import com.tridium.workbench.auth.AuthUtil;
import com.tridium.workbench.shell.BGeneralOptions;
import com.tridium.workbench.shell.WbMain;
import java.io.File;
import java.util.HashMap;
import javax.baja.nre.util.Base64;
import javax.baja.security.BICredentials;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.util.BTypeSpec;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XWriter;

public class CredentialsList {
    public static final CredentialsList INSTANCE = new CredentialsList(new File(Sys.getCredentialsHome(), "credentials.xml"));
    File file;
    private HashMap map = new HashMap();
    private BGeneralOptions gopt = BGeneralOptions.make();

    public CredentialsList(File file) {
        this.file = file;
    }

    public CredentialsList(CredentialsList credentialsList) {
        this.copyFrom(credentialsList);
    }

    public BICredentials lookup(String string) {
        if (WbMain.isKiosk()) {
            return null;
        }
        if (!this.gopt.getAllowUserCredentialCaching()) {
            return null;
        }
        BValue bValue = (BValue)this.map.get(string);
        if (bValue == null) {
            return null;
        }
        return (BICredentials)bValue.newCopy();
    }

    public String[] keys() {
        return this.map.keySet().toArray(new String[this.map.size()]);
    }

    public void put(String string, BICredentials bICredentials) {
        this.map.put(string, ((BValue)bICredentials).newCopy());
    }

    public void remove(String string) {
        this.map.remove(string);
    }

    public void clear() {
        this.map.clear();
    }

    public void copyFrom(CredentialsList credentialsList) {
        this.map = (HashMap)credentialsList.map.clone();
    }

    public void load() throws Exception {
        this.map.clear();
        if (!this.file.exists()) {
            return;
        }
        XElem xElem = XParser.make((File)this.file).parse();
        XElem[] xElemArray = xElem.elems("entry");
        for (int i = 0; i < xElemArray.length; ++i) {
            XElem xElem2 = xElemArray[i];
            String string = xElem2.get("realm");
            BICredentials bICredentials = (BICredentials)BTypeSpec.make((String)xElem2.get("type")).getInstance();
            byte[] byArray = Base64.decode((String)xElem2.get("value"));
            bICredentials = bICredentials.decodeCredentials(byArray);
            this.put(string, bICredentials);
        }
    }

    public void save() throws Exception {
        if (!this.gopt.getAllowUserCredentialCaching()) {
            return;
        }
        XWriter xWriter = new XWriter(this.file);
        xWriter.w((Object)"<credentials>\n");
        String[] stringArray = this.keys();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            BICredentials bICredentials = this.lookup(string);
            xWriter.w((Object)" <entry").attr(" realm", string).attr(" type", bICredentials.asObject().getType().toString()).attr(" value", Base64.encode((byte[])bICredentials.encodeCredentials())).w((Object)"/>\n");
        }
        xWriter.w((Object)"</credentials>\n");
        xWriter.close();
    }

    static {
        try {
            INSTANCE.load();
        }
        catch (Exception exception) {
            AuthUtil.log.error("Cannot load credentials list", (Throwable)exception);
        }
    }
}

