/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.auth;

import com.tridium.workbench.auth.CredentialsList;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.SortUtil;
import javax.baja.security.BICredentials;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.commands.ReflectCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.BWbShell;

public class BCredentialsManager
extends BEdgePane {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$auth$BCredentialsManager == null ? (class$com$tridium$workbench$auth$BCredentialsManager = BCredentialsManager.class$("com.tridium.workbench.auth.BCredentialsManager")) : class$com$tridium$workbench$auth$BCredentialsManager));
    static final BImage icon = BImage.make((String)"module://icons/x16/keys.png");
    static final int COL_REALM = 0;
    static final int COL_CREDENTIALS = 1;
    static final int COL_TYPE = 2;
    final UiLexicon lex = UiLexicon.bajaui();
    final String LEX_REALM = this.lex.getText("auth.realmName");
    final String LEX_TYPE = this.lex.getText("auth.type");
    final String LEX_CREDENTIALS = this.lex.getText("auth.credentials");
    final String LEX_REMOVE = this.lex.getText("auth.credentialsManager.remove");
    final String LEX_REMOVE_ALL = this.lex.getText("auth.credentialsManager.removeAll");
    final String LEX_RESET = this.lex.getText("auth.credentialsManager.reset");
    final String LEX_OPEN = this.lex.getText("auth.credentialsManager.open");
    BWidget owner;
    CredentialsList orig;
    CredentialsList list;
    BTable table;
    Row[] rows = new Row[0];
    Command remove;
    Command removeAll;
    Command reset;
    Command open;
    static /* synthetic */ Class class$com$tridium$workbench$auth$BCredentialsManager;

    public Type getType() {
        return TYPE;
    }

    public BCredentialsManager() {
        throw new IllegalStateException();
    }

    public BCredentialsManager(BWidget bWidget, CredentialsList credentialsList) {
        this.owner = bWidget;
        this.list = credentialsList;
        this.orig = new CredentialsList(credentialsList);
        this.table = new BTable((TableModel)new Model(), (TableController)new Controller());
        this.table.setSelection((TableSelection)new Selection());
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.setValign(BValign.top);
        bGridPane.setColumnAlign(BHalign.fill);
        this.reset = new ReflectCommand((BWidget)this, this.LEX_RESET, "cmdReset");
        bGridPane.add(null, (BValue)new BButton(this.reset));
        this.remove = new ReflectCommand((BWidget)this, this.LEX_REMOVE, "cmdRemove");
        bGridPane.add(null, (BValue)new BButton(this.remove));
        this.removeAll = new ReflectCommand((BWidget)this, this.LEX_REMOVE_ALL, "cmdRemoveAll");
        bGridPane.add(null, (BValue)new BButton(this.removeAll));
        this.open = new ReflectCommand((BWidget)this, this.LEX_OPEN, "cmdOpen");
        bGridPane.add(null, (BValue)new BButton(this.open));
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setCenter((BWidget)new BBorderPane((BWidget)this.table, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        bEdgePane.setRight((BWidget)new BBorderPane((BWidget)bGridPane, 0.0, 0.0, 0.0, 10.0));
        this.setCenter((BWidget)new BBorderPane((BWidget)bEdgePane));
        this.updateRows();
        this.updateCommands();
        this.table.sortByColumn(0, true);
    }

    public void computePreferredSize() {
        this.setPreferredSize(550.0, 220.0);
    }

    public void updateCommands() {
        int n = this.table.getSelection().getRows().length;
        this.remove.setEnabled(n > 0);
        this.removeAll.setEnabled(this.rows.length > 0);
        this.open.setEnabled(n == 1);
    }

    public void cmdRemove() {
        int[] nArray = this.table.getSelection().getRows();
        for (int i = 0; i < nArray.length; ++i) {
            Row row = this.rows[nArray[i]];
            this.list.remove(row.realm);
        }
        this.updateRows();
        this.relayout();
    }

    public void cmdRemoveAll() {
        this.list.clear();
        this.updateRows();
        this.relayout();
    }

    public void cmdReset() {
        this.list.copyFrom(this.orig);
        this.updateRows();
        this.relayout();
    }

    public void cmdOpen() {
        int[] nArray = this.table.getSelection().getRows();
        if (nArray.length < 1) {
            return;
        }
        Row row = this.rows[nArray[0]];
        BOrd bOrd = null;
        try {
            bOrd = BOrd.make((String)row.realm);
            bOrd.parse();
        }
        catch (Exception exception) {
            BDialog.error((BWidget)this, (Object)("Realm does not map to an ord: " + row.realm));
            return;
        }
        BDialog bDialog = (BDialog)this.getShell();
        bDialog.close();
        BWbShell bWbShell = (BWbShell)this.owner.getShell();
        bWbShell.hyperlink(bOrd);
    }

    public void updateRows() {
        String[] stringArray = this.list.keys();
        this.rows = new Row[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.rows[i] = new Row(stringArray[i], this.list.lookup(stringArray[i]));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class Row {
        String realm;
        BICredentials credentials;
        String type;
        String summary;

        Row(String string, BICredentials bICredentials) {
            try {
                this.realm = string;
                this.credentials = bICredentials;
                this.type = bICredentials.getType().toString();
                this.summary = bICredentials instanceof BUsernameAndPassword ? ((BUsernameAndPassword)bICredentials).getUsername() : bICredentials.toString();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public Object getSortKey(int n) {
            switch (n) {
                case 0: {
                    return this.realm;
                }
                case 2: {
                    return this.type;
                }
                case 1: {
                    return this.summary;
                }
            }
            throw new IllegalStateException();
        }
    }

    class Model
    extends TableModel {
        Model() {
        }

        public int getRowCount() {
            return BCredentialsManager.this.rows.length;
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return BCredentialsManager.this.LEX_REALM;
                }
                case 1: {
                    return BCredentialsManager.this.LEX_CREDENTIALS;
                }
                case 2: {
                    return BCredentialsManager.this.LEX_TYPE;
                }
            }
            return "?";
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return BCredentialsManager.this.rows[n].realm;
                }
                case 1: {
                    return BCredentialsManager.this.rows[n].summary;
                }
                case 2: {
                    return BCredentialsManager.this.rows[n].type;
                }
            }
            return "?";
        }

        public Object getSubject(int n) {
            return BCredentialsManager.this.rows[n];
        }

        public boolean isColumnSortable(int n) {
            return true;
        }

        public void sortByColumn(int n, boolean bl) {
            Object[] objectArray = new Object[BCredentialsManager.this.rows.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = BCredentialsManager.this.rows[i].getSortKey(n);
            }
            SortUtil.sort((Object[])objectArray, (Object[])BCredentialsManager.this.rows, (boolean)bl);
        }

        public BImage getRowIcon(int n) {
            return icon;
        }
    }

    class Controller
    extends TableController {
        Controller() {
        }

        public void keyPressed(BKeyEvent bKeyEvent) {
            if (bKeyEvent.getKeyCode() == 10) {
                bKeyEvent.consume();
                BCredentialsManager.this.cmdOpen();
            } else if (bKeyEvent.getKeyCode() == 127) {
                bKeyEvent.consume();
                BCredentialsManager.this.cmdRemove();
            }
            super.keyPressed(bKeyEvent);
        }

        public void cellDoubleClicked(BMouseEvent bMouseEvent, int n, int n2) {
            super.cellDoubleClicked(bMouseEvent, n, n2);
            BCredentialsManager.this.cmdOpen();
        }
    }

    class Selection
    extends TableSelection {
        Selection() {
        }

        public void updateTable() {
            super.updateTable();
            BCredentialsManager.this.updateCommands();
        }
    }
}

