/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.auth;

import com.tridium.workbench.auth.AuthUtil;
import com.tridium.workbench.auth.BCredentialsEditor;
import com.tridium.workbench.auth.BDeviceCnxType;
import com.tridium.workbench.auth.BHostCnxHandler;
import com.tridium.workbench.auth.BPlatformCnxType;
import com.tridium.workbench.auth.BStationCnxType;
import com.tridium.workbench.nav.BSessionAgent;
import com.tridium.workbench.shell.BGeneralOptions;
import com.tridium.workbench.shell.BNiagaraWbShell;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.agent.BIAgent;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.registry.TypeInfo;
import javax.baja.security.BICredentials;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public abstract class BCnxHandler
extends BComponent
implements BIAgent {
    public static final Action saveCnx = BCnxHandler.newAction((int)0, null);
    public static final Action clearCnx = BCnxHandler.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$auth$BCnxHandler == null ? (class$com$tridium$workbench$auth$BCnxHandler = BCnxHandler.class$("com.tridium.workbench.auth.BCnxHandler")) : class$com$tridium$workbench$auth$BCnxHandler));
    public static final String LEX_DESC_FIELD = ".description";
    public static final String LEX_TITLE_FIELD = ".title";
    public static final String LEX_ICON_FIELD = ".icon";
    public static final String LEX_LABEL = ".label";
    public static final String LEX_DISPLAY_NAME = ".displayName";
    private Lexicon lexicon;
    private String key;
    protected BICredentials credentials;
    protected BCredentialsEditor credFE;
    static /* synthetic */ Class class$com$tridium$workbench$auth$BCnxHandler;

    public void saveCnx() {
        this.invoke(saveCnx, null, null);
    }

    public void clearCnx() {
        this.invoke(clearCnx, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BCnxHandler(BICredentials bICredentials) {
        this.setCredentials(bICredentials);
    }

    public BCnxHandler(BICredentials bICredentials, Lexicon lexicon, String string) {
        this(bICredentials);
        this.key = string;
        this.lexicon = lexicon;
    }

    public String getTitle() {
        if (null != this.lexicon && null != this.key) {
            return this.lexicon.getText(this.key + LEX_TITLE_FIELD);
        }
        return null;
    }

    public String getDescription() {
        if (null != this.lexicon && null != this.key) {
            return this.lexicon.getText(this.key + LEX_DESC_FIELD);
        }
        return null;
    }

    public BIcon getIcon() {
        String string;
        if (null != this.lexicon && null != this.key && null != (string = this.lexicon.get(this.key + LEX_ICON_FIELD))) {
            return BIcon.make((String)string);
        }
        return null;
    }

    public String getLabel() {
        if (null != this.lexicon && null != this.key) {
            return this.lexicon.getText(this.key + LEX_LABEL);
        }
        return null;
    }

    public String toString(Context context) {
        return this.getType().getModule().getLexicon().getText(this.key + LEX_DISPLAY_NAME);
    }

    public final BICredentials getCredentials() throws CannotSaveException, Exception {
        return (BICredentials)this.credFE.saveValue();
    }

    public void setCredentials(BICredentials bICredentials) {
        if (null == bICredentials) {
            throw new BajaRuntimeException("Cannot instantiate a BCnxHandler with NULL default credential type.");
        }
        this.credFE = (BCredentialsEditor)BWbFieldEditor.makeFor(bICredentials.asObject());
        this.credFE.loadValue(bICredentials.asObject());
        this.credentials = bICredentials;
    }

    public final BCredentialsEditor getCredentialsFE() {
        return this.credFE;
    }

    public abstract String toAuthenticationRealm();

    public abstract BOrd toHyperlink();

    public abstract BWbPlugin getCnxEditor();

    public abstract boolean isSecure();

    public abstract void doSaveCnx();

    public abstract void doClearCnx();

    public static Command[] getCnxCommands(BWidget bWidget, BHost bHost) {
        LinkedList<Command> linkedList = new LinkedList<Command>();
        TypeInfo[] typeInfoArray = new TypeInfo[]{BPlatformCnxType.TYPE.getTypeInfo(), BStationCnxType.TYPE.getTypeInfo(), BDeviceCnxType.TYPE.getTypeInfo()};
        for (int i = 0; i < typeInfoArray.length; ++i) {
            BCnxHandler[] bCnxHandlerArray = BCnxHandler.getHandlersOnType(typeInfoArray[i], bHost);
            if (bCnxHandlerArray.length <= 0) continue;
            CnxCommand cnxCommand = new CnxCommand(bWidget, typeInfoArray[i].getTypeName(), bCnxHandlerArray);
            linkedList.add(cnxCommand);
        }
        BSessionAgent.OpenCommand[] openCommandArray = BCnxHandler.listOpenCommands(bWidget, bHost);
        linkedList.addAll(Arrays.asList(openCommandArray));
        return linkedList.toArray(new Command[linkedList.size()]);
    }

    private static BCnxHandler[] getHandlersOnType(TypeInfo typeInfo, BHost bHost) {
        AgentList agentList = Sys.getRegistry().getAgents(typeInfo);
        AgentList agentList2 = agentList.filter((AgentFilter)new Filter());
        BCnxHandler[] bCnxHandlerArray = new BCnxHandler[agentList2.size()];
        for (int i = 0; i < agentList2.size(); ++i) {
            AgentInfo agentInfo = agentList2.get(i);
            BCnxHandler bCnxHandler = (BCnxHandler)agentInfo.getInstance();
            if (bCnxHandler instanceof BHostCnxHandler) {
                ((BHostCnxHandler)bCnxHandler).setHost(bHost);
            }
            bCnxHandlerArray[i] = bCnxHandler;
        }
        return BCnxHandler.getPreferredHandlerOrder(bCnxHandlerArray);
    }

    private static BSessionAgent.OpenCommand[] listOpenCommands(BWidget bWidget, BHost bHost) {
        BNiagaraWbShell bNiagaraWbShell = (BNiagaraWbShell)bWidget.getShell();
        ArrayList<BSessionAgent.OpenCommand> arrayList = new ArrayList<BSessionAgent.OpenCommand>();
        BSessionAgent[] bSessionAgentArray = BCnxHandler.listSessionAgents();
        for (int i = 0; i < bSessionAgentArray.length; ++i) {
            try {
                BOrd bOrd;
                BSessionAgent.OpenCommand openCommand = bSessionAgentArray[i].getOpenCommand(bWidget, bHost);
                if (openCommand == null || !bNiagaraWbShell.profile.canHyperlink(bOrd = BOrd.make((String)("local:|" + openCommand.sessionScheme + ":")))) continue;
                arrayList.add(openCommand);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return arrayList.toArray(new BSessionAgent.OpenCommand[arrayList.size()]);
    }

    private static BSessionAgent[] listSessionAgents() {
        TypeInfo[] typeInfoArray = Sys.getRegistry().getTypes(BSessionAgent.TYPE.getTypeInfo());
        ArrayList<BSessionAgent> arrayList = new ArrayList<BSessionAgent>();
        for (int i = 0; i < typeInfoArray.length; ++i) {
            try {
                Type type = typeInfoArray[i].getTypeSpec().getResolvedType();
                if (type.isAbstract()) continue;
                arrayList.add((BSessionAgent)type.getInstance());
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return arrayList.toArray(new BSessionAgent[arrayList.size()]);
    }

    private static BCnxHandler[] getPreferredHandlerOrder(BCnxHandler[] bCnxHandlerArray) {
        LinkedList<BCnxHandler> linkedList = new LinkedList<BCnxHandler>();
        LinkedList<BCnxHandler> linkedList2 = new LinkedList<BCnxHandler>();
        for (int i = 0; i < bCnxHandlerArray.length; ++i) {
            if (bCnxHandlerArray[i].isSecure()) {
                linkedList.add(bCnxHandlerArray[i]);
                continue;
            }
            linkedList2.add(bCnxHandlerArray[i]);
        }
        BGeneralOptions bGeneralOptions = BGeneralOptions.make();
        if (bGeneralOptions.getIsDefaultConnectionTypeSsl()) {
            linkedList.addAll(linkedList2);
        } else {
            linkedList.addAll(0, linkedList2);
        }
        return linkedList.toArray(new BCnxHandler[linkedList.size()]);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Filter
    extends AgentFilter {
        private Filter() {
        }

        public boolean include(AgentInfo agentInfo) {
            boolean bl = agentInfo.getAgentType().isAbstract();
            boolean bl2 = agentInfo.getAgentType().is(TYPE.getTypeInfo());
            return !bl && bl2;
        }
    }

    public static class CnxCommand
    extends Command {
        private BCnxHandler[] handlers;

        public CnxCommand(BWidget bWidget, String string, BCnxHandler[] bCnxHandlerArray) {
            super(bWidget, TYPE.getModule().getLexicon(), string);
            this.handlers = bCnxHandlerArray;
        }

        public CommandArtifact doInvoke() throws Exception {
            this.handlers = BCnxHandler.getPreferredHandlerOrder(this.handlers);
            AuthUtil.connect(this.getOwner(), this.handlers);
            return null;
        }
    }
}

