/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.auth;

import com.tridium.fox.kerberos.KerberosConfig;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxAuthenticationException;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.util.ThrowableUtil;
import com.tridium.workbench.auth.BCnxConfigPane;
import com.tridium.workbench.auth.BCnxHandler;
import com.tridium.workbench.auth.BCredentialsManager;
import com.tridium.workbench.auth.BIAuthResponseHandler;
import com.tridium.workbench.auth.BOpenPane;
import com.tridium.workbench.auth.BWbLoginPane;
import com.tridium.workbench.auth.CredentialsList;
import com.tridium.workbench.auth.kerb.KerberosInfo;
import com.tridium.workbench.shell.BGeneralOptions;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.NHyperlinkInfo;
import java.security.PrivilegedAction;
import javax.baja.gx.BImage;
import javax.baja.log.Log;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.registry.TypeInfo;
import javax.baja.security.AuthenticationException;
import javax.baja.security.AuthenticationRealm;
import javax.baja.security.BICredentials;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.security.kerberos.BKerberosCredentials;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.ui.BDialog;
import javax.baja.ui.BHyperlinkMode;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.TextUtil;
import javax.security.auth.Subject;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;

public class AuthUtil {
    public static final char SSO_SEP = ';';
    public static boolean saveCredentials;
    public static boolean kerberosUser;
    static final BImage icon;
    static final Log log;

    public static boolean challenge(BWidget bWidget, AuthenticationException authenticationException) {
        return AuthUtil.challenge(bWidget, authenticationException, false);
    }

    public static boolean challenge(BWidget bWidget, AuthenticationException authenticationException, boolean bl) {
        if (authenticationException == null) {
            return false;
        }
        AuthenticationRealm authenticationRealm = authenticationException.getAuthenticationRealm();
        FoxMessage foxMessage = null;
        Throwable throwable = authenticationException.getCause();
        if (throwable instanceof FoxAuthenticationException) {
            foxMessage = ((FoxAuthenticationException)throwable).data;
        }
        return AuthUtil.challenge(bWidget, authenticationRealm, bl, foxMessage);
    }

    public static boolean challenge(BWidget bWidget, AuthenticationRealm authenticationRealm) {
        return AuthUtil.challenge(bWidget, authenticationRealm, false, null);
    }

    public static boolean challenge(BWidget bWidget, AuthenticationRealm authenticationRealm, boolean bl) {
        return AuthUtil.challenge(bWidget, authenticationRealm, bl, null);
    }

    public static boolean challenge(BWidget bWidget, AuthenticationRealm authenticationRealm, boolean bl, FoxMessage foxMessage) {
        int n;
        Object object;
        BICredentials bICredentials = AuthUtil.getCredentials(authenticationRealm);
        UiLexicon uiLexicon = UiLexicon.bajaui();
        String string = uiLexicon.getText("auth.title");
        BGeneralOptions bGeneralOptions = BGeneralOptions.make();
        boolean bl2 = bGeneralOptions.getAllowUserCredentialCaching();
        saveCredentials = !bl2 ? false : AuthUtil.hasSavedCredentials(authenticationRealm);
        BKerberosCredentials bKerberosCredentials = null;
        KerberosInfo kerberosInfo = new KerberosInfo();
        if (authenticationRealm.getAuthenticationScheme().contains("kerberos")) {
            try {
                object = foxMessage.getMessage("ldap");
                String string2 = object.getString("kerberosRealm");
                kerberosInfo.setRealm(string2);
                if (authenticationRealm instanceof BFoxSession) {
                    kerberosInfo.setStationName(((BFoxSession)authenticationRealm).getStationName());
                }
                if ((bKerberosCredentials = AuthUtil.getCurrentKerberosCredentials()) != null && string2.equals(bKerberosCredentials.getRealm()) && !bKerberosCredentials.isExpired()) {
                    kerberosInfo.setCreds(bKerberosCredentials);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((n = BDialog.open((BWidget)bWidget, (String)string, (Object)(object = new BWbLoginPane(authenticationRealm, bl, kerberosInfo)), (int)3)) == 2) {
            ((BWbLoginPane)((Object)object)).getCredInputPane().cleanCredentials();
            return false;
        }
        try {
            bICredentials = ((BWbLoginPane)((Object)object)).getCredInputPane().extractCredentials();
        }
        catch (Exception exception) {
            Throwable throwable = ThrowableUtil.getCause((Throwable)exception);
            if (throwable != null) {
                throwable.printStackTrace();
            }
            BDialog.error((BWidget)bWidget, (String)UiLexicon.bajaui().getText("dialog.error"), (Object)exception.getMessage(), (Throwable)exception);
            return false;
        }
        if (((BWbLoginPane)((Object)object)).getCredInputPane().shouldSaveCredentials()) {
            saveCredentials = true;
            AuthUtil.saveCredentials(authenticationRealm.getAuthenticationRealmName(), bICredentials);
        } else if (((BWbLoginPane)((Object)object)).getCredInputPane().shouldDeleteCredentials()) {
            saveCredentials = false;
            AuthUtil.removeCredentials(authenticationRealm.getAuthenticationRealmName());
        }
        kerberosUser = ((BWbLoginPane)((Object)object)).getCredInputPane().getKerbUserState();
        if (kerberosUser && bICredentials instanceof BUsernameAndPassword) {
            BUsernameAndPassword bUsernameAndPassword = (BUsernameAndPassword)bICredentials;
            bICredentials = new BUsernameAndPassword("kerberos:" + bUsernameAndPassword.getUsername(), bUsernameAndPassword.getPassword());
        }
        authenticationRealm.setCredentials(bICredentials);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BKerberosCredentials getCurrentKerberosCredentials() {
        KerberosConfig kerberosConfig = new KerberosConfig(true, true);
        LoginContext loginContext = null;
        try {
            loginContext = new LoginContext("com.tridium.workbench.auth.AuthUtil", null, null, (Configuration)kerberosConfig);
            loginContext.login();
            GSSCredential gSSCredential = (GSSCredential)Subject.doAs(loginContext.getSubject(), new ExtractGSSCredentialAction());
            if (gSSCredential != null) {
                BKerberosCredentials bKerberosCredentials = new BKerberosCredentials(gSSCredential);
                return bKerberosCredentials;
            }
        }
        catch (LoginException loginException) {
            BKerberosCredentials bKerberosCredentials = null;
            return bKerberosCredentials;
        }
        finally {
            try {
                loginContext.logout();
            }
            catch (LoginException loginException) {}
        }
        return null;
    }

    public static boolean connect(BWidget bWidget, BCnxHandler[] bCnxHandlerArray) {
        BCnxHandler bCnxHandler;
        BCnxConfigPane bCnxConfigPane = new BCnxConfigPane(bCnxHandlerArray);
        int n = BDialog.open((BWidget)bWidget, (String)UiLexicon.bajaui().get("auth.connect", "Connect"), (Object)((Object)bCnxConfigPane), (int)3);
        if (n != 1) {
            bCnxConfigPane.clearCnxHandlers();
            return false;
        }
        BOrd bOrd = null;
        try {
            bCnxHandler = bCnxConfigPane.saveCnxHandler();
            BGeneralOptions.make().setIsDefaultConnectionTypeSsl(bCnxHandler.isSecure());
            bCnxHandler.saveCnx();
            bOrd = bCnxHandler.toHyperlink().normalize();
            bCnxConfigPane.clearCnxHandlers();
        }
        catch (Exception exception) {
            Throwable throwable = ThrowableUtil.getCause((Throwable)exception);
            if (throwable != null) {
                throwable.printStackTrace();
            }
            BDialog.error((BWidget)bWidget, (String)UiLexicon.bajaui().getText("dialog.error"), (Object)exception.getMessage(), (Throwable)exception);
            return false;
        }
        bCnxHandler = new BUsernameAndPassword();
        BWidgetShell bWidgetShell = bWidget.getShell();
        if (bWidgetShell instanceof BNiagaraWbShell) {
            BNiagaraWbShell bNiagaraWbShell = (BNiagaraWbShell)bWidgetShell;
            bNiagaraWbShell.hyperlink(new NHyperlinkInfo(bOrd, BHyperlinkMode.replace, true, (BICredentials)bCnxHandler));
        }
        return saveCredentials;
    }

    public static boolean handleAuthResponse(AuthenticationException authenticationException, BWidgetShell bWidgetShell, BICredentials bICredentials) {
        TypeInfo[] typeInfoArray = Sys.getRegistry().getTypes(BIAuthResponseHandler.TYPE.getTypeInfo());
        for (int i = 0; i < typeInfoArray.length; ++i) {
            TypeInfo typeInfo = typeInfoArray[i];
            if (typeInfo.isInterface() || typeInfo.isAbstract()) continue;
            BIAuthResponseHandler bIAuthResponseHandler = (BIAuthResponseHandler)typeInfo.getInstance();
            try {
                if (!bIAuthResponseHandler.canAccept(authenticationException, bICredentials) || !bIAuthResponseHandler.processResponse(authenticationException, bWidgetShell, bICredentials)) continue;
                return true;
            }
            catch (AbstractMethodError abstractMethodError) {
                log.message("Skipping unsupported BIAuthResponseHandler: ", (Throwable)abstractMethodError);
            }
        }
        return false;
    }

    public static boolean open(BWidget bWidget, OpenHandler openHandler) {
        BWidgetShell bWidgetShell;
        BOpenPane bOpenPane = openHandler.makeOpenPane();
        int n = BDialog.open((BWidget)bWidget, (String)openHandler.title, (Object)((Object)bOpenPane), (int)3);
        if (n != 1) {
            return false;
        }
        BICredentials bICredentials = null;
        String string = null;
        BOrd bOrd = null;
        try {
            bICredentials = (BICredentials)bOpenPane.credentialsEditor.saveValue();
            bOpenPane.saveAddress();
            bOpenPane.host.saveHistory();
            string = openHandler.toAuthenticationRealm();
            bOrd = openHandler.toHyperlink().normalize();
        }
        catch (Exception exception) {
            Throwable throwable = ThrowableUtil.getCause((Throwable)exception);
            if (throwable != null) {
                throwable.printStackTrace();
            }
            BDialog.error((BWidget)bWidget, (String)UiLexicon.bajaui().getText("dialog.error"), (Object)exception.getMessage(), (Throwable)exception);
            return false;
        }
        saveCredentials = bOpenPane.saveCredentials.isSelected();
        if (string != null) {
            if (saveCredentials) {
                AuthUtil.saveCredentials(string, bICredentials);
            } else {
                AuthUtil.removeCredentials(string);
            }
        }
        if ((bWidgetShell = bWidget.getShell()) instanceof BNiagaraWbShell) {
            BNiagaraWbShell bNiagaraWbShell = (BNiagaraWbShell)bWidgetShell;
            bNiagaraWbShell.hyperlink(new NHyperlinkInfo(bOrd, BHyperlinkMode.replace, true, bICredentials));
            if (bNiagaraWbShell.getActiveOrdTarget() != null) {
                bNiagaraWbShell.syncTree();
            }
        }
        return saveCredentials;
    }

    public static boolean hasSavedCredentials(AuthenticationRealm authenticationRealm) {
        String string = authenticationRealm.getAuthenticationRealmName();
        BICredentials bICredentials = CredentialsList.INSTANCE.lookup(string);
        return bICredentials != null;
    }

    public static BICredentials getCredentials(AuthenticationRealm authenticationRealm) {
        BICredentials bICredentials = authenticationRealm.getCredentials();
        if (bICredentials == null) {
            String string = authenticationRealm.getAuthenticationRealmName();
            bICredentials = CredentialsList.INSTANCE.lookup(string);
            if (bICredentials == null) {
                bICredentials = authenticationRealm.makeCredentials();
            }
        } else {
            bICredentials = (BICredentials)((BValue)bICredentials).newCopy();
        }
        return bICredentials;
    }

    public static void saveCredentials(String string, BICredentials bICredentials) {
        if (bICredentials instanceof BKerberosCredentials) {
            return;
        }
        CredentialsList.INSTANCE.put(string, bICredentials);
        AuthUtil.saveCredentials();
    }

    public static void removeCredentials(String string) {
        CredentialsList.INSTANCE.remove(string);
        AuthUtil.saveCredentials();
    }

    public static void manageCredentials(BWidget bWidget, String string) {
        CredentialsList credentialsList = new CredentialsList(CredentialsList.INSTANCE);
        int n = BDialog.open((BWidget)bWidget, (String)string, (Object)((Object)new BCredentialsManager(bWidget, credentialsList)), (int)3);
        if (n == 1) {
            CredentialsList.INSTANCE.copyFrom(credentialsList);
            AuthUtil.saveCredentials();
        }
    }

    public static void saveCredentials() {
        try {
            CredentialsList.INSTANCE.save();
        }
        catch (Exception exception) {
            log.error("Cannot save credentials list", (Throwable)exception);
        }
    }

    public static boolean resolveSSO(AuthenticationException authenticationException) {
        if (!(authenticationException.getCause() instanceof FoxAuthenticationException)) {
            return false;
        }
        FoxAuthenticationException foxAuthenticationException = (FoxAuthenticationException)authenticationException.getCause();
        BFoxSession[] bFoxSessionArray = BFoxSession.list();
        BFoxSession bFoxSession = null;
        String[] stringArray = AuthUtil.extractSSO(foxAuthenticationException.session.getRemoteHello());
        if (stringArray.length == 0) {
            return false;
        }
        for (int i = 0; i < bFoxSessionArray.length; ++i) {
            if (!AuthUtil.inSSORealm(bFoxSessionArray[i], stringArray) || bFoxSession != null && !bFoxSessionArray[i].getConnection().getLastConnectTime().isAfter(bFoxSession.getConnection().getLastConnectTime())) continue;
            bFoxSession = bFoxSessionArray[i];
        }
        if (bFoxSession == null) {
            return false;
        }
        authenticationException.getAuthenticationRealm().setCredentials(bFoxSession.getCredentials());
        return true;
    }

    private static boolean inSSORealm(BFoxSession bFoxSession, String[] stringArray) {
        FoxSession foxSession = bFoxSession.getConnection().session();
        if (foxSession == null) {
            return false;
        }
        FoxMessage foxMessage = foxSession.getRemoteHello();
        String[] stringArray2 = AuthUtil.extractSSO(foxMessage);
        if (stringArray2.length == 0) {
            return false;
        }
        for (int i = 0; i < stringArray2.length; ++i) {
            if (stringArray2[i].length() == 0) continue;
            for (int j = 0; j < stringArray.length; ++j) {
                if (!stringArray2[i].equals(stringArray[j])) continue;
                return true;
            }
        }
        return false;
    }

    private static String[] extractSSO(FoxMessage foxMessage) {
        if (null == foxMessage) {
            return new String[0];
        }
        String string = null;
        string = foxMessage.getString("realms", null);
        if (string != null) {
            return TextUtil.splitAndTrim((String)string, (char)';');
        }
        return new String[0];
    }

    static {
        BGeneralOptions bGeneralOptions = BGeneralOptions.make();
        boolean bl = bGeneralOptions.getAllowUserCredentialCaching();
        if (!bl) {
            saveCredentials = false;
        }
        saveCredentials = false;
        kerberosUser = false;
        icon = BImage.make((String)"module://icons/x32/keys.png");
        log = Log.getLog((String)"workbench.auth");
    }

    public static class OpenHandler {
        public String title;
        public String description;
        public BICredentials credentials;
        public BOrd hostOrd;
        public String sessionScheme;
        public int port;
        public int defaultPort;
        public String[] tunnelAuthorities = null;

        public OpenHandler(String string, String string2, BHost bHost, String string3, int n, BICredentials bICredentials) {
            this(string, string2, bHost, string3, n, bICredentials, null);
        }

        public OpenHandler(String string, String string2, BHost bHost, String string3, int n, BICredentials bICredentials, String[] stringArray) {
            this.title = string;
            this.description = string2;
            if (bHost != null) {
                this.hostOrd = bHost.getAbsoluteOrd();
            }
            this.sessionScheme = string3;
            this.defaultPort = n;
            this.port = n;
            this.credentials = bICredentials;
            this.tunnelAuthorities = stringArray;
        }

        public BOpenPane makeOpenPane() {
            return new BOpenPane(this);
        }

        public BOrd toHyperlink() {
            return BOrd.make((String)this.addressToOrd());
        }

        public String toAuthenticationRealm() {
            return this.addressToOrd();
        }

        protected String addressToOrd() {
            String string = this.hostOrd.toString() + "|" + this.sessionScheme + ":";
            if (this.port != this.defaultPort) {
                string = string + this.port;
            }
            if (this.tunnelAuthorities != null) {
                string = string + "/" + TextUtil.join((String[])this.tunnelAuthorities, (char)'/');
            }
            return string;
        }
    }

    static class ExtractGSSCredentialAction
    implements PrivilegedAction {
        ExtractGSSCredentialAction() {
        }

        public Object run() {
            try {
                GSSManager gSSManager = GSSManager.getInstance();
                GSSCredential gSSCredential = gSSManager.createCredential(1);
                return gSSCredential;
            }
            catch (GSSException gSSException) {
                return null;
            }
        }
    }
}

