/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.dmp.util;

import com.tridium.dmp.util.DmpError;
import com.tridium.dmp.util.DmpIoException;
import com.tridium.ndriver.util.TByteArrayInputStream;
import java.io.OutputStream;
import javax.baja.nre.util.IntHashMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DmpInputStream {
    private static final String formatChars = "\r\n\t ";
    boolean terminated;
    boolean endBlock;
    public TByteArrayInputStream in;

    public String getAll() throws DmpIoException {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.isEndOfStream()) {
            char c = this.getChar();
            while (c != '\r' || !this.isEndOfStream()) {
                stringBuffer.append(c);
                c = this.getChar();
            }
        }
        return stringBuffer.toString();
    }

    public String getAccountNumber() throws DmpIoException {
        char c = this.getChar();
        while (this.isSkipChar(c)) {
            c = this.getChar();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isAccountChar(c)) {
            int n = 0;
            while (n < 6) {
                c = this.getChar();
                if (!this.isSkipChar(c)) {
                    stringBuffer.append(c);
                }
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public String getResponseCode() throws DmpIoException {
        char c = this.getChar();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(c);
        return stringBuffer.toString();
    }

    public String getCmdCode() throws DmpIoException {
        char c = this.getChar();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(c);
        char c2 = this.peekChar();
        if (c == 'W' && (c2 == 'B' || c2 == 'S') || c == 'T' && c2 == '0') {
            c = this.getChar();
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public String getBlock(int n) throws DmpIoException {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            char c = this.getChar();
            stringBuffer.append(c);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public String getToRecordSeparator() throws DmpIoException {
        char c = this.getChar();
        StringBuffer stringBuffer = new StringBuffer();
        while (!this.isRecordSeparator(c)) {
            stringBuffer.append(c);
            c = this.getChar();
        }
        return stringBuffer.toString();
    }

    public boolean isEndBlock() throws DmpIoException {
        char c = this.peekChar();
        return this.isEndBlock(c);
    }

    public IntHashMap getSystemInfo() throws DmpIoException {
        IntHashMap intHashMap = new IntHashMap();
        this.skipChars(5);
        char c = this.getChar();
        if (c != '-') {
            intHashMap.put(1, (Object)new Character(c));
        }
        if ((c = this.getChar()) != '-') {
            intHashMap.put(2, (Object)new Character(c));
        }
        this.skipChars(1);
        c = this.getChar();
        if (c != '-') {
            intHashMap.put(5, (Object)new Character(c));
        }
        if ((c = this.getChar()) != '-') {
            intHashMap.put(4, (Object)new Character(c));
        }
        return intHashMap;
    }

    public void terminate() throws DmpIoException {
        if (this.terminated) {
            return;
        }
        throw new DmpIoException(DmpError.IPEX);
    }

    private final boolean isTerminator(char c) {
        boolean bl = false;
        if (c == ';' || c == '-') {
            bl = true;
        }
        return bl;
    }

    private final boolean isEndBlock(char c) {
        boolean bl = false;
        if (c == '-') {
            bl = true;
        }
        return bl;
    }

    private final boolean isSkipChar(char c) {
        boolean bl = false;
        if (c == ' ' || c == '\u0000' || c == '\u0002') {
            bl = true;
        }
        return bl;
    }

    public static boolean isFormatChar(char c) {
        boolean bl = false;
        if (formatChars.indexOf(c) >= 0) {
            bl = true;
        }
        return bl;
    }

    private final boolean isRecordSeparator(char c) {
        boolean bl = false;
        if (c == '\u001e') {
            bl = true;
        }
        return bl;
    }

    private final boolean isAccountChar(char c) {
        boolean bl = false;
        if (c == '@') {
            bl = true;
        }
        return bl;
    }

    public char getChar() throws DmpIoException {
        char c;
        try {
            c = (char)this.in.read();
        }
        catch (Throwable throwable) {
            throw new DmpIoException("end of buf encountered", DmpError.IISP);
        }
        if (this.isTerminator(c)) {
            this.terminated = true;
        }
        if (this.isEndBlock(c)) {
            this.endBlock = true;
        }
        return c;
    }

    public char peekChar() throws DmpIoException {
        try {
            return (char)this.in.peek();
        }
        catch (Throwable throwable) {
            throw new DmpIoException("end of buf encountered", DmpError.IISP);
        }
    }

    public void skipChars(int n) throws DmpIoException {
        try {
            this.in.skip((long)n);
        }
        catch (Throwable throwable) {
            throw new DmpIoException("end of buf encountered", DmpError.IISP);
        }
    }

    public String restOfBufferToString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.in.mark();
        try {
            if (!this.isEndOfStream()) {
                char c = this.getChar();
                while (!this.isEndOfStream()) {
                    stringBuffer.append(c);
                    c = this.getChar();
                }
                if (c != '\r') {
                    stringBuffer.append(c);
                }
            }
        }
        catch (DmpIoException dmpIoException) {
            dmpIoException.printStackTrace();
        }
        this.in.reset();
        return stringBuffer.toString();
    }

    public String toString() {
        return this.in.toString();
    }

    public boolean isFragment() {
        boolean bl = false;
        if ((char)this.in.peekFinal() == '-') {
            bl = true;
        }
        return bl;
    }

    public boolean isEndOfStream() {
        boolean bl = false;
        if (this.in.available() == 0) {
            bl = true;
        }
        return bl;
    }

    public void mergeToOutStream(OutputStream outputStream) throws Exception {
        int n = this.in.available();
        if (this.isFragment()) {
            --n;
        }
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.in.read();
            if (n3 != 45) {
                outputStream.write(n3);
            }
            ++n2;
        }
    }

    private final /* synthetic */ void this() {
        this.terminated = false;
        this.endBlock = false;
    }

    public DmpInputStream(TByteArrayInputStream tByteArrayInputStream) {
        this.this();
        this.in = tByteArrayInputStream;
    }
}

