/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.dmp.comm;

import com.tridium.dmp.BDmpDevice;
import com.tridium.dmp.BDmpNetwork;
import com.tridium.dmp.comm.BDmpSerialCommConfig;
import com.tridium.dmp.enums.BDmpInstructs;
import com.tridium.dmp.enums.BZoneEnum;
import com.tridium.dmp.messages.DmpCommand;
import com.tridium.dmp.messages.DmpReceiveZoneInfo;
import com.tridium.dmp.messages.DmpReceivedMsg;
import com.tridium.dmp.util.DmpInputStream;
import com.tridium.dmp.util.DmpIoException;
import com.tridium.dmp.util.FletcherChecksum;
import com.tridium.ndriver.comm.ICommListener;
import com.tridium.ndriver.comm.NMessage;
import java.util.ArrayList;
import javax.baja.log.Log;
import javax.baja.nre.util.IntHashMap;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BValue;
import javax.baja.util.SortUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DmpListener
implements ICommListener {
    BDmpSerialCommConfig parent;
    boolean continueZoneMessage;
    int numOfZones;
    int numOfAreas;
    String zoneList;
    String zone24HourList;
    String zoneInfo;
    String zoneAreaList;
    String areaList;
    String armedAreas;
    String bypassedZones;
    static /* synthetic */ Class class$com$tridium$dmp$BDmpDevice;

    BDmpNetwork getNetwork() {
        return (BDmpNetwork)this.parent.getParent();
    }

    public void receiveMessage(NMessage nMessage) {
        BDmpNetwork bDmpNetwork = this.getNetwork();
        Class clazz = class$com$tridium$dmp$BDmpDevice;
        if (clazz == null) {
            clazz = class$com$tridium$dmp$BDmpDevice = DmpListener.class("[Lcom.tridium.dmp.BDmpDevice;", false);
        }
        BDmpDevice bDmpDevice = (BDmpDevice)((Object)bDmpNetwork.getChildren(clazz)[0]);
        DmpCommand dmpCommand = (DmpCommand)nMessage;
        if (dmpCommand.isFragmentable()) {
            Log.getLog((String)"dmp").trace(bDmpDevice.getAccountNumber());
            if (!this.isCorrectAccountNumber(((DmpReceiveZoneInfo)dmpCommand).account, bDmpDevice)) {
                return;
            }
            bDmpDevice.received();
            String string = ((DmpReceiveZoneInfo)dmpCommand).cmdCode;
            if (string.equals("WB")) {
                this.processZoneAndAreaStatus((DmpReceiveZoneInfo)dmpCommand);
            }
            bDmpDevice.updateDisplay();
        } else {
            String string = ((DmpReceivedMsg)dmpCommand).cmdCode;
            boolean bl = ((DmpReceivedMsg)dmpCommand).isNAK();
            if (!this.isCorrectAccountNumber(((DmpReceivedMsg)dmpCommand).account, bDmpDevice)) {
                return;
            }
            if (this.verifyFletcher((DmpReceivedMsg)dmpCommand)) {
                if (string.equals("V")) {
                    try {
                        if (((DmpReceivedMsg)dmpCommand).tin.peekChar() == '\r') {
                            Log.getLog((String)"dmp").warning("Not connected to panel, please connect.");
                            return;
                        }
                    }
                    catch (DmpIoException dmpIoException) {
                        dmpIoException.printStackTrace();
                    }
                    bDmpDevice.received();
                    this.processConnect((DmpReceivedMsg)dmpCommand);
                    return;
                }
                bDmpDevice.received();
                if (!string.equals("H")) {
                    if (string.equals("WS")) {
                        this.processSystemStatus((DmpReceivedMsg)dmpCommand);
                    } else if (string.equals("C")) {
                        if (bl) {
                            bDmpDevice.setArmDisarmFail(true);
                        }
                        bDmpDevice.invoke(BDmpDevice.command, (BValue)BDmpInstructs.zoneStatusRequest);
                    } else if (string.equals("O")) {
                        if (bl) {
                            bDmpDevice.setArmDisarmFail(true);
                        }
                        bDmpDevice.invoke(BDmpDevice.command, (BValue)BDmpInstructs.zoneStatusRequest);
                    } else if (string.equals("T0")) {
                        this.processFletcherCmd((DmpReceivedMsg)dmpCommand);
                    } else {
                        Log.getLog((String)"dmp").error("The command code " + string + " is not implemented");
                    }
                }
            } else {
                Log.getLog((String)"dmp").error("Incoming Message Checksum failed!");
            }
        }
    }

    private final boolean verifyFletcher(DmpReceivedMsg dmpReceivedMsg) {
        DmpInputStream dmpInputStream = dmpReceivedMsg.tin;
        DmpInputStream dmpInputStream2 = dmpReceivedMsg.fletcher;
        try {
            String string = dmpInputStream2.getAll();
            String string2 = dmpInputStream.restOfBufferToString();
            int n = Integer.parseInt(string.substring(0, 1));
            String string3 = string.substring(1);
            String string4 = dmpReceivedMsg.responseSign + dmpReceivedMsg.cmdCode + string2 + n;
            String string5 = FletcherChecksum.getFletcherChecksum(string4);
            return string5.equals(string3);
        }
        catch (DmpIoException dmpIoException) {
            dmpIoException.printStackTrace();
            return false;
        }
    }

    private final void processFletcherCmd(DmpReceivedMsg dmpReceivedMsg) {
        BDmpNetwork bDmpNetwork = this.getNetwork();
        Class clazz = class$com$tridium$dmp$BDmpDevice;
        if (clazz == null) {
            clazz = class$com$tridium$dmp$BDmpDevice = DmpListener.class("[Lcom.tridium.dmp.BDmpDevice;", false);
        }
        BDmpDevice bDmpDevice = (BDmpDevice)((Object)bDmpNetwork.getChildren(clazz)[0]);
        DmpInputStream dmpInputStream = dmpReceivedMsg.fletcher;
        try {
            String string = dmpInputStream.getAll();
            int n = Integer.parseInt(string.substring(0, 1));
            bDmpDevice.setSequenceNumber(n);
        }
        catch (DmpIoException dmpIoException) {
            dmpIoException.printStackTrace();
        }
    }

    private final void processConnect(DmpReceivedMsg dmpReceivedMsg) {
        BDmpNetwork bDmpNetwork = this.getNetwork();
        Class clazz = class$com$tridium$dmp$BDmpDevice;
        if (clazz == null) {
            clazz = class$com$tridium$dmp$BDmpDevice = DmpListener.class("[Lcom.tridium.dmp.BDmpDevice;", false);
        }
        BDmpDevice bDmpDevice = (BDmpDevice)((Object)bDmpNetwork.getChildren(clazz)[0]);
        DmpInputStream dmpInputStream = dmpReceivedMsg.tin;
        try {
            String string = dmpInputStream.getAll();
            if (string.equals("")) {
                bDmpDevice.setSystemReady(false);
            }
            bDmpDevice.addElemSystemMap(3, 'N');
        }
        catch (DmpIoException dmpIoException) {
            dmpIoException.printStackTrace();
        }
    }

    private final void processSystemStatus(DmpReceivedMsg dmpReceivedMsg) {
        BDmpNetwork bDmpNetwork = this.getNetwork();
        Class clazz = class$com$tridium$dmp$BDmpDevice;
        if (clazz == null) {
            clazz = class$com$tridium$dmp$BDmpDevice = DmpListener.class("[Lcom.tridium.dmp.BDmpDevice;", false);
        }
        BDmpDevice bDmpDevice = (BDmpDevice)((Object)bDmpNetwork.getChildren(clazz)[0]);
        DmpInputStream dmpInputStream = dmpReceivedMsg.tin;
        String string = "";
        try {
            IntHashMap intHashMap = dmpInputStream.getSystemInfo();
            IntHashMap.Iterator iterator = intHashMap.iterator();
            while (iterator.hasNext()) {
                char c = ((Character)iterator.next()).charValue();
                switch (iterator.key()) {
                    case 1: {
                        string = string + '1' + c + ',';
                        bDmpDevice.addElemSystemMap(1, c);
                        break;
                    }
                    case 2: {
                        string = string + '2' + c + ',';
                        bDmpDevice.addElemSystemMap(2, c);
                        break;
                    }
                    case 5: {
                        string = string + '5' + c + ',';
                        bDmpDevice.addElemSystemMap(5, c);
                        break;
                    }
                    case 4: {
                        string = string + '4' + c + ',';
                        bDmpDevice.addElemSystemMap(4, c);
                        break;
                    }
                }
            }
        }
        catch (DmpIoException dmpIoException) {
            dmpIoException.printStackTrace();
        }
        bDmpDevice.setSystemStatus(string);
    }

    private final void processZoneAndAreaStatus(DmpReceiveZoneInfo dmpReceiveZoneInfo) {
        Object[] objectArray;
        BDmpNetwork bDmpNetwork = this.getNetwork();
        Class clazz = class$com$tridium$dmp$BDmpDevice;
        if (clazz == null) {
            clazz = class$com$tridium$dmp$BDmpDevice = DmpListener.class("[Lcom.tridium.dmp.BDmpDevice;", false);
        }
        BDmpDevice bDmpDevice = (BDmpDevice)((Object)bDmpNetwork.getChildren(clazz)[0]);
        DmpInputStream dmpInputStream = dmpReceiveZoneInfo.tin;
        this.numOfZones = 0;
        this.numOfAreas = 0;
        boolean bl = true;
        this.zoneList = "";
        this.zone24HourList = "";
        this.zoneInfo = "";
        this.zoneAreaList = "";
        this.areaList = "";
        this.armedAreas = "";
        this.bypassedZones = "";
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl2 = false;
        try {
            while (!dmpInputStream.isEndBlock()) {
                String string;
                objectArray = dmpInputStream.getToRecordSeparator();
                if (objectArray.startsWith("L")) {
                    string = objectArray.substring(1, 4);
                    ++this.numOfZones;
                    this.zoneInfo = this.zoneInfo + (String)objectArray + ',';
                    this.zoneAreaList = this.zoneAreaList + (String)objectArray + ',';
                    if (bl2) {
                        this.zoneList = this.addToList(this.zoneList, string);
                    } else {
                        this.zone24HourList = this.addToList(this.zone24HourList, string);
                    }
                    int n = Integer.parseInt(string);
                    String string2 = objectArray.substring(4, 5);
                    BZoneEnum bZoneEnum = BZoneEnum.none;
                    if (string2.equals("O")) {
                        bl = false;
                        bZoneEnum = BZoneEnum.open;
                    } else if (string2.equals("S")) {
                        bl = false;
                        bZoneEnum = BZoneEnum.shorted;
                    } else if (string2.equals("L")) {
                        bl = false;
                        bZoneEnum = BZoneEnum.lowBattery;
                    } else if (string2.equals("X")) {
                        arrayList.add(string);
                        bZoneEnum = BZoneEnum.bypassed;
                    } else if (string2.equals("N")) {
                        bZoneEnum = BZoneEnum.normal;
                    } else if (string2.equals("M")) {
                        bl = false;
                        bZoneEnum = BZoneEnum.missing;
                    }
                    bDmpDevice.addElemZoneMap(n, bZoneEnum);
                    continue;
                }
                ++this.numOfAreas;
                bl2 = true;
                this.zoneAreaList = this.zoneAreaList + (String)objectArray + ',';
                string = objectArray.substring(1, 4);
                String string3 = objectArray.substring(4, 5);
                boolean bl3 = false;
                if (string3.equals("A")) {
                    bl3 = true;
                    this.armedAreas = this.addToList(this.armedAreas, string);
                }
                bDmpDevice.addElemAreaMap(Integer.parseInt(string), bl3);
                this.areaList = this.addToList(this.areaList, string);
            }
            bDmpDevice.addElemSystemMap(3, 'N');
        }
        catch (DmpIoException dmpIoException) {
            bDmpDevice.setSystemReady(false);
            bDmpDevice.addElemSystemMap(3, 'T');
            dmpIoException.printStackTrace();
        }
        if (arrayList.size() > 0) {
            objectArray = arrayList.toArray(new String[arrayList.size()]);
            SortUtil.sort((Object[])objectArray);
            int n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                this.bypassedZones = this.addToList(this.bypassedZones, (String)object);
                ++n;
            }
        }
        bDmpDevice.setSystemReady(bl);
        bDmpDevice.setZonePointInfo(this.zoneInfo);
        bDmpDevice.setArmed24HourZoneList(this.zone24HourList);
        bDmpDevice.setMaxZones(this.numOfZones);
        bDmpDevice.setZoneList(this.zoneList);
        bDmpDevice.setZoneAreaList(this.zoneAreaList);
        bDmpDevice.setArmableAreaList(this.areaList);
        bDmpDevice.setMaxAreas(this.numOfAreas);
        bDmpDevice.setArmedAreas(this.armedAreas);
        bDmpDevice.setBypassedZones(this.bypassedZones);
        if (TextUtil.split((String)this.armedAreas, (char)',').length == this.numOfAreas) {
            bDmpDevice.setSystemArmed(true);
        } else {
            bDmpDevice.setSystemArmed(false);
        }
    }

    private final boolean isCorrectAccountNumber(String string, BDmpDevice bDmpDevice) {
        if (!string.equals(bDmpDevice.getAccountNumber())) {
            Log.getLog((String)"dmp").error("The account number " + bDmpDevice.getAccountNumber() + " is incorrect.  Receiving messages from: " + string);
            return false;
        }
        return true;
    }

    private final String addToList(String string, String string2) {
        if (string.equals("")) {
            return string2;
        }
        string = string + ',' + string2;
        return string;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.continueZoneMessage = false;
    }

    public DmpListener(BDmpSerialCommConfig bDmpSerialCommConfig) {
        this.this();
        this.parent = bDmpSerialCommConfig;
    }
}

