/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.schedule.ui;

import com.tridium.gx.util.ColorUtil;
import com.tridium.schedule.ui.Utils;
import com.tridium.util.ArrayUtil;
import java.util.HashMap;
import java.util.Map;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.log.Log;
import javax.baja.schedule.BDailySchedule;
import javax.baja.schedule.BDaySchedule;
import javax.baja.schedule.BTimeSchedule;
import javax.baja.schedule.BWeeklySchedule;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Context;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ScheduleColors {
    private static Log LOG = Log.getLog((String)"schedule");
    private static BColor scheduleBackground;
    private static final BColor NULL_BACKGROUND_COLOR;
    private static final BColor FALSE_BACKGROUND_COLOR;
    private static final BColor TRUE_BACKGROUND_COLOR;
    private static final BColor DEFAULT_BACKGROUND_COLOR;
    private static final BColor[] DEFAULT_ENUM_COLORS;
    private static Integer lumaThreshold;
    private static final String[] VENDOR_PREFIXES;
    private BColor foregroundColor;
    private BColor backgroundColor;
    private BBrush.Stop[] stops;
    private BBrush foreground;
    private BBrush background;
    private String css;
    private Context cx;
    private BStatusValue statusValue;
    private boolean built;
    static /* synthetic */ Class class$javax$baja$schedule$BTimeSchedule;

    private final void rebuild(Context context) {
        if (this.cx == context && this.built) {
            return;
        }
        if (this.statusValue.getStatus().isNull()) {
            this.applyPlainColor(this.getNullColor(this.statusValue));
        } else if (this.statusValue instanceof BStatusEnum) {
            this.applyGradient(this.getBlockColor((BStatusEnum)this.statusValue));
        } else if (this.statusValue instanceof BStatusBoolean) {
            this.applyGradient(this.getBlockColor((BStatusBoolean)this.statusValue));
        } else {
            this.applyGradient(DEFAULT_BACKGROUND_COLOR);
        }
        this.cx = context;
        this.css = null;
        this.built = true;
    }

    public BBrush getForeground(Context context) {
        this.rebuild(context);
        return this.foreground;
    }

    public BBrush getBackground(Context context) {
        this.rebuild(context);
        return this.background;
    }

    public String getCss(Context context) {
        this.rebuild(context);
        if (this.css == null) {
            this.css = ScheduleColors.generateCss(this);
        }
        return this.css;
    }

    public static String getValueString(BStatusValue bStatusValue) {
        String string = null;
        string = bStatusValue.getStatus().isNull() ? "null" : (bStatusValue instanceof BStatusEnum ? Integer.toString(ScheduleColors.getOrdinalIndex((BStatusEnum)bStatusValue)) : (bStatusValue instanceof BStatusBoolean ? ((BStatusBoolean)bStatusValue).getValueValue().toString() : "default"));
        return string;
    }

    private static final Map generateAllColorValues(BTimeSchedule[] bTimeScheduleArray, Context context) {
        HashMap<String, ScheduleColors> hashMap = new HashMap<String, ScheduleColors>();
        int n = 0;
        while (n < bTimeScheduleArray.length) {
            BStatusValue bStatusValue = bTimeScheduleArray[n].getEffectiveValue();
            String string = ScheduleColors.getValueString(bStatusValue);
            if (!hashMap.containsKey(string)) {
                hashMap.put(string, new ScheduleColors(bStatusValue));
            }
            ++n;
        }
        return hashMap;
    }

    private static final Map generateAllColorValues(BWeeklySchedule bWeeklySchedule, Context context) {
        BWeekday bWeekday = BWeekday.getFirstDayOfWeek((Context)context);
        HashMap hashMap = new HashMap();
        BWeekday bWeekday2 = bWeekday;
        do {
            BDaySchedule bDaySchedule = bWeeklySchedule.get(bWeekday2);
            Class clazz = class$javax$baja$schedule$BTimeSchedule;
            if (clazz == null) {
                clazz = ScheduleColors.class("[Ljavax.baja.schedule.BTimeSchedule;", false);
            }
            BTimeSchedule[] bTimeScheduleArray = (BTimeSchedule[])bDaySchedule.getChildren(clazz);
            hashMap.putAll(ScheduleColors.generateAllColorValues(bTimeScheduleArray, context));
        } while ((bWeekday2 = bWeekday2.next()) != bWeekday);
        return hashMap;
    }

    private static final String getHxCssSelector(String string) {
        return ".schedule-HxScheduler-dayEvent.value-" + string;
    }

    private static final String colorMapToCss(Map map, Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<style>\n");
        Object object = map.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = object.next();
            String string = (String)entry.getKey();
            ScheduleColors scheduleColors = (ScheduleColors)entry.getValue();
            String string2 = ScheduleColors.getHxCssSelector(string);
            stringBuffer.append(string2).append("{").append(scheduleColors.getCss(context)).append("}\n");
        }
        stringBuffer.append("</style>\n");
        object = stringBuffer.toString();
        return object;
    }

    public static String generateInlineCss(BWeeklySchedule bWeeklySchedule, Context context) {
        Map map = ScheduleColors.generateAllColorValues(bWeeklySchedule, context);
        return ScheduleColors.colorMapToCss(map, context);
    }

    public static String generateInlineCss(BDailySchedule bDailySchedule, Context context) {
        BTimeSchedule[] bTimeScheduleArray = bDailySchedule.getDay().getTimesInOrder();
        Map map = ScheduleColors.generateAllColorValues(bTimeScheduleArray, context);
        return ScheduleColors.colorMapToCss(map, context);
    }

    private static final double normalize(double d, double d2) {
        return Math.max(0.0, Math.min(d, d2));
    }

    private static final int normalize(int n, int n2) {
        return Math.max(0, Math.min(n, n2));
    }

    private static final double[] rgbToHsv(int n, int n2, int n3) {
        n = ScheduleColors.normalize(n, 255);
        n2 = ScheduleColors.normalize(n2, 255);
        n3 = ScheduleColors.normalize(n3, 255);
        return ColorUtil.toHsb((BColor)BColor.make((int)n, (int)n2, (int)n3));
    }

    private static final BColor hsvToRgb(double d, double d2, double d3) {
        d2 = ScheduleColors.normalize(d2, 1.0);
        d3 = ScheduleColors.normalize(d3, 1.0);
        return ColorUtil.toRgb((double[])new double[]{d, d2, d3});
    }

    private final void applyPlainColor(BColor bColor) {
        this.backgroundColor = bColor;
        this.foregroundColor = ScheduleColors.getContrastingColor(bColor);
        this.foreground = this.foregroundColor.toBrush();
        this.background = this.backgroundColor.toBrush();
    }

    private final void applyGradient(BColor bColor) {
        int n = bColor.getAlpha();
        double[] dArray = ScheduleColors.rgbToHsv(bColor.getRed(), bColor.getGreen(), bColor.getBlue());
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        BColor bColor2 = BColor.make((BColor)ScheduleColors.hsvToRgb(d, d2 * 0.5, d3 * 1.35), (int)n);
        BColor bColor3 = BColor.make((BColor)ScheduleColors.hsvToRgb(d, d2 * 0.6, d3 * 1.25), (int)n);
        BColor bColor4 = BColor.make((BColor)ScheduleColors.hsvToRgb(d, d2 * 0.9, d3 * 1.05), (int)n);
        BColor bColor5 = BColor.make((BColor)ScheduleColors.hsvToRgb(d, d2, d3), (int)n);
        this.stops = new BBrush.Stop[]{BBrush.stop((double)0.0, (BColor)bColor2), BBrush.stop((double)30.0, (BColor)bColor3), BBrush.stop((double)90.0, (BColor)bColor4), BBrush.stop((double)97.0, (BColor)bColor5), BBrush.stop((double)100.0, (BColor)bColor4)};
        this.backgroundColor = bColor2;
        this.background = BBrush.makeLinearGradient((BBrush.Stop[])this.stops, (int)1, (double)270.0);
        this.foregroundColor = ScheduleColors.getContrastingColor(bColor2);
        this.foreground = this.foregroundColor.toBrush();
    }

    private static final double luma(BColor bColor) {
        double d = bColor.getRed();
        double d2 = bColor.getGreen();
        double d3 = bColor.getBlue();
        if (bColor.getAlpha() < 255) {
            BColor bColor2 = ScheduleColors.getScheduleBackground();
            double d4 = bColor2.getRed();
            double d5 = bColor2.getGreen();
            double d6 = bColor2.getBlue();
            double d7 = (double)bColor.getAlpha() / 255.0;
            d = d7 * (d - d4) + d4;
            d2 = d7 * (d2 - d5) + d5;
            d3 = d7 * (d3 - d6) + d6;
        }
        return 0.2126 * d + 0.7152 * d2 + 0.0722 * d3;
    }

    private static final BColor getContrastingColor(BColor bColor) {
        if (ScheduleColors.luma(bColor) > (double)ScheduleColors.getLumaThreshold()) {
            return BColor.black;
        }
        return BColor.white;
    }

    private static final int getLumaThreshold() {
        if (lumaThreshold == null) {
            try {
                int n = Integer.parseInt(System.getProperty("schedule.lumaThreshold", "150"));
                lumaThreshold = new Integer(n);
            }
            catch (Exception exception) {
                lumaThreshold = new Integer(150);
            }
        }
        return lumaThreshold;
    }

    private final BColor getBlockColor(BStatusEnum bStatusEnum) {
        BDynamicEnum bDynamicEnum = bStatusEnum.getValue();
        BWeeklySchedule bWeeklySchedule = ScheduleColors.getWeeklySchedule((BStatusValue)bStatusEnum);
        BColor bColor = ScheduleColors.getConfiguredColor(bDynamicEnum.getOrdinal(), bWeeklySchedule);
        if (bColor == null) {
            bColor = this.getLexiconColor(bStatusEnum);
        }
        if (bColor == null) {
            bColor = ScheduleColors.getDefaultColor(bStatusEnum);
        }
        return bColor;
    }

    private static final BEnumRange getEnumRange(BStatusEnum bStatusEnum) {
        BObject bObject;
        BWeeklySchedule bWeeklySchedule;
        BDynamicEnum bDynamicEnum = bStatusEnum.getValue();
        BEnumRange bEnumRange = bDynamicEnum.getRange();
        if (bEnumRange == BEnumRange.DEFAULT && (bWeeklySchedule = ScheduleColors.getWeeklySchedule((BStatusValue)bStatusEnum)) != null && (bObject = bWeeklySchedule.getFacets().get("range")) instanceof BEnumRange) {
            bEnumRange = (BEnumRange)bObject;
        }
        return bEnumRange;
    }

    public static int getOrdinalIndex(BStatusEnum bStatusEnum) {
        BDynamicEnum bDynamicEnum = bStatusEnum.getValue();
        BEnumRange bEnumRange = ScheduleColors.getEnumRange(bStatusEnum);
        int n = bDynamicEnum.getOrdinal();
        int[] nArray = bEnumRange.getOrdinals();
        int n2 = ArrayUtil.indexOf((int[])nArray, (int)n);
        if (n2 == -1) {
            return n;
        }
        return n2;
    }

    private final BColor getLexiconColor(BStatusEnum bStatusEnum) {
        int n = ScheduleColors.getOrdinalIndex(bStatusEnum);
        if (n >= 0) {
            String string = "EnumSchedule.colors." + n;
            return this.getColorFromLexicon(string);
        }
        return null;
    }

    private static final BColor getDefaultColor(BStatusEnum bStatusEnum) {
        int n = ScheduleColors.getOrdinalIndex(bStatusEnum);
        n = Math.abs(n);
        int n2 = DEFAULT_ENUM_COLORS.length;
        int n3 = n % (n2 * 2);
        int n4 = n3 % n2;
        return DEFAULT_ENUM_COLORS[n4];
    }

    private final BColor getBlockColor(BStatusBoolean bStatusBoolean) {
        BWeeklySchedule bWeeklySchedule;
        boolean bl = bStatusBoolean.getValue();
        BColor bColor = ScheduleColors.getConfiguredColor(bl ? 1 : 0, bWeeklySchedule = ScheduleColors.getWeeklySchedule((BStatusValue)bStatusBoolean));
        if (bColor == null) {
            bColor = this.getLexiconColor(bl);
        }
        if (bColor == null) {
            bColor = ScheduleColors.getDefaultColor(bl);
        }
        return bColor;
    }

    private final BColor getLexiconColor(boolean bl) {
        String string = "BooleanSchedule.colors." + (int)(bl ? 1 : 0);
        return this.getColorFromLexicon(string);
    }

    private static final BColor getDefaultColor(boolean bl) {
        return bl ? TRUE_BACKGROUND_COLOR : FALSE_BACKGROUND_COLOR;
    }

    private static final BColor getConfiguredColor(int n, BWeeklySchedule bWeeklySchedule) {
        BEnumRange bEnumRange;
        BFacets bFacets;
        BObject bObject;
        if (bWeeklySchedule instanceof BWeeklySchedule && (bObject = (bFacets = bWeeklySchedule.getFacets()).get("colors")) instanceof BEnumRange && (bEnumRange = (BEnumRange)bObject).isOrdinal(n)) {
            String string = bEnumRange.getDisplayTag(n, null);
            try {
                return BColor.make((String)string);
            }
            catch (Exception exception) {
                LOG.error("Invalid color configured on schedule: " + string);
            }
        }
        return null;
    }

    private final BColor getColorFromLexicon(String string) {
        String string2 = this.getScheduleLex().get(string);
        if (string2 != null) {
            try {
                return BColor.make((String)string2);
            }
            catch (Exception exception) {
                LOG.error("Invalid color in lexicon: " + string + " = " + string2);
                return null;
            }
        }
        return null;
    }

    private final BColor getNullColor(BStatusValue bStatusValue) {
        BColor bColor = null;
        if (bStatusValue instanceof BStatusEnum) {
            bColor = this.getColorFromLexicon("EnumSchedule.colors.null");
        } else if (bStatusValue instanceof BStatusBoolean) {
            bColor = this.getColorFromLexicon("BooleanSchedule.colors.null");
        }
        if (bColor == null) {
            bColor = NULL_BACKGROUND_COLOR;
        }
        return bColor;
    }

    private static final BColor getScheduleBackground() {
        if (scheduleBackground == null) {
            scheduleBackground = ((BBrush.Solid)Utils.clrBg.getPaint()).getColor();
        }
        return scheduleBackground;
    }

    private final Lexicon getScheduleLex() {
        return Lexicon.make((String)"schedule", (Context)this.cx);
    }

    private static final BWeeklySchedule getWeeklySchedule(BStatusValue bStatusValue) {
        BStatusValue bStatusValue2 = bStatusValue;
        while (bStatusValue2 != null && !bStatusValue2.isNull()) {
            if (bStatusValue2.getType().is(BWeeklySchedule.TYPE)) {
                return (BWeeklySchedule)bStatusValue2;
            }
            bStatusValue2 = bStatusValue2.getParent();
        }
        return null;
    }

    private static final String toRgba(BColor bColor) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = bColor.getAlpha();
        if (n == 255) {
            stringBuffer.append("rgb(").append(bColor.getRed()).append(',').append(bColor.getGreen()).append(',').append(bColor.getBlue()).append(')');
        } else {
            double d = (double)Math.round((double)bColor.getAlpha() / 255.0 * 100.0) / 100.0;
            stringBuffer.append("rgba(").append(bColor.getRed()).append(',').append(bColor.getGreen()).append(',').append(bColor.getBlue()).append(',').append(d).append(')');
        }
        return stringBuffer.toString();
    }

    private static final String makeIEFilter(BColor bColor, BColor bColor2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("progid:DXImageTransform.Microsoft.gradient(GradientType=0,startColorstr='").append(bColor.toHtmlString()).append("',endColorstr='").append(bColor2.toHtmlString()).append("')");
        return stringBuffer.toString();
    }

    private static final String createGradientPointData(double d) {
        double d2 = d * Math.PI / 180.0;
        double d3 = Math.cos(d2);
        double d4 = Math.sin(d2);
        double d5 = 1.0 / Math.max(Math.abs(d4), Math.abs(d3));
        double d6 = d3 * d5;
        double d7 = -d4 * d5;
        double d8 = -d6;
        double d9 = -d7;
        d8 = Math.round((d8 + 1.0) * 50.0);
        d9 = Math.round((d9 + 1.0) * 50.0);
        d6 = Math.round((d6 + 1.0) * 50.0);
        d7 = Math.round((d7 + 1.0) * 50.0);
        return d8 + "% " + d9 + "%, " + d6 + "% " + d7 + '%';
    }

    private static final String makeWebkitGradient(BBrush.Stop[] stopArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(linear, left top, left bottom");
        int n = 0;
        while (n < stopArray.length) {
            BBrush.Stop stop = stopArray[n];
            BColor bColor = stop.getColor();
            stringBuffer.append(", color-stop(").append(stop.getOffset()).append("%, ").append(ScheduleColors.toRgba(bColor)).append(")");
            ++n;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private static final String makeLinearGradient(BBrush.Stop[] stopArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = stopArray.length;
        int n2 = 0;
        stringBuffer.append("(top, ");
        while (n2 < n) {
            BBrush.Stop stop = stopArray[n2];
            stringBuffer.append(ScheduleColors.toRgba(stop.getColor())).append(" ").append(stop.getOffset()).append("%");
            if (++n2 >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private static final String generateCss(ScheduleColors scheduleColors) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" color:").append(ScheduleColors.toRgba(scheduleColors.foregroundColor)).append(";\n");
        stringBuffer.append(" background-color:").append(ScheduleColors.toRgba(scheduleColors.backgroundColor)).append(";\n");
        BBrush.Stop[] stopArray = scheduleColors.stops;
        if (stopArray == null || stopArray.length == 0) {
            return stringBuffer.toString();
        }
        BColor bColor = stopArray[0].getColor();
        BColor bColor2 = stopArray[stopArray.length - 1].getColor();
        stringBuffer.append(" background-image:-webkit-gradient").append(ScheduleColors.makeWebkitGradient(stopArray)).append(";\n");
        String string = ScheduleColors.makeLinearGradient(stopArray);
        int n = 0;
        while (n < VENDOR_PREFIXES.length) {
            stringBuffer.append(" background-image:").append(VENDOR_PREFIXES[n]).append("linear-gradient").append(string).append(";\n");
            ++n;
        }
        stringBuffer.append(" filter: ").append(ScheduleColors.makeIEFilter(bColor, bColor2)).append(";\n");
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.foreground = Utils.clrSelFg;
        this.background = Utils.clrSelBg;
        this.css = null;
    }

    public ScheduleColors(BStatusValue bStatusValue) {
        this.this();
        this.statusValue = bStatusValue;
    }

    static {
        NULL_BACKGROUND_COLOR = BColor.make((String)"#f8cccccc");
        FALSE_BACKGROUND_COLOR = BColor.make((String)"#f8e17171");
        TRUE_BACKGROUND_COLOR = BColor.make((String)"#f865cb65");
        DEFAULT_BACKGROUND_COLOR = BColor.make((String)"#f88fbc8f");
        DEFAULT_ENUM_COLORS = new BColor[]{BColor.make((String)"#f88c0000"), BColor.make((String)"#f8387038"), BColor.make((String)"#f8703870"), BColor.make((String)"#f825255a"), BColor.make((String)"#f81f6f70"), BColor.make((String)"#f8704308"), BColor.make((String)"#f8606060"), BColor.make((String)"#f8e17171"), BColor.make((String)"#f865cb65"), BColor.make((String)"#f8cb7fcb"), BColor.make((String)"#f86c6ccb"), BColor.make((String)"#f854b7b8"), BColor.make((String)"#f8c88435"), BColor.make((String)"#f8e1e171")};
        VENDOR_PREFIXES = new String[]{"-webkit-", "-moz-", "-ms-", ""};
    }
}

