/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.schedule.ui;

import com.tridium.schedule.ui.BAbstractScheduleView;
import com.tridium.schedule.ui.BAbstractScheduleWidget;
import com.tridium.schedule.ui.ScheduleColors;
import com.tridium.schedule.ui.Utils;
import com.tridium.ui.UiEnv;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.WidgetTheme;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BDaySchedule;
import javax.baja.schedule.BTimeSchedule;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BDaySlider
extends BAbstractScheduleWidget {
    public static final Topic clearWeek = BDaySlider.newTopic((int)0, null);
    public static final Topic fillWeek = BDaySlider.newTopic((int)0, null);
    public static final Topic schDragged = BDaySlider.newTopic((int)0, null);
    public static final Topic schRemoved = BDaySlider.newTopic((int)0, null);
    public static final Topic schSelected = BDaySlider.newTopic((int)0, null);
    public static final Type TYPE;
    private static final int BOTTOM = 0;
    private static final int CENTER = 1;
    private static final int TOP = 2;
    private static int RANGE_BORDER;
    static WidgetTheme widgetTheme;
    static BFont font;
    static double fontOffset;
    private Clipboard clipboard;
    private BStatusValue defaultValue;
    private Range dragging;
    private int dragType;
    private BFacets facets;
    private Range first;
    private int maxU;
    private int minU;
    private double pressedOffset;
    private double pressedY;
    BDaySchedule schedule;
    private Range selected;
    private boolean week;
    int units;
    int[] unitLines;
    private int[] unitY;
    private boolean dragHappened;
    static /* synthetic */ Class class$com$tridium$schedule$ui$BDaySlider;
    static /* synthetic */ Class class$javax$baja$schedule$BTimeSchedule;
    static /* synthetic */ Class class$javax$baja$schedule$BAbstractSchedule;

    public void fireClearWeek(BValue bValue) {
        this.fire(clearWeek, bValue, null);
    }

    public void fireFillWeek(BDaySchedule bDaySchedule) {
        this.fire(fillWeek, (BValue)bDaySchedule, null);
    }

    public void fireSchDragged(BValue bValue) {
        this.fire(schDragged, bValue, null);
    }

    public void fireSchRemoved(BValue bValue) {
        this.fire(schRemoved, bValue, null);
    }

    public void fireSchSelected(BDaySlider bDaySlider) {
        this.fire(schSelected, (BValue)bDaySlider, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Range add(Object object, BTime bTime, BTime bTime2) {
        BTimeSchedule bTimeSchedule = new BTimeSchedule();
        bTimeSchedule.setStart(bTime);
        bTimeSchedule.setFinish(bTime2);
        bTimeSchedule.setEffectiveValue((BStatusValue)object);
        this.schedule.add(bTimeSchedule);
        Range range = new Range(this, bTimeSchedule);
        this.add(range);
        return range;
    }

    public Range add(Object object, int n, int n2) {
        if (n == n2 && n == 0) {
            n2 = n + 1;
            this.fireModified(null);
        }
        BTimeSchedule bTimeSchedule = new BTimeSchedule();
        bTimeSchedule.setStart(BTime.make((BRelTime)BRelTime.make((long)this.unitToMillis(n, true))));
        bTimeSchedule.setFinish(BTime.make((BRelTime)BRelTime.make((long)this.unitToMillis(n2, false))));
        bTimeSchedule.setEffectiveValue((BStatusValue)object);
        this.schedule.add(bTimeSchedule);
        Range range = new Range(this, bTimeSchedule, n, n2);
        this.add(range);
        return range;
    }

    public void clearDay() {
        while (this.first != null) {
            this.remove(this.first);
        }
    }

    public void copy(BDaySchedule bDaySchedule) {
        this.clearDay();
        this.schedule.removeAll(null);
        Class clazz = class$javax$baja$schedule$BTimeSchedule;
        if (clazz == null) {
            clazz = class$javax$baja$schedule$BTimeSchedule = BDaySlider.class("[Ljavax.baja.schedule.BTimeSchedule;", false);
        }
        Object[] objectArray = bDaySchedule.getChildren(clazz);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            BTimeSchedule bTimeSchedule = (BTimeSchedule)((Object)objectArray[n2]);
            bTimeSchedule = (BTimeSchedule)bTimeSchedule.newCopy(true);
            this.schedule.add(bTimeSchedule);
            Range range = new Range(this, bTimeSchedule, this.millisToUnit(bTimeSchedule.getStart().getTimeOfDayMillis(), true), this.millisToUnit(bTimeSchedule.getFinish().getTimeOfDayMillis(), false));
            this.add(range);
            ++n2;
        }
    }

    public void computePreferredSize() {
        double d = font.width("WWWWW");
        double d2 = d * (double)3;
        this.setPreferredSize(d, d2);
    }

    public void deselect() {
        this.selected = null;
        this.repaint();
    }

    public void doLayout(BWidget[] bWidgetArray) {
        if (this.schedule != null) {
            BAbstractSchedule bAbstractSchedule = this.schedule.getRootSchedule();
            this.facets = (BFacets)bAbstractSchedule.get("facets");
        }
        if (this.unitY == null) {
            this.unitY = new int[this.units + 1];
        }
        double d = this.getHeight();
        double d2 = d / (double)this.units;
        int n = 0;
        while (n < this.units) {
            this.unitY[n] = (int)Math.round((double)n * d2);
            ++n;
        }
        this.unitY[this.units] = (int)d - 1;
    }

    public BTimeSchedule getSelectedSchedule() {
        if (this.selected == null) {
            return null;
        }
        return this.selected.sch;
    }

    public String getUnitLabel(int n) {
        long l = this.unitToMillis(n, false);
        BTime bTime = BTime.make((BRelTime)BRelTime.make((long)l));
        return bTime.toString(null);
    }

    public boolean isFocusTraversable() {
        boolean bl = false;
        if (this.first != null) {
            bl = true;
        }
        return bl;
    }

    public void load(BDaySchedule bDaySchedule, BStatusValue bStatusValue) {
        this.schedule = bDaySchedule;
        this.defaultValue = bStatusValue;
        this.first = null;
        this.dragging = null;
        this.selected = null;
        BAbstractSchedule bAbstractSchedule = bDaySchedule.getRootSchedule();
        this.facets = (BFacets)bAbstractSchedule.get("facets");
        Class clazz = class$javax$baja$schedule$BTimeSchedule;
        if (clazz == null) {
            clazz = class$javax$baja$schedule$BTimeSchedule = BDaySlider.class("[Ljavax.baja.schedule.BTimeSchedule;", false);
        }
        Object[] objectArray = bDaySchedule.getChildren(clazz);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            BTimeSchedule bTimeSchedule = (BTimeSchedule)((Object)objectArray[n2]);
            Range range = new Range(this, bTimeSchedule, this.millisToUnit(bTimeSchedule.getStart().getTimeOfDayMillis(), true), this.millisToUnit(bTimeSchedule.getFinish().getTimeOfDayMillis(), false));
            this.add(range);
            ++n2;
        }
    }

    public void keyPressed(BKeyEvent bKeyEvent) {
        if (!this.isEnabled() || this.isReadonly()) {
            return;
        }
        switch (bKeyEvent.getKeyCode()) {
            case 8: 
            case 127: {
                if (this.selected == null) {
                    return;
                }
                bKeyEvent.consume();
                this.remove(this.selected);
                this.repaint();
                break;
            }
            case 9: {
                if (this.selected == null) {
                    if (this.first == null) break;
                    this.select(this.first);
                    bKeyEvent.consume();
                    break;
                }
                if (this.selected.next == null) break;
                this.select(this.selected.next);
                bKeyEvent.consume();
            }
        }
    }

    public int millisToUnit(long l, boolean bl) {
        if (l == 0L) {
            if (bl) {
                return 0;
            }
            return this.units;
        }
        float f = 86400000 / this.units;
        return Math.round((float)l / f);
    }

    public int millisToRangeUnit(long l, boolean bl) {
        if (l == 0L) {
            if (bl) {
                return 0;
            }
            return this.units;
        }
        float f = 86400000 / this.units;
        if (bl) {
            return Math.round((float)l / f - 0.49999f);
        }
        return Math.round((float)l / f + 0.49999f);
    }

    public void mouseDragged(BMouseEvent bMouseEvent) {
        this.processMouseMotionEvent(bMouseEvent);
    }

    public void mouseEntered(BMouseEvent bMouseEvent) {
        this.processMouseEvent(bMouseEvent);
    }

    public void mouseExited(BMouseEvent bMouseEvent) {
        this.processMouseEvent(bMouseEvent);
    }

    public void mouseMoved(BMouseEvent bMouseEvent) {
        this.processMouseMotionEvent(bMouseEvent);
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        this.processMouseEvent(bMouseEvent);
    }

    public void mousePulsed(BMouseEvent bMouseEvent) {
        this.processMouseEvent(bMouseEvent);
    }

    public void mouseReleased(BMouseEvent bMouseEvent) {
        this.processMouseEvent(bMouseEvent);
        if (this.dragHappened) {
            this.dragHappened = false;
            this.fireModified(null);
        }
    }

    public void paint(Graphics graphics) {
        this.paintBackground(graphics);
        this.paintForeground(graphics);
    }

    public void popup(BMouseEvent bMouseEvent) {
        Class clazz;
        if (this.isReadonly()) {
            return;
        }
        BMenu bMenu = new BMenu();
        this.pressedY = bMouseEvent.getY();
        Range range = this.yToRange(this.pressedY);
        if (range != null) {
            if (this.selected != range) {
                this.select(range);
            }
            bMenu.add(null, (Command)new CmdDelete());
        }
        if ((clazz = class$javax$baja$schedule$BAbstractSchedule) == null) {
            clazz = class$javax$baja$schedule$BAbstractSchedule = BDaySlider.class("[Ljavax.baja.schedule.BAbstractSchedule;", false);
        }
        Object[] objectArray = this.schedule.getChildren(clazz);
        if (this.clipboard != null && this.clipboard.get() != null && this.clipboard.get() != this.schedule) {
            bMenu.add(null, (Command)new CmdPaste());
        }
        bMenu.add(null, (Command)new CmdAllDay());
        if (objectArray.length > 0) {
            if (this.week) {
                bMenu.add(null, (Command)new CmdFill());
                bMenu.add(null, (Command)new CmdCopy());
            }
            bMenu.add(null, (Command)new CmdClear());
        }
        if (this.week) {
            bMenu.add(null, (Command)new CmdClearWeek());
        } else {
            bMenu.add(null, (Command)new CmdScheduleDefaults());
        }
        bMenu.open((BWidget)this, bMouseEvent.getX(), bMouseEvent.getY());
    }

    private final void processMouseEvent(BMouseEvent bMouseEvent) {
        if (bMouseEvent.isPopupTrigger()) {
            this.popup(bMouseEvent);
            return;
        }
        switch (bMouseEvent.getId()) {
            case 504: {
                if (!this.isEnabled() || this.isReadonly()) {
                    return;
                }
                if (this.dragging != null) break;
                this.checkCursor(bMouseEvent.getY());
                break;
            }
            case 505: {
                if (!this.isEnabled() || this.isReadonly()) {
                    return;
                }
                if (this.dragging != null) break;
                this.setMouseCursor(MouseCursor.normal);
                break;
            }
            case 501: {
                this.pressedY = bMouseEvent.getY();
                if (bMouseEvent.isButton1Down()) {
                    this.dragging = this.yToRange(this.pressedY);
                }
                if (this.dragging == null) {
                    if (!UiEnv.get().hasMouse() && bMouseEvent.isButton1Down()) {
                        int n;
                        int n2 = this.yToUnit(this.pressedY);
                        if (n2 == (n = Math.min(this.units, n2 + 2))) {
                            return;
                        }
                        if (this.yToRange(this.unitToY(n2 + 1)) != null) {
                            return;
                        }
                        this.dragging = this.add((Object)this.newEffectiveValue(), n2, n);
                    } else {
                        return;
                    }
                }
                this.select(this.dragging);
                if (!this.isEnabled() || this.isReadonly()) {
                    this.dragging = null;
                    return;
                }
                this.startDrag(this.pressedY, false);
                this.requestFocus();
                break;
            }
            case 502: {
                if (!this.isEnabled() || this.isReadonly()) {
                    return;
                }
                this.dragging = null;
                this.checkCursor(bMouseEvent.getY());
                break;
            }
        }
    }

    private final void processMouseMotionEvent(BMouseEvent bMouseEvent) {
        if (!this.isEnabled() || this.isReadonly()) {
            return;
        }
        switch (bMouseEvent.getId()) {
            case 503: {
                this.checkCursor(bMouseEvent.getY());
                break;
            }
            case 506: {
                if (!bMouseEvent.isButton1Down()) {
                    return;
                }
                double d = bMouseEvent.getY();
                if (this.dragging != null) {
                    this.handleDrag(d);
                    break;
                }
                if (!(d - this.pressedY >= (double)2)) break;
                int n = this.yToUnit(this.pressedY);
                int n2 = this.unitToY(n);
                Range range = this.yToRange(n2);
                if (range != null && range.finishRange > n) {
                    return;
                }
                this.dragging = this.add((Object)this.newEffectiveValue(), this.yToUnit(this.pressedY), this.yToUnit(d));
                this.select(this.dragging);
                this.startDrag(d, true);
                break;
            }
        }
    }

    public void remove(Range range) {
        if (range == this.first) {
            this.first = range.next;
            if (this.first != null) {
                this.first.prev = null;
            }
        } else {
            range.prev.next = range.next;
            if (range.prev.next != null) {
                range.next.prev = range.prev;
            }
        }
        if (range == this.selected) {
            this.selected = null;
        }
        this.schedule.remove((BComplex)range.sch);
        this.fireSchRemoved((BValue)range.sch);
    }

    public final void select(Range range) {
        if (this.selected == range) {
            return;
        }
        this.selected = range;
        this.repaint();
        if (range != null) {
            this.fireSchSelected(this);
        }
    }

    public final BTime selectedEarliestStart() {
        if (this.selected.prev == null) {
            return BTime.make((int)0, (int)0, (int)0, (int)0);
        }
        return this.selected.prev.sch.getFinish();
    }

    public final BTime selectedLatestFinish() {
        if (this.selected.next == null) {
            return BTime.make((int)0, (int)0, (int)0, (int)0);
        }
        return this.selected.next.sch.getStart();
    }

    public long unitToMillis(int n, boolean bl) {
        if (n == 0) {
            if (bl) {
                return 0L;
            }
            return 86400000L;
        }
        float f = 86400000 / this.units;
        return (long)(f * (float)n);
    }

    public final int unitToY(int n) {
        if (this.unitY == null) {
            return 0;
        }
        return this.unitY[n];
    }

    public final int unitToY(int n, int n2) {
        float f = (float)n2 / (float)this.units;
        return Math.round((float)n * f);
    }

    public void updateSelectedSchedule() {
        this.selected.updateUnits();
        this.selected.updateColors();
        this.repaint();
    }

    public final Range yToRange(double d) {
        Range range = this.first;
        while (range != null) {
            if (d >= range.startY() && d <= range.finishY()) {
                return range;
            }
            range = range.next;
        }
        return null;
    }

    public final int yToUnit(double d) {
        double d2 = d / this.getHeight();
        d2 = (double)this.units * d2;
        return (int)Math.min(Math.round(d2), (long)this.units);
    }

    protected void paintBackground(Graphics graphics) {
        double d = this.getWidth();
        double d2 = this.getHeight();
        if (this.isReadonly() || !this.isEnabled()) {
            graphics.setBrush(Utils.clrRoBg);
        } else {
            graphics.setBrush(Utils.clrBg);
        }
        graphics.fillRect(0.0, 0.0, d, d2);
        if (this.unitLines != null) {
            graphics.setBrush(Utils.clrFg);
            int n = this.unitLines.length;
            while (--n >= 0) {
                double d3 = this.unitToY(this.unitLines[n]);
                graphics.strokeLine(0.0, d3, d, d3);
            }
        }
        if (this.defaultValue != null) {
            graphics.setFont(font);
            graphics.setBrush(Utils.clrFg);
            if (this.week) {
                graphics.drawString(this.valueText(this.defaultValue), (double)2, (double)2 + fontOffset);
            } else {
                graphics.drawString(this.lex("day.unscheduled"), (double)2, (double)2 + fontOffset);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void paintForeground(Graphics graphics) {
        graphics.setFont(font);
        Range range = this.first;
        double d = this.getWidth();
        while (range != null) {
            Object var14_9;
            double d2 = range.startY();
            double d3 = range.height() + 1.0;
            boolean bl = false;
            if (range == this.selected) {
                bl = true;
            }
            boolean bl2 = bl;
            graphics.push();
            try {
                ScheduleColors scheduleColors = range.getColors();
                graphics.clip(0.0, d2, d, d3);
                graphics.setBrush(bl2 ? Utils.clrSelCurBg : scheduleColors.getBackground(null));
                graphics.fillRect(0.0, d2, d, d3);
                graphics.setBrush(Utils.clrFg);
                double d4 = d2 + d3 - 1.0;
                graphics.strokeLine(0.0, d2, d, d2);
                graphics.strokeLine(0.0, d4, d, d4);
                String string = this.rangeText(range);
                if (string != null) {
                    graphics.setBrush(bl2 ? Utils.clrSelFg : scheduleColors.getForeground(null));
                    graphics.drawString(string, (double)2, d2 + fontOffset);
                }
            }
            catch (Throwable throwable) {
                var14_9 = null;
                graphics.pop();
                throw throwable;
            }
            {
                var14_9 = null;
            }
            graphics.pop();
            range = range.next;
        }
        return;
    }

    private final void add(Range range) {
        Range range2 = this.predecessor(range.start);
        if (range2 == null) {
            range.next = this.first;
            if (range.next != null) {
                this.first.prev = range;
            }
            this.first = range;
        } else {
            range.next = range2.next;
            if (range.next != null) {
                range.next.prev = range;
            }
            range.prev = range2;
            range2.next = range;
        }
    }

    private final void checkCursor(double d) {
        if (!this.isEnabled() || this.isReadonly()) {
            return;
        }
        Range range = this.yToRange(d);
        if (range == null) {
            this.setMouseCursor(MouseCursor.normal);
        } else if (d <= range.startY() + (double)RANGE_BORDER) {
            this.setMouseCursor(MouseCursor.nResize);
        } else if (d >= range.finishY() - (double)RANGE_BORDER) {
            this.setMouseCursor(MouseCursor.sResize);
        } else if (d > range.startY() && d < range.finishY()) {
            this.setMouseCursor(MouseCursor.openHand);
        } else {
            this.setMouseCursor(MouseCursor.normal);
        }
    }

    private final void handleDrag(double d) {
        boolean bl = false;
        switch (this.dragType) {
            case 2: {
                int n = this.yToUnit(d);
                n = n < this.minU ? this.minU : (n > this.maxU ? this.maxU : n);
                boolean bl2 = false;
                if (n != this.dragging.start) {
                    bl2 = bl = true;
                }
                if (this.dragging.start == n) {
                    return;
                }
                this.dragging.start = n;
                this.dragging.updateStartTime();
                break;
            }
            case 0: {
                int n = this.yToUnit(d);
                n = n < this.minU ? this.minU : (n > this.maxU ? this.maxU : n);
                boolean bl3 = false;
                if (n != this.dragging.finish) {
                    bl3 = bl = true;
                }
                if (this.dragging.finish == n) {
                    return;
                }
                this.dragging.finish = n;
                this.dragging.updateFinishTime();
                break;
            }
            case 1: {
                int n = this.dragging.finish - this.dragging.start;
                int n2 = this.yToUnit(d -= this.pressedOffset);
                n2 = n2 < this.minU ? this.minU : (n2 > this.maxU ? this.maxU : n2);
                boolean bl4 = false;
                if (n2 != this.dragging.start) {
                    bl4 = bl = true;
                }
                if (this.dragging.start == n2 && this.dragging.finish == n2 + n) {
                    return;
                }
                this.dragging.start = n2;
                this.dragging.finish = n2 + n;
                this.dragging.updateStartTime();
                this.dragging.updateFinishTime();
                break;
            }
        }
        if (bl) {
            this.repaint();
        }
        this.dragHappened = true;
        this.fireSchDragged(null);
    }

    private final BStatusValue newEffectiveValue() {
        BStatusBoolean bStatusBoolean;
        if (this.clipboard != null) {
            return this.clipboard.newEffectiveValue();
        }
        BAbstractScheduleView bAbstractScheduleView = this.getView();
        BStatusValue bStatusValue = this.defaultValue;
        if ((bStatusValue = (BStatusValue)bStatusValue.newCopy(true)) instanceof BStatusBoolean) {
            bStatusBoolean = (BStatusBoolean)bStatusValue;
            bStatusBoolean.setValue(bStatusBoolean.getValue() ^ true);
        }
        if ((bStatusBoolean = bStatusValue.getStatus()).isNull()) {
            bStatusValue.setStatus(BStatus.makeNull((BStatus)bStatusBoolean, (boolean)false));
        }
        return bStatusValue;
    }

    private final Range predecessor(double d) {
        Range range = this.first;
        Range range2 = null;
        while (range != null) {
            if (d <= (double)range.start) {
                return range2;
            }
            range2 = range;
            range = range.next;
        }
        return range2;
    }

    private final String rangeText(Range range) {
        try {
            BTimeSchedule bTimeSchedule = range.sch;
            if (bTimeSchedule == null) {
                return "???";
            }
            BStatusValue bStatusValue = bTimeSchedule.getEffectiveValue();
            if (bStatusValue == null) {
                return "";
            }
            return this.valueText(bStatusValue);
        }
        catch (Exception exception) {
            Utils.error(this, exception);
            return "-";
        }
    }

    private final void startDrag(double d, boolean bl) {
        Range range = this.dragging;
        if (range != null) {
            if (d >= range.finishY() - (double)RANGE_BORDER || bl) {
                this.dragType = 0;
                this.minU = range.start + 1;
                this.maxU = range.next == null ? this.units : range.next.startRange;
                this.setMouseCursor(MouseCursor.sResize);
            } else if (d <= range.startY() + (double)RANGE_BORDER) {
                this.setMouseCursor(MouseCursor.nResize);
                this.dragType = 2;
                int n = 0;
                if (range.prev != null) {
                    n = range.prev.finishRange;
                }
                this.minU = n;
                this.maxU = range.finish - 1;
            } else {
                this.setMouseCursor(MouseCursor.grabHand);
                this.dragType = 1;
                this.pressedOffset = d - range.startY();
                int n = this.dragging.finish - this.dragging.start;
                int n2 = 0;
                if (range.prev != null) {
                    n2 = range.prev.finishRange;
                }
                this.minU = n2;
                this.maxU = range.next == null ? this.units - n : range.next.startRange - n;
            }
        } else {
            range = this.predecessor(d);
            if (range == null) {
                this.minU = 0;
                this.maxU = this.first == null ? this.units : this.first.start;
            } else {
                this.minU = range.finish;
                this.maxU = range.next == null ? this.units : range.start;
            }
            this.setMouseCursor(MouseCursor.sResize);
        }
    }

    private final String valueText(BStatusValue bStatusValue) {
        if (bStatusValue.getStatus().isNull()) {
            return this.lex("day.null");
        }
        return bStatusValue.getValueValue().toString((Context)this.facets);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.units = 48;
        this.unitLines = new int[]{6, 12, 18, 24, 30, 36, 42};
        this.dragHappened = false;
    }

    public BDaySlider() {
        this.this();
    }

    public BDaySlider(Clipboard clipboard, boolean bl) {
        this.this();
        this.clipboard = clipboard;
        this.week = bl;
    }

    static {
        Class clazz = class$com$tridium$schedule$ui$BDaySlider;
        if (clazz == null) {
            clazz = class$com$tridium$schedule$ui$BDaySlider = BDaySlider.class("[Lcom.tridium.schedule.ui.BDaySlider;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        RANGE_BORDER = 4;
        widgetTheme = Theme.widget();
        font = widgetTheme.getTextFont();
        fontOffset = font.getMaxAscent() + 1.0;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class Range {
        Range next;
        Range prev;
        BTimeSchedule sch;
        BDaySlider slider;
        private int start;
        private int finish;
        int startRange;
        int finishRange;
        private ScheduleColors colors;

        public int getFinish() {
            return this.finish;
        }

        public int getStart() {
            return this.start;
        }

        public ScheduleColors getColors() {
            return this.colors;
        }

        final double finishY() {
            return this.slider.unitToY(this.finish);
        }

        public BDaySlider getSlider() {
            return this.slider;
        }

        public Object getValue() {
            return this.sch.getEffectiveValue();
        }

        final double height() {
            double d = this.slider.unitToY(this.finish);
            double d2 = this.slider.unitToY(this.start);
            return Math.max(d - d2, 1.0);
        }

        final double startY() {
            return this.slider.unitToY(this.start);
        }

        final void updateFinishTime() {
            this.sch.setFinish(BTime.make((BRelTime)BRelTime.make((long)BDaySlider.this.unitToMillis(this.finish, false))));
            this.updateRangeUnits();
        }

        final void updateStartTime() {
            this.sch.setStart(BTime.make((BRelTime)BRelTime.make((long)BDaySlider.this.unitToMillis(this.start, true))));
            this.updateRangeUnits();
        }

        final void updateUnits() {
            this.start = BDaySlider.this.millisToUnit(this.sch.getStart().getTimeOfDayMillis(), true);
            this.finish = BDaySlider.this.millisToUnit(this.sch.getFinish().getTimeOfDayMillis(), false);
            this.updateRangeUnits();
        }

        final void updateRangeUnits() {
            this.startRange = BDaySlider.this.millisToRangeUnit(this.sch.getStart().getTimeOfDayMillis(), true);
            this.finishRange = BDaySlider.this.millisToRangeUnit(this.sch.getFinish().getTimeOfDayMillis(), false);
        }

        void updateColors() {
            this.colors = new ScheduleColors(this.sch.getEffectiveValue());
        }

        Range(BDaySlider bDaySlider2, BTimeSchedule bTimeSchedule) {
            this.slider = bDaySlider2;
            this.sch = bTimeSchedule;
            this.updateUnits();
            this.updateColors();
        }

        Range(BDaySlider bDaySlider2, BTimeSchedule bTimeSchedule, int n, int n2) {
            this.slider = bDaySlider2;
            this.sch = bTimeSchedule;
            this.start = n;
            this.finish = n2;
            this.updateRangeUnits();
            this.updateColors();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class CmdDelete
    extends Command {
        public CommandArtifact doInvoke() {
            BDaySlider.this.remove(BDaySlider.this.selected);
            BDaySlider.this.repaint();
            return null;
        }

        CmdDelete() {
            super((BWidget)BDaySlider.this, BDaySlider.this.lex("day.delete"));
        }
    }

    public static interface Clipboard {
        public BDaySchedule get();

        public BStatusValue newEffectiveValue();

        public void set(BDaySchedule var1);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class CmdPaste
    extends Command {
        public CommandArtifact doInvoke() {
            if (BDaySlider.this.clipboard != null) {
                BDaySlider.this.clearDay();
                BDaySlider.this.copy(BDaySlider.this.clipboard.get());
            }
            BDaySlider.this.repaint();
            BDaySlider.this.fireModified(null);
            return null;
        }

        CmdPaste() {
            super((BWidget)BDaySlider.this, BDaySlider.this.lex("day.paste_day"));
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class CmdAllDay
    extends Command {
        public CommandArtifact doInvoke() {
            BDaySlider.this.clearDay();
            BDaySlider.this.select(BDaySlider.this.add((Object)BDaySlider.this.newEffectiveValue(), 0, BDaySlider.this.units));
            BDaySlider.this.fireModified(null);
            return null;
        }

        CmdAllDay() {
            super((BWidget)BDaySlider.this, BDaySlider.this.lex("day.all_day"));
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class CmdFill
    extends Command {
        public CommandArtifact doInvoke() {
            BDaySlider.this.fireFillWeek(BDaySlider.this.schedule);
            return null;
        }

        CmdFill() {
            super((BWidget)BDaySlider.this, BDaySlider.this.lex("day.apply_weekdays"));
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class CmdCopy
    extends Command {
        public CommandArtifact doInvoke() {
            if (BDaySlider.this.clipboard != null) {
                BDaySlider.this.clipboard.set((BDaySchedule)BDaySlider.this.schedule.newCopy(true));
            }
            return null;
        }

        CmdCopy() {
            super((BWidget)BDaySlider.this, BDaySlider.this.lex("day.copy_day"));
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class CmdClear
    extends Command {
        public CommandArtifact doInvoke() {
            BDaySlider.this.clearDay();
            BDaySlider.this.repaint();
            return null;
        }

        CmdClear() {
            super((BWidget)BDaySlider.this, BDaySlider.this.lex("day.clear_day"));
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class CmdClearWeek
    extends Command {
        public CommandArtifact doInvoke() {
            BDaySlider.this.fireClearWeek(null);
            return null;
        }

        CmdClearWeek() {
            super((BWidget)BDaySlider.this, BDaySlider.this.lex("day.clear_week"));
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class CmdScheduleDefaults
    extends Command {
        public CommandArtifact doInvoke() {
            Range range = BDaySlider.this.first;
            if (range == null) {
                BDaySlider.this.select(BDaySlider.this.add((Object)BDaySlider.this.defaultValue.newCopy(), 0, BDaySlider.this.units));
                return null;
            }
            Object var2_2 = null;
            if (range.start != 0) {
                range = BDaySlider.this.add((Object)BDaySlider.this.defaultValue.newCopy(), BTime.make((BRelTime)BRelTime.make((long)BDaySlider.this.unitToMillis(0, true))), range.sch.getStart());
            }
            Range range2 = range.next;
            while (range != null) {
                range2 = range.next;
                if (range2 == null) {
                    if (range.finish != BDaySlider.this.units) {
                        BDaySlider.this.add((Object)BDaySlider.this.defaultValue.newCopy(), range.sch.getFinish(), BTime.make((BRelTime)BRelTime.make((long)BDaySlider.this.unitToMillis(BDaySlider.this.units, false))));
                    }
                } else if (!range.sch.getFinish().equals((Object)range2.sch.getStart())) {
                    BDaySlider.this.add((Object)BDaySlider.this.defaultValue.newCopy(), range.sch.getFinish(), range2.sch.getStart());
                }
                range = range2;
            }
            BDaySlider.this.repaint();
            BDaySlider.this.fireModified(null);
            return null;
        }

        CmdScheduleDefaults() {
            super((BWidget)BDaySlider.this, BDaySlider.this.lex("day.schedule_defaults"));
        }
    }
}

