/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.schedule.ui;

import com.tridium.schedule.ui.BAbstractScheduleWidget;
import com.tridium.schedule.ui.BMonthWidget;
import javax.baja.gx.BImage;
import javax.baja.nre.util.Array;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BMonth;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BAlign;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BCalendarWidget
extends BAbstractScheduleWidget {
    public static final Action handleSelect = BCalendarWidget.newAction((int)0, (BValue)new BMonthWidget(), null);
    public static final Action nextMonth = BCalendarWidget.newAction((int)0, null);
    public static final Action nextPage = BCalendarWidget.newAction((int)0, null);
    public static final Action prevMonth = BCalendarWidget.newAction((int)0, null);
    public static final Action prevPage = BCalendarWidget.newAction((int)0, null);
    public static final Action updateMonths = BCalendarWidget.newAction((int)16, null);
    public static final Action today = BCalendarWidget.newAction((int)0, null);
    public static final Topic selected = BCalendarWidget.newTopic((int)0, null);
    public static final Type TYPE;
    static final double pad = 10.0;
    BButton butNextMonth;
    BButton butNextPage;
    BButton butPrevMonth;
    BButton butPrevPage;
    BButton butToday;
    BGridPane buttons;
    int cols;
    BGridPane calendar;
    BEdgePane content;
    BMonthWidget current;
    Array months;
    int rows;
    boolean selectable;
    BAbstractSchedule schedule;
    BMonthWidget selection;
    static /* synthetic */ Class class$com$tridium$schedule$ui$BCalendarWidget;
    static /* synthetic */ Class class$com$tridium$schedule$ui$BMonthWidget;

    public void handleSelect(BMonthWidget bMonthWidget) {
        this.invoke(handleSelect, (BValue)bMonthWidget, null);
    }

    public void nextMonth() {
        this.invoke(nextMonth, null, null);
    }

    public void nextPage() {
        this.invoke(nextPage, null, null);
    }

    public void prevMonth() {
        this.invoke(prevMonth, null, null);
    }

    public void prevPage() {
        this.invoke(prevPage, null, null);
    }

    public void updateMonths() {
        this.invoke(updateMonths, null, null);
    }

    public void today() {
        this.invoke(today, null, null);
    }

    public void fireSelected(BAbsTime bAbsTime) {
        this.fire(selected, (BValue)bAbsTime, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void computePreferredSize() {
        double d = BMonthWidget.widgetW + 10.0;
        double d2 = BMonthWidget.widgetH + 10.0;
        this.buttons.computePreferredSize();
        this.setPreferredSize(d * (double)4, d2 += this.buttons.getPreferredHeight());
    }

    public void doHandleSelect(BMonthWidget bMonthWidget) {
        this.fireSelected(BAbsTime.make((int)bMonthWidget.getYear(), (BMonth)bMonthWidget.getMonth(), (int)bMonthWidget.getSelection(), (int)0, (int)0, (int)0, (int)0));
        if (this.selection == bMonthWidget) {
            return;
        }
        if (this.selection != null) {
            this.selection.setSelection(-1);
            this.selection.repaint();
        }
        this.selection = bMonthWidget;
        this.selection.repaint();
    }

    public void doLayout(BWidget[] bWidgetArray) {
        int n;
        int n2;
        this.content.setBounds(0.0, 0.0, this.getWidth(), this.getHeight());
        int n3 = this.computeCols();
        if (n3 != this.calendar.getColumnCount()) {
            this.calendar.setColumnCount(n3);
        }
        if ((n2 = n3 * (n = this.computeRows())) != this.months.size()) {
            this.fillCal(this.current.getStart());
            if (this.selection == null && this.schedule != null) {
                this.doToday();
            }
        }
    }

    public void doNextMonth() {
        this.fillCal(this.nextMonth(this.current.getStart()));
    }

    public void doNextPage() {
        BMonthWidget bMonthWidget = (BMonthWidget)((Object)this.months.peek());
        this.fillCal(this.nextMonth(bMonthWidget.getStart()));
    }

    public void doPrevMonth() {
        this.fillCal(this.prevMonth(this.current.getStart()));
    }

    public void doPrevPage() {
        int n = this.computeCols() * this.computeRows();
        BAbsTime bAbsTime = this.current.getStart();
        int n2 = bAbsTime.getYear();
        BMonth bMonth = bAbsTime.getMonth();
        while (--n >= 0) {
            if (bMonth == BMonth.january) {
                --n2;
                bMonth = BMonth.december;
                continue;
            }
            bMonth = bMonth.previous();
        }
        this.fillCal(BAbsTime.make((int)n2, (BMonth)bMonth, (int)1, (int)0, (int)0, (int)0, (int)0));
    }

    public void doToday() {
        BAbsTime bAbsTime = Clock.time();
        this.fillCal(bAbsTime);
        this.current.setSelection(bAbsTime.getDay());
        this.doHandleSelect(this.current);
    }

    public synchronized void doUpdateMonths() {
        BMonthWidget[] bMonthWidgetArray = (BMonthWidget[])this.months.array();
        int n = this.months.size();
        while (--n >= 0) {
            this.highlight(bMonthWidgetArray[n]);
        }
        this.repaint();
    }

    public void setSchedule(BAbstractSchedule bAbstractSchedule) {
        this.schedule = bAbstractSchedule;
        this.updateMonths();
    }

    public void syncSchedule(BAbstractSchedule bAbstractSchedule) {
        this.schedule = bAbstractSchedule;
        this.doUpdateMonths();
    }

    private final int computeCols() {
        return (int)(this.getWidth() / (BMonthWidget.widgetW + 10.0));
    }

    private final int computeRows() {
        double d = this.getHeight() - this.buttons.getHeight() - 10.0;
        int n = (int)(d / (BMonthWidget.widgetH + 10.0));
        if (n == 0) {
            return 1;
        }
        return n;
    }

    private final synchronized void fillCal(BAbsTime bAbsTime) {
        BAbsTime bAbsTime2 = Clock.time();
        int n = bAbsTime2.getYear();
        BMonth bMonth = bAbsTime2.getMonth();
        this.butToday.setEnabled(true);
        this.months.clear();
        this.calendar.removeAll();
        int n2 = this.computeCols();
        int n3 = n2 * this.computeRows();
        BAbsTime bAbsTime3 = bAbsTime;
        int n4 = 0;
        while (n4 < n3) {
            BMonthWidget bMonthWidget = new BMonthWidget(bAbsTime3.getYear(), bAbsTime3.getMonth());
            bMonthWidget.setSelectable(this.selectable);
            if (n4 == 0) {
                this.current = bMonthWidget;
            }
            if (bAbsTime3.getYear() == n && bAbsTime3.getMonth() == bMonth && !this.selectable) {
                bMonthWidget.setSelection(bAbsTime2.getDay());
            }
            this.highlight(bMonthWidget);
            this.linkTo((BComponent)bMonthWidget, (Slot)BMonthWidget.selected, (Slot)handleSelect);
            this.calendar.add(null, (BValue)bMonthWidget);
            this.months.add((Object)bMonthWidget);
            bAbsTime3 = this.nextMonth(bAbsTime3);
            ++n4;
        }
    }

    private final void highlight(BMonthWidget bMonthWidget) {
        bMonthWidget.clearHighlights();
        if (this.schedule == null) {
            return;
        }
        BAbsTime bAbsTime = bMonthWidget.getStart();
        BAbsTime bAbsTime2 = this.nextDay(bAbsTime);
        BAbsTime bAbsTime3 = this.nextMonth(bAbsTime);
        while (bAbsTime.isBefore(bAbsTime3)) {
            if (this.schedule.isEffective(bAbsTime)) {
                bMonthWidget.highlight(bAbsTime.getDay());
            } else if ((bAbsTime = this.schedule.next(true, bAbsTime, bAbsTime2)) != null) {
                bMonthWidget.highlight(bAbsTime.getDay());
            }
            bAbsTime = bAbsTime2;
            bAbsTime2 = this.nextDay(bAbsTime);
        }
    }

    private final BAbsTime nextDay(BAbsTime bAbsTime) {
        return bAbsTime.nextDay().timeOfDay(0, 0, 0, 0);
    }

    private final BAbsTime nextMonth(BAbsTime bAbsTime) {
        BMonth bMonth = bAbsTime.getMonth();
        if (bMonth == BMonth.december) {
            return BAbsTime.make((int)(bAbsTime.getYear() + 1), (BMonth)BMonth.january, (int)1, (int)0, (int)0, (int)0, (int)0);
        }
        return BAbsTime.make((int)bAbsTime.getYear(), (BMonth)bMonth.next(), (int)1, (int)0, (int)0, (int)0, (int)0);
    }

    private final BAbsTime prevMonth(BAbsTime bAbsTime) {
        BMonth bMonth = bAbsTime.getMonth();
        if (bMonth == BMonth.january) {
            return BAbsTime.make((int)(bAbsTime.getYear() - 1), (BMonth)BMonth.december, (int)1, (int)0, (int)0, (int)0, (int)0);
        }
        return BAbsTime.make((int)bAbsTime.getYear(), (BMonth)bMonth.previous(), (int)1, (int)0, (int)0, (int)0, (int)0);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.cols = 0;
        Class clazz = class$com$tridium$schedule$ui$BMonthWidget;
        if (clazz == null) {
            clazz = class$com$tridium$schedule$ui$BMonthWidget = BCalendarWidget.class("[Lcom.tridium.schedule.ui.BMonthWidget;", false);
        }
        this.months = new Array(clazz);
        this.rows = 0;
        this.selectable = false;
    }

    public BCalendarWidget(boolean bl) {
        this.this();
        this.selectable = bl;
        this.buttons = new BGridPane(5);
        BImage bImage = BImage.make((BIcon)BIcon.std((String)"arrowRight.png"));
        this.butNextMonth = new BButton(bImage, this.lex("calendar.nextMonth"));
        this.butNextMonth.setButtonStyle(BButtonStyle.toolBar);
        this.butNextMonth.setTextToIconAlign(BAlign.left);
        this.butNextPage = new BButton(bImage, this.lex("calendar.nextPage"));
        this.butNextPage.setButtonStyle(BButtonStyle.toolBar);
        this.butNextPage.setTextToIconAlign(BAlign.left);
        bImage = BImage.make((BIcon)BIcon.std((String)"arrowLeft.png"));
        this.butPrevMonth = new BButton(bImage, this.lex("calendar.prevMonth"));
        this.butPrevMonth.setButtonStyle(BButtonStyle.toolBar);
        this.butPrevMonth.setTextToIconAlign(BAlign.right);
        this.butPrevPage = new BButton(bImage, this.lex("calendar.prevPage"));
        this.butPrevPage.setButtonStyle(BButtonStyle.toolBar);
        this.butPrevPage.setTextToIconAlign(BAlign.right);
        this.butToday = new BButton(this.lex("calendar.today"));
        this.linkTo((BComponent)this.butNextMonth, (Slot)BButton.actionPerformed, (Slot)nextMonth);
        this.linkTo((BComponent)this.butNextPage, (Slot)BButton.actionPerformed, (Slot)nextPage);
        this.linkTo((BComponent)this.butPrevMonth, (Slot)BButton.actionPerformed, (Slot)prevMonth);
        this.linkTo((BComponent)this.butPrevPage, (Slot)BButton.actionPerformed, (Slot)prevPage);
        this.linkTo((BComponent)this.butToday, (Slot)BButton.actionPerformed, (Slot)today);
        this.buttons.add(null, (BValue)this.butPrevPage);
        this.buttons.add(null, (BValue)this.butPrevMonth);
        this.buttons.add(null, (BValue)this.butToday);
        this.buttons.add(null, (BValue)this.butNextMonth);
        this.buttons.add(null, (BValue)this.butNextPage);
        this.content = new BEdgePane();
        this.content.setTop((BWidget)this.buttons);
        this.calendar = new BGridPane();
        this.calendar.setColumnGap(10.0);
        this.calendar.setRowGap(10.0);
        this.content.setCenter((BWidget)this.calendar);
        BAbsTime bAbsTime = Clock.time();
        this.current = new BMonthWidget(bAbsTime.getYear(), bAbsTime.getMonth());
        this.setContent((BWidget)this.content);
    }

    static {
        Class clazz = class$com$tridium$schedule$ui$BCalendarWidget;
        if (clazz == null) {
            clazz = class$com$tridium$schedule$ui$BCalendarWidget = BCalendarWidget.class("[Lcom.tridium.schedule.ui.BCalendarWidget;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

