/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.schedule;

import com.tridium.sys.Nre;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.baja.log.Log;
import javax.baja.nre.util.TextUtil;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ScheduleSpyManager {
    private static Log LOG = Log.getLog((String)"schedule.scheduleManager");
    private Thread standardOutPrinter;
    private TimedStackTrace greatest;
    private HashMap stacks;
    private long count;
    private long totalCount;
    private int CLOSED_MAX_ENTRIES;
    private LinkedHashMap closedStacks;
    private BAbsTime dstFixTime;
    private String dstFixInfo;

    public static String getId(Runnable runnable) {
        return runnable.toString();
    }

    public void enqueueSpy(Runnable runnable) {
        if (!LOG.isTraceOn()) {
            return;
        }
        ++this.count;
        this.totalCount = Long.MAX_VALUE > this.totalCount ? ++this.totalCount : this.count;
        try {
            throw new Exception("EnqueueStackTrace");
        }
        catch (Exception exception) {
            this.stacks.put(ScheduleSpyManager.getId(runnable), new TimedStackTrace(exception, runnable));
            return;
        }
    }

    public void dequeueSpy(Runnable runnable) {
        if (!LOG.isTraceOn()) {
            return;
        }
        TimedStackTrace timedStackTrace = (TimedStackTrace)this.stacks.remove(ScheduleSpyManager.getId(runnable));
        if (timedStackTrace != null) {
            --this.count;
        } else {
            timedStackTrace = new TimedStackTrace(null, runnable);
        }
        try {
            throw new Exception("DequeueStackTrace");
        }
        catch (Exception exception) {
            timedStackTrace.setClose(exception);
            this.closedStacks.put(ScheduleSpyManager.getId(runnable), timedStackTrace);
            if (this.greatest == null || timedStackTrace.delta().compareTo((Object)this.greatest.delta()) > 0) {
                this.greatest = timedStackTrace;
            }
            return;
        }
    }

    public void daylightSavingsTimeFix(String string) {
        if (!LOG.isTraceOn()) {
            return;
        }
        this.dstFixTime = BAbsTime.now();
        this.dstFixInfo = string;
    }

    private final /* synthetic */ void this() {
        this.stacks = new HashMap();
        this.count = 0L;
        this.totalCount = 0L;
        this.CLOSED_MAX_ENTRIES = 10;
        this.closedStacks = new LinkedHashMap(this.CLOSED_MAX_ENTRIES){

            protected final boolean removeEldestEntry(Map.Entry entry) {
                boolean bl = false;
                if (this.size() > ScheduleSpyManager.this.CLOSED_MAX_ENTRIES) {
                    bl = true;
                }
                return bl;
            }
        };
    }

    public ScheduleSpyManager() {
        this.this();
        SummaryPage summaryPage = new SummaryPage();
        Nre.spySysManagers.add("scheduleManager", (Spy)summaryPage);
    }

    public static class TimedStackTrace {
        BAbsTime openTime = BAbsTime.now();
        BAbsTime closeTime;
        Exception openTrace;
        Exception closeTrace;
        Runnable runnable;

        void setClose(Exception exception) {
            this.closeTime = BAbsTime.now();
            this.closeTrace = exception;
        }

        BRelTime delta() {
            if (this.closeTime != null) {
                return this.openTime.delta(this.closeTime);
            }
            return this.openTime.delta(BAbsTime.now());
        }

        TimedStackTrace(Exception exception, Runnable runnable) {
            this.openTrace = exception;
            this.runnable = runnable;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class SummaryPage
    extends SpyDir {
        public void write(SpyWriter spyWriter) throws Exception {
            BFacets bFacets = BFacets.make((String)"showMilliseconds", (boolean)true);
            spyWriter.startProps();
            if (!LOG.isTraceOn()) {
                spyWriter.prop((Object)"Schedule Manager Not Active", (Object)"<a href='spy:/logSetup/trace-schedule.scheduleManager'>Click here to turn schedule.scheduleManager Log to 'trace' </a>");
                spyWriter.endProps();
                return;
            }
            if (ScheduleSpyManager.this.standardOutPrinter != null) {
                spyWriter.prop((Object)"Standard Out Printer", (Object)"Running <a href='standardOutStarter'>Stop</a>");
            } else {
                spyWriter.prop((Object)"Standard Out Printer", (Object)"<a href='standardOutStarter'>Start</a>");
            }
            spyWriter.prop((Object)"Finished Queue Count", (Object)("" + (ScheduleSpyManager.this.totalCount - ScheduleSpyManager.this.count)));
            spyWriter.prop((Object)"Recently Dequeued Stack Traces", (Object)"<a href='closed'>View</a>");
            spyWriter.prop((Object)"Current Queue Size", (Object)("" + ScheduleSpyManager.this.count));
            if (ScheduleSpyManager.this.greatest != null && ScheduleSpyManager.this.greatest.delta().getMillis() > 0L) {
                spyWriter.prop((Object)"Longest Runnable", (Object)ScheduleSpyManager.getId(((ScheduleSpyManager)ScheduleSpyManager.this).greatest.runnable));
                spyWriter.prop((Object)"Longest Runnable Time", (Object)ScheduleSpyManager.this.greatest.delta());
            }
            if (ScheduleSpyManager.this.dstFixTime != null) {
                spyWriter.prop((Object)"Last Day Light Saving Time Fix Time", (Object)ScheduleSpyManager.this.dstFixTime);
                spyWriter.prop((Object)"Last Day Light Saving Time Fix Info", (Object)ScheduleSpyManager.this.dstFixInfo);
            }
            Collection collection = ScheduleSpyManager.this.stacks.values();
            Set set = ScheduleSpyManager.this.stacks.keySet();
            Object[] objectArray = collection.toArray();
            Object[] objectArray2 = set.toArray();
            if (ScheduleSpyManager.this.count != (long)objectArray2.length) {
                spyWriter.prop((Object)"Acknowledged Enqueue Count", (Object)("" + (ScheduleSpyManager.this.count - (long)objectArray2.length)));
            }
            int n = objectArray.length - 1;
            while (n >= 0) {
                RemoveSpy removeSpy = new RemoveSpy(objectArray2[n], "" + n, ScheduleSpyManager.this.stacks);
                this.add("" + n, (Spy)removeSpy);
                spyWriter.prop((Object)("Enqueued " + n), (Object)("<a href='" + n + "'>Acknowledge</a>"));
                spyWriter.prop((Object)"Path", (Object)("" + objectArray2[n]));
                TimedStackTrace timedStackTrace = (TimedStackTrace)objectArray[n];
                spyWriter.prop((Object)"Open Time ", (Object)timedStackTrace.delta());
                Exception exception = timedStackTrace.openTrace;
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                exception.printStackTrace(printWriter);
                String[] stringArray = TextUtil.split((String)((Object)stringWriter).toString(), (char)'\n');
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (n2 == 0) {
                        spyWriter.prop((Object)"", (Object)stringArray[n2].toString());
                    } else {
                        spyWriter.prop((Object)"", (Object)stringArray[n2].toString());
                    }
                    ++n2;
                }
                --n;
            }
            spyWriter.endProps();
        }

        public SummaryPage() {
            this.add("closed", (Spy)new ClosedSpy());
            this.add("standardOutStarter", (Spy)new StandardOutStarter());
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class StandardOutStarter
    extends SpyDir {
        public void write(SpyWriter spyWriter) {
            if (ScheduleSpyManager.this.standardOutPrinter == null) {
                spyWriter.startProps();
                spyWriter.prop((Object)"Started...", (Object)"<a href='..'>Return to Schedule Manager</a>");
                spyWriter.endProps();
                ScheduleSpyManager.this.standardOutPrinter = new Thread(){

                    public final void run() {
                        try {
                            block2: while (true) {
                                Thread.sleep(10000L);
                                Collection collection = ScheduleSpyManager.this.stacks.values();
                                Set set = ScheduleSpyManager.this.stacks.keySet();
                                Object[] objectArray = collection.toArray();
                                if (objectArray.length > 0) {
                                    System.out.println("***********OPEN RUNNABLES FOR SCHEDULE MANAGER****************");
                                }
                                Object[] objectArray2 = set.toArray();
                                int n = objectArray.length - 1;
                                while (true) {
                                    if (n < 0) continue block2;
                                    TimedStackTrace timedStackTrace = (TimedStackTrace)objectArray[n];
                                    System.out.println("Path:" + objectArray2[n]);
                                    System.out.println("Time Open:" + timedStackTrace.delta());
                                    timedStackTrace.openTrace.printStackTrace();
                                    System.out.println("*************************************************************");
                                    --n;
                                }
                                break;
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            return;
                        }
                    }
                };
                ScheduleSpyManager.this.standardOutPrinter.start();
            } else {
                spyWriter.startProps();
                spyWriter.prop((Object)"Stopped...", (Object)"<a href='..'>Return to Schedule Manager</a>");
                spyWriter.endProps();
                ScheduleSpyManager.this.standardOutPrinter.stop();
                ScheduleSpyManager.this.standardOutPrinter = null;
            }
        }

        public String getTitle() {
            return "closed";
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ClosedSpy
    extends SpyDir {
        public void write(SpyWriter spyWriter) {
            spyWriter.startProps();
            Collection collection = ScheduleSpyManager.this.closedStacks.values();
            Set set = ScheduleSpyManager.this.closedStacks.keySet();
            Object[] objectArray = collection.toArray();
            Object[] objectArray2 = set.toArray();
            spyWriter.prop((Object)"Recently Dequeued Stack Traces Count", (Object)("" + objectArray2.length));
            if (objectArray.length > 1) {
                spyWriter.prop((Object)"", (Object)"<a href='removeAll'>Acknowledge All</a>");
            }
            int n = objectArray.length - 1;
            while (n >= 0) {
                RemoveSpy removeSpy = new RemoveSpy(objectArray2[n], "" + n, ScheduleSpyManager.this.closedStacks);
                this.add("" + n, (Spy)removeSpy);
                spyWriter.prop((Object)("Dequeued Runnable" + n), (Object)("<a href='" + n + "'>Acknowledge</a>"));
                spyWriter.prop((Object)"Path", (Object)("" + objectArray2[n]));
                TimedStackTrace timedStackTrace = (TimedStackTrace)objectArray[n];
                spyWriter.prop((Object)"Time In Queue ", (Object)timedStackTrace.delta());
                Exception exception = timedStackTrace.openTrace;
                if (exception == null) {
                    exception = timedStackTrace.closeTrace;
                }
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                exception.printStackTrace(printWriter);
                String[] stringArray = TextUtil.split((String)((Object)stringWriter).toString(), (char)'\n');
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (n2 == 0) {
                        spyWriter.prop((Object)"", (Object)stringArray[n2].toString());
                    } else {
                        spyWriter.prop((Object)"", (Object)stringArray[n2].toString());
                    }
                    ++n2;
                }
                --n;
            }
            spyWriter.endProps();
        }

        public String getTitle() {
            return "closed";
        }

        public ClosedSpy() {
            this.add("removeAll", (Spy)new RemoveAllSpy("removeAll", ScheduleSpyManager.this.closedStacks));
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class RemoveAllSpy
    extends SpyDir {
        private Object key;
        private String title;
        private HashMap hashMap;

        public void write(SpyWriter spyWriter) {
            this.hashMap.clear();
            spyWriter.startProps();
            if (this.hashMap instanceof LinkedHashMap) {
                spyWriter.prop((Object)"All Dequeue Stack Traces Acknowledged", (Object)"<a href='..'>Return to Dequeued Traces Summary</a>");
            } else {
                spyWriter.prop((Object)"All Enqueue Stack Traces Acknowledged", (Object)"<a href='..'>Return to Schedule Manager</a>");
            }
            spyWriter.endProps();
        }

        public String getTitle() {
            return this.title;
        }

        public RemoveAllSpy(String string, HashMap hashMap) {
            this.title = string;
            this.hashMap = hashMap;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class RemoveSpy
    extends SpyDir {
        private Object key;
        private String title;
        private HashMap hashMap;

        public void write(SpyWriter spyWriter) {
            this.hashMap.remove(this.key);
            spyWriter.startProps();
            if (this.hashMap instanceof LinkedHashMap) {
                spyWriter.prop((Object)"Stack Trace Acknowledged", (Object)"<a href='..'>Return to Dequeued Traces Summary</a>");
            } else {
                spyWriter.prop((Object)"Stack Trace Acknowledged", (Object)"<a href='..'>Return to Schedule Manager</a>");
            }
            spyWriter.endProps();
        }

        public String getTitle() {
            return this.title;
        }

        public RemoveSpy(Object object, String string, HashMap hashMap) {
            this.key = object;
            this.title = string;
            this.hashMap = hashMap;
        }
    }
}

