/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.schedule;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class IntSet
implements Serializable {
    private int[] ints;

    public boolean add(int n) {
        if (this.contains(n)) {
            return false;
        }
        this.ints = this.union(n, this.ints);
        return true;
    }

    public void clear() {
        this.ints = new int[0];
    }

    public boolean contains(int n) {
        if (this.ints.length == 0) {
            return false;
        }
        int n2 = this.predecessor(n, this.ints) + 1;
        if (n2 == this.ints.length) {
            return false;
        }
        boolean bl = false;
        if (this.ints[n2] == n) {
            bl = true;
        }
        return bl;
    }

    public void decode(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        this.ints = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.ints[n2] = dataInput.readInt();
            ++n2;
        }
    }

    public void decodeFromString(String string) {
        char c;
        int n = string.length();
        int n2 = 0;
        char c2 = ' ';
        int n3 = 0;
        while (n3 < n) {
            c = string.charAt(n3);
            if (Character.isDigit(c) && !Character.isDigit(c2)) {
                ++n2;
            }
            c2 = c;
            ++n3;
        }
        if (n2 == 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        this.ints = new int[n2];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            c = string.charAt(n5);
            if (Character.isDigit(c)) {
                stringBuffer.append(c);
            } else if (stringBuffer.length() > 0) {
                this.ints[n4] = Integer.parseInt(stringBuffer.toString());
                ++n4;
                stringBuffer.setLength(0);
            }
            ++n5;
        }
        if (stringBuffer.length() > 0) {
            this.ints[n4] = Integer.parseInt(stringBuffer.toString());
        }
        if (n4 != n2) {
            throw new RuntimeException("Error parsing int set: " + string);
        }
    }

    public void encode(DataOutput dataOutput) throws IOException {
        int n = this.ints.length;
        dataOutput.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            dataOutput.writeInt(this.ints[n2]);
            ++n2;
        }
    }

    public String encodeToString() {
        StringBuffer stringBuffer = new StringBuffer(this.ints.length * 5);
        stringBuffer.append('{');
        boolean bl = false;
        int n = this.ints.length;
        int n2 = 0;
        while (n2 < n) {
            if (bl) {
                stringBuffer.append(", ");
            } else {
                bl = true;
            }
            stringBuffer.append(this.ints[n2]);
            ++n2;
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof IntSet)) {
            return false;
        }
        int[] nArray = this.ints;
        int[] nArray2 = ((IntSet)object).ints;
        if (nArray == nArray2) {
            return true;
        }
        int n = nArray.length;
        if (n != nArray2.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (nArray[n2] != nArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public int get(int n) {
        return this.ints[n];
    }

    public int[] intern() {
        return this.ints;
    }

    public boolean isEmpty() {
        boolean bl = false;
        if (this.ints.length == 0) {
            bl = true;
        }
        return bl;
    }

    public boolean remove(int n) {
        if (!this.contains(n)) {
            return false;
        }
        this.ints = this.ints.length == 1 ? new int[0] : this.intersection(n, this.ints);
        return true;
    }

    public int size() {
        return this.ints.length;
    }

    public int[] toIntArray() {
        int[] nArray = new int[this.ints.length];
        System.arraycopy(this.ints, 0, nArray, 0, nArray.length);
        return nArray;
    }

    public String toString() {
        return this.encodeToString();
    }

    public static IntSet wrap(int[] nArray) {
        IntSet intSet = new IntSet();
        intSet.ints = nArray;
        return intSet;
    }

    private final int[] intersection(int n, int[] nArray) {
        if (nArray.length == 1) {
            return new int[0];
        }
        int[] nArray2 = new int[nArray.length - 1];
        int n2 = this.predecessor(n, nArray) + 1;
        if (n2 == 0) {
            System.arraycopy(nArray, 1, nArray2, 0, nArray2.length);
        } else if (n2 == nArray2.length) {
            System.arraycopy(nArray, 0, nArray2, 0, nArray2.length);
        } else {
            System.arraycopy(nArray, 0, nArray2, 0, n2);
            System.arraycopy(nArray, n2 + 1, nArray2, n2, nArray2.length - n2);
        }
        return nArray2;
    }

    private final int predecessor(int n, int[] nArray) {
        if (nArray.length == 0) {
            return -1;
        }
        int n2 = 0;
        if (nArray[n2] >= n) {
            return -1;
        }
        int n3 = nArray.length - 1;
        if (nArray[n3] < n) {
            return n3;
        }
        while (true) {
            int n4;
            int n5;
            if ((n5 = nArray[n4 = (n2 + n3) / 2]) >= n) {
                n3 = n4--;
                if (nArray[n4] >= n) continue;
                return n4;
            }
            if (nArray[n4 + 1] >= n) {
                return n4;
            }
            n2 = n4;
        }
    }

    private final int[] union(int n, int[] nArray) {
        if (nArray.length == 0) {
            return new int[]{n};
        }
        int[] nArray2 = new int[nArray.length + 1];
        int n2 = this.predecessor(n, nArray) + 1;
        if (n2 == 0) {
            nArray2[0] = n;
            System.arraycopy(nArray, 0, nArray2, 1, nArray.length);
        } else if (n2 == nArray.length) {
            nArray2[n2] = n;
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        } else {
            System.arraycopy(nArray, 0, nArray2, 0, n2);
            nArray2[n2] = n;
            System.arraycopy(nArray, n2, nArray2, n2 + 1, nArray.length - n2);
        }
        return nArray2;
    }

    private final /* synthetic */ void this() {
        this.ints = new int[0];
    }

    public IntSet() {
        this.this();
    }

    public IntSet(int[] nArray) {
        this.this();
        int n = nArray.length;
        while (--n >= 0) {
            this.add(nArray[n]);
        }
    }
}

