/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndriver.discover;

import com.tridium.ndriver.discover.BINDiscoveryHost;
import com.tridium.ndriver.discover.BINDiscoveryObject;
import com.tridium.ndriver.discover.BNDiscoveryPreferences;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComponent;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BNDiscoveryJob
extends BJob {
    public static final Property discoveryFolder = BNDiscoveryJob.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Property discoveryPreferences = BNDiscoveryJob.newProperty((int)0, (BValue)new BNDiscoveryPreferences(), null);
    public static final Type TYPE;
    public static final Lexicon LEX;
    private BINDiscoveryHost discoveryHost;
    private Exception jobException;
    private JobThread thread;
    static /* synthetic */ Class class$com$tridium$ndriver$discover$BNDiscoveryJob;
    static /* synthetic */ Class class$com$tridium$ndriver$discover$BINDiscoveryObject;

    public BOrd getDiscoveryFolder() {
        return (BOrd)this.get(discoveryFolder);
    }

    public void setDiscoveryFolder(BOrd bOrd) {
        this.set(discoveryFolder, (BValue)bOrd, null);
    }

    public BNDiscoveryPreferences getDiscoveryPreferences() {
        return (BNDiscoveryPreferences)this.get(discoveryPreferences);
    }

    public void setDiscoveryPreferences(BNDiscoveryPreferences bNDiscoveryPreferences) {
        this.set(discoveryPreferences, (BValue)bNDiscoveryPreferences, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doRun(Context context) {
        this.thread = new JobThread(this.toPathString(), context);
        this.thread.start();
    }

    public void doCancel(Context context) {
        if (this.getJobState().isRunning()) {
            this.setJobState(BJobState.canceling);
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }
    }

    public String toString(Context context) {
        BModule bModule = this.getDiscoveryPreferences().getType().getModule();
        String string = this.getDiscoveryPreferences().getType().getTypeName() + ".discovery.jobBar.name";
        String string2 = bModule.getLexicon().get(string);
        if (string2 == null || string2.length() == 0) {
            string2 = bModule.getModuleName();
            string2 = TextUtil.toFriendly((String)string2) + ' ' + LEX.getText("Discovery");
        }
        return string2;
    }

    protected void end() {
        if (this.jobException != null) {
            this.failed(this.jobException);
        } else if (this.isCanceled()) {
            this.canceled();
        } else {
            this.success();
        }
    }

    public boolean isCanceled() {
        boolean bl = false;
        if (this.getJobState() == BJobState.canceling || this.getJobState() == BJobState.canceled) {
            bl = true;
        }
        return bl;
    }

    public void discoverFail(String string) {
        this.log().message(string);
    }

    public void discoverOk(BINDiscoveryObject[] bINDiscoveryObjectArray) {
        if (bINDiscoveryObjectArray == null) {
            return;
        }
        int n = 0;
        while (n < bINDiscoveryObjectArray.length) {
            this.addDiscoveryObject(bINDiscoveryObjectArray[n]);
            ++n;
        }
    }

    public void addDiscoveryObject(BINDiscoveryObject bINDiscoveryObject) {
        if (bINDiscoveryObject == null) {
            return;
        }
        BINDiscoveryObject[] bINDiscoveryObjectArray = this.getRootDiscoveryObjects();
        int n = 0;
        while (n < bINDiscoveryObjectArray.length) {
            if (bINDiscoveryObjectArray[n].equivalent(bINDiscoveryObject)) {
                return;
            }
            ++n;
        }
        this.discoveryFolder().add("d?", (BValue)bINDiscoveryObject);
    }

    public BINDiscoveryObject[] getRootDiscoveryObjects() {
        BComponent bComponent = this.discoveryFolder();
        Class clazz = class$com$tridium$ndriver$discover$BINDiscoveryObject;
        if (clazz == null) {
            clazz = class$com$tridium$ndriver$discover$BINDiscoveryObject = BNDiscoveryJob.class("[Lcom.tridium.ndriver.discover.BINDiscoveryObject;", false);
        }
        return (BINDiscoveryObject[])bComponent.getChildren(clazz);
    }

    protected void clearRootDiscoveryObjects() {
        this.discoveryFolder().removeAll();
    }

    public BComponent discoveryFolder() {
        BOrd bOrd = this.getDiscoveryFolder();
        BNDiscoveryJob bNDiscoveryJob = null;
        if (!bOrd.isNull()) {
            bNDiscoveryJob = (BComponent)bOrd.get((BObject)this);
        }
        return bNDiscoveryJob != null ? bNDiscoveryJob : this;
    }

    static /* synthetic */ Exception access$0(BNDiscoveryJob bNDiscoveryJob) {
        return bNDiscoveryJob.jobException;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.discoveryHost = null;
        this.jobException = null;
    }

    public BNDiscoveryJob() {
        this.this();
    }

    public BNDiscoveryJob(BINDiscoveryHost bINDiscoveryHost) {
        this.this();
        this.discoveryHost = bINDiscoveryHost;
    }

    static {
        Class clazz = class$com$tridium$ndriver$discover$BNDiscoveryJob;
        if (clazz == null) {
            clazz = class$com$tridium$ndriver$discover$BNDiscoveryJob = BNDiscoveryJob.class("[Lcom.tridium.ndriver.discover.BNDiscoveryJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Class clazz2 = class$com$tridium$ndriver$discover$BNDiscoveryJob;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$ndriver$discover$BNDiscoveryJob = BNDiscoveryJob.class("[Lcom.tridium.ndriver.discover.BNDiscoveryJob;", false);
        }
        LEX = Lexicon.make((Class)clazz2);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class JobThread
    extends Thread {
        Context cx;

        public void run() {
            BNDiscoveryJob.this.clearRootDiscoveryObjects();
            try {
                BNDiscoveryPreferences bNDiscoveryPreferences = BNDiscoveryJob.this.getDiscoveryPreferences();
                bNDiscoveryPreferences.job = BNDiscoveryJob.this;
                boolean bl = false;
                while (!bl) {
                    BINDiscoveryObject[] bINDiscoveryObjectArray = BNDiscoveryJob.this.discoveryHost.getDiscoveryObjects(bNDiscoveryPreferences);
                    BNDiscoveryJob.this.discoverOk(bINDiscoveryObjectArray);
                    if (bNDiscoveryPreferences.isMultiStep() && bINDiscoveryObjectArray != null && BNDiscoveryJob.this.getJobState().isRunning()) continue;
                    bl = true;
                }
            }
            catch (Exception exception) {
                BNDiscoveryJob.this.jobException = exception;
            }
            BNDiscoveryJob.this.end();
        }

        JobThread(String string, Context context) {
            super(string);
            this.cx = context;
        }
    }
}

