/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndriver.datatypes;

import com.tridium.ndriver.BNNetwork;
import com.tridium.ndriver.comm.IComm;
import com.tridium.ndriver.comm.ICommListener;
import com.tridium.ndriver.comm.ILinkLayer;
import com.tridium.ndriver.comm.IMessageFactory;
import com.tridium.ndriver.comm.LinkMessage;
import com.tridium.ndriver.comm.NComm;
import com.tridium.ndriver.comm.NLinkMessageFactory;
import com.tridium.ndriver.comm.NMessage;
import com.tridium.ndriver.datatypes.BAddress;
import com.tridium.ndriver.datatypes.BSpyReset;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaException;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BCommConfig
extends BComponent {
    public static final Property faultCause = BCommConfig.newProperty((int)67, (String)"", null);
    public static final Property statisticsReset = BCommConfig.newProperty((int)7, (BValue)new BSpyReset(), null);
    public static final Type TYPE;
    private static final BIcon icon;
    IMessageFactory fac;
    NLinkMessageFactory lnkFac;
    Exception startExp;
    IComm comm;
    protected ICommListener defaultListener;
    boolean commStarted;
    static /* synthetic */ Class class$com$tridium$ndriver$datatypes$BCommConfig;

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public BSpyReset getStatisticsReset() {
        return (BSpyReset)this.get(statisticsReset);
    }

    public void setStatisticsReset(BSpyReset bSpyReset) {
        this.set(statisticsReset, (BValue)bSpyReset, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final void started() throws Exception {
        if (this.commStarted) {
            return;
        }
        if (!this.okayToRun()) {
            this.setFault(this.getStatusFault(), false);
            return;
        }
        this.init();
        this.commStarted = true;
        this.ccStarted();
    }

    public final void stopped() throws Exception {
        if (this.comm != null) {
            this.comm.stop();
        }
        this.ccStopped();
        this.commStarted = false;
    }

    public final void changed(Property property, Context context) {
        super.changed(property, context);
        if (property == faultCause) {
            return;
        }
        if (this.comm != null) {
            try {
                this.comm.verifySettings(this);
                this.clearFault();
            }
            catch (Exception exception) {
                this.setFault(exception, true);
                throw new LocalizableRuntimeException("ndriver", "commConfig.configError", (Throwable)exception);
            }
        }
        this.ccChanged(property, context);
    }

    public void ccStarted() {
    }

    public void ccStopped() {
    }

    public void ccChanged(Property property, Context context) {
    }

    public IComm createComm() {
        return new NComm(this, this.defaultListener);
    }

    public final IComm comm() {
        if (this.comm == null) {
            try {
                this.started();
            }
            catch (Exception exception) {}
        }
        if (this.startExp != null) {
            throw new BajaRuntimeException("Comm error", (Throwable)this.startExp);
        }
        return this.comm;
    }

    private final void init() {
        try {
            if (this.comm == null) {
                this.comm = this.createComm();
            }
            this.comm.start();
            this.clearFault();
        }
        catch (Exception exception) {
            this.setFault(exception, true);
        }
    }

    private final void clearFault() {
        this.setFaultCause("");
        if (this.startExp != null) {
            this.startExp = null;
            this.notifyParent();
        }
    }

    private final void setFault(Exception exception, boolean bl) {
        this.startExp = exception;
        this.setFaultCause(exception.getMessage());
        if (bl) {
            this.notifyParent();
        }
    }

    private final void notifyParent() {
        BComponent bComponent = this.getParent().asComponent();
        if (bComponent == null) {
            return;
        }
        bComponent.changed(this.getPropertyInParent(), null);
    }

    public final void statusUpdate() {
        boolean bl = this.okayToRun();
        if (!bl && this.commStarted) {
            try {
                this.stopped();
            }
            catch (Exception exception) {}
            this.setFault(this.getStatusFault(), false);
        } else if (bl && !this.commStarted) {
            try {
                this.started();
            }
            catch (Exception exception) {}
        }
    }

    private final boolean okayToRun() {
        if (!(this.getParent() instanceof BIStatus)) {
            return true;
        }
        BStatus bStatus = ((BIStatus)this.getParent()).getStatus();
        boolean bl = false;
        if (bStatus.isDisabled() || bStatus.isFault()) {
            bl = true;
        }
        return bl ^ true;
    }

    private final Exception getStatusFault() {
        BStatus bStatus = ((BIStatus)this.getParent()).getStatus();
        if (bStatus.isFault()) {
            return new BajaRuntimeException("Comm error: parent in fault");
        }
        return new BajaRuntimeException("Comm error: parent is disabled");
    }

    public void setDefaultListener(ICommListener iCommListener) {
        this.defaultListener = iCommListener;
        if (this.comm != null) {
            this.comm.setDefaultListener(iCommListener);
        }
    }

    public final IMessageFactory getMessageFactory() {
        if (this.fac == null) {
            this.fac = this.makeMessageFactory();
        }
        return this.fac;
    }

    protected IMessageFactory makeMessageFactory() {
        return new IMessageFactory(){

            public final NMessage makeMessage(LinkMessage linkMessage) throws Exception {
                NMessage nMessage = new NMessage((BAddress)((Object)linkMessage.address));
                nMessage.fromInputStream(linkMessage.getInputStream());
                return nMessage;
            }
        };
    }

    public ILinkLayer makeLinkLayer(NComm nComm) {
        throw new BajaRuntimeException("Not Implemented: Must implement specific comm config object");
    }

    public int getMaxOutstandingTransactions() {
        return 32;
    }

    public int getMaxTransactionWait() {
        return 30;
    }

    public final NLinkMessageFactory getLinkMessageFactory() {
        if (this.lnkFac == null) {
            this.lnkFac = this.makeLinkMessageFactory();
        }
        return this.lnkFac;
    }

    protected NLinkMessageFactory makeLinkMessageFactory() {
        return new NLinkMessageFactory(32, 1500);
    }

    public String getResourcePrefix() {
        String string;
        BComplex bComplex = this.getParent();
        while (bComplex != null && !bComplex.getType().is(BNNetwork.TYPE)) {
            bComplex = bComplex.getParent();
        }
        if (bComplex != null) {
            string = ((BNNetwork)bComplex).getNetworkName();
        } else {
            string = this.getParent().getClass().getName();
            if (string.indexOf(46) >= 0) {
                string = string.substring(string.lastIndexOf(46) + 1);
            }
        }
        return string;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        if (this.comm == null && this.startExp == null) {
            spyWriter.thTitle((Object)"Comm stack not initialized.");
            return;
        }
        spyWriter.startProps("Comm Config");
        spyWriter.prop((Object)"okayToRun", this.okayToRun());
        spyWriter.prop((Object)"commStarted", this.commStarted);
        spyWriter.prop((Object)"defaultListener", (Object)(this.defaultListener != null ? this.defaultListener.getClass().getName() : "null"));
        spyWriter.endProps();
        if (this.startExp != null) {
            spyWriter.startProps("start exception");
            Throwable throwable = this.startExp;
            while (throwable != null) {
                spyWriter.tr((Object)throwable.toString());
                if (throwable instanceof BajaException) {
                    throwable = ((BajaException)throwable).getCause();
                    continue;
                }
                if (!(throwable instanceof BajaRuntimeException)) break;
                throwable = ((BajaRuntimeException)throwable).getCause();
            }
            spyWriter.endProps();
        } else if (this.comm != null) {
            this.comm.spy(spyWriter);
            this.resetRef(spyWriter);
        }
    }

    private final void resetRef(SpyWriter spyWriter) {
        String string = "<a href='" + spyWriter.getPath().getBody() + "/statisticsReset'>reset statistics</a>";
        spyWriter.w((Object)"<table><tr><td align='left' nowrap='true'><b>").w((Object)string).w((Object)"</b></td></tr></table>\n");
    }

    public void spyReset() {
        if (this.comm != null) {
            this.comm.resetStats();
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.fac = null;
        this.lnkFac = null;
        this.startExp = null;
        this.comm = null;
        this.defaultListener = null;
        this.commStarted = false;
    }

    public BCommConfig() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$ndriver$datatypes$BCommConfig;
        if (clazz == null) {
            clazz = class$com$tridium$ndriver$datatypes$BCommConfig = BCommConfig.class("[Lcom.tridium.ndriver.datatypes.BCommConfig;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"gears.png");
    }
}

