/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndriver.comm.udp;

import com.tridium.ndriver.comm.ILinkLayer;
import com.tridium.ndriver.comm.LinkMessage;
import com.tridium.ndriver.comm.NComm;
import com.tridium.ndriver.comm.NLinkMessageFactory;
import com.tridium.ndriver.datatypes.BCommConfig;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridium.ndriver.datatypes.BUdpCommConfig;
import com.tridium.ndriver.util.SpyUtil;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Hashtable;
import javax.baja.log.Log;
import javax.baja.spy.SpyWriter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class UdpLinkLayer
implements ILinkLayer {
    private Log log;
    private NComm comm;
    private BUdpCommConfig udpComCfg;
    private InetAddress ia;
    private int port;
    private NLinkMessageFactory lnkFac;
    private DatagramSocket udpSock;
    private boolean done;
    private Statistics stats;
    Hashtable sessions;
    LinkReceive receive;
    Thread rcvThread;

    public void start() throws Exception {
        this.log().trace("start UdpLinkLayer");
        this.done = false;
        this.udpSock = this.createSocket(this.udpComCfg);
        this.receive = new LinkReceive();
        this.rcvThread = new Thread((Runnable)this.receive, this.udpComCfg.getResourcePrefix() + ".LinkReceive");
        this.rcvThread.start();
    }

    private final DatagramSocket createSocket(BUdpCommConfig bUdpCommConfig) throws Exception {
        this.ia = UdpLinkLayer.ipAddr(bUdpCommConfig);
        this.port = UdpLinkLayer.udpPort(bUdpCommConfig);
        if (this.port > 0) {
            if (this.ia != null) {
                return new DatagramSocket(this.port, this.ia);
            }
            return new DatagramSocket(this.port);
        }
        return new DatagramSocket();
    }

    public void stop() {
        try {
            this.done = true;
            if (this.udpSock != null) {
                this.udpSock.close();
            }
        }
        catch (Throwable throwable) {}
    }

    public synchronized void verifySettings(BCommConfig bCommConfig) throws Exception {
        BUdpCommConfig bUdpCommConfig = (BUdpCommConfig)bCommConfig;
        InetAddress inetAddress = UdpLinkLayer.ipAddr(bUdpCommConfig);
        if (this.udpSock == null || this.port != UdpLinkLayer.udpPort(bUdpCommConfig) || this.ia == null && inetAddress != null || this.ia != null && !this.ia.equals(inetAddress)) {
            DatagramSocket datagramSocket = this.udpSock;
            this.udpSock = this.createSocket(bUdpCommConfig);
            datagramSocket.close();
        }
    }

    private static final int udpPort(BUdpCommConfig bUdpCommConfig) {
        return bUdpCommConfig.getAddress().getPort();
    }

    private static final InetAddress ipAddr(BUdpCommConfig bUdpCommConfig) {
        BIpAddress bIpAddress = bUdpCommConfig.getAddress();
        if (bIpAddress.getIpAddress().equalsIgnoreCase("local")) {
            return null;
        }
        return bIpAddress.getInetAddress();
    }

    public synchronized void sendMessage(LinkMessage linkMessage) throws Exception {
        if (this.done) {
            return;
        }
        this.log().trace("sendMessage to " + linkMessage.address);
        BIpAddress bIpAddress = (BIpAddress)((Object)linkMessage.address);
        DatagramPacket datagramPacket = new DatagramPacket(linkMessage.getByteArray(), linkMessage.getLength(), bIpAddress.getInetAddress(), bIpAddress.getPort());
        this.udpSock.send(datagramPacket);
        ++this.stats.msgSent;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        spyWriter.startProps("UdpLinkLayer");
        spyWriter.prop((Object)"done", this.done);
        spyWriter.prop((Object)"srvSock inet address", (Object)(this.udpSock != null && this.udpSock.getInetAddress() != null ? this.udpSock.getInetAddress().toString() : "n/a"));
        spyWriter.prop((Object)"srvSock port", (Object)(this.udpSock != null ? Integer.toString(this.udpSock.getLocalPort()) : "n/a"));
        spyWriter.prop((Object)"number of linkSessions", this.sessions.size());
        spyWriter.endProps();
        SpyUtil.spy(spyWriter, "UdpLink Statistics", this.stats);
    }

    public void resetStats() {
        this.stats = new Statistics();
    }

    public final Log log() {
        if (this.log == null) {
            this.log = Log.getLog((String)(this.udpComCfg.getResourcePrefix() + ".Link"));
        }
        return this.log;
    }

    private final /* synthetic */ void this() {
        this.udpSock = null;
        this.done = true;
        this.stats = new Statistics();
        this.sessions = new Hashtable(30);
        this.receive = null;
    }

    public UdpLinkLayer(NComm nComm, BUdpCommConfig bUdpCommConfig) {
        this.this();
        this.comm = nComm;
        this.udpComCfg = bUdpCommConfig;
        this.lnkFac = bUdpCommConfig.getLinkMessageFactory();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class LinkReceive
    implements Runnable {
        public void run() {
            while (!UdpLinkLayer.this.done) {
                try {
                    LinkMessage linkMessage = UdpLinkLayer.this.lnkFac.getLinkMessage();
                    byte[] byArray = linkMessage.getByteArray();
                    DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                    UdpLinkLayer.this.udpSock.receive(datagramPacket);
                    linkMessage.setLength(datagramPacket.getLength());
                    linkMessage.address = new BIpAddress(datagramPacket.getAddress(), datagramPacket.getPort());
                    UdpLinkLayer.this.comm.receiveMessage(linkMessage);
                    ++((UdpLinkLayer)UdpLinkLayer.this).stats.msgReceived;
                }
                catch (Throwable throwable) {
                    if (UdpLinkLayer.this.done) {
                        return;
                    }
                    throwable.printStackTrace();
                    UdpLinkLayer.this.log().error("Exception caught in LinkReceiver. " + throwable);
                    ++((UdpLinkLayer)UdpLinkLayer.this).stats.receiveError;
                }
            }
        }

        private LinkReceive() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Statistics {
        public long msgSent;
        public long msgReceived;
        public long receiveError;

        private final /* synthetic */ void this() {
            this.msgSent = 0L;
            this.msgReceived = 0L;
            this.receiveError = 0L;
        }

        public Statistics() {
            this.this();
        }
    }
}

