/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndriver.comm.http;

import com.tridium.ndriver.comm.IComm;
import com.tridium.ndriver.comm.ICommListener;
import com.tridium.ndriver.comm.NCommException;
import com.tridium.ndriver.comm.http.AuthUtil;
import com.tridium.ndriver.comm.http.NHttpErrorResponse;
import com.tridium.ndriver.comm.http.NHttpMessage;
import com.tridium.ndriver.comm.http.NHttpRequest;
import com.tridium.ndriver.comm.http.NHttpResponse;
import com.tridium.ndriver.comm.http.NHttpStream;
import com.tridium.ndriver.datatypes.BCommConfig;
import com.tridium.ndriver.datatypes.BHttpCommConfig;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridium.ndriver.util.SpyUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.baja.log.Log;
import javax.baja.naming.BHost;
import javax.baja.naming.BIpHost;
import javax.baja.net.HttpConnection;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Clock;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class HttpComm
implements IComm {
    private Log log;
    private BHttpCommConfig comCfg;
    private boolean done;
    private Statistics stats;
    Hashtable sessions;
    AuthUtil auth;
    Thread rcvThread;

    public void start() throws Exception {
        this.log().trace("start HttpComm");
        this.done = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() {
        this.done = true;
        Enumeration enumeration = this.sessions.elements();
        while (enumeration.hasMoreElements()) {
            LinkSession linkSession = (LinkSession)enumeration.nextElement();
            LinkSession linkSession2 = linkSession;
            synchronized (linkSession2) {
                linkSession.close();
                linkSession.notify();
            }
        }
        this.sessions.clear();
    }

    public void verifySettings(BCommConfig bCommConfig) throws Exception {
    }

    public void setDefaultListener(ICommListener iCommListener) {
    }

    public NHttpResponse sendRequest(NHttpRequest nHttpRequest) throws Exception {
        if (this.done) {
            return null;
        }
        String string = nHttpRequest.getAddress().toString();
        LinkSession linkSession = (LinkSession)this.sessions.get(string);
        if (linkSession == null) {
            linkSession = new LinkSession((BIpAddress)nHttpRequest.getAddress());
            this.log().trace("new LinkSession for " + string);
            this.sessions.put(string, linkSession);
        }
        int n = nHttpRequest.getRetryCount();
        while (true) {
            try {
                if (this.log().isTraceOn()) {
                    this.log().trace("sendRequest to " + string + '\n' + nHttpRequest.toTraceString());
                }
                NHttpResponse nHttpResponse = (NHttpResponse)linkSession.doSend(nHttpRequest, false);
                if (this.log().isTraceOn()) {
                    this.log().trace("response from " + string + '\n' + nHttpResponse.toTraceString());
                }
                ++this.stats.msgSent;
                return nHttpResponse;
            }
            catch (Exception exception) {
                if (n-- > 0) continue;
                throw exception;
            }
            break;
        }
    }

    public NHttpStream openStream(NHttpRequest nHttpRequest) throws Exception {
        if (this.done) {
            return null;
        }
        LinkSession linkSession = new LinkSession((BIpAddress)nHttpRequest.getAddress());
        NHttpStream nHttpStream = (NHttpStream)linkSession.doSend(nHttpRequest, true);
        ++this.stats.openStreamReq;
        if (this.log().isTraceOn()) {
            this.log().trace("openStream to " + (Object)((Object)nHttpRequest.getAddress()) + '\n' + nHttpRequest.toTraceString());
        }
        return nHttpStream;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        spyWriter.startProps("HttpComm");
        spyWriter.prop((Object)"done", this.done);
        spyWriter.prop((Object)"number of linkSessions", this.sessions.size());
        spyWriter.endProps();
        this.auth.spy(spyWriter);
        SpyUtil.spy(spyWriter, "HttpComm Statistics", this.stats);
    }

    public void resetStats() {
        this.stats = new Statistics();
    }

    public final Log log() {
        if (this.log == null) {
            this.log = Log.getLog((String)(this.comCfg.getResourcePrefix() + ".HttpComm"));
        }
        return this.log;
    }

    private final /* synthetic */ void this() {
        this.done = true;
        this.stats = new Statistics();
        this.sessions = new Hashtable(30);
        this.auth = new AuthUtil();
    }

    public HttpComm(BHttpCommConfig bHttpCommConfig, ICommListener iCommListener) {
        this.this();
        this.comCfg = bHttpCommConfig;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class LinkSession {
        HttpConnection httpConn;

        NHttpMessage doSend(NHttpRequest nHttpRequest, boolean bl) throws Exception {
            try {
                NHttpMessage.NVPair[] nVPairArray;
                BIpAddress bIpAddress = (BIpAddress)nHttpRequest.getAddress();
                boolean bl2 = true;
                boolean bl3 = true;
                while (bl2) {
                    if (this.httpConn == null) {
                        this.httpConn = new HttpConnection((BHost)new BIpHost(bIpAddress.getIpAddress()), bIpAddress.getPort());
                    }
                    HttpComm.this.auth.addAuthorization(nHttpRequest, HttpComm.this.log);
                    this.httpConn.setTimeout(nHttpRequest.getResponseTimeOut());
                    this.httpConn.setRequestMethod(nHttpRequest.getMethod());
                    nVPairArray = nHttpRequest.getHeaders();
                    int n = 0;
                    while (n < nVPairArray.length) {
                        this.httpConn.setRequestHeader(nVPairArray[n].name, nVPairArray[n].value);
                        ++n;
                    }
                    String string = nHttpRequest.getUri();
                    byte[] byArray = nHttpRequest.getData();
                    int n2 = byArray == null ? this.httpConn.newRequest(string) : this.httpConn.newRequest(nHttpRequest.getUri(), (long)byArray.length, (InputStream)new ByteArrayInputStream(byArray));
                    if (n2 == 200 || nHttpRequest.isValidResponse(n2)) {
                        bl2 = false;
                        continue;
                    }
                    NHttpErrorResponse nHttpErrorResponse = new NHttpErrorResponse(bIpAddress, this.httpConn);
                    ++((HttpComm)HttpComm.this).stats.errorResponses;
                    if (n2 != 401 || !bl3 || !HttpComm.this.auth.receiveChallenge(nHttpRequest, nHttpErrorResponse, HttpComm.this.log)) {
                        throw new NCommException("Error " + n2 + ':' + nHttpErrorResponse.getErrorMessage());
                    }
                    bl3 = false;
                    this.httpConn.close();
                }
                if (bl) {
                    nVPairArray = new NHttpStream(bIpAddress, this.httpConn);
                    ++((HttpComm)HttpComm.this).stats.streamsOpened;
                } else {
                    nVPairArray = new NHttpResponse(bIpAddress, this.httpConn);
                    ++((HttpComm)HttpComm.this).stats.msgReceived;
                }
                if (!bl) {
                    if (this.httpConn.shouldClose() || nHttpRequest.closeConn()) {
                        this.httpConn.close();
                    }
                    if (this.httpConn.shouldClose()) {
                        this.httpConn = null;
                    }
                }
                return nVPairArray;
            }
            catch (Exception exception) {
                this.close();
                this.httpConn = null;
                throw exception;
            }
        }

        void close() {
            if (this.httpConn != null) {
                this.httpConn.close();
            }
        }

        private final /* synthetic */ void this() {
            this.httpConn = null;
        }

        LinkSession(BIpAddress bIpAddress) throws Exception {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Statistics {
        long startTime;
        public long msgSent;
        public long openStreamReq;
        public long streamsOpened;
        public long msgReceived;
        public long errorResponses;

        public String getStartTime() {
            return BAbsTime.make((long)this.startTime).toLocalTime().toString(null);
        }

        private final /* synthetic */ void this() {
            this.startTime = Clock.millis();
            this.msgSent = 0L;
            this.openStreamReq = 0L;
            this.streamsOpened = 0L;
            this.msgReceived = 0L;
            this.errorResponses = 0L;
        }

        public Statistics() {
            this.this();
        }
    }
}

