/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndriver.comm.http;

import com.tridium.ndriver.comm.http.NHttpErrorResponse;
import com.tridium.ndriver.comm.http.NHttpRequest;
import com.tridium.ndriver.datatypes.BIpAddress;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.security.MessageDigest;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.StringTokenizer;
import javax.baja.log.Log;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.spy.SpyWriter;
import javax.baja.util.TextUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class AuthUtil {
    Hashtable hash;
    Random clientRandom;

    boolean receiveChallenge(NHttpRequest nHttpRequest, NHttpErrorResponse nHttpErrorResponse, Log log) {
        if (nHttpRequest.getUsernamePassword() == null) {
            return false;
        }
        String string = nHttpErrorResponse.getValue("www-authenticate");
        if (string == null) {
            return false;
        }
        String string2 = this.getHashKey(nHttpRequest);
        if (log.isTraceOn()) {
            log.trace("receiveChallenge - add auth for " + string2);
        }
        AuthParams authParams = new AuthParams(string);
        Authenticate authenticate = (Authenticate)this.hash.get(string2);
        if (authenticate != null && log.isTraceOn()) {
            log.trace("Replace authentication info \n" + authenticate.params.getValue("nonce") + '\n' + authParams.getValue("nonce"));
        }
        authenticate = new Authenticate(authParams);
        this.hash.put(string2, authenticate);
        return true;
    }

    boolean addAuthorization(NHttpRequest nHttpRequest, Log log) {
        if (nHttpRequest.getUsernamePassword() == null) {
            return false;
        }
        String string = this.getHashKey(nHttpRequest);
        Authenticate authenticate = (Authenticate)this.hash.get(string);
        if (authenticate == null) {
            return false;
        }
        if (log.isTraceOn()) {
            log.trace("addAuthorization for " + string + "\nscheme:" + authenticate.params.scheme);
        }
        try {
            if (authenticate.params.scheme.equalsIgnoreCase("Digest")) {
                return this.addDigestAuthorization(nHttpRequest, authenticate);
            }
            if (authenticate.params.scheme.equalsIgnoreCase("Basic")) {
                BUsernameAndPassword bUsernameAndPassword = nHttpRequest.getUsernamePassword();
                nHttpRequest.addBasicAuthorization(bUsernameAndPassword.getUsername(), bUsernameAndPassword.getPassword().getString());
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    private final boolean addDigestAuthorization(NHttpRequest nHttpRequest, Authenticate authenticate) throws Exception {
        BUsernameAndPassword bUsernameAndPassword = nHttpRequest.getUsernamePassword();
        String string = nHttpRequest.getUri();
        String string2 = authenticate.params.getValue("realm");
        String string3 = authenticate.params.getValue("nonce");
        String string4 = authenticate.params.getValue("qop");
        String string5 = authenticate.params.getValue("opaque");
        if (string3 == null) {
            return false;
        }
        String string6 = this.getCnonce(authenticate, nHttpRequest);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Digest ");
        stringBuffer.append("username=").append(this.quote(bUsernameAndPassword.getUsername())).append(", ");
        stringBuffer.append("realm=").append(string2).append(", ");
        stringBuffer.append("nonce=").append(string3).append(", ");
        if (string5 != null) {
            stringBuffer.append("opaque=").append(string5).append(", ");
        }
        stringBuffer.append("uri=").append(this.quote(string)).append(", ");
        String string7 = "00000000" + Integer.toHexString(++authenticate.nc);
        string7 = string7.substring(string7.length() - 8);
        if (string4 != null) {
            stringBuffer.append("nc=").append(string7).append(", ");
            stringBuffer.append("qop=").append(this.unquote(string4)).append(", ");
            stringBuffer.append("cnonce=").append(this.quote(string6)).append(", ");
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(this.hexMD5(bUsernameAndPassword.getUsername() + ':' + this.unquote(string2) + ':' + bUsernameAndPassword.getPassword().getString())).append(':');
        stringBuffer2.append(this.unquote(string3)).append(':');
        stringBuffer2.append(string7).append(':');
        stringBuffer2.append(string6).append(':');
        stringBuffer2.append(this.unquote(string4)).append(':');
        stringBuffer2.append(this.hexMD5(nHttpRequest.getMethod() + ':' + string));
        stringBuffer.append("response=").append(this.quote(this.hexMD5(stringBuffer2.toString())));
        nHttpRequest.addHeader("Authorization", stringBuffer.toString());
        return true;
    }

    private final String unquote(String string) {
        return string.substring(1, string.length() - 1);
    }

    private final String quote(String string) {
        return "\"" + string + '\"';
    }

    private final String getCnonce(Authenticate authenticate, NHttpRequest nHttpRequest) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        BIpAddress bIpAddress = (BIpAddress)nHttpRequest.getAddress();
        dataOutputStream.writeUTF("cnonce");
        dataOutputStream.writeInt(authenticate.nc);
        dataOutputStream.writeUTF(bIpAddress.getIpAddress());
        dataOutputStream.writeInt(bIpAddress.getPort());
        dataOutputStream.writeLong(System.currentTimeMillis());
        dataOutputStream.writeInt(this.clientRandom.nextInt());
        return this.hexMD5(new String(byteArrayOutputStream.toByteArray()));
    }

    private final String hexMD5(String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        byte[] byArray = messageDigest.digest(string.getBytes());
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(TextUtil.toLowerCase((String)TextUtil.byteToHexString((int)byArray[n])));
            ++n;
        }
        return stringBuffer.toString();
    }

    private final String getHashKey(NHttpRequest nHttpRequest) {
        String string = nHttpRequest.getUri();
        BUsernameAndPassword bUsernameAndPassword = nHttpRequest.getUsernamePassword();
        BIpAddress bIpAddress = (BIpAddress)nHttpRequest.getAddress();
        return bIpAddress.getIpAddress() + ':' + string.substring(0, string.indexOf(63)) + ':' + bUsernameAndPassword.getUsername() + ':' + bUsernameAndPassword.getPassword().getString();
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        spyWriter.startProps("AuthUtil");
        spyWriter.endProps();
        if (this.hash.size() <= 0) {
            spyWriter.write("<b>no sessions</b><br><br>");
            return;
        }
        spyWriter.startTable(true);
        spyWriter.trTitle((Object)"sessions", 3);
        Enumeration enumeration = this.hash.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Authenticate authenticate = (Authenticate)this.hash.get(string);
            spyWriter.w((Object)"<tr><th scope='rowgroup' colspan='3'>").w((Object)string).w((Object)"</th></tr>\n");
            authenticate.params.spy(spyWriter);
        }
        spyWriter.endTable();
    }

    private final /* synthetic */ void this() {
        this.hash = new Hashtable();
        this.clientRandom = new Random();
    }

    AuthUtil() {
        this.this();
    }

    static class AuthParams {
        String scheme;
        String[] nam;
        String[] val;

        String getValue(String string) {
            int n = 0;
            while (n < this.nam.length) {
                if (this.nam[n].equals(string)) {
                    return this.val[n];
                }
                ++n;
            }
            return null;
        }

        void spy(SpyWriter spyWriter) {
            int n = 0;
            while (n < this.nam.length) {
                spyWriter.w((Object)"<tr>");
                spyWriter.td((Object)(n == 0 ? this.scheme : ""));
                spyWriter.td((Object)this.nam[n]).td((Object)this.val[n]);
                spyWriter.w((Object)"</tr>\n");
                ++n;
            }
        }

        AuthParams(String string) {
            int n = string.indexOf(32);
            this.scheme = string.substring(0, n);
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n + 1), ",");
            int n2 = stringTokenizer.countTokens();
            this.nam = new String[n2];
            this.val = new String[n2];
            int n3 = 0;
            while (n3 < n2) {
                String string2 = stringTokenizer.nextToken().trim();
                n = string2.indexOf(61);
                this.nam[n3] = string2.substring(0, n);
                this.val[n3] = string2.substring(n + 1);
                ++n3;
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class Authenticate {
        AuthParams params;
        int nc;

        private final /* synthetic */ void this() {
            this.nc = 1;
        }

        Authenticate(AuthParams authParams) {
            this.this();
            this.params = authParams;
        }
    }
}

