/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndriver.comm;

import com.tridium.ndriver.comm.LinkMessage;

public class NLinkMessageFactory {
    private Pool pool;
    protected int linkMaxLength;

    public final LinkMessage getLinkMessage() {
        LinkMessage linkMessage = this.pool.getPoolMessage();
        return linkMessage;
    }

    public final void releaseLinkMessage(LinkMessage linkMessage) {
        this.pool.releasePoolMessage(linkMessage);
    }

    protected LinkMessage createLinkMessage() {
        return new LinkMessage(this.linkMaxLength);
    }

    public int getLinkMaxLength() {
        return this.linkMaxLength;
    }

    public NLinkMessageFactory(int n) {
        this(32, n);
    }

    public NLinkMessageFactory(int n, int n2) {
        this.pool = new Pool(n);
        this.linkMaxLength = n2;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Pool {
        private LinkMessage[] appPool;
        private int appCnt;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        LinkMessage getPoolMessage() {
            LinkMessage[] linkMessageArray = this.appPool;
            synchronized (this.appPool) {
                LinkMessage linkMessage = this.appCnt > 0 ? this.appPool[--this.appCnt] : NLinkMessageFactory.this.createLinkMessage();
                linkMessage.init();
                linkMessage.freeBuf = false;
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return linkMessage;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void releasePoolMessage(LinkMessage linkMessage) {
            LinkMessage[] linkMessageArray = this.appPool;
            synchronized (this.appPool) {
                while (true) {
                    if (linkMessage == null) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                    if (linkMessage.freeBuf) {
                        System.out.println("already free ");
                        Thread.dumpStack();
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                    if (this.appCnt < this.appPool.length) {
                        this.appPool[this.appCnt++] = linkMessage;
                    }
                    linkMessage.freeBuf = true;
                    linkMessage = (LinkMessage)linkMessage.getNext();
                }
            }
        }

        private final /* synthetic */ void this() {
            this.appCnt = 0;
        }

        public Pool(int n) {
            this.this();
            this.appPool = new LinkMessage[n];
        }
    }
}

