/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndriver.comm;

import com.tridium.ndriver.comm.FragmentManager;
import com.tridium.ndriver.comm.IComm;
import com.tridium.ndriver.comm.ICommFilter;
import com.tridium.ndriver.comm.ICommListener;
import com.tridium.ndriver.comm.IFragmentable;
import com.tridium.ndriver.comm.ILinkLayer;
import com.tridium.ndriver.comm.IMessageFactory;
import com.tridium.ndriver.comm.LinkMessage;
import com.tridium.ndriver.comm.LinkedProcessor;
import com.tridium.ndriver.comm.NCommException;
import com.tridium.ndriver.comm.NCommTimeoutException;
import com.tridium.ndriver.comm.NCommTimer;
import com.tridium.ndriver.comm.NLinkMessageFactory;
import com.tridium.ndriver.comm.NMessage;
import com.tridium.ndriver.datatypes.BCommConfig;
import com.tridium.ndriver.util.SpyUtil;
import java.util.Vector;
import javax.baja.log.Log;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NComm
implements IComm {
    LinkedProcessor receive;
    LinkedProcessor incoming;
    Vector listeners;
    private Log log;
    private BCommConfig comCfg;
    ILinkLayer linkLayer;
    private ICommListener defListener;
    private NCommTimer ntimer;
    private NLinkMessageFactory lnkFac;
    private IMessageFactory msgFac;
    private FragmentManager fragMgr;
    private boolean serviceStarted;
    private Exception lnkEx;
    private Statistics stats;

    public void start() throws Exception {
        if (this.serviceStarted) {
            return;
        }
        this.ntimer.start();
        this.receive.start(this.comCfg.getResourcePrefix() + ".Receiver");
        this.incoming.start(this.comCfg.getResourcePrefix() + ".Incoming");
        this.log().trace("start NComm");
        try {
            this.linkLayer.start();
            this.lnkEx = null;
        }
        catch (Exception exception) {
            this.lnkEx = exception;
        }
        this.serviceStarted = true;
        if (this.lnkEx != null) {
            throw this.lnkEx;
        }
    }

    public void stop() {
        this.serviceStarted = false;
        this.linkLayer.stop();
        this.ntimer.stop();
        this.receive.stop();
        this.incoming.stop();
        this.listeners.clear();
    }

    public void verifySettings(BCommConfig bCommConfig) throws Exception {
        try {
            if (!this.serviceStarted) {
                return;
            }
            this.linkLayer.verifySettings(bCommConfig);
            this.lnkEx = null;
        }
        catch (Exception exception) {
            this.lnkEx = exception;
            throw exception;
        }
    }

    public ILinkLayer getLinkLayer() {
        return this.linkLayer;
    }

    public void resetStats() {
        this.stats = new Statistics();
        if (this.linkLayer != null) {
            this.linkLayer.resetStats();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NMessage sendRequest(NMessage nMessage) throws Exception {
        boolean bl;
        Exception exception = null;
        NMessage nMessage2 = null;
        this.verify();
        if (this.log().isTraceOn()) {
            String string = nMessage.getAddress() != null ? " to " + (Object)((Object)nMessage.getAddress()) : "";
            this.log.trace("sendRequest" + string + " :\n" + nMessage.toTraceString() + '\n');
        }
        ++this.stats.sendRequest;
        int n = nMessage.getRetryCount();
        do {
            block12: {
                Object var8_8;
                bl = false;
                NCommTimer.Transaction transaction = this.ntimer.getTransaction(nMessage);
                if (transaction == null) {
                    return null;
                }
                try {
                    try {
                        NCommTimer.Transaction transaction2 = transaction;
                        synchronized (transaction2) {
                            this.sendFragments(nMessage);
                            transaction.wait();
                            transaction.setComplete(true);
                            // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 4, 8] lbl22 : MonitorExitStatement: MONITOREXIT : var10_9
                            nMessage2 = transaction.getResponseMessage();
                            exception = transaction.getException();
                        }
                    }
                    catch (Exception exception2) {
                        transaction.setComplete(true);
                        exception = exception2;
                    }
                    var8_8 = null;
                    this.ntimer.freeTransaction(transaction);
                    if (n <= 0) break block12;
                }
                catch (Throwable throwable) {
                    var8_8 = null;
                    this.ntimer.freeTransaction(transaction);
                    throw throwable;
                }
                if (exception instanceof NCommTimeoutException) {
                    this.log.trace("retry");
                    bl = true;
                    --n;
                    ++this.stats.timeoutRetry;
                }
            }
            if (bl || exception == null) continue;
            ++this.stats.sendFail;
            throw exception;
        } while (bl);
        return nMessage.modifyResponse(nMessage2);
    }

    public void sendMessage(NMessage nMessage) throws Exception {
        this.verify();
        if (this.log().isTraceOn()) {
            String string = nMessage.getAddress() != null ? " to " + (Object)((Object)nMessage.getAddress()) : "";
            this.log.trace("sendMessage" + string + " :\n" + nMessage.toTraceString() + '\n');
        }
        ++this.stats.sendMessage;
        this.sendFragments(nMessage);
    }

    private final void sendFragments(NMessage nMessage) throws Exception {
        boolean bl = true;
        nMessage.initFragmentation();
        while (bl) {
            bl = this.sendToLink(nMessage);
        }
    }

    private final boolean sendToLink(NMessage nMessage) throws Exception {
        LinkMessage linkMessage = this.lnkFac.getLinkMessage();
        boolean bl = linkMessage.setMessage(nMessage);
        this.linkLayer.sendMessage(linkMessage);
        return bl;
    }

    public void receiveMessage(LinkMessage linkMessage) {
        this.receive.enqueue(linkMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void doReceiveMessage(LinkMessage linkMessage) {
        block14: {
            block13: {
                try {
                    try {
                        Object object;
                        NMessage nMessage = this.msgFac.makeMessage(linkMessage);
                        if (nMessage == null) {
                            Object var3_4 = null;
                            this.lnkFac.releaseLinkMessage(linkMessage);
                            return;
                        }
                        if (this.fragMgr != null && nMessage.isFragmentable()) {
                            object = (IFragmentable)((Object)nMessage);
                            NMessage nMessage2 = object.getFragmentAck();
                            if (nMessage2 != null) {
                                this.sendToLink(nMessage2);
                            }
                            if ((nMessage = this.fragMgr.mergeFragments((IFragmentable)object)) == null) {
                                break block13;
                            }
                        }
                        if (this.log().isTraceOn()) {
                            object = nMessage.getAddress() != null ? " from " + (Object)((Object)nMessage.getAddress()) : "";
                            this.log().trace("receiveMessage" + (String)object + " :\n" + nMessage.toTraceString() + '\n');
                        }
                        if ((object = nMessage.getAck()) != null) {
                            this.sendToLink((NMessage)object);
                        }
                        if (nMessage.isResponse()) {
                            ++this.stats.receiveResponse;
                            this.processResponse(nMessage);
                            break block14;
                        } else {
                            ++this.stats.receiveIncoming;
                            this.processIncoming(nMessage);
                        }
                        break block14;
                    }
                    catch (Throwable throwable) {
                        this.log().error("Exception in NComm.receiveMessage()", throwable);
                        ++this.stats.receiveException;
                        Object var3_6 = null;
                        this.lnkFac.releaseLinkMessage(linkMessage);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var3_7 = null;
                    this.lnkFac.releaseLinkMessage(linkMessage);
                    throw throwable;
                }
            }
            Object var3_5 = null;
            this.lnkFac.releaseLinkMessage(linkMessage);
            return;
        }
        Object var3_8 = null;
        this.lnkFac.releaseLinkMessage(linkMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void processResponse(NMessage nMessage) {
        NCommTimer.Transaction transaction = this.ntimer.getTransactionMatch(nMessage.getTag());
        if (transaction == null) {
            this.log().error("Receive response with no matching transaction from " + (Object)((Object)nMessage.getAddress()) + " :\n" + nMessage.toTraceString() + '\n');
            return;
        }
        NCommTimer.Transaction transaction2 = transaction;
        synchronized (transaction2) {
            try {
                if (transaction.getComplete()) {
                    this.log().warning("Received response message with no matching transaction." + nMessage);
                    return;
                }
                switch (transaction.getRequestMessage().validateResponse(nMessage)) {
                    case 4: {
                        this.ntimer.resetTimer(transaction);
                        return;
                    }
                    case 1: {
                        transaction.setException((Exception)((Object)new NCommException("Failed response")));
                        break;
                    }
                    case 2: {
                        transaction.setResponseMessage(nMessage);
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
            }
            catch (Exception exception) {
                transaction.setException(exception);
            }
            transaction.notify();
            return;
        }
    }

    private final void processIncoming(NMessage nMessage) {
        this.incoming.enqueue(nMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void doProcessIncoming(NMessage nMessage) {
        boolean bl = false;
        Vector vector = this.listeners;
        synchronized (vector) {
            int n = 0;
            while (true) {
                if (n >= this.listeners.size()) {
                    // MONITOREXIT @DISABLED, blocks:[1, 3, 8] lbl12 : MonitorExitStatement: MONITOREXIT : var3_3
                    if (!bl && this.defListener != null) {
                        this.defListener.receiveMessage(nMessage);
                    }
                    if (!bl && this.defListener == null) {
                        ++this.stats.noListener;
                    }
                    return;
                }
                ListenerData listenerData = (ListenerData)this.listeners.elementAt(n);
                if (listenerData.fltr.accept(nMessage)) {
                    listenerData.listner.receiveMessage(nMessage);
                    if (listenerData.exclusive) {
                        bl = true;
                    }
                }
                ++n;
            }
        }
    }

    public void setDefaultListener(ICommListener iCommListener) {
        this.defListener = iCommListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registerCommListener(ICommListener iCommListener, ICommFilter iCommFilter, boolean bl) {
        Vector vector = this.listeners;
        synchronized (vector) {
            if (this.findListener(iCommListener, iCommFilter) < 0) {
                ListenerData listenerData = new ListenerData();
                listenerData.listner = iCommListener;
                listenerData.fltr = iCommFilter;
                listenerData.exclusive = bl;
                this.listeners.add(listenerData);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unregisterCommListener(ICommListener iCommListener, ICommFilter iCommFilter) {
        Vector vector = this.listeners;
        synchronized (vector) {
            int n = this.findListener(iCommListener, iCommFilter);
            while (n >= 0) {
                this.listeners.remove(n);
                n = this.findListener(iCommListener, iCommFilter);
            }
            return;
        }
    }

    private final int findListener(ICommListener iCommListener, ICommFilter iCommFilter) {
        int n = 0;
        while (n < this.listeners.size()) {
            ListenerData listenerData = (ListenerData)this.listeners.elementAt(n);
            if (listenerData.listner == iCommListener && (iCommFilter == null || listenerData.fltr == iCommFilter)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        spyWriter.startProps("NComm");
        spyWriter.prop((Object)"serviceStarted", this.serviceStarted);
        if (this.defListener != null) {
            spyWriter.prop((Object)"defListener", (Object)this.defListener.getClass().getName());
        }
        if (this.lnkEx != null) {
            spyWriter.prop((Object)"link fault", (Object)this.lnkEx.getMessage());
            spyWriter.endProps();
            return;
        }
        spyWriter.endProps();
        SpyUtil.spy(spyWriter, "NCom Statistics", this.stats);
        this.ntimer.spy(spyWriter);
        this.linkLayer.spy(spyWriter);
        this.fragMgr.spy(spyWriter);
    }

    final Log log() {
        if (this.log == null) {
            this.log = Log.getLog((String)(this.comCfg.getResourcePrefix() + ".Comm"));
        }
        return this.log;
    }

    private final void verify() {
        if (!this.serviceStarted) {
            throw new BajaRuntimeException("service not started.");
        }
        if (this.lnkEx != null) {
            throw new BajaRuntimeException("link fault:", (Throwable)this.lnkEx);
        }
    }

    private final /* synthetic */ void this() {
        this.receive = new LinkedProcessor(){

            public final void process(Object object) {
                NComm.this.doReceiveMessage((LinkMessage)object);
            }
        };
        this.incoming = new LinkedProcessor(){

            public final void process(Object object) {
                NComm.this.doProcessIncoming((NMessage)object);
            }
        };
        this.listeners = new Vector();
        this.serviceStarted = false;
        this.lnkEx = null;
        this.stats = new Statistics();
    }

    public NComm(BCommConfig bCommConfig, ICommListener iCommListener) {
        this.this();
        this.comCfg = bCommConfig;
        this.ntimer = new NCommTimer(bCommConfig.getMaxOutstandingTransactions(), bCommConfig.getMaxTransactionWait(), bCommConfig.getResourcePrefix());
        this.fragMgr = new FragmentManager(this, this.ntimer);
        this.ntimer.setFragmentManager(this.fragMgr);
        this.linkLayer = bCommConfig.makeLinkLayer(this);
        this.defListener = iCommListener;
        this.lnkFac = bCommConfig.getLinkMessageFactory();
        this.msgFac = bCommConfig.getMessageFactory();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Statistics {
        long startTime;
        public long sendRequest;
        public long sendMessage;
        public long sendFail;
        public long timeoutRetry;
        public long receiveResponse;
        public long receiveIncoming;
        public long receiveException;
        public long noListener;

        public String getStartTime() {
            return BAbsTime.make((long)this.startTime).toLocalTime().toString(null);
        }

        private final /* synthetic */ void this() {
            this.startTime = Clock.millis();
            this.sendRequest = 0L;
            this.sendMessage = 0L;
            this.sendFail = 0L;
            this.timeoutRetry = 0L;
            this.receiveResponse = 0L;
            this.receiveIncoming = 0L;
            this.receiveException = 0L;
            this.noListener = 0L;
        }

        public Statistics() {
            this.this();
        }
    }

    private static class ListenerData {
        ICommListener listner;
        ICommFilter fltr;
        boolean exclusive;

        private ListenerData() {
        }
    }
}

