/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.mysql;

import com.tridium.rdb.aes.AesSysKeyEncoder;
import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import com.tridium.rdb.mysql.BMySQLConnectionPool;
import com.tridium.rdb.mysql.history.BMySQLHistoryDeviceExt;
import java.sql.Connection;
import java.sql.SQLException;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.BRdbmsTimestampStorage;
import javax.baja.rdb.RdbmsContext;
import javax.baja.rdb.ddl.Constraint;
import javax.baja.security.BPassword;
import javax.baja.status.BStatus;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BMySQLDatabase
extends BRdbms {
    public static final Property timestampStorage = BMySQLDatabase.newProperty((int)5, (BValue)BRdbmsTimestampStorage.dialectDefault, null);
    public static final Property databaseName = BMySQLDatabase.newProperty((int)0, (String)"", null);
    public static final Property port = BMySQLDatabase.newProperty((int)0, (int)3306, null);
    public static final Property histories = BMySQLDatabase.newProperty((int)0, (BValue)new BMySQLHistoryDeviceExt(), null);
    public static final Property connectionPool = BMySQLDatabase.newProperty((int)4, (BValue)new BMySQLConnectionPool(), null);
    public static final Property extraConnectionProperties = BMySQLDatabase.newProperty((int)0, (String)"", null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$rdb$mysql$BMySQLDatabase == null ? (class$com$tridium$rdb$mysql$BMySQLDatabase = BMySQLDatabase.class$("com.tridium.rdb.mysql.BMySQLDatabase")) : class$com$tridium$rdb$mysql$BMySQLDatabase));
    private final RdbmsDialect DIALECT = new RdbmsDialect(){

        public String getValidationQuery() {
            return "select 1;";
        }

        public void issueCheckpoint(Connection connection) throws SQLException {
        }

        public boolean supportsBatchInsert() {
            return true;
        }

        public boolean supportsBatchUpdate() {
            return true;
        }

        public boolean supportsBatchDelete() {
            return true;
        }

        public int getInsertionMode() {
            return 1;
        }

        public String getIdentityCreation() {
            return "AUTO_INCREMENT";
        }

        public String getIdentityLookup() {
            throw new UnsupportedOperationException();
        }

        public String getSequenceName(String string) {
            throw new UnsupportedOperationException();
        }

        public String getSequenceLookup(String string) {
            throw new UnsupportedOperationException();
        }

        public String getAlterColumn() {
            return "MODIFY";
        }

        public String getAlterColumnSuffix() {
            return null;
        }

        public boolean getAlterColumnSupportsNotNull() {
            return true;
        }

        public String getStringLengthFunctionName() {
            return "CHAR_LENGTH";
        }

        public AesSysKeyEncoder getAesEncoder() {
            return BMySQLDatabase.this.getEncoder();
        }

        public int getMaxTableName() {
            return 64;
        }

        public int getMaxIndexName() {
            return 64;
        }

        public int getMaxConstraintName() {
            return 64;
        }

        public int getMaxColumnName() {
            return 64;
        }

        public boolean allowsUnicodeNames() {
            return true;
        }

        public String getColumnIdentifier(String string, String string2, String string3) {
            if (string != null && string.length() > 0) {
                return string + "." + string2 + ".`" + string3 + "`";
            }
            return string2 + ".`" + string3 + "`";
        }

        public String getTableIdentifier(String string, String string2) {
            if (string != null && string.length() > 0) {
                return string + "." + string2;
            }
            return string2;
        }

        public String getDropIndex(String string, String string2) {
            return "ALTER TABLE " + string + " DROP INDEX " + string2;
        }

        public String getDropConstraint(String string, Constraint constraint) {
            String string2 = "CONSTRAINT";
            if (constraint.getConstraintType() == 1) {
                string2 = "PRIMARY KEY";
            } else if (constraint.getConstraintType() == 2) {
                string2 = "FOREIGN KEY";
            }
            return "ALTER TABLE " + string + " " + "DROP  " + string2 + " " + constraint.getName();
        }

        public String getIntType() {
            return "INTEGER";
        }

        public String getLongType() {
            return "BIGINT";
        }

        public String getFloatType() {
            return "FLOAT";
        }

        public String getDoubleType() {
            return "DOUBLE";
        }

        public String getCharType() {
            return BMySQLDatabase.this.getUseUnicodeEncodingScheme() ? "NCHAR" : "CHAR";
        }

        public String getVarCharType() {
            return BMySQLDatabase.this.getUseUnicodeEncodingScheme() ? "NVARCHAR" : "VARCHAR";
        }

        public String getUuidType() {
            return "BINARY(16)";
        }

        public String getDateType() {
            return "DATE";
        }

        public String getBooleanType() {
            return "TINYINT";
        }

        public String getTimestampType() {
            throw new UnsupportedOperationException();
        }

        public boolean supportsBooleanType() {
            return true;
        }

        public boolean supportsDateType() {
            return true;
        }

        public boolean supportsMillisecondTimestamp() {
            return false;
        }

        public boolean useUtcTimestamps() {
            return false;
        }

        public String getBlobType() {
            return "MEDIUMBLOB";
        }

        public boolean usesDefaultBlobTranslator() {
            return true;
        }

        public void setBlobValue(RdbmsPreparedStatement rdbmsPreparedStatement, int n, byte[] byArray) {
            throw new UnsupportedOperationException();
        }

        public String getClobType() {
            if (!BMySQLDatabase.this.getUseUnicodeEncodingScheme()) {
                return "TEXT";
            }
            return "TEXT CHARACTER SET utf8 COLLATE utf8_unicode_ci";
        }

        public boolean usesDefaultClobTranslator() {
            return true;
        }

        public void setClobValue(RdbmsPreparedStatement rdbmsPreparedStatement, int n, String string) {
            throw new UnsupportedOperationException();
        }

        public String getOnDelete(int n) {
            switch (n) {
                case 1: {
                    return "CASCADE";
                }
                case 0: {
                    return "NO ACTION";
                }
            }
            throw new IllegalStateException();
        }

        public boolean supportsDropColumn() {
            return true;
        }

        public boolean supportsRenameTable() {
            return false;
        }

        public boolean supportsClusteredIndex() {
            return false;
        }

        public int getJdbcTypeBlob() {
            return -4;
        }

        public int getJdbcTypeBoolean() {
            return -6;
        }

        public int getJdbcTypeChar() {
            return 1;
        }

        public int getJdbcTypeClob() {
            return -1;
        }

        public int getJdbcTypeDouble() {
            return 8;
        }

        public int getJdbcTypeFloat() {
            return 7;
        }

        public int getJdbcTypeInt() {
            return 4;
        }

        public int getJdbcTypeLong() {
            return -5;
        }

        public int getJdbcTypeTimestamp() {
            return -5;
        }

        public int getJdbcTypeUuid() {
            return -2;
        }

        public int getJdbcTypeVarchar() {
            return 12;
        }

        public int getJdbcTypeDate() {
            return 91;
        }
    };
    static /* synthetic */ Class class$com$tridium$rdb$mysql$BMySQLDatabase;

    public BRdbmsTimestampStorage getTimestampStorage() {
        return (BRdbmsTimestampStorage)this.get(timestampStorage);
    }

    public void setTimestampStorage(BRdbmsTimestampStorage bRdbmsTimestampStorage) {
        this.set(timestampStorage, (BValue)bRdbmsTimestampStorage, null);
    }

    public String getDatabaseName() {
        return this.getString(databaseName);
    }

    public void setDatabaseName(String string) {
        this.setString(databaseName, string, null);
    }

    public int getPort() {
        return this.getInt(port);
    }

    public void setPort(int n) {
        this.setInt(port, n, null);
    }

    public BMySQLHistoryDeviceExt getHistories() {
        return (BMySQLHistoryDeviceExt)this.get(histories);
    }

    public void setHistories(BMySQLHistoryDeviceExt bMySQLHistoryDeviceExt) {
        this.set(histories, (BValue)bMySQLHistoryDeviceExt, null);
    }

    public BMySQLConnectionPool getConnectionPool() {
        return (BMySQLConnectionPool)this.get(connectionPool);
    }

    public void setConnectionPool(BMySQLConnectionPool bMySQLConnectionPool) {
        this.set(connectionPool, (BValue)bMySQLConnectionPool, null);
    }

    public String getExtraConnectionProperties() {
        return this.getString(extraConnectionProperties);
    }

    public void setExtraConnectionProperties(String string) {
        this.setString(extraConnectionProperties, string, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BMySQLDatabase() {
    }

    public BMySQLDatabase(BOrd bOrd, int n) {
        this.setHostAddress(bOrd);
        this.setPort(n);
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "rdbMySQL");
    }

    public Connection getConnection(String string, BPassword bPassword) throws SQLException {
        BStatus bStatus = this.getStatus();
        if (bStatus.isFault()) {
            return null;
        }
        return this.getConnectionPool().getConnection(string, bPassword.getString());
    }

    public AesSysKeyEncoder getEncoder() {
        return this.getRdbSecuritySettings().getEncoder();
    }

    public RdbmsContext getRdbmsContext() {
        return this.DIALECT;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

