/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.virtual;

import javax.baja.agent.AgentList;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BCategoryService;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.space.BComponentSpace;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.virtual.BVirtualGateway;
import javax.baja.virtual.VirtualPath;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BVirtualComponent
extends BComponent {
    public static final Type TYPE;
    private static final BIcon icon;
    long lastActiveTicks;
    static /* synthetic */ Class class$javax$baja$virtual$BVirtualComponent;

    public Type getType() {
        return TYPE;
    }

    public boolean performAutoRemoval() {
        return true;
    }

    public final long getLastActiveTicks() {
        return this.lastActiveTicks;
    }

    public final void setLastActiveTicks(long l) {
        this.lastActiveTicks = l;
    }

    public final BVirtualGateway getVirtualGateway() {
        BComponentSpace bComponentSpace = this.getComponentSpace();
        if (bComponentSpace == null) {
            return null;
        }
        BINavNode bINavNode = bComponentSpace.getNavParent();
        if (bINavNode instanceof BVirtualGateway) {
            return (BVirtualGateway)bINavNode;
        }
        return null;
    }

    public BOrd getCategorizableOrd() {
        BOrd bOrd = this.getNavOrd();
        if (bOrd != null) {
            return bOrd.relativizeToSession();
        }
        return null;
    }

    public boolean isChildLegal(BComponent bComponent) {
        boolean bl = false;
        if (bComponent instanceof BVirtualComponent || bComponent instanceof BVector) {
            bl = true;
        }
        return bl;
    }

    public boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BVirtualComponent;
    }

    public final BOrd getNavOrd() {
        BOrd bOrd;
        BComponentSpace bComponentSpace = this.getComponentSpace();
        if (bComponentSpace == null) {
            return null;
        }
        BOrd bOrd2 = bOrd = this.getVirtualGateway() == null ? bComponentSpace.getAbsoluteOrd() : bComponentSpace.getNavOrd();
        if (bOrd == null) {
            return null;
        }
        SlotPath slotPath = this.getSlotPath();
        if (slotPath == null) {
            return null;
        }
        VirtualPath virtualPath = VirtualPath.convertFromSlotPath(slotPath);
        return BOrd.make(bOrd, virtualPath).normalize();
    }

    public BCategoryMask getAppliedCategoryMask() {
        BComponent bComponent;
        BOrd bOrd = this.getCategorizableOrd();
        if (bOrd != null && !bOrd.isNull()) {
            bComponent = null;
            if (this.isRunning()) {
                bComponent = BCategoryService.getService();
            } else {
                bComponent = (BCategoryService)BOrd.make(this.getVirtualGateway().getAbsoluteOrd(), "service:baja:CategoryService").get();
                bComponent.lease(1);
            }
            BCategoryMask bCategoryMask = ((BCategoryService)bComponent).getOrdMap().getAppliedCategoryMask(bOrd.relativizeToSession());
            if (bCategoryMask != null) {
                return bCategoryMask;
            }
        }
        if ((bComponent = this.getVirtualGateway()) != null) {
            return bComponent.getAppliedCategoryMask();
        }
        return super.getAppliedCategoryMask();
    }

    public BCategoryMask getCategoryMask() {
        BOrd bOrd = this.getCategorizableOrd();
        if (bOrd != null && !bOrd.isNull()) {
            BCategoryService bCategoryService = null;
            if (this.isRunning() || this.getVirtualGateway() == null) {
                bCategoryService = BCategoryService.getService();
            } else {
                bCategoryService = (BCategoryService)BOrd.make(this.getVirtualGateway().getAbsoluteOrd(), "service:baja:CategoryService").get();
                bCategoryService.lease(1);
            }
            BCategoryMask bCategoryMask = bCategoryService.getOrdMap().getCategoryMask(bOrd.relativizeToSession());
            if (bCategoryMask != null) {
                return bCategoryMask;
            }
        }
        return BCategoryMask.NULL;
    }

    public AgentList getAgents(Context context) {
        AgentList agentList = super.getAgents(context);
        agentList.remove("pxEditor:PxEditor");
        agentList.remove("wiresheet:WireSheet");
        agentList.remove("workbench:LinkSheet");
        return agentList;
    }

    public BIcon getIcon() {
        BValue bValue = this.get("icon");
        if (bValue instanceof BIcon) {
            return (BIcon)bValue;
        }
        return icon;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        spyWriter.startProps();
        spyWriter.trTitle("VirtualComponent", 2);
        spyWriter.prop((Object)"performAutoRemoval", this.performAutoRemoval());
        spyWriter.prop((Object)"lastActiveTicks", this.getLastActiveTicks() + " (" + BAbsTime.make(this.getLastActiveTicks()).encodeToString() + ')');
        spyWriter.prop((Object)"categorizableOrd", this.getCategorizableOrd());
        spyWriter.endProps();
        super.spy(spyWriter);
    }

    public Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        switch (n) {
            case 11: {
                this.updateTicks();
                break;
            }
            case 12: {
                this.updateTicks();
                break;
            }
            case 18: {
                this.updateTicks();
                break;
            }
        }
        return super.fw(n, object, object2, object3, object4);
    }

    void updateTicks() {
        this.setLastActiveTicks(Clock.ticks());
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.lastActiveTicks = Long.MAX_VALUE;
    }

    public BVirtualComponent() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$virtual$BVirtualComponent;
        if (clazz == null) {
            clazz = class$javax$baja$virtual$BVirtualComponent = BVirtualComponent.class("[Ljavax.baja.virtual.BVirtualComponent;", false);
        }
        TYPE = Sys.loadType(clazz);
        icon = BIcon.make(BIcon.std("object.png"), BIcon.std("badges/ghost.png"));
    }
}

