/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import javax.baja.nre.util.TextUtil;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFloat;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.Queue;

public class Worker {
    boolean isAlive;
    Thread thread;
    ITodo todo;
    int timeout;
    int numProcessed;
    long startTime;
    long startTicks;
    long processingTicks;

    public ITodo getTodo() {
        return this.todo;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }

    public String toString() {
        return TextUtil.getClassName(this.getClass()) + " [" + (this.isAlive ? "Running" : "Stopped") + ']';
    }

    public boolean isRunning() {
        boolean bl = false;
        if (this.thread != null && this.isAlive) {
            bl = true;
        }
        return bl;
    }

    public final void start(String string) {
        this.start(Thread.currentThread().getThreadGroup(), string);
    }

    public void start(ThreadGroup threadGroup, String string) {
        if (this.isAlive) {
            return;
        }
        this.isAlive = true;
        this.startTime = Clock.millis();
        this.startTicks = Clock.ticks();
        this.numProcessed = 0;
        this.thread = new Thread(threadGroup, new Processor(), string);
        this.thread.start();
    }

    public void stop() {
        this.isAlive = false;
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    protected void process(Runnable runnable) throws Exception {
        if (runnable != null) {
            runnable.run();
        }
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        spyWriter.startProps("Worker");
        this.spyImpl(spyWriter);
        spyWriter.endProps();
    }

    void spyImpl(SpyWriter spyWriter) {
        Queue queue;
        spyWriter.prop((Object)"isAlive", "" + this.isAlive);
        if (this.isAlive) {
            Worker.spy(spyWriter, this.startTime, this.startTicks, this.processingTicks, this.numProcessed);
        }
        spyWriter.prop((Object)"todo", this.todo.getClass().getName());
        if (this.todo instanceof Queue) {
            queue = (Queue)this.todo;
            spyWriter.prop((Object)"queue.size", "" + queue.size());
            spyWriter.prop((Object)"queue.maxSize", "" + queue.maxSize());
        }
        if (this.todo instanceof CoalesceQueue) {
            queue = (CoalesceQueue)this.todo;
            spyWriter.prop((Object)"queue.hashTable", "" + ((CoalesceQueue)queue).table.length);
            spyWriter.prop((Object)"queue.hashSize", "" + ((CoalesceQueue)queue).hashSize);
            spyWriter.prop((Object)"queue.threshold", "" + ((CoalesceQueue)queue).threshold);
        }
    }

    static void spy(SpyWriter spyWriter, long l, long l2, long l3, int n) {
        long l4 = Clock.ticks() - l2;
        float f = (float)l3 / (float)l4 * 100.0f;
        float f2 = (float)l3 / (float)n;
        spyWriter.prop((Object)"startTime", BAbsTime.make(l));
        spyWriter.prop((Object)"upTime", BRelTime.toString(l4));
        spyWriter.prop((Object)"processing", BRelTime.toString(l3));
        spyWriter.prop((Object)"numProcessed", "" + n);
        spyWriter.prop((Object)"average", BFloat.toString(f2, null) + "ms/work");
        spyWriter.prop((Object)"utilization", "" + (int)f + '%');
    }

    public Worker(ITodo iTodo) {
        this.todo = iTodo;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Processor
    implements Runnable {
        public void run() {
            Worker.this.isAlive = true;
            while (Worker.this.isAlive) {
                try {
                    Runnable runnable = Worker.this.todo.todo(Worker.this.timeout);
                    long l = Clock.ticks();
                    Worker.this.process(runnable);
                    long l2 = Clock.ticks();
                    Worker.this.processingTicks += l2 - l;
                    ++Worker.this.numProcessed;
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }

        Processor() {
        }
    }

    public static interface ITodo {
        public Runnable todo(int var1) throws InterruptedException;
    }
}

